import { useSelector, TypedUseSelectorHook } from 'react-redux'
import { configureStore } from '@reduxjs/toolkit'
import settingSlice from 'hwmsdk-electron-demo/redux/settingSlice'

const store = configureStore({
  reducer: {
    setting: settingSlice.reducer,
  },
})

export type RootState = ReturnType<typeof store.getState>
export const useRootState: TypedUseSelectorHook<RootState> = useSelector
export const globalDispatch = store.dispatch

export default store
