import React, { Component } from 'react'
import { HashRouter, Route } from 'react-router-dom'

import './App.css'
import routes from './routes'
import Login from './UIDemo/login/index'
import Main from './UIDemo/main/index'

class App extends Component {
  render () {
    return (
      <HashRouter>
        <div>
          <Route exact path='/' component={Login} />
          <Route exact path='/main' component={Main} />
          {
            routes.map((page, index) => page.component
              ? <Route key={index} exact path={page.path} component={page.component} />
              : '')
          }
        </div>
      </HashRouter>
    )
  }
}

export default App
