import UISDKService from 'hwmsdk-electron'
import { getNodePath } from './getNodePath'

const log = require('electron-log')

let instance = null
export default class ApiService {
  constructor () {
    if (!instance) {
      instance = this
      const nodePath = getNodePath()
      log.info('ApiService nodePath', nodePath)
      this.uisdkService = new UISDKService(nodePath)
    }
    return instance
  }

  async setServerAddress (serverInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setServerAddress, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setServerAddress, in param = ', serverInfo)
      this.uisdkService.getLoginApi().setServerAddress(serverInfo, resultCallback)
    })
  }

  async setProxy (proxyInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setProxy, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setProxy, in param = ', proxyInfo)
      this.uisdkService.getLoginApi().setProxy(proxyInfo, resultCallback)
    })
  }

  async loginByAccount (accountAuthInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, loginResult) => {
        log.info('loginByAccount, out data = ', { ret, reason, loginResult })
        resolve({ ret, reason, loginResult })
      }
      log.info('loginByAccount, in param = ', accountAuthInfo)
      this.uisdkService.getLoginApi().loginByAccount(accountAuthInfo, resultCallback)
    })
  }

  async loginByAppId (appIdAuthInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, loginResult) => {
        log.info('loginByAppId, out data = ', { ret, reason, loginResult })
        resolve({ ret, reason, loginResult })
      }
      log.info('loginByAppId, in param = ', appIdAuthInfo)
      this.uisdkService.getLoginApi().loginByAppId(appIdAuthInfo, resultCallback)
    })
  }

  async loginBySSO (ssoAuthInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, loginResult) => {
        log.info('loginBySSO, out data = ', { ret, reason, loginResult })
        resolve({ ret, reason, loginResult })
      }
      log.info('loginBySSO, in param = ', ssoAuthInfo)
      this.uisdkService.getLoginApi().loginBySSO(ssoAuthInfo, resultCallback)
    })
  }

  async logout () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, logoutResult) => {
        log.info('logout, out data = ', { ret, reason, logoutResult })
        resolve({ ret, reason, logoutResult })
      }
      log.info('logout, in param = ')
      this.uisdkService.getLoginApi().logout(resultCallback)
    })
  }

  async setNetworkMode (networkInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setNetworkMode, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setNetworkMode, in param = ', networkInfo)
      this.uisdkService.getLoginApi().setNetworkMode(networkInfo, resultCallback)
    })
  }

  async uploadSelfAvatar (selfAvatarInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('uploadSelfAvatar, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('uploadSelfAvatar, in param = ', selfAvatarInfo)
      this.uisdkService.getLoginApi().uploadSelfAvatar(selfAvatarInfo, resultCallback)
    })
  }

  async createConf (createConfInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, createConfResult) => {
        log.info('createConf, out data = ', { ret, reason, createConfResult })
        resolve({ ret, reason, createConfResult })
      }
      log.info('createConf, in param = ', createConfInfo)
      this.uisdkService.getConfCtrlApi().createConf(createConfInfo, resultCallback)
    })
  }

  async startP2pConf (createConfInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, createConfResult) => {
        log.info('startP2pConf, out data = ', { ret, reason, createConfResult })
        resolve({ ret, reason, createConfResult })
      }
      log.info('startP2pConf, in param = ', createConfInfo)
      this.uisdkService.getConfCtrlApi().startP2pConf(createConfInfo, resultCallback)
    })
  }

  async showToast (toastInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('showToast, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('showToast, in param = ', toastInfo)
      this.uisdkService.getUIConfigApi().showToast(toastInfo, resultCallback)
    })
  }

  async getMainWindowInfo () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, mainWindowInfo) => {
        log.info('getMainWindowInfo, out data = ', { ret, reason, mainWindowInfo })
        resolve({ ret, reason, mainWindowInfo })
      }
      log.info('getMainWindowInfo, in param = ')
      this.uisdkService.getUIConfigApi().getMainWindowInfo(resultCallback)
    })
  }

  async joinConfById (joinConfByIdInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('joinConfById, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('joinConfById, in param = ', joinConfByIdInfo)
      this.uisdkService.getConfCtrlApi().joinConfById(joinConfByIdInfo, resultCallback)
    })
  }

  async joinConfByRandom (joinConfByRandomInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('joinConfByRandom, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('joinConfByRandom, in param = ', joinConfByRandomInfo)
      this.uisdkService.getConfCtrlApi().joinConfByRandom(joinConfByRandomInfo, resultCallback)
    })
  }

  async addAttendee (addAttendeeInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('addAttendee, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('addAttendee, in param = ', addAttendeeInfo)
      this.uisdkService.getConfCtrlApi().addAttendee(addAttendeeInfo, resultCallback)
    })
  }

  async leaveConf () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('leaveConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('leaveConf, in param = ')
      this.uisdkService.getConfCtrlApi().leaveConf(resultCallback)
    })
  }

  async endConf () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('endConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('endConf, in param = ')
      this.uisdkService.getConfCtrlApi().endConf(resultCallback)
    })
  }

  async getAttendeeList () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, attendeeList) => {
        log.info('getAttendeeList, out data = ', { ret, reason, attendeeList })
        resolve({ ret, reason, attendeeList })
      }
      log.info('getAttendeeList, in param = ')
      this.uisdkService.getConfCtrlApi().getAttendeeList(resultCallback)
    })
  }

  async getAudienceList () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, audidenceList) => {
        log.info('getAudienceList, out data = ', { ret, reason, audidenceList })
        resolve({ ret, reason, audidenceList })
      }
      log.info('getAudienceList, in param = ')
      this.uisdkService.getConfCtrlApi().getAudienceList(resultCallback)
    })
  }

  async getUserState () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, userState) => {
        log.info('getUserState, out data = ', { ret, reason, userState })
        resolve({ ret, reason, userState })
      }
      log.info('getUserState, in param = ')
      this.uisdkService.getConfCtrlApi().getUserState(resultCallback)
    })
  }

  async getLoginState () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, loginState) => {
        log.info('getLoginState, out data = ', { ret, reason, loginState })
        resolve({ ret, reason, loginState })
      }
      log.info('getLoginState, in param = ')
      this.uisdkService.getLoginApi().getLoginState(resultCallback)
    })
  }

  async getLoginToken () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, loginToken) => {
        log.info('getLoginToken, out data = ', { ret, reason, loginToken })
        resolve({ ret, reason, loginToken })
      }
      log.info('getLoginToken, in param = ')
      this.uisdkService.getLoginApi().getLoginToken(resultCallback)
    })
  }

  async getSelfRole () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, selfRole) => {
        log.info('getSelfRole, out data = ', { ret, reason, selfRole })
        resolve({ ret, reason, selfRole })
      }
      log.info('getSelfRole, in param = ')
      this.uisdkService.getConfCtrlApi().getSelfRole(resultCallback)
    })
  }

  async renameSelf (renameSelfInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('renameSelf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('renameSelf, in param = ', renameSelfInfo)
      this.uisdkService.getConfCtrlApi().renameSelf(renameSelfInfo, resultCallback)
    })
  }

  async bookConf (bookConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, confDetail) => {
        log.info('bookConf, out data = ', { ret, reason, confDetail })
        resolve({ ret, reason, confDetail })
      }
      log.info('bookConf, in param = ', bookConfParam)
      this.uisdkService.getConfMgrApi().bookConf(bookConfParam, resultCallback)
    })
  }

  async bookCycleConf (bookConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, confDetail) => {
        log.info('bookCylceConf, out data = ', { ret, reason, confDetail })
        resolve({ ret, reason, confDetail })
      }
      log.info('bookCylceConf, in param = ', bookConfParam)
      this.uisdkService.getConfMgrApi().bookCycleConf(bookConfParam, resultCallback)
    })
  }

  async cancelConf (cancelConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('cancelConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('cancelConf, in param = ', cancelConfParam)
      this.uisdkService.getConfMgrApi().cancelConf(cancelConfParam, resultCallback)
    })
  }

  async cancelCycleConf (cancelCycleConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('cancelCycleConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('cancelCycleConf, in param = ', cancelCycleConfParam)
      this.uisdkService.getConfMgrApi().cancelCycleConf(cancelCycleConfParam, resultCallback)
    })
  }

  async cancelSubCycleConf (cancelSubCycleConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('cancelSubCycleConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('cancelSubCycleConf, in param = ', cancelSubCycleConfParam)
      this.uisdkService.getConfMgrApi().cancelSubCycleConf(cancelSubCycleConfParam, resultCallback)
    })
  }

  async editConf (editConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('editConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('editConf, in param = ', editConfParam)
      this.uisdkService.getConfMgrApi().editConf(editConfParam, resultCallback)
    })
  }

  async editCycleConf (editCycleConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('editCycleConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('editCycleConf, in param = ', editCycleConfParam)
      this.uisdkService.getConfMgrApi().modifyCycleConf(editCycleConfParam, resultCallback)
    })
  }

  async editCycleSubConf (editCycleSubConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('editCycleSubConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('editCycleSubConf, in param = ', editCycleSubConfParam)
      this.uisdkService.getConfMgrApi().modifySubCycleConf(editCycleSubConfParam, resultCallback)
    })
  }

  async getVmrList () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, vmrListInfo) => {
        log.info('getVmrList, out data = ', { ret, reason, vmrListInfo })
        resolve({ ret, reason, vmrListInfo })
      }
      log.info('getVmrList, in param = ')
      this.uisdkService.getConfMgrApi().getVmrList(resultCallback)
    })
  }

  async getConfDetail (getConfDetailParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, confDetail) => {
        log.info('getConfDetail, out data = ', { ret, reason, confDetail })
        resolve({ ret, reason, confDetail })
      }
      log.info('getConfDetail, in param = ', getConfDetailParam)
      this.uisdkService.getConfMgrApi().getConfDetail(getConfDetailParam, resultCallback)
    })
  }

  async changeVmrInfo (vmrInfoParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('changeVmrInfo, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('changeVmrInfo, in param = ', vmrInfoParam)
      this.uisdkService.getConfMgrApi().changeVmrInfo(vmrInfoParam, resultCallback)
    })
  }

  async getConfList () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, confListInfo) => {
        log.info('getConfList, out data = ', { ret, reason, confListInfo })
        resolve({ ret, reason, confListInfo })
      }
      log.info('getConfList, in param = ')
      this.uisdkService.getConfMgrApi().getConfList(resultCallback)
    })
  }

  async enableCapability (capabilityInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('enableCapability, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('enableCapability, in param = ', capabilityInfo)
      this.uisdkService.getConfigApi().enableCapability(capabilityInfo, resultCallback)
    })
  }

  async agreeVoiceprintStatement (isAgreed) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('agreeVoiceprintStatement, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('agreeVoiceprintStatement, in param = ', isAgreed)
      this.uisdkService.getConfigApi().agreeVoiceprintStatement(isAgreed, resultCallback)
    })
  }

  async setLanguage (languageInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setLanguage, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setLanguage, in param = ', languageInfo)
      this.uisdkService.getConfigApi().setLanguage(languageInfo, resultCallback)
    })
  }

  async setUserSavePath (userSavePathInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setUserSavePath, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setUserSavePath, in param = ', userSavePathInfo)
      this.uisdkService.getConfigApi().setUserSavePath(userSavePathInfo, resultCallback)
    })
  }

  async getUserSavePath (userSavePathInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, info) => {
        log.info('getUserSavePath, out data = ', { ret, reason, info })
        resolve({ ret, reason })
      }
      log.info('getUserSavePath, in param = ', userSavePathInfo)
      this.uisdkService.getConfigApi().getUserSavePath(userSavePathInfo, resultCallback)
    })
  }

  async setAudioRawDataOutputConfig (audioRawDataConfigInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setAudioRawDataOutputConfig, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setAudioRawDataOutputConfig, in param = ', audioRawDataConfigInfo)
      this.uisdkService.getConfigApi().setAudioRawDataOutputConfig(audioRawDataConfigInfo, resultCallback)
    })
  }

  async setAnswerType (inComingAnswerTypeInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setAnswerType, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setAnswerType, in param = ', inComingAnswerTypeInfo)
      this.uisdkService.getConfigApi().setAnswerType(inComingAnswerTypeInfo, resultCallback)
    })
  }

  async setDeviceConfigForConfIncoming (deviceConfig) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setDeviceConfigForConfIncoming, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setDeviceConfigForConfIncoming, in param = ', deviceConfig)
      this.uisdkService.getConfigApi().setDeviceConfigForConfIncoming(deviceConfig, resultCallback)
    })
  }

  async getConfPstnAccessNumber () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, pstnAccessNumberInfo) => {
        log.info('getConfPstnAccessNumber, out data = ', { ret, reason, pstnAccessNumberInfo })
        resolve({ ret, reason, pstnAccessNumberInfo })
      }
      log.info('getConfPstnAccessNumber, in param = ')
      this.uisdkService.getConfigApi().getConfPstnAccessNumber(resultCallback)
    })
  }

  async config (uiConfig) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('config, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('config, in param = ', uiConfig)
      this.uisdkService.getUIConfigApi().config(uiConfig, resultCallback)
    })
  }

  async openSettingDialog (openSettingDialogInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('openSettingDialog, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('openSettingDialog, in param = ', openSettingDialogInfo)
      this.uisdkService.getUIConfigApi().showSettingWindow(openSettingDialogInfo, resultCallback)
    })
  }

  async setWaterMark (waterMarkInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setWaterMark, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setWaterMark, in param = ', waterMarkInfo)
      this.uisdkService.getUIConfigApi().setWaterMark(waterMarkInfo, resultCallback)
    })
  }

  async getRenderWindowInfoList () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, hwndInfo) => {
        log.info('getRenderWindowInfoList, out data = ', { ret, reason, hwndInfo })
        resolve({ ret, reason, hwndInfo })
      }
      log.info('getRenderWindowInfoList, in param = ')
      this.uisdkService.getUIConfigApi().getRenderWindowInfoList(resultCallback)
    })
  }

  async showMeetingWindow () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('showMeetingWindow, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('showMeetingWindow, in param = ')
      this.uisdkService.getUIConfigApi().showMeetingWindow(resultCallback)
    })
  }

  async setAvatar (avatarInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setAvatar, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setAvatar, in param = ', avatarInfo)
      this.uisdkService.getUIConfigApi().setAvatar(avatarInfo, resultCallback)
    })
  }

  async setMeetingWindowIcon (windowIconInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setMeetingWindowIcon, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setMeetingWindowIcon, in param = ', windowIconInfo)
      this.uisdkService.getUIConfigApi().setMeetingWindowIcon(windowIconInfo, resultCallback)
    })
  }

  async setTransparentWnd (wndInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setTransparentWnd, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setTransparentWnd, in param = ', wndInfo)
      this.uisdkService.getConfigApi().setTransparentWnd(wndInfo, resultCallback)
    })
  }

  async disableVoicePrompts (voicePromptsInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('voicePromptsInfo, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('disableVoicePrompts, in param = ', voicePromptsInfo)
      this.uisdkService.getConfigApi().disableVoicePrompts(voicePromptsInfo, resultCallback)
    })
  }

  async setShareScreenPermission (sharePermission) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('sharePermission, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setShareScreenPermission, in param = ', sharePermission)
      this.uisdkService.getConfigApi().setShareScreenPermission(sharePermission, resultCallback)
    })
  }

  async getErrorMessage (errorCode) {
    log.info('errorMessage, in param = ', errorCode)
    const errorMessage = this.uisdkService.getConfigApi().getErrorMessage(errorCode)
    log.info('getErrorMessage, out data = ', errorMessage)
    return errorMessage
  }

  SetGuaranteedIpAddresses (guaranteedIpAddresses) {
    log.info('SetGuaranteedIpAddresses, in param = ', guaranteedIpAddresses)
    const ret = this.uisdkService.getLoginApi().setGuaranteedIpAddresses(guaranteedIpAddresses)
    log.info('SetGuaranteedIpAddresses, out data = ', ret)
    return ret
  }

  async startProjection (startProjectionParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, startProjectionResult) => {
        log.info('startProjection, out data = ', { ret, reason, startProjectionResult })
        resolve({ ret, reason, startProjectionResult })
      }
      log.info('startProjection, in param = ', startProjectionParam)
      this.uisdkService.getConfCtrlApi().startProjection(startProjectionParam, resultCallback)
    })
  }

  async setCustomUIText (customSceneTextInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setCustomUIText, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setCustomUIText, in param = ', customSceneTextInfo)
      this.uisdkService.getConfigApi().setCustomUIText(customSceneTextInfo, resultCallback)
    })
  }

  async setCAVerifyInfo (CAVerifyInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setCAVerifyInfo, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setCAVerifyInfo, in param = ', CAVerifyInfo)
      this.uisdkService.getLoginApi().setCAVerifyInfo(CAVerifyInfo, resultCallback)
    })
  }

  setAutoHideToolBar (autoHideToolBarParam) {
    log.info('setAutoHideToolBar, in param = ', autoHideToolBarParam)
    const ret = this.uisdkService.getConfCtrlApi().setAutoHideToolBar(autoHideToolBarParam)
    log.info('setAutoHideToolBar, out data = ', ret)
    return ret
  }

  async acceptConf (acceptConfParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('acceptConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('acceptConf, in param = ', acceptConfParam)
      this.uisdkService.getConfCtrlApi().acceptConf(acceptConfParam, resultCallback)
    })
  }

  async rejectConf () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('rejectConf, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('rejectConf, in param = ')
      this.uisdkService.getConfCtrlApi().rejectConf(resultCallback)
    })
  }

  async setGlobalGuaranteedIpAddresses (guaranteedIpAddressesParam) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setGlobalGuaranteedIpAddresses, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setGlobalGuaranteedIpAddresses, in param = ', guaranteedIpAddressesParam)
      this.uisdkService.getLoginApi().setGlobalGuaranteedIpAddresses(guaranteedIpAddressesParam, resultCallback)
    })
  }

  async getSelfShareState () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, selfShareStateInfo) => {
        log.info('getSelfShareState, out data = ', { ret, reason, selfShareStateInfo })
        resolve({ ret, reason, selfShareStateInfo })
      }
      log.info('getSelfShareState, in param = ')
      this.uisdkService.getConfCtrlApi().getSelfShareState(resultCallback)
    })
  }

  async startShare (startShareInfo) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('startShare, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('startShare, in param = ', startShareInfo)
      this.uisdkService.getConfCtrlApi().startShare(startShareInfo, resultCallback)
    })
  }

  async stopShare () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('stopShare, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('stopShare, in param = ')
      this.uisdkService.getConfCtrlApi().stopShare(resultCallback)
    })
  }

  async setAvatarStyle (avatarStyle) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setAvatarStyle, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setAvatarStyle, in param = ', avatarStyle)
      this.uisdkService.getUIConfigApi().setAvatarStyle(avatarStyle, resultCallback)
    })
  }

  async openSubtitle (isOpen) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, isOpen) => {
        log.info('openSubtitle, out data = ', { ret, reason, isOpen })
        resolve({ ret, reason, isOpen })
      }
      log.info('openSubtitle, in param = ', isOpen)
      this.uisdkService.getConfCtrlApi().openSubtitle(isOpen, resultCallback)
    })
  }

  async subscribeSubtitle (isSubscribe) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, isSubscribe) => {
        log.info('subscribeSubtitle, out data = ', { ret, reason, isSubscribe })
        resolve({ ret, reason, isSubscribe })
      }
      log.info('subscribeSubtitle, in param = ', isSubscribe)
      this.uisdkService.getConfCtrlApi().subscribeSubtitle(isSubscribe, resultCallback)
    })
  }

  async subscribeSubtitleLanguage (targetLanguageType) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, targetLanguageType) => {
        log.info('subscribeSubtitleLanguage, out data = ', { ret, reason, targetLanguageType })
        resolve({ ret, reason, targetLanguageType })
      }
      log.info('subscribeSubtitleLanguage, in param = ', targetLanguageType)
      this.uisdkService.getConfCtrlApi().subscribeSubtitleLanguage(targetLanguageType, resultCallback)
    })
  }

  async getSubtitleSupportLanguage () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, languageInfo) => {
        log.info('getSubtitleSupportLanguage, out data = ', { ret, reason, languageInfo })
        resolve({ ret, reason, languageInfo })
      }
      log.info('getSubtitleSupportLanguage, in param')
      this.uisdkService.getConfCtrlApi().getSubtitleSupportLanguage(resultCallback)
    })
  }

  async openWaitingRoom (isOpen) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, isOpen) => {
        log.info('openWaitingRoom, out data = ', { ret, reason, isOpen })
        resolve({ ret, reason, isOpen })
      }
      log.info('openWaitingRoom, in param = ', isOpen)
      this.uisdkService.getConfCtrlApi().openWaitingRoom(isOpen, resultCallback)
    })
  }

  async operateLocalRecord (type) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, type) => {
        log.info('operateLocalRecord, out data = ', { ret, reason, type })
        resolve({ ret, reason, type })
      }
      log.info('operateLocalRecord, in param = ', type)
      this.uisdkService.getConfCtrlApi().operateLocalRecord(type, resultCallback)
    })
  }

  async openVirtualBackgroundSettingPage () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('openVirtualBackgroundSettingPage, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('openVirtualBackgroundSettingPage, in param')
      this.uisdkService.getConfCtrlApi().openVirtualBackgroundSettingPage(resultCallback)
    })
  }

  async getConfLocalRecordStatus () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, state) => {
        log.info('getConfLocalRecordStatus, out data = ', { ret, reason, state })
        resolve({ ret, reason, state })
      }
      log.info('getConfLocalRecordStatus, in param')
      this.uisdkService.getConfCtrlApi().getConfLocalRecordStatus(resultCallback)
    })
  }

  async getSelfHasLocalRecordPermission () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, permission) => {
        log.info('getSelfHasLocalRecordPermission, out data = ', { ret, reason, permission })
        resolve({ ret, reason, permission })
      }
      log.info('getSelfHasLocalRecordPermission, in param')
      this.uisdkService.getConfCtrlApi().getSelfHasLocalRecordPermission(resultCallback)
    })
  }

  async requestLocalRecordPermission () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('requestLocalRecordPermission, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('requestLocalRecordPermission, in param')
      this.uisdkService.getConfCtrlApi().requestLocalRecordPermission(resultCallback)
    })
  }

  async applyHostRole (password) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('applyHostRole, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('applyHostRole, in param = ', password)
      this.uisdkService.getConfCtrlApi().applyHostRole(password, resultCallback)
    })
  }

  async getSubtitlePageOpened () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, isOpen) => {
        log.info('getSubtitlePageOpened, out data = ', { ret, reason, isOpen })
        resolve({ ret, reason, isOpen })
      }
      log.info('getSubtitlePageOpened, in param')
      this.uisdkService.getConfCtrlApi().getSubtitlePageOpened(resultCallback)
    })
  }

  async getWaitingRoomOpened () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, isOpen) => {
        log.info('getWaitingRoomOpened, out data = ', { ret, reason, isOpen })
        resolve({ ret, reason, isOpen })
      }
      log.info('getWaitingRoomOpened, in param')
      this.uisdkService.getConfCtrlApi().getWaitingRoomOpened(resultCallback)
    })
  }

  async getVirtualBackgroundSettingPageOpened () {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason, isOpen) => {
        log.info('getVirtualBackgroundSettingPageOpened, out data = ', { ret, reason, isOpen })
        resolve({ ret, reason, isOpen })
      }
      log.info('getVirtualBackgroundSettingPageOpened, in param')
      this.uisdkService.getConfCtrlApi().getVirtualBackgroundSettingPageOpened(resultCallback)
    })
  }

  async setVirtualBackgroundDefaultImages (param) {
    return new Promise((resolve) => {
      const resultCallback = (ret, reason) => {
        log.info('setVirtualBackgroundDefaultImages, out data = ', { ret, reason })
        resolve({ ret, reason })
      }
      log.info('setVirtualBackgroundDefaultImages, mode: ', param.mode)
      this.uisdkService.getConfigApi().setVirtualBackgroundDefaultImages(param)
    })
  }

  init (initInfo) {
    log.info('init, in param = ', initInfo)
    const ret = this.uisdkService.init(initInfo)
    log.info('init, out data = ', ret)
    return ret
  }

  exit () {
    log.info('exit, in param = ')
    const ret = this.uisdkService.exit()
    log.info('exit, out data = ', ret)
    return ret
  }
}
