import UISDKService from 'hwmsdk-electron'
import moment from 'moment'
import { ClickInjectBtn } from '../Constants/enum'
import { getNodePath } from './getNodePath'
import { getErrorTips } from '../utils'

const fs = require('fs')
const path = require('path')
const log = require('electron-log')

export default class NotifyService {
  static setNotifyFunc () {
    const nodePath = getNodePath()
    log.info('NotifyService nodePath', nodePath)
    const uisdkService = new UISDKService(nodePath)
    uisdkService.getLoginApi().setOnKickedOutNotifyCB(NotifyService.handleOnKickedOutNotify)
    uisdkService.getLoginApi().setOnCorpConfigNotifyCB(NotifyService.handleOnCorpConfigNotify)
    uisdkService.getLoginApi().setOnLoginErrorNotifyCB(NotifyService.handleOnLoginErrorNotify)
    uisdkService.getLoginApi().setOnLoginStateChangeNotifyCB(NotifyService.handleOnLoginStateChangeNotify)
    uisdkService.getConfCtrlApi().setOnConfStateChangedCB(NotifyService.handleOnConfStateChanged)
    uisdkService.getConfCtrlApi().setOnShareStateChangedCB(NotifyService.handleOnShareStateChanged)
    uisdkService.getConfCtrlApi().setOnConfEndedNotifyCB(NotifyService.handleOnConfEndedNotify)
    uisdkService.getConfCtrlApi().setOnConfInfoNotifyCB(NotifyService.handleOnConfInfoNotify)
    uisdkService.getConfCtrlApi().setOnSelfRoleChangedCB(NotifyService.handleOnSelfRoleChanged)
    uisdkService.getConfMgrApi().setOnConfListChangedCB(NotifyService.handleOnConfListChanged)
    uisdkService.getConfMgrApi().setOnCreateConfFinishedNotifyCB(NotifyService.handleOnCreateConfFinishedNotify)
    uisdkService.getUIConfigApi().setOnClickInjectBtnNotifyCB(NotifyService.handleOnClickInjectBtnNotify)
    uisdkService.getUIConfigApi().setOnClickInjectParticipantItemBtnNotifyCB(NotifyService.handleOnClickInjectParticipantItemBtnNotify)
    uisdkService.getUIConfigApi().setOnClickInjectCallAllBtnNotifyCB(NotifyService.handleOnClickInjectCallAllBtnNotify)
    uisdkService.getUIConfigApi().setOnRenderWindowInfoListChangedCB(NotifyService.handleOnRenderWindowInfoListChanged)
    uisdkService.getUIConfigApi().setOnQueryContactAvatarNotifyCB(NotifyService.handleOnQueryContactAvatarNotify)
    uisdkService.getCallApi().setOnCallStateChangedCB(NotifyService.handleOnCallStateChanged)
    uisdkService.getCallApi().setOnCallEndedNotifyCB(NotifyService.handleOnCallEndedNotify)
    uisdkService.setOnSdkDisconnectedNotifyCB(NotifyService.handleOnSdkDisconnectedNotify)
    uisdkService.getConfCtrlApi().setOnP2PConfRecordNotifyCB(NotifyService.handleOnP2PConfRecordNotify)
    uisdkService.getLoginApi().setOnShareVmrInfoNotifyCB(NotifyService.handleOnShareVmrInfoNotify)
    uisdkService.getConfigApi().setOnAudioFrameNotifyCB(NotifyService.handleOnAudioFrameNotify)
    uisdkService.getConfCtrlApi().setOnMeetingInfoChangedCB(NotifyService.handleOnMeetingInfoChanged)
    uisdkService.getConfigApi().setOnUserSavePathChangedCB(NotifyService.handleOnUserSavePathChanged)
    uisdkService.getConfMgrApi().setOnConfIncomingNotifyCB(NotifyService.handleOnConfIncomingNotify)
    uisdkService.getConfCtrlApi().setOnWaitingListChangedCB(NotifyService.handleOnWaitingListChanged)
    uisdkService.getConfCtrlApi().setOnAddAttendeeNotifyCB(NotifyService.handleOnAddAttendeeNotify)
    uisdkService.getConfCtrlApi().setOnSelfLocalRecordStateNotifyCB(NotifyService.handleOnSelfLocalRecordStateNotify)
    uisdkService.getUIConfigApi().setOnDoubleClickParticipantListItemNotifyCB(NotifyService.handleOnDoubleClickParticipantListItemNotify)
    uisdkService.getConfCtrlApi().setOnAttendeeListChangedCB(NotifyService.handleOnAttendeeListChanged)
    uisdkService.getConfCtrlApi().setOnSubtitleStateChangedCB(NotifyService.handleOnSubtitleStateChanged)
    uisdkService.getConfCtrlApi().setOnWaitingRoomStateChangedCB(NotifyService.handleOnWaitingRoomStateChanged)
    uisdkService.getConfCtrlApi().setOnStartLocalRecordOperationInterruptNotifyCB(NotifyService.handleOnStartLocalRecordOperationInterruptNotify)
    uisdkService.getConfCtrlApi().setOnRealTimeSubtitleInfoNotifyCB(NotifyService.handleOnRealTimeSubtitleInfoNotify)
    uisdkService.getConfCtrlApi().setOnSubtitleRecordNotifyCB(NotifyService.handleOnSubtitleRecordNotify)
  }

  static handleOnKickedOutNotify () {
    log.info('OnKickedOutNotify')
    window.location.hash = '#/'
    window.sessionStorage.setItem('confListInfo', '')
  }

  static handleOnCorpConfigNotify (configInfo) {
    log.info('OnCorpConfigNotify', ', configInfo = ', configInfo)
  }

  static handleOnLoginErrorNotify (ret, reason) {
    log.info('OnLoginErrorNotify', ', ret = ', ret, ', reason = ', reason)
    getErrorTips(ret)
      .then(errorTips => {
        log.info('OnLoginErrorNotify', 'errorTips = ', errorTips)
      })
  }

  static handleOnLoginStateChangeNotify (loginStateInfo) {
    log.info('OnLoginStateChangeNotify', ', loginStateInfo = ', loginStateInfo)
  }

  static handleOnShareVmrInfoNotify (res) {
    log.info('OnShareVmrInfoNotify', ', res = ', res)
  }

  static handleOnConfStateChanged (confStateInfo) {
    log.info('OnConfStateChanged', ', confStateInfo = ', confStateInfo)
  }

  static handleOnShareStateChanged (shareStateInfo) {
    log.info('OnShareStateChanged', ', shareStateInfo = ', shareStateInfo)
  }

  static handleOnConfEndedNotify (confEndInfo) {
    log.info('OnConfEndedNotify', ', confEndInfo = ', confEndInfo)

    getErrorTips(confEndInfo.reason)
      .then(errorTips => {
        log.info('OnConfEndedNotify', 'errorTips = ', errorTips)
      })
  }

  static handleOnConfInfoNotify (confInfo) {
    log.info('OnConfInfoNotify', ', confInfo = ', confInfo)
  }

  static handleOnSelfRoleChanged (role) {
    log.info('OnSelfRoleChanged', ', role = ', role)
  }

  static handleOnConfListChanged (confListInfo) {
    log.info('OnConfListChanged', ', confListInfo = ', confListInfo)
    let _confListInfo = window.sessionStorage.getItem('confListInfo')
    _confListInfo = _confListInfo ? JSON.parse(_confListInfo) : []
    log.info('sessionStorage confList:', _confListInfo)
    const conflistNew = confListInfo.confListItem
    const _data = JSON.stringify(conflistNew || [])
    window.sessionStorage.setItem('confListInfo', _data)
  }

  static handleOnClickInjectBtnNotify (injectBtnInfo) {
    log.info('OnClickInjectBtnNotify', ', injectBtnInfo = ', injectBtnInfo)
    switch (injectBtnInfo.injectBtn) {
      // 邀请按钮点击事件
      case ClickInjectBtn.HWM_CLICK_INJECT_BTN_INVITE:
        // 显示添加与会人界面
        window.location.hash = '#/confCtrlPage/addAttendee'
        window.electron.ipcRenderer.send('show-add-attendee-window')
        break
      default:
        break
    }
  }

  static handleOnClickInjectParticipantItemBtnNotify (injectBtnInfo) {
    log.info('OnClickInjectParticipantItemBtnNotify', ', injectBtnInfo = ', injectBtnInfo)
  }

  static handleOnClickInjectCallAllBtnNotify (injectBtnInfo) {
    log.info('OnClickInjectCallAllBtnNotify', ', injectBtnInfo = ', injectBtnInfo)
  }

  static handleOnRenderWindowInfoListChanged (hwndInfo) {
    log.info('OnRenderWindowInfoListChanged', ', hwndInfo = ', hwndInfo)
  }

  static handleOnQueryContactAvatarNotify (contactInfo) {
    log.info('OnQueryContactAvatarNotify', ', contactInfo = ', contactInfo)
  }

  static handleOnCallStateChanged (callStateInfo) {
    log.info('OnCallStateChanged', ', callStateInfo = ', callStateInfo)
  }

  static handleOnCallEndedNotify (callRecordInfo) {
    log.info('OnCallEndedNotify', ', callRecordInfo = ', callRecordInfo)
  }

  static handleOnSdkDisconnectedNotify () {
    log.info('OnSdkDisconnectedNotify')
    // 退回登录界面
    window.location.hash = '#/'
    // 弹框提示请重新初始化
    window.electron.ipcRenderer.send('show-error-alert', 'OnSdkDisconnectedNotify, Please init')
  }

  static handleOnP2PConfRecordNotify (P2PConfRecordInfo) {
    log.info('OnP2PConfRecordNotify', ', P2PConfRecordInfo = ', P2PConfRecordInfo)

    getErrorTips(P2PConfRecordInfo.resultCode)
      .then(errorTips => {
        log.info('OnP2PConfRecordNotify', 'errorTips = ', errorTips)
      })
  }

  static beforeOnAudioFrameNotifyTime
  static handleOnAudioFrameNotify (audioFrameData) {
    try {
      let codeRate = 0
      const currTime = moment()
      if (NotifyService.beforeOnAudioFrameNotifyTime) {
        codeRate = currTime.diff(NotifyService.beforeOnAudioFrameNotifyTime, 'ms')
      }
      log.info('OnAudioFrameNotify', `codeRate = ${codeRate} , currTime = ${currTime.format('x')}, audioFrameData = `, audioFrameData)

      // 假设这是您的PCM数据，它是一个Buffer
      const pcmData = Buffer.from(audioFrameData.pBuffer)

      // 定义文件路径和文件名
      const filePath = path.join(__dirname, 'output.pcm')
      fs.appendFileSync(filePath, pcmData)

      NotifyService.beforeOnAudioFrameNotifyTime = currTime
    } catch (ex) {
      log.error('OnAudioFrameNotify error', ex)
    }
  }

  static handleOnMeetingInfoChanged (meetingInfo) {
    log.info('OnMeetingInfoChanged', ', meetingInfo = ', meetingInfo)
  }

  static handleOnUserSavePathChanged (userSavePathInfo) {
    log.info('OnUserSavePathChanged, userSavePathInfo = ', userSavePathInfo)
  }

  static handleOnConfIncomingNotify (confIncomingInfo) {
    log.info('OnConfIncomingNotify, confIncomingInfo = ', confIncomingInfo)
  }

  static handleOnWaitingListChanged (waitingList) {
    log.info('OnWaitingListChanged, waitingList = ', waitingList)
  }

  static handleOnAddAttendeeNotify (addAttendeeResultList) {
    log.info('OnAddAttendeeNotify, addAttendeeResultList = ', addAttendeeResultList)
  }

  static handleOnSelfLocalRecordStateNotify (localRecordStateInfo) {
    log.info('OnSelfLocalRecordStateNotify, localRecordStateInfo = ', localRecordStateInfo)
  }

  static handleOnDoubleClickParticipantListItemNotify (participantInfo) {
    log.info('OnDoubleClickParticipantListItemNotify, participantInfo = ', participantInfo)
  }

  static handleOnAttendeeListChanged (attendeeList) {
    log.info('OnAttendeeListChanged, attendeeList = ', attendeeList)
  }

  static handleOnSubtitleStateChanged (isOpen) {
    log.info('OnSubtitleStateChanged, isOpen = ', isOpen)
  }

  static handleOnWaitingRoomStateChanged (isOpen) {
    log.info('OnWaitingRoomStateChanged, isOpen = ', isOpen)
  }

  static handleOnStartLocalRecordOperationInterruptNotify (info) {
    log.info('OnStartLocalRecordOperationInterruptNotify, info = ', info)
  }

  static handleOnRealTimeSubtitleInfoNotify (info) {
    log.info('OnRealTimeSubtitleInfoNotify, info = ', info)
  }

  static handleOnSubtitleRecordNotify (info) {
    log.info('OnSubtitleRecordNotify, info = ', info)
  }

  static handleOnCreateConfFinishedNotify (ret, reason, info) {
    log.info('OnCreateConfFinishedNotify, ret = ', ret, ', reason = ', reason, ', info = ', info)
  }
}
