import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'
import { TargetLanguageType } from '../../../../Constants/enum'
import { TargetLanguageTypeOptions } from '../../../../Constants/typeOption'

class OpenSubtitle extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isOpen: false,
      isSubsubscribe: false,
      targetLanguageType: TargetLanguageType.SUBTITLE_LANGUAGE_DEFAULT,
    }
  }

  changeisOpen (e) {
    this.setState({
      isOpen: e.target.checked,
    })
  }

  changeisSubscribe (e) {
    this.setState({
      isSubsubscribe: e.target.checked,
    })
  }

  changeLanguageType (e) {
    const val = Number(e.target.value)
    this.setState({
      targetLanguageType: val,
    })
  }

  // 打开字幕窗口
  async goOpenSubtitle () {
    const { isOpen } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.openSubtitle(isOpen)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  // 订阅字幕内容
  async goSubscribeSubtitle () {
    const { isSubsubscribe } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.subscribeSubtitle(isSubsubscribe)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  // 获取字幕语言列表
  async goGetSubtitleSupportLanguage () {
    const apiService = new ApiService()
    const setResult = await apiService.getSubtitleSupportLanguage()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  // 订阅字幕语言类型
  async goSubscribeSubtitleLanguage () {
    const { targetLanguageType } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.subscribeSubtitleLanguage(targetLanguageType)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="area">
          <div className="input-box">
            <div className="input-box-title-check">Is Open:</div>
            <div className="input-box-text-check"><input type="checkbox" checked={this.state.isOpen} onChange={this.changeisOpen.bind(this)} /></div>
          </div>
          <button onClick={this.goOpenSubtitle.bind(this)}>Open Subtitle</button>
          <div className="input-box">
            <div className="input-box-title-check">Is Subscribe:</div>
            <div className="input-box-text-check"><input type="checkbox" checked={this.state.isSubscribe} onChange={this.changeisSubscribe.bind(this)} /></div>
          </div>
          <button onClick={this.goSubscribeSubtitle.bind(this)}>Subscribe Subtitle</button>
          <div className="input-box">
          <div className="input-box-title-check">Choose Target Language:</div>
            <select value={this.state.targetLanguageType} onChange={this.changeLanguageType.bind(this)}>
              {TargetLanguageTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
          <button onClick={this.goSubscribeSubtitleLanguage.bind(this)}>Subscribe Subtitle Language</button>
          <button onClick={this.goGetSubtitleSupportLanguage.bind(this)}>Get Subtitle Languages</button>
          <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default OpenSubtitle
