import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { LocalRecordOperateType } from '../../../../Constants/enum'
import { LocalRecordOperateTypeOptions } from '../../../../Constants/typeOption'
import { showErrorTips } from '../../../../utils'

class OperateLocalRecord extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      type: LocalRecordOperateType.LOCAL_RECORD_OPERATE_TYPE_STOP,
    }
  }

  changeisOpen (e) {
    this.setState({
      isOpen: e.target.checked,
    })
  }

  changeLocalRecordOperateType (e) {
    const val = Number(e.target.value)
    this.setState({
      type: val,
    })
  }

  async goOperateLocalRecord () {
    const { type } = this.state
    const apiService = new ApiService()
    const setResult = await apiService.operateLocalRecord(type)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="area">
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>OperateType:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select value={this.state.type} onChange={this.changeLocalRecordOperateType.bind(this)}>
              {LocalRecordOperateTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>

        <button onClick={this.goOperateLocalRecord.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default OperateLocalRecord
