import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'
import { isMac } from 'hwmsdk-electron-demo/src/common/platform'

class ConfCtrlPage extends React.Component {
  constructor (props) {
    super(props)
    this.state = {

    }
  }

  goToAddAttendee () {
    this.props.history.push('/confCtrlPage/addAttendee')
  }

  async goToEndConf () {
    const apiService = new ApiService()
    const setResult = await apiService.endConf()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetAttendeeList () {
    const apiService = new ApiService()
    const setResult = await apiService.getAttendeeList()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetAudienceList () {
    const apiService = new ApiService()
    const setResult = await apiService.getAudienceList()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToLeaveConf () {
    const apiService = new ApiService()
    const setResult = await apiService.leaveConf()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetSelfRole () {
    const apiService = new ApiService()
    const setResult = await apiService.getSelfRole()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToSetAutoHideToolBar () {
    this.props.history.push('/confCtrlPage/setAutoHideToolBar')
  }

  async goToGetSelfShareState () {
    const apiService = new ApiService()
    const setResult = await apiService.getSelfShareState()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToStartShare () {
    this.props.history.push('/confCtrlPage/startShare')
  }

  async goToStopShare () {
    const apiService = new ApiService()
    const setResult = await apiService.stopShare()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToOpenSubtitle () {
    this.props.history.push('/confCtrlPage/openSubtitle')
  }

  goToOpenWaitingRoom () {
    this.props.history.push('/confCtrlPage/openWaitingRoom')
  }

  goToOperateLocalRecord () {
    this.props.history.push('/confCtrlPage/operateLocalRecord')
  }

  async goToOpenVirtualBackgroundSettingPage () {
    const apiService = new ApiService()
    const setResult = await apiService.openVirtualBackgroundSettingPage()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetConfLocalRecordStatus () {
    const apiService = new ApiService()
    const setResult = await apiService.getConfLocalRecordStatus()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetSelfHasLocalRecordPermission () {
    const apiService = new ApiService()
    const setResult = await apiService.getSelfHasLocalRecordPermission()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToRequestLocalRecordPermission () {
    const apiService = new ApiService()
    const setResult = await apiService.requestLocalRecordPermission()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetSubtitlePageOpened () {
    const apiService = new ApiService()
    const setResult = await apiService.getSubtitlePageOpened()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetWaitingRoomOpened () {
    const apiService = new ApiService()
    const setResult = await apiService.getWaitingRoomOpened()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetVirtualBackgroundSettingPageOpened () {
    const apiService = new ApiService()
    const setResult = await apiService.getVirtualBackgroundSettingPageOpened()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToApplyHostRole () {
    this.props.history.push('/confCtrlPage/applyHostRole')
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="confCtrlPage">
                <button onClick={this.goToAddAttendee.bind(this)}>Add Attendee</button>
                <button onClick={this.goToGetAttendeeList.bind(this)}>Get Attendee List</button>
                <button onClick={this.goToGetAudienceList.bind(this)}>Get Audience List</button>
                <button onClick={this.goToLeaveConf.bind(this)}>Leave Conf</button>
                <button onClick={this.goToEndConf.bind(this)}>End Conf</button>
                <button onClick={this.goToGetSelfRole.bind(this)}>Get Self Role</button>
                {!isMac() && <button onClick={this.goToSetAutoHideToolBar.bind(this)}>SetAutoHideToolBar</button>}
                <button onClick={this.goToGetSelfShareState.bind(this)}>GetSelfShareState</button>
                <button onClick={this.goToStartShare.bind(this)}>StartShare</button>
                <button onClick={this.goToStopShare.bind(this)}>StopShare</button>
                <button onClick={this.goToOpenSubtitle.bind(this)}>OpenSubtitle</button>
                <button onClick={this.goToOpenWaitingRoom.bind(this)}>OpenWaitingRoom</button>
                <button onClick={this.goToOperateLocalRecord.bind(this)}>OperateLocalRecord</button>
                <button onClick={this.goToOpenVirtualBackgroundSettingPage.bind(this)}>OpenVirtualBgSettingPage</button>
                <button onClick={this.goToGetConfLocalRecordStatus.bind(this)}>GetConfLocalRecordStatus</button>
                <button onClick={this.goToGetSelfHasLocalRecordPermission.bind(this)}>GetSelfLocalRecordPermission</button>
                <button onClick={this.goToRequestLocalRecordPermission.bind(this)}>RequestLocalRecordPermission</button>
                <button onClick={this.goToApplyHostRole.bind(this)}>ApplyHostRole</button>
                <button onClick={this.goToGetSubtitlePageOpened.bind(this)}>GetSubtitlePageOpened</button>
                <button onClick={this.goToGetWaitingRoomOpened.bind(this)}>GetWaitingRoomOpened</button>
                <button onClick={this.goToGetVirtualBackgroundSettingPageOpened.bind(this)}>VirtualBgSettingPageOpened</button>
                <button style={{ width: '110px' }} onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default ConfCtrlPage
