import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { CapabilityType } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const CapabilityTypeOptions = [
  {
    value: CapabilityType.HWM_CAPABILITY_TYPE_SHOW_HANGUP_ATTENDEE,
    label: 'Show hangup attendee',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_TYPE_HIDE_EXTERNAL_LABEL,
    label: 'Hide external label',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_TYPE_RESOLUTION_1080P,
    label: '1080P resolution',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_TYPE_RESOLUTION_720P,
    label: '720P resolution',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_TYPE_MULTI_MONITOR,
    label: 'Multi-monitor',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_TYPE_HOWLING_DETECTION,
    label: 'Howling detection',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_AUTO_MIC_VOLUME,
    label: 'Automatic microphone volume adjustment',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_SHARE_AUDIO,
    label: 'Share audio',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_HIDE_NO_CAMERA_VIEW,
    label: 'hide no camera view',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_BREAKOUT_CONF,
    label: 'Breakout conf',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_CONFIRM_RECORD,
    label: 'Recording confirmation',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_VOICEPRINT_NOISE_REDUCE,
    label: 'Voiceprint noise reduce',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_SUPPORT_DISCONNECT_AUDIO,
    label: 'Support Disconnect Audio',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_DISCONNECT_AUDIO_TO_JOIN_CONF,
    label: 'Disconnect Audio joinconf',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_CPU_REDUCTION_DETECT,
    label: 'CPU Reduction detect',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_SUPPORT_GUEST_INVITE,
    label: 'Guest Invite',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_HIDE_INVITE_RESULT_TOAST,
    label: 'Hide Invite Result Toast',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_SUPPORT_AUTO_ACCEPT_REMOTE_CONTROL,
    label: 'Support Auto Accept Remote Control',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_HIDE_VB_RISK_TIP,
    label: 'hide virtual background risk tip',
  },
  {
    value: CapabilityType.HWM_CAPABILITY_CONF_END_SHOW_TIPS,
    label: 'Conf End Show Tips',
  },
]

class EnableCapability extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      type: CapabilityType.HWM_CAPABILITY_TYPE_SHOW_HANGUP_ATTENDEE,
      isEnable: false,
    }
  }

  changeType (e) {
    this.setState({
      type: Number(e.target.value),
    })
  }

  changeIsEnable (e) {
    this.setState({
      isEnable: e.target.value !== '0',
    })
  }

  async goEnableCapability () {
    const { type, isEnable } = this.state
    const param = {
      type: parseInt(type),
      isEnable,
    }
    const apiService = new ApiService()
    const setResult = await apiService.enableCapability(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="area">
                <div className="input-box">
                    <div className="input-box-title">Type:</div>
                    <div className="input-box-text">
                        <select value={this.state.type} onChange={this.changeType.bind(this)}>
                            {CapabilityTypeOptions.map(item => {
                              return <option value={item.value} key={item.value}>{item.label}</option>
                            })}
                        </select>
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Enable:</div>
                    <div className="input-box-text">
                        <input type="radio" name="isEnable" value="0" checked={!this.state.isEnable} onChange={this.changeIsEnable.bind(this)}/>No
                        <input type="radio" name="isEnable" value="1" checked={this.state.isEnable} onChange={this.changeIsEnable.bind(this)}/>Yes
                    </div>
                </div>
                <button onClick={this.goEnableCapability.bind(this)}>Submit</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default EnableCapability
