import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { SavePathType } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const SavePathTypeOptions = [
  {
    value: SavePathType.HWM_SAVE_PATH_LOCAL_RECORD,
    label: 'Local Record Path',
  },
]

class GetUserSavePath extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      pathType: SavePathType.HWM_SAVE_PATH_LOCAL_RECORD,
    }
  }

  changePathType (e) {
    this.setState({
      pathType: Number(e.target.value),
    })
  }

  changePath (e) {
    this.setState({
      path: e.target.value,
    })
  }

  async goToGetUserSavePath () {
    const { pathType } = this.state
    const param = {
      pathType,
    }
    const apiService = new ApiService()
    const setResult = await apiService.getUserSavePath(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="getUserSavePath">
        <div className="input-box">
          <div className="input-box-title">Path Type:</div>
          <div className="input-box-text">
            <select value={this.state.pathType} onChange={this.changePathType.bind(this)}>
              {SavePathTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.goToGetUserSavePath.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default GetUserSavePath
