import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { NameShowType, AvatarShape } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const NameShowTypeOptions = [
  {
    value: NameShowType.FIRST_LETTER,
    label: 'First Letter',
  },
  {
    value: NameShowType.FAMILY_NAME,
    label: 'Family Name',
  },
]

const AvatarShapeOptions = [
  {
    value: AvatarShape.CIRCLE,
    label: 'Circle',
  },
]

class SetAvatarStyle extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      backgroundColor: '#ff59aaff',
      textColor: '#ffffffff',
      phoneIconPath: '',
      boardIconPath: '',
      nameShowType: NameShowType.FIRST_LETTER,
      avatarShape: AvatarShape.CIRCLE,
    }
  }

  changeBackgroundColor (e) {
    this.setState({
      backgroundColor: e.target.value,
    })
  }

  changeTextColor (e) {
    this.setState({
      textColor: e.target.value,
    })
  }

  changePhoneIconPath (e) {
    this.setState({
      phoneIconPath: e.target.value,
    })
  }

  changeBoardIconPath (e) {
    this.setState({
      boardIconPath: e.target.value,
    })
  }

  changeNameShowType (e) {
    this.setState({
      nameShowType: Number(e.target.value),
    })
  }

  changeAvatarShape (e) {
    this.setState({
      avatarShape: Number(e.target.value),
    })
  }

  async goToSetAvatarStyle () {
    const { backgroundColor, textColor, phoneIconPath, boardIconPath, nameShowType, avatarShape } = this.state
    const param = {
      backgroundColor,
      textColor,
      phoneIconPath,
      boardIconPath,
      nameShowType,
      avatarShape,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setAvatarStyle(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setAvatarStyle">
        <div className="input-box">
          <div className="input-box-title">BackgroundColor:</div>
          <div className="input-box-text">
            <input value={this.state.backgroundColor} onChange={this.changeBackgroundColor.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">TextColor:</div>
          <div className="input-box-text">
            <input value={this.state.textColor} onChange={this.changeTextColor.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">PhoneIconPath:</div>
          <div className="input-box-text">
            <input value={this.state.phoneIconPath} onChange={this.changePhoneIconPath.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">BoardIconPath:</div>
          <div className="input-box-text">
            <input value={this.state.boardIconPath} onChange={this.changeBoardIconPath.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">NameShowType:</div>
          <div className="input-box-text">
            <select value={this.state.nameShowType} onChange={this.changeNameShowType.bind(this)}>
              {NameShowTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AvatarShape:</div>
          <div className="input-box-text">
            <select value={this.state.avatarShape} onChange={this.changeAvatarShape.bind(this)}>
              {AvatarShapeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.goToSetAvatarStyle.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetAvatarStyle
