import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class SetDeviceConfigForConfIncoming extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isMicOn: true,
      isCameraOn: false,
    }
  }

  changeIsMicOn (e) {
    this.setState({
      isMicOn: e.target.checked,
    })
  }

  changeIsCameraOn (e) {
    this.setState({
      isCameraOn: e.target.checked,
    })
  }

  async goToSetDeviceConfigForConfIncoming () {
    const { isMicOn, isCameraOn } = this.state
    const param = {
      isMicOn,
      isCameraOn,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setDeviceConfigForConfIncoming(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setDeviceConfigForConfIncoming">
        <div className="input-box">
          <div className="input-box-title-check">IsMicOn:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isMicOn} onChange={this.changeIsMicOn.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsCameraOn:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isCameraOn} onChange={this.changeIsCameraOn.bind(this)} />
          </div>
        </div>
        <button onClick={this.goToSetDeviceConfigForConfIncoming.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetDeviceConfigForConfIncoming
