import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { WaterMarkColorType } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const WaterMarkColorTypeOptions = [
  {
    value: WaterMarkColorType.HWM_WATERMARK_COLOR_TYPE_LIGHT,
    label: 'Light Color',
  },
  {
    value: WaterMarkColorType.HWM_WATERMARK_COLOR_TYPE_STANDARD,
    label: 'Standard Color',
  },
  {
    value: WaterMarkColorType.HWM_WATERMARK_COLOR_TYPE_DARKER,
    label: 'Darker Color',
  },
]

class SetWaterMark extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      content: '',
      color: WaterMarkColorType.HWM_WATERMARK_COLOR_TYPE_LIGHT,
    }
  }

  changeContent (e) {
    this.setState({
      content: e.target.value,
    })
  }

  changeColor (e) {
    this.setState({
      color: Number(e.target.value),
    })
  }

  async goToSetWaterMark () {
    const { content, color } = this.state
    const param = {
      content,
      color,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setWaterMark(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setWaterMark">
        <div className="input-box">
          <div className="input-box-title">Content:</div>
          <div className="input-box-text">
            <input value={this.state.content} onChange={this.changeContent.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Color Type:</div>
          <div className="input-box-text">
            <select value={this.state.color} onChange={this.changeColor.bind(this)}>
              {WaterMarkColorTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.goToSetWaterMark.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetWaterMark
