import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'
import { isMac } from 'hwmsdk-electron-demo/src/common/platform'

class JoinConfById extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      confId: '',
      password: '',
      nickName: '',
      aliasCN: '',
      aliasEN: '',
      corpTrustAppId: '',
      confPrefix: '',
      isSpeakerOff: false,
      isMicOn: true,
      isCameraOn: false,
      isStopConflictConf: false,
      isCascadingMeeting: false,
      extendedField: '',
      isHidePasswordAlert: false,
    }
  }

  changeConfId (e) {
    this.setState({
      confId: e.target.value,
    })
  }

  changePassword (e) {
    this.setState({
      password: e.target.value,
    })
  }

  changeNickName (e) {
    this.setState({
      nickName: e.target.value,
    })
  }

  changeAliasCN (e) {
    this.setState({
      aliasCN: e.target.value,
    })
  }

  changeAliasEN (e) {
    this.setState({
      aliasEN: e.target.value,
    })
  }

  changeCorpTrustAppId (e) {
    this.setState({
      corpTrustAppId: e.target.value,
    })
  }

  changeConfPrefix (e) {
    this.setState({
      confPrefix: e.target.value,
    })
  }

  changeExtendedField (e) {
    this.setState({
      extendedField: e.target.value,
    })
  }

  changeIsSpeakerOff (e) {
    this.setState({
      isSpeakerOff: e.target.checked,
    })
  }

  changeIsMicOn (e) {
    this.setState({
      isMicOn: e.target.checked,
    })
  }

  changeIsCameraOn (e) {
    this.setState({
      isCameraOn: e.target.checked,
    })
  }

  changeIsStopConflictConf (e) {
    this.setState({
      isStopConflictConf: e.target.checked,
    })
  }

  changeIsCascadingMeeting (e) {
    this.setState({
      isCascadingMeeting: e.target.checked,
    })
  }

  changeIsHidePasswordAlert (e) {
    this.setState({
      isHidePasswordAlert: e.target.checked,
    })
  }

  async goToJoinConfById () {
    const { confId, password, nickName, aliasCN, aliasEN, isSpeakerOff, isMicOn, isCameraOn, isStopConflictConf, corpTrustAppId, isCascadingMeeting, confPrefix, extendedField, isHidePasswordAlert } = this.state
    const param = {
      confId,
      password,
      nickName,
      aliasCN,
      aliasEN,
      isSpeakerOff,
      isMicOn,
      isCameraOn,
      isStopConflictConf,
      corpTrustAppId,
      isCascadingMeeting,
      confPrefix,
      extendedField,
      isHidePasswordAlert,
    }
    const apiService = new ApiService()
    const setResult = await apiService.joinConfById(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="joinConfById">
        <div className="input-box">
          <div className="input-box-title">ConfId:</div>
          <div className="input-box-text">
            <input value={this.state.confId} onChange={this.changeConfId.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Password:</div>
          <div className="input-box-text">
            <input value={this.state.password} onChange={this.changePassword.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">NickName:</div>
          <div className="input-box-text">
            <input value={this.state.nickName} onChange={this.changeNickName.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AliasCN:</div>
          <div className="input-box-text">
            <input value={this.state.aliasCN} onChange={this.changeAliasCN.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">AliasEN:</div>
          <div className="input-box-text">
            <input value={this.state.aliasEN} onChange={this.changeAliasEN.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">CorpTrustAppId:</div>
          <div className="input-box-text">
            <input value={this.state.corpTrustAppId} onChange={this.changeCorpTrustAppId.bind(this)} />
          </div>
        </div>
        {!isMac() && <div className="input-box">
          <div className="input-box-title">ConfPrefix:</div>
          <div className="input-box-text">
            <input value={this.state.confPrefix} onChange={this.changeConfPrefix.bind(this)} />
          </div>
        </div>}
        <div className="input-box">
          <div className="input-box-title">ExtendedField:</div>
          <div className="input-box-text">
            <input value={this.state.extendedField} onChange={this.changeExtendedField.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsSpeakerOff:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isSpeakerOff} onChange={this.changeIsSpeakerOff.bind(this)} />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsMicOn:</div>
          <div className="input-box-text-check">
            <input type="checkbox" checked={this.state.isMicOn} onChange={this.changeIsMicOn.bind(this)} />
        </div>
      </div >
      <div className="input-box">
        <div className="input-box-title-check">IsCameraOn:</div>
        <div className="input-box-text-check">
          <input type="checkbox" checked={this.state.isCameraOn} onChange={this.changeIsCameraOn.bind(this)} />
      </div>
        </div >
        <div className="input-box">
        <div className="input-box-title-check">IsStopConflictConf:</div>
        <div className="input-box-text-check">
          <input type="checkbox" checked={this.state.isStopConflictConf} onChange={this.changeIsStopConflictConf.bind(this)} />
        </div>
      </div >
      {!isMac() && <div className="input-box">
        <div className="input-box-title-check">IsCascadingMeeting:</div>
        <div className="input-box-text-check">
          <input type="checkbox" checked={this.state.isCascadingMeeting} onChange={this.changeIsCascadingMeeting.bind(this)} />
        </div>
      </div >}
      {isMac() && <div className="input-box">
        <div className="input-box-title-check">IsHidePasswordAlert:</div>
        <div className="input-box-text-check">
          <input type="checkbox" checked={this.state.isHidePasswordAlert} onChange={this.changeIsHidePasswordAlert.bind(this)} />
        </div>
      </div >}
      <button onClick={this.goToJoinConfById.bind(this)}>Submit</button>
      <button onClick={this.goBack.bind(this)}>Back</button>
      </div >
    )
  }
}

export default JoinConfById
