import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'

class AcceptConf extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isAudioAccept: false,
    }
  }

  changeIsAudioAccept (e) {
    this.setState({
      isAudioAccept: e.target.checked,
    })
  }

  async goToAcceptConf () {
    const { isAudioAccept } = this.state
    const param = {
      isAudioAccept,
    }
    const apiService = new ApiService()
    const setResult = await apiService.acceptConf(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="acceptConf">
        <div className="input-box">
          <div className="input-box-title-check">isAudioAccept:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isAudioAccept} onChange={this.changeIsAudioAccept.bind(this)} /></div>
        </div>
        <button onClick={this.goToAcceptConf.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default AcceptConf
