import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'

class UploadSelfAvatar extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      path: '',
    }
  }

  changePath (e) {
    this.setState({
      path: e.target.value,
    })
  }

  async goToUploadSelfAvatar () {
    const { path } = this.state
    const param = {
      path,
    }
    const apiService = new ApiService()
    const setResult = await apiService.uploadSelfAvatar(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="uploadSelfAvatar">
        <div className="input-box">
          <div className="input-box-title">Path:</div>
          <div className="input-box-text">
            <input value={this.state.path} onChange={this.changePath.bind(this)}/>
          </div>
        </div>
        <button onClick={this.goToUploadSelfAvatar.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default UploadSelfAvatar
