import ApiService from './AppService/ApiService'

export const showErrorTips = async (ret, reason) => {
  const errorMessage = await getErrorTips(ret)

  let showTips = ''
  if (!isNullOrEmpty(errorMessage)) {
    showTips += errorMessage + '\n'
  }
  showTips += '错误码：' + ret + '\n'
  showTips += '错误描述：' + reason + '\n'

  window.electron.ipcRenderer.send('show-error-alert', showTips)
  return reason
}

export const getErrorTips = async (ret) => {
  const apiService = new ApiService()
  const { errorMessage } = await apiService.getErrorMessage(ret)
  return errorMessage
}

export const isNullOrEmpty = (obj) => {
  return (obj === 'undefined' || obj === null || obj === '')
}
