import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import eslintPlugin from 'vite-plugin-eslint'
import { viteStaticCopy } from 'vite-plugin-static-copy'

export default defineConfig({
  base: '',
  publicDir: '../../public',
  plugins: [react(), eslintPlugin({
    fix: true,
    exclude: [
      '**/node_modules/**',
      '**/Constants/enum.*',
      '**/packages/hwmsdk-electron/**',
    ],
  }),
  viteStaticCopy({
    targets: [
      {
        src: '../../node_modules/electron-log',
        dest: 'node_modules',
      },
    ],
  })],
  optimizeDeps: {
    include: ['hwmsdk-electron'],
  },
  build: {
    commonjsOptions: { include: [/hwmsdk-electron/, /node_modules/] },
    outDir: 'dist',
    sourcemap: true,
  },
})
