"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ICall = void 0;
var enum_1 = require("./enum");
var util_1 = require("./util");
var electron = window.require('electron');
var ICall = /** @class */ (function () {
    function ICall(addOn) {
        this.callWithIPC = false;
        this.addOn = addOn;
        this._inProcessCallbackSet = new Set();
        this.callWithIPC = util_1.needCallWithIPC();
    }
    ICall.prototype.init = function () {
        this._inProcessCallbackSet.clear();
    };
    /**
    * [en] Notify of call state. [cn] 通话状态通知
    */
    ICall.prototype.setOnCallStateChangedCB = function (onCallStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnCallStateChangedCB', {});
            electron.ipcRenderer.on('onCallStateChanged', function (event, arg) {
                if (onCallStateChanged) {
                    onCallStateChanged(arg["callStateInfo"]);
                }
            });
            return;
        }
        this._onCallStateChangedCallback = function (callStateInfo) {
            if (onCallStateChanged) {
                onCallStateChanged(callStateInfo);
            }
        };
        this.addOn.setOnCallStateChangedCB(this._onCallStateChangedCallback);
    };
    /**
    * [en] Notify of the call record when the call ended [cn] 通话结束通知
    */
    ICall.prototype.setOnCallEndedNotifyCB = function (onCallEndedNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnCallEndedNotifyCB', {});
            electron.ipcRenderer.on('onCallEndedNotify', function (event, arg) {
                if (onCallEndedNotify) {
                    onCallEndedNotify(arg["callRecordInfo"]);
                }
            });
            return;
        }
        this._onCallEndedNotifyCallback = function (callRecordInfo) {
            if (onCallEndedNotify) {
                onCallEndedNotify(callRecordInfo);
            }
        };
        this.addOn.setOnCallEndedNotifyCB(this._onCallEndedNotifyCallback);
    };
    /**
    * [en] This interface is used to start call. [cn] 发起呼叫
    */
    ICall.prototype.startCall = function (startCallInfo, onStartCallResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("startCall")) {
            if (onStartCallResult) {
                onStartCallResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("startCall");
        this._startCallCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("startCall");
            if (onStartCallResult) {
                onStartCallResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('startCall', { "startCallInfo": startCallInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('startCall');
                if (onStartCallResult) {
                    onStartCallResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.startCall(startCallInfo, this._startCallCallback);
    };
    return ICall;
}());
exports.ICall = ICall;
