"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IConfCtrl = void 0;
var enum_1 = require("./enum");
var util_1 = require("./util");
var electron = window.require('electron');
var IConfCtrl = /** @class */ (function () {
    function IConfCtrl(addOn) {
        this.callWithIPC = false;
        this.addOn = addOn;
        this._inProcessCallbackSet = new Set();
        this.callWithIPC = util_1.needCallWithIPC();
    }
    IConfCtrl.prototype.init = function () {
        this._inProcessCallbackSet.clear();
    };
    /**
    * [en] Notify of conf state. [cn] 会议状态通知
    */
    IConfCtrl.prototype.setOnConfStateChangedCB = function (onConfStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnConfStateChangedCB', {});
            electron.ipcRenderer.on('onConfStateChanged', function (event, arg) {
                if (onConfStateChanged) {
                    onConfStateChanged(arg["confStateInfo"]);
                }
            });
            return;
        }
        this._onConfStateChangedCallback = function (confStateInfo) {
            if (onConfStateChanged) {
                onConfStateChanged(confStateInfo);
            }
        };
        this.addOn.setOnConfStateChangedCB(this._onConfStateChangedCallback);
    };
    /**
    * [en] This class is about the notification of an ended conference. [cn] 会议结束通知
    */
    IConfCtrl.prototype.setOnConfEndedNotifyCB = function (onConfEndedNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnConfEndedNotifyCB', {});
            electron.ipcRenderer.on('onConfEndedNotify', function (event, arg) {
                if (onConfEndedNotify) {
                    onConfEndedNotify(arg["confEndInfo"]);
                }
            });
            return;
        }
        this._onConfEndedNotifyCallback = function (confEndInfo) {
            if (onConfEndedNotify) {
                onConfEndedNotify(confEndInfo);
            }
        };
        this.addOn.setOnConfEndedNotifyCB(this._onConfEndedNotifyCallback);
    };
    /**
    * [en] This class is about the callback of transfering point to point call to conference. [cn] 立即会议记录回调
    */
    IConfCtrl.prototype.setOnP2PConfRecordNotifyCB = function (onP2PConfRecordNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnP2PConfRecordNotifyCB', {});
            electron.ipcRenderer.on('onP2PConfRecordNotify', function (event, arg) {
                if (onP2PConfRecordNotify) {
                    onP2PConfRecordNotify(arg["recordInfo"]);
                }
            });
            return;
        }
        this._onP2PConfRecordNotifyCallback = function (recordInfo) {
            if (onP2PConfRecordNotify) {
                onP2PConfRecordNotify(recordInfo);
            }
        };
        this.addOn.setOnP2PConfRecordNotifyCB(this._onP2PConfRecordNotifyCallback);
    };
    /**
    * [en] Notify of conf info. [cn] 会议信息通知
    */
    IConfCtrl.prototype.setOnConfInfoNotifyCB = function (onConfInfoNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnConfInfoNotifyCB', {});
            electron.ipcRenderer.on('onConfInfoNotify', function (event, arg) {
                if (onConfInfoNotify) {
                    onConfInfoNotify(arg["confInfo"]);
                }
            });
            return;
        }
        this._onConfInfoNotifyCallback = function (confInfo) {
            if (onConfInfoNotify) {
                onConfInfoNotify(confInfo);
            }
        };
        this.addOn.setOnConfInfoNotifyCB(this._onConfInfoNotifyCallback);
    };
    /**
    * [en] Notify of share state. [cn] 共享状态通知
    */
    IConfCtrl.prototype.setOnShareStateChangedCB = function (onShareStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnShareStateChangedCB', {});
            electron.ipcRenderer.on('onShareStateChanged', function (event, arg) {
                if (onShareStateChanged) {
                    onShareStateChanged(arg["shareStateInfo"]);
                }
            });
            return;
        }
        this._onShareStateChangedCallback = function (shareStateInfo) {
            if (onShareStateChanged) {
                onShareStateChanged(shareStateInfo);
            }
        };
        this.addOn.setOnShareStateChangedCB(this._onShareStateChangedCallback);
    };
    /**
    * [en] Notify of receive share state. [cn] 收到共享状态通知
    */
    IConfCtrl.prototype.setOnRecvShareStateChangedCB = function (onRecvShareStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnRecvShareStateChangedCB', {});
            electron.ipcRenderer.on('onRecvShareStateChanged', function (event, arg) {
                if (onRecvShareStateChanged) {
                    onRecvShareStateChanged(arg["shareStateInfo"]);
                }
            });
            return;
        }
        this._onRecvShareStateChangedCallback = function (shareStateInfo) {
            if (onRecvShareStateChanged) {
                onRecvShareStateChanged(shareStateInfo);
            }
        };
        this.addOn.setOnRecvShareStateChangedCB(this._onRecvShareStateChangedCallback);
    };
    /**
    * [en] Self role changed. [cn] 个人角色变化通知
    */
    IConfCtrl.prototype.setOnSelfRoleChangedCB = function (onSelfRoleChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnSelfRoleChangedCB', {});
            electron.ipcRenderer.on('onSelfRoleChanged', function (event, arg) {
                if (onSelfRoleChanged) {
                    onSelfRoleChanged(arg["role"]);
                }
            });
            return;
        }
        this._onSelfRoleChangedCallback = function (role) {
            if (onSelfRoleChanged) {
                onSelfRoleChanged(role);
            }
        };
        this.addOn.setOnSelfRoleChangedCB(this._onSelfRoleChangedCallback);
    };
    /**
    * [en] This class is about the notification of low quality network. [cn] 弱网提示通知
    */
    IConfCtrl.prototype.setOnPoorNetworkQualityInfoNotifyCB = function (onPoorNetworkQualityInfoNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnPoorNetworkQualityInfoNotifyCB', {});
            electron.ipcRenderer.on('onPoorNetworkQualityInfoNotify', function (event, arg) {
                if (onPoorNetworkQualityInfoNotify) {
                    onPoorNetworkQualityInfoNotify(arg["poorNetWorkInfo"]);
                }
            });
            return;
        }
        this._onPoorNetworkQualityInfoNotifyCallback = function (poorNetWorkInfo) {
            if (onPoorNetworkQualityInfoNotify) {
                onPoorNetworkQualityInfoNotify(poorNetWorkInfo);
            }
        };
        this.addOn.setOnPoorNetworkQualityInfoNotifyCB(this._onPoorNetworkQualityInfoNotifyCallback);
    };
    /**
    * [en]Notify of conf info [cn]会中信息更新通知
    */
    IConfCtrl.prototype.setOnMeetingInfoChangedCB = function (onMeetingInfoChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnMeetingInfoChangedCB', {});
            electron.ipcRenderer.on('onMeetingInfoChanged', function (event, arg) {
                if (onMeetingInfoChanged) {
                    onMeetingInfoChanged(arg["meetingInfo"]);
                }
            });
            return;
        }
        this._onMeetingInfoChangedCallback = function (meetingInfo) {
            if (onMeetingInfoChanged) {
                onMeetingInfoChanged(meetingInfo);
            }
        };
        this.addOn.setOnMeetingInfoChangedCB(this._onMeetingInfoChangedCallback);
    };
    /**
    * [en] Notify of the waiting list [cn] 等候室成员列表变更的通知
    */
    IConfCtrl.prototype.setOnWaitingListChangedCB = function (onWaitingListChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnWaitingListChangedCB', {});
            electron.ipcRenderer.on('onWaitingListChanged', function (event, arg) {
                if (onWaitingListChanged) {
                    onWaitingListChanged(arg["waitingList"]);
                }
            });
            return;
        }
        this._onWaitingListChangedCallback = function (waitingList) {
            if (onWaitingListChanged) {
                onWaitingListChanged(waitingList);
            }
        };
        this.addOn.setOnWaitingListChangedCB(this._onWaitingListChangedCallback);
    };
    /**
    * [en] Notify of the add attendee [cn] 添加与会者结果通知
    */
    IConfCtrl.prototype.setOnAddAttendeeNotifyCB = function (onAddAttendeeNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnAddAttendeeNotifyCB', {});
            electron.ipcRenderer.on('onAddAttendeeNotify', function (event, arg) {
                if (onAddAttendeeNotify) {
                    onAddAttendeeNotify(arg["addAttendeeResultList"]);
                }
            });
            return;
        }
        this._onAddAttendeeNotifyCallback = function (addAttendeeResultList) {
            if (onAddAttendeeNotify) {
                onAddAttendeeNotify(addAttendeeResultList);
            }
        };
        this.addOn.setOnAddAttendeeNotifyCB(this._onAddAttendeeNotifyCallback);
    };
    /**
    * [en] Notify of local record state [cn] 本地录制状态通知
    */
    IConfCtrl.prototype.setOnSelfLocalRecordStateNotifyCB = function (onSelfLocalRecordStateNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnSelfLocalRecordStateNotifyCB', {});
            electron.ipcRenderer.on('onSelfLocalRecordStateNotify', function (event, arg) {
                if (onSelfLocalRecordStateNotify) {
                    onSelfLocalRecordStateNotify(arg["localRecordStateInfo"]);
                }
            });
            return;
        }
        this._onSelfLocalRecordStateNotifyCallback = function (localRecordStateInfo) {
            if (onSelfLocalRecordStateNotify) {
                onSelfLocalRecordStateNotify(localRecordStateInfo);
            }
        };
        this.addOn.setOnSelfLocalRecordStateNotifyCB(this._onSelfLocalRecordStateNotifyCallback);
    };
    /**
    * [en] Notify of the attendee list [cn] 与会者列表变更的通知
    */
    IConfCtrl.prototype.setOnAttendeeListChangedCB = function (onAttendeeListChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnAttendeeListChangedCB', {});
            electron.ipcRenderer.on('onAttendeeListChanged', function (event, arg) {
                if (onAttendeeListChanged) {
                    onAttendeeListChanged(arg["attendeeList"]);
                }
            });
            return;
        }
        this._onAttendeeListChangedCallback = function (attendeeList) {
            if (onAttendeeListChanged) {
                onAttendeeListChanged(attendeeList);
            }
        };
        this.addOn.setOnAttendeeListChangedCB(this._onAttendeeListChangedCallback);
    };
    /**
    * [en] Notify of the real time subtitle info [cn] 实时字幕信息的通知
    */
    IConfCtrl.prototype.setOnRealTimeSubtitleInfoNotifyCB = function (onRealTimeSubtitleInfoNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnRealTimeSubtitleInfoNotifyCB', {});
            electron.ipcRenderer.on('onRealTimeSubtitleInfoNotify', function (event, arg) {
                if (onRealTimeSubtitleInfoNotify) {
                    onRealTimeSubtitleInfoNotify(arg["realTimeSubtitleInfo"]);
                }
            });
            return;
        }
        this._onRealTimeSubtitleInfoNotifyCallback = function (realTimeSubtitleInfo) {
            if (onRealTimeSubtitleInfoNotify) {
                onRealTimeSubtitleInfoNotify(realTimeSubtitleInfo);
            }
        };
        this.addOn.setOnRealTimeSubtitleInfoNotifyCB(this._onRealTimeSubtitleInfoNotifyCallback);
    };
    /**
    * [en] Notify of the subtitle record info [cn] 字幕记录消息的通知
    */
    IConfCtrl.prototype.setOnSubtitleRecordNotifyCB = function (onSubtitleRecordNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnSubtitleRecordNotifyCB', {});
            electron.ipcRenderer.on('onSubtitleRecordNotify', function (event, arg) {
                if (onSubtitleRecordNotify) {
                    onSubtitleRecordNotify(arg["subtitleRecordInfo"]);
                }
            });
            return;
        }
        this._onSubtitleRecordNotifyCallback = function (subtitleRecordInfo) {
            if (onSubtitleRecordNotify) {
                onSubtitleRecordNotify(subtitleRecordInfo);
            }
        };
        this.addOn.setOnSubtitleRecordNotifyCB(this._onSubtitleRecordNotifyCallback);
    };
    /**
    * [en] Notify of subtitle state change [cn] 字幕状态变更通知
    */
    IConfCtrl.prototype.setOnSubtitleStateChangedCB = function (onSubtitleStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnSubtitleStateChangedCB', {});
            electron.ipcRenderer.on('onSubtitleStateChanged', function (event, arg) {
                if (onSubtitleStateChanged) {
                    onSubtitleStateChanged(arg["isOpen"]);
                }
            });
            return;
        }
        this._onSubtitleStateChangedCallback = function (isOpen) {
            if (onSubtitleStateChanged) {
                onSubtitleStateChanged(isOpen);
            }
        };
        this.addOn.setOnSubtitleStateChangedCB(this._onSubtitleStateChangedCallback);
    };
    /**
    * [en] Notify of waiting room state change [cn] 等候室状态变更通知
    */
    IConfCtrl.prototype.setOnWaitingRoomStateChangedCB = function (onWaitingRoomStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnWaitingRoomStateChangedCB', {});
            electron.ipcRenderer.on('onWaitingRoomStateChanged', function (event, arg) {
                if (onWaitingRoomStateChanged) {
                    onWaitingRoomStateChanged(arg["isOpen"]);
                }
            });
            return;
        }
        this._onWaitingRoomStateChangedCallback = function (isOpen) {
            if (onWaitingRoomStateChanged) {
                onWaitingRoomStateChanged(isOpen);
            }
        };
        this.addOn.setOnWaitingRoomStateChangedCB(this._onWaitingRoomStateChangedCallback);
    };
    /**
    * [en] Notify of local record operation interrupt notify [cn] 本地录制操作中断通知
    */
    IConfCtrl.prototype.setOnStartLocalRecordOperationInterruptNotifyCB = function (onStartLocalRecordOperationInterruptNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnStartLocalRecordOperationInterruptNotifyCB', {});
            electron.ipcRenderer.on('onStartLocalRecordOperationInterruptNotify', function (event, arg) {
                if (onStartLocalRecordOperationInterruptNotify) {
                    onStartLocalRecordOperationInterruptNotify(arg["info"]);
                }
            });
            return;
        }
        this._onStartLocalRecordOperationInterruptNotifyCallback = function (info) {
            if (onStartLocalRecordOperationInterruptNotify) {
                onStartLocalRecordOperationInterruptNotify(info);
            }
        };
        this.addOn.setOnStartLocalRecordOperationInterruptNotifyCB(this._onStartLocalRecordOperationInterruptNotifyCallback);
    };
    /**
    * [en]Notify of forbidden screenshots enabletype changed [cn]禁止截屏开关状态变更
    */
    IConfCtrl.prototype.setOnConfForbiddenScreenShotsEnableChangedCB = function (onConfForbiddenScreenShotsEnableChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnConfForbiddenScreenShotsEnableChangedCB', {});
            electron.ipcRenderer.on('onConfForbiddenScreenShotsEnableChanged', function (event, arg) {
                if (onConfForbiddenScreenShotsEnableChanged) {
                    onConfForbiddenScreenShotsEnableChanged(arg["enableType"]);
                }
            });
            return;
        }
        this._onConfForbiddenScreenShotsEnableChangedCallback = function (enableType) {
            if (onConfForbiddenScreenShotsEnableChanged) {
                onConfForbiddenScreenShotsEnableChanged(enableType);
            }
        };
        this.addOn.setOnConfForbiddenScreenShotsEnableChangedCB(this._onConfForbiddenScreenShotsEnableChangedCallback);
    };
    /**
    * [en] This interface is used to create conf. [cn] 创建会议
    */
    IConfCtrl.prototype.createConf = function (createConfInfo, onCreateConfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("createConf")) {
            if (onCreateConfResult) {
                var nullResult = {};
                onCreateConfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("createConf");
        this._createConfCallback = function (ret, reason, createConfResult) {
            _this._inProcessCallbackSet.delete("createConf");
            if (onCreateConfResult) {
                onCreateConfResult(ret, reason, createConfResult);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('createConf', { "createConfInfo": createConfInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('createConf');
                if (onCreateConfResult) {
                    onCreateConfResult(ret["ret"], ret["reason"], ret["createConfResult"]);
                }
            });
        }
        this.addOn.createConf(createConfInfo, this._createConfCallback);
    };
    /**
    * [en] This interface is used to start p2p conf. [cn] 发起立即会议
    */
    IConfCtrl.prototype.startP2pConf = function (startCallInfo, onStartP2pConfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("startP2pConf")) {
            if (onStartP2pConfResult) {
                var nullResult = {};
                onStartP2pConfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("startP2pConf");
        this._startP2pConfCallback = function (ret, reason, createConfResult) {
            _this._inProcessCallbackSet.delete("startP2pConf");
            if (onStartP2pConfResult) {
                onStartP2pConfResult(ret, reason, createConfResult);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('startP2pConf', { "startCallInfo": startCallInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('startP2pConf');
                if (onStartP2pConfResult) {
                    onStartP2pConfResult(ret["ret"], ret["reason"], ret["createConfResult"]);
                }
            });
        }
        this.addOn.startP2pConf(startCallInfo, this._startP2pConfCallback);
    };
    /**
    * [en] This interface is used to join conf by id. [cn] 加入会议
    */
    IConfCtrl.prototype.joinConfById = function (joinConfByIdInfo, onJoinConfByIdResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("joinConfById")) {
            if (onJoinConfByIdResult) {
                onJoinConfByIdResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("joinConfById");
        this._joinConfByIdCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("joinConfById");
            if (onJoinConfByIdResult) {
                onJoinConfByIdResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('joinConfById', { "joinConfByIdInfo": joinConfByIdInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('joinConfById');
                if (onJoinConfByIdResult) {
                    onJoinConfByIdResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.joinConfById(joinConfByIdInfo, this._joinConfByIdCallback);
    };
    /**
    * [en] This interface is used to join conf by random. [cn] Random入会
    */
    IConfCtrl.prototype.joinConfByRandom = function (joinConfByRandomInfo, onJoinConfByRandomResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("joinConfByRandom")) {
            if (onJoinConfByRandomResult) {
                onJoinConfByRandomResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("joinConfByRandom");
        this._joinConfByRandomCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("joinConfByRandom");
            if (onJoinConfByRandomResult) {
                onJoinConfByRandomResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('joinConfByRandom', { "joinConfByRandomInfo": joinConfByRandomInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('joinConfByRandom');
                if (onJoinConfByRandomResult) {
                    onJoinConfByRandomResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.joinConfByRandom(joinConfByRandomInfo, this._joinConfByRandomCallback);
    };
    /**
    * [en] This interface is used to add attendee. [cn] 添加与会者
    */
    IConfCtrl.prototype.addAttendee = function (addAttendeeInfo, onAddAttendeeResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("addAttendee")) {
            if (onAddAttendeeResult) {
                onAddAttendeeResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("addAttendee");
        this._addAttendeeCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("addAttendee");
            if (onAddAttendeeResult) {
                onAddAttendeeResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('addAttendee', { "addAttendeeInfo": addAttendeeInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('addAttendee');
                if (onAddAttendeeResult) {
                    onAddAttendeeResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.addAttendee(addAttendeeInfo, this._addAttendeeCallback);
    };
    /**
    * [en] This interface is used to leave conf. [cn] 离开会议
    */
    IConfCtrl.prototype.leaveConf = function (onLeaveConfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("leaveConf")) {
            if (onLeaveConfResult) {
                onLeaveConfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("leaveConf");
        this._leaveConfCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("leaveConf");
            if (onLeaveConfResult) {
                onLeaveConfResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('leaveConf', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('leaveConf');
                if (onLeaveConfResult) {
                    onLeaveConfResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.leaveConf(this._leaveConfCallback);
    };
    /**
    * [en] This interface is used to end conf. [cn] 结束会议
    */
    IConfCtrl.prototype.endConf = function (onEndConfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("endConf")) {
            if (onEndConfResult) {
                onEndConfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("endConf");
        this._endConfCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("endConf");
            if (onEndConfResult) {
                onEndConfResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('endConf', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('endConf');
                if (onEndConfResult) {
                    onEndConfResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.endConf(this._endConfCallback);
    };
    /**
    * [en] This interface is used to start share. [cn] 开启共享
    */
    IConfCtrl.prototype.startShare = function (startShareInfo, onStartShareResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("startShare")) {
            if (onStartShareResult) {
                onStartShareResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("startShare");
        this._startShareCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("startShare");
            if (onStartShareResult) {
                onStartShareResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('startShare', { "startShareInfo": startShareInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('startShare');
                if (onStartShareResult) {
                    onStartShareResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.startShare(startShareInfo, this._startShareCallback);
    };
    /**
    * [en] This interface is used to stop share. [cn] 结束共享
    */
    IConfCtrl.prototype.stopShare = function (onStopShareResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("stopShare")) {
            if (onStopShareResult) {
                onStopShareResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("stopShare");
        this._stopShareCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("stopShare");
            if (onStopShareResult) {
                onStopShareResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('stopShare', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('stopShare');
                if (onStopShareResult) {
                    onStopShareResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.stopShare(this._stopShareCallback);
    };
    /**
    * [en] This interface is used to get attendee List. [cn] 获取与会者列表
    */
    IConfCtrl.prototype.getAttendeeList = function (onGetAttendeeListResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getAttendeeList")) {
            if (onGetAttendeeListResult) {
                var nullResult = {};
                onGetAttendeeListResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getAttendeeList");
        this._getAttendeeListCallback = function (ret, reason, attendeeList) {
            _this._inProcessCallbackSet.delete("getAttendeeList");
            if (onGetAttendeeListResult) {
                onGetAttendeeListResult(ret, reason, attendeeList);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getAttendeeList', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getAttendeeList');
                if (onGetAttendeeListResult) {
                    onGetAttendeeListResult(ret["ret"], ret["reason"], ret["attendeeList"]);
                }
            });
        }
        this.addOn.getAttendeeList(this._getAttendeeListCallback);
    };
    /**
    * [en] This interface is used to get audience List. [cn] 获取观众列表
    */
    IConfCtrl.prototype.getAudienceList = function (onGetAudienceListResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getAudienceList")) {
            if (onGetAudienceListResult) {
                var nullResult = {};
                onGetAudienceListResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getAudienceList");
        this._getAudienceListCallback = function (ret, reason, audidenceList) {
            _this._inProcessCallbackSet.delete("getAudienceList");
            if (onGetAudienceListResult) {
                onGetAudienceListResult(ret, reason, audidenceList);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getAudienceList', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getAudienceList');
                if (onGetAudienceListResult) {
                    onGetAudienceListResult(ret["ret"], ret["reason"], ret["audidenceList"]);
                }
            });
        }
        this.addOn.getAudienceList(this._getAudienceListCallback);
    };
    /**
    * [en] This interface is used to get user state. [cn] 获取用户状态
    */
    IConfCtrl.prototype.getUserState = function (onGetUserStateResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getUserState")) {
            if (onGetUserStateResult) {
                var nullResult = {};
                onGetUserStateResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getUserState");
        this._getUserStateCallback = function (ret, reason, userState) {
            _this._inProcessCallbackSet.delete("getUserState");
            if (onGetUserStateResult) {
                onGetUserStateResult(ret, reason, userState);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getUserState', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getUserState');
                if (onGetUserStateResult) {
                    onGetUserStateResult(ret["ret"], ret["reason"], ret["userState"]);
                }
            });
        }
        this.addOn.getUserState(this._getUserStateCallback);
    };
    /**
    * [en] This interface is used to get self role. [cn] 获取自己会中角色
    */
    IConfCtrl.prototype.getSelfRole = function (onGetSelfRoleResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getSelfRole")) {
            if (onGetSelfRoleResult) {
                var nullResult = {};
                onGetSelfRoleResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getSelfRole");
        this._getSelfRoleCallback = function (ret, reason, selfRole) {
            _this._inProcessCallbackSet.delete("getSelfRole");
            if (onGetSelfRoleResult) {
                onGetSelfRoleResult(ret, reason, selfRole);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getSelfRole', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getSelfRole');
                if (onGetSelfRoleResult) {
                    onGetSelfRoleResult(ret["ret"], ret["reason"], ret["selfRole"]);
                }
            });
        }
        this.addOn.getSelfRole(this._getSelfRoleCallback);
    };
    /**
    * [en] This interface is used to rename self. [cn] 设置会场名
    */
    IConfCtrl.prototype.renameSelf = function (renameSelfInfo, onRenameSelfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("renameSelf")) {
            if (onRenameSelfResult) {
                onRenameSelfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("renameSelf");
        this._renameSelfCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("renameSelf");
            if (onRenameSelfResult) {
                onRenameSelfResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('renameSelf', { "renameSelfInfo": renameSelfInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('renameSelf');
                if (onRenameSelfResult) {
                    onRenameSelfResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.renameSelf(renameSelfInfo, this._renameSelfCallback);
    };
    /**
    * [en] This interface is used to start projection. [cn] 发起投屏
    */
    IConfCtrl.prototype.startProjection = function (startProjectionParam, onStartProjectionResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("startProjection")) {
            if (onStartProjectionResult) {
                var nullResult = {};
                onStartProjectionResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("startProjection");
        this._startProjectionCallback = function (ret, reason, startProjectionResult) {
            _this._inProcessCallbackSet.delete("startProjection");
            if (onStartProjectionResult) {
                onStartProjectionResult(ret, reason, startProjectionResult);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('startProjection', { "startProjectionParam": startProjectionParam }).then(function (ret) {
                _this._inProcessCallbackSet.delete('startProjection');
                if (onStartProjectionResult) {
                    onStartProjectionResult(ret["ret"], ret["reason"], ret["startProjectionResult"]);
                }
            });
        }
        this.addOn.startProjection(startProjectionParam, this._startProjectionCallback);
    };
    /**
    * [en] This interface is used to set auto hide tool bar. [cn] 设置会控栏自动隐藏
    */
    IConfCtrl.prototype.setAutoHideToolBar = function (autoHideToolBarParam) {
        if (this.callWithIPC) {
            var ret = electron.ipcRenderer.sendSync('setAutoHideToolBar', { "autoHideToolBarParam": autoHideToolBarParam });
            return ret;
        }
        return this.addOn.setAutoHideToolBar(autoHideToolBarParam);
    };
    /**
    * [en] This interface is used to accept conf. [cn] 接受会议邀请
    */
    IConfCtrl.prototype.acceptConf = function (acceptConfParam, onAcceptConfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("acceptConf")) {
            if (onAcceptConfResult) {
                onAcceptConfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("acceptConf");
        this._acceptConfCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("acceptConf");
            if (onAcceptConfResult) {
                onAcceptConfResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('acceptConf', { "acceptConfParam": acceptConfParam }).then(function (ret) {
                _this._inProcessCallbackSet.delete('acceptConf');
                if (onAcceptConfResult) {
                    onAcceptConfResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.acceptConf(acceptConfParam, this._acceptConfCallback);
    };
    /**
    * [en] This interface is used to reject conf. [cn] 拒绝会议邀请
    */
    IConfCtrl.prototype.rejectConf = function (onRejectConfResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("rejectConf")) {
            if (onRejectConfResult) {
                onRejectConfResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("rejectConf");
        this._rejectConfCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("rejectConf");
            if (onRejectConfResult) {
                onRejectConfResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('rejectConf', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('rejectConf');
                if (onRejectConfResult) {
                    onRejectConfResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.rejectConf(this._rejectConfCallback);
    };
    /**
    * [en] This interface is used to get self share state. [cn] 获取自己的开启共享状态
    */
    IConfCtrl.prototype.getSelfShareState = function (onGetSelfShareStateResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getSelfShareState")) {
            if (onGetSelfShareStateResult) {
                var nullResult = {};
                onGetSelfShareStateResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getSelfShareState");
        this._getSelfShareStateCallback = function (ret, reason, selfShareStateInfo) {
            _this._inProcessCallbackSet.delete("getSelfShareState");
            if (onGetSelfShareStateResult) {
                onGetSelfShareStateResult(ret, reason, selfShareStateInfo);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getSelfShareState', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getSelfShareState');
                if (onGetSelfShareStateResult) {
                    onGetSelfShareStateResult(ret["ret"], ret["reason"], ret["selfShareStateInfo"]);
                }
            });
        }
        this.addOn.getSelfShareState(this._getSelfShareStateCallback);
    };
    /**
    * [en] This interface is used to operate subtitle. [cn] 开启/关闭字幕
    */
    IConfCtrl.prototype.openSubtitle = function (isOpen, onOpenSubtitleResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("openSubtitle")) {
            if (onOpenSubtitleResult) {
                var nullResult = {};
                onOpenSubtitleResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("openSubtitle");
        this._openSubtitleCallback = function (ret, reason, isOpen) {
            _this._inProcessCallbackSet.delete("openSubtitle");
            if (onOpenSubtitleResult) {
                onOpenSubtitleResult(ret, reason, isOpen);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('openSubtitle', { "isOpen": isOpen }).then(function (ret) {
                _this._inProcessCallbackSet.delete('openSubtitle');
                if (onOpenSubtitleResult) {
                    onOpenSubtitleResult(ret["ret"], ret["reason"], ret["isOpen"]);
                }
            });
        }
        this.addOn.openSubtitle(isOpen, this._openSubtitleCallback);
    };
    /**
    * [en] This interface is used to operate waiting room. [cn] 开启/关闭等候室
    */
    IConfCtrl.prototype.openWaitingRoom = function (isOpen, onOpenWaitingRoomResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("openWaitingRoom")) {
            if (onOpenWaitingRoomResult) {
                var nullResult = {};
                onOpenWaitingRoomResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("openWaitingRoom");
        this._openWaitingRoomCallback = function (ret, reason, isOpen) {
            _this._inProcessCallbackSet.delete("openWaitingRoom");
            if (onOpenWaitingRoomResult) {
                onOpenWaitingRoomResult(ret, reason, isOpen);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('openWaitingRoom', { "isOpen": isOpen }).then(function (ret) {
                _this._inProcessCallbackSet.delete('openWaitingRoom');
                if (onOpenWaitingRoomResult) {
                    onOpenWaitingRoomResult(ret["ret"], ret["reason"], ret["isOpen"]);
                }
            });
        }
        this.addOn.openWaitingRoom(isOpen, this._openWaitingRoomCallback);
    };
    /**
    * [en] This interface is used to operate local record. [cn] 操作本地录制
    */
    IConfCtrl.prototype.operateLocalRecord = function (type, onOperateLocalRecordResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("operateLocalRecord")) {
            if (onOperateLocalRecordResult) {
                var nullResult = {};
                onOperateLocalRecordResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("operateLocalRecord");
        this._operateLocalRecordCallback = function (ret, reason, type) {
            _this._inProcessCallbackSet.delete("operateLocalRecord");
            if (onOperateLocalRecordResult) {
                onOperateLocalRecordResult(ret, reason, type);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('operateLocalRecord', { "type": type }).then(function (ret) {
                _this._inProcessCallbackSet.delete('operateLocalRecord');
                if (onOperateLocalRecordResult) {
                    onOperateLocalRecordResult(ret["ret"], ret["reason"], ret["type"]);
                }
            });
        }
        this.addOn.operateLocalRecord(type, this._operateLocalRecordCallback);
    };
    /**
    * [en] This interface is used to open virtual background setting page. [cn] 打开虚拟背景设置
    */
    IConfCtrl.prototype.openVirtualBackgroundSettingPage = function (onOpenVirtualBackgroundSettingPageResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("openVirtualBackgroundSettingPage")) {
            if (onOpenVirtualBackgroundSettingPageResult) {
                onOpenVirtualBackgroundSettingPageResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("openVirtualBackgroundSettingPage");
        this._openVirtualBackgroundSettingPageCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("openVirtualBackgroundSettingPage");
            if (onOpenVirtualBackgroundSettingPageResult) {
                onOpenVirtualBackgroundSettingPageResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('openVirtualBackgroundSettingPage', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('openVirtualBackgroundSettingPage');
                if (onOpenVirtualBackgroundSettingPageResult) {
                    onOpenVirtualBackgroundSettingPageResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.openVirtualBackgroundSettingPage(this._openVirtualBackgroundSettingPageCallback);
    };
    /**
    * [en] This interface is used to get local record status. [cn] 获取本地录制状态
    */
    IConfCtrl.prototype.getConfLocalRecordStatus = function (onGetConfLocalRecordStatusResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getConfLocalRecordStatus")) {
            if (onGetConfLocalRecordStatusResult) {
                var nullResult = {};
                onGetConfLocalRecordStatusResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getConfLocalRecordStatus");
        this._getConfLocalRecordStatusCallback = function (ret, reason, state) {
            _this._inProcessCallbackSet.delete("getConfLocalRecordStatus");
            if (onGetConfLocalRecordStatusResult) {
                onGetConfLocalRecordStatusResult(ret, reason, state);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getConfLocalRecordStatus', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getConfLocalRecordStatus');
                if (onGetConfLocalRecordStatusResult) {
                    onGetConfLocalRecordStatusResult(ret["ret"], ret["reason"], ret["state"]);
                }
            });
        }
        this.addOn.getConfLocalRecordStatus(this._getConfLocalRecordStatusCallback);
    };
    /**
    * [en] This interface is used to get local record permission. [cn] 获取本地录制权限
    */
    IConfCtrl.prototype.getSelfHasLocalRecordPermission = function (onGetSelfHasLocalRecordPermissionResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getSelfHasLocalRecordPermission")) {
            if (onGetSelfHasLocalRecordPermissionResult) {
                var nullResult = {};
                onGetSelfHasLocalRecordPermissionResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getSelfHasLocalRecordPermission");
        this._getSelfHasLocalRecordPermissionCallback = function (ret, reason, permission) {
            _this._inProcessCallbackSet.delete("getSelfHasLocalRecordPermission");
            if (onGetSelfHasLocalRecordPermissionResult) {
                onGetSelfHasLocalRecordPermissionResult(ret, reason, permission);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getSelfHasLocalRecordPermission', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getSelfHasLocalRecordPermission');
                if (onGetSelfHasLocalRecordPermissionResult) {
                    onGetSelfHasLocalRecordPermissionResult(ret["ret"], ret["reason"], ret["permission"]);
                }
            });
        }
        this.addOn.getSelfHasLocalRecordPermission(this._getSelfHasLocalRecordPermissionCallback);
    };
    /**
    * [en] This interface is used to request local record permission. [cn] 申请本地录制权限
    */
    IConfCtrl.prototype.requestLocalRecordPermission = function (onRequestLocalRecordPermissionResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("requestLocalRecordPermission")) {
            if (onRequestLocalRecordPermissionResult) {
                onRequestLocalRecordPermissionResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("requestLocalRecordPermission");
        this._requestLocalRecordPermissionCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("requestLocalRecordPermission");
            if (onRequestLocalRecordPermissionResult) {
                onRequestLocalRecordPermissionResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('requestLocalRecordPermission', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('requestLocalRecordPermission');
                if (onRequestLocalRecordPermissionResult) {
                    onRequestLocalRecordPermissionResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.requestLocalRecordPermission(this._requestLocalRecordPermissionCallback);
    };
    /**
    * [en] This interface is used to request host role. [cn] 申请主持人
    */
    IConfCtrl.prototype.applyHostRole = function (password, onApplyHostRoleResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("applyHostRole")) {
            if (onApplyHostRoleResult) {
                onApplyHostRoleResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("applyHostRole");
        this._applyHostRoleCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("applyHostRole");
            if (onApplyHostRoleResult) {
                onApplyHostRoleResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('applyHostRole', { "password": password }).then(function (ret) {
                _this._inProcessCallbackSet.delete('applyHostRole');
                if (onApplyHostRoleResult) {
                    onApplyHostRoleResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.applyHostRole(password, this._applyHostRoleCallback);
    };
    /**
    * [en] This interface is used to get subtitle state. [cn] 获取字幕状态
    */
    IConfCtrl.prototype.getSubtitlePageOpened = function (onGetSubtitlePageOpenedResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getSubtitlePageOpened")) {
            if (onGetSubtitlePageOpenedResult) {
                var nullResult = {};
                onGetSubtitlePageOpenedResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getSubtitlePageOpened");
        this._getSubtitlePageOpenedCallback = function (ret, reason, isOpen) {
            _this._inProcessCallbackSet.delete("getSubtitlePageOpened");
            if (onGetSubtitlePageOpenedResult) {
                onGetSubtitlePageOpenedResult(ret, reason, isOpen);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getSubtitlePageOpened', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getSubtitlePageOpened');
                if (onGetSubtitlePageOpenedResult) {
                    onGetSubtitlePageOpenedResult(ret["ret"], ret["reason"], ret["isOpen"]);
                }
            });
        }
        this.addOn.getSubtitlePageOpened(this._getSubtitlePageOpenedCallback);
    };
    /**
    * [en] This interface is used to get waiting room state. [cn] 获取等候室状态
    */
    IConfCtrl.prototype.getWaitingRoomOpened = function (onGetWaitingRoomOpenedResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getWaitingRoomOpened")) {
            if (onGetWaitingRoomOpenedResult) {
                var nullResult = {};
                onGetWaitingRoomOpenedResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getWaitingRoomOpened");
        this._getWaitingRoomOpenedCallback = function (ret, reason, isOpen) {
            _this._inProcessCallbackSet.delete("getWaitingRoomOpened");
            if (onGetWaitingRoomOpenedResult) {
                onGetWaitingRoomOpenedResult(ret, reason, isOpen);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getWaitingRoomOpened', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getWaitingRoomOpened');
                if (onGetWaitingRoomOpenedResult) {
                    onGetWaitingRoomOpenedResult(ret["ret"], ret["reason"], ret["isOpen"]);
                }
            });
        }
        this.addOn.getWaitingRoomOpened(this._getWaitingRoomOpenedCallback);
    };
    /**
    * [en] This interface is used to get virtual background setting page state. [cn] 获取是否已经打开虚拟背景设置
    */
    IConfCtrl.prototype.getVirtualBackgroundSettingPageOpened = function (onGetVirtualBackgroundSettingPageOpenedResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getVirtualBackgroundSettingPageOpened")) {
            if (onGetVirtualBackgroundSettingPageOpenedResult) {
                var nullResult = {};
                onGetVirtualBackgroundSettingPageOpenedResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getVirtualBackgroundSettingPageOpened");
        this._getVirtualBackgroundSettingPageOpenedCallback = function (ret, reason, isOpen) {
            _this._inProcessCallbackSet.delete("getVirtualBackgroundSettingPageOpened");
            if (onGetVirtualBackgroundSettingPageOpenedResult) {
                onGetVirtualBackgroundSettingPageOpenedResult(ret, reason, isOpen);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getVirtualBackgroundSettingPageOpened', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getVirtualBackgroundSettingPageOpened');
                if (onGetVirtualBackgroundSettingPageOpenedResult) {
                    onGetVirtualBackgroundSettingPageOpenedResult(ret["ret"], ret["reason"], ret["isOpen"]);
                }
            });
        }
        this.addOn.getVirtualBackgroundSettingPageOpened(this._getVirtualBackgroundSettingPageOpenedCallback);
    };
    /**
    * [en] This interface is used to subscribe subtitle language. [cn] 订阅字幕语言
    */
    IConfCtrl.prototype.subscribeSubtitleLanguage = function (targetLanguageType, onSubscribeSubtitleLanguageResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("subscribeSubtitleLanguage")) {
            if (onSubscribeSubtitleLanguageResult) {
                var nullResult = {};
                onSubscribeSubtitleLanguageResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("subscribeSubtitleLanguage");
        this._subscribeSubtitleLanguageCallback = function (ret, reason, targetLanguageType) {
            _this._inProcessCallbackSet.delete("subscribeSubtitleLanguage");
            if (onSubscribeSubtitleLanguageResult) {
                onSubscribeSubtitleLanguageResult(ret, reason, targetLanguageType);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('subscribeSubtitleLanguage', { "targetLanguageType": targetLanguageType }).then(function (ret) {
                _this._inProcessCallbackSet.delete('subscribeSubtitleLanguage');
                if (onSubscribeSubtitleLanguageResult) {
                    onSubscribeSubtitleLanguageResult(ret["ret"], ret["reason"], ret["targetLanguageType"]);
                }
            });
        }
        this.addOn.subscribeSubtitleLanguage(targetLanguageType, this._subscribeSubtitleLanguageCallback);
    };
    /**
    * [en] This interface is used to subscribe subtitle. [cn] 订阅/取消订阅字幕
    */
    IConfCtrl.prototype.subscribeSubtitle = function (isSubscribe, onSubscribeSubtitleResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("subscribeSubtitle")) {
            if (onSubscribeSubtitleResult) {
                var nullResult = {};
                onSubscribeSubtitleResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("subscribeSubtitle");
        this._subscribeSubtitleCallback = function (ret, reason, isSubscirbe) {
            _this._inProcessCallbackSet.delete("subscribeSubtitle");
            if (onSubscribeSubtitleResult) {
                onSubscribeSubtitleResult(ret, reason, isSubscirbe);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('subscribeSubtitle', { "isSubscribe": isSubscribe }).then(function (ret) {
                _this._inProcessCallbackSet.delete('subscribeSubtitle');
                if (onSubscribeSubtitleResult) {
                    onSubscribeSubtitleResult(ret["ret"], ret["reason"], ret["isSubscirbe"]);
                }
            });
        }
        this.addOn.subscribeSubtitle(isSubscribe, this._subscribeSubtitleCallback);
    };
    /**
    * [en] This interface is used to get subtitle support languagues. [cn] 获取字幕支持的语言
    */
    IConfCtrl.prototype.getSubtitleSupportLanguage = function (onGetSubtitleSupportLanguageResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getSubtitleSupportLanguage")) {
            if (onGetSubtitleSupportLanguageResult) {
                var nullResult = {};
                onGetSubtitleSupportLanguageResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getSubtitleSupportLanguage");
        this._getSubtitleSupportLanguageCallback = function (ret, reason, targetLanguageTypeList) {
            _this._inProcessCallbackSet.delete("getSubtitleSupportLanguage");
            if (onGetSubtitleSupportLanguageResult) {
                onGetSubtitleSupportLanguageResult(ret, reason, targetLanguageTypeList);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getSubtitleSupportLanguage', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getSubtitleSupportLanguage');
                if (onGetSubtitleSupportLanguageResult) {
                    onGetSubtitleSupportLanguageResult(ret["ret"], ret["reason"], ret["targetLanguageTypeList"]);
                }
            });
        }
        this.addOn.getSubtitleSupportLanguage(this._getSubtitleSupportLanguageCallback);
    };
    return IConfCtrl;
}());
exports.IConfCtrl = IConfCtrl;
