"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IConfig = void 0;
var enum_1 = require("./enum");
var util_1 = require("./util");
var electron = window.require('electron');
var IConfig = /** @class */ (function () {
    function IConfig(addOn) {
        this.callWithIPC = false;
        this.addOn = addOn;
        this._inProcessCallbackSet = new Set();
        this.callWithIPC = util_1.needCallWithIPC();
    }
    IConfig.prototype.init = function () {
        this._inProcessCallbackSet.clear();
    };
    /**
    * [en] Notify of AVDevice control state [cn] 音视频设备控制状态变化通知
    */
    IConfig.prototype.setOnAVDeviceCtrlStateChangedCB = function (onAVDeviceCtrlStateChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnAVDeviceCtrlStateChangedCB', {});
            electron.ipcRenderer.on('onAVDeviceCtrlStateChanged', function (event, arg) {
                if (onAVDeviceCtrlStateChanged) {
                    onAVDeviceCtrlStateChanged(arg["info"]);
                }
            });
            return;
        }
        this._onAVDeviceCtrlStateChangedCallback = function (info) {
            if (onAVDeviceCtrlStateChanged) {
                onAVDeviceCtrlStateChanged(info);
            }
        };
        this.addOn.setOnAVDeviceCtrlStateChangedCB(this._onAVDeviceCtrlStateChangedCallback);
    };
    /**
    * [en] Notify of audio famme [cn] 上报音频码流帧数据通知
    */
    IConfig.prototype.setOnAudioFrameNotifyCB = function (onAudioFrameNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnAudioFrameNotifyCB', {});
            electron.ipcRenderer.on('onAudioFrameNotify', function (event, arg) {
                if (onAudioFrameNotify) {
                    onAudioFrameNotify(arg["audioFrameData"]);
                }
            });
            return;
        }
        this._onAudioFrameNotifyCallback = function (audioFrameData) {
            if (onAudioFrameNotify) {
                onAudioFrameNotify(audioFrameData);
            }
        };
        this.addOn.setOnAudioFrameNotifyCB(this._onAudioFrameNotifyCallback);
    };
    /**
    * [en] Notify of show voiceprint statement [cn] 声纹降噪功能声明显示通知
    */
    IConfig.prototype.setOnShowVoiceprintStatementCB = function (onShowVoiceprintStatement) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnShowVoiceprintStatementCB', {});
            electron.ipcRenderer.on('onShowVoiceprintStatement', function (event, arg) {
                if (onShowVoiceprintStatement) {
                    onShowVoiceprintStatement(arg["info"]);
                }
            });
            return;
        }
        this._onShowVoiceprintStatementCallback = function (info) {
            if (onShowVoiceprintStatement) {
                onShowVoiceprintStatement(info);
            }
        };
        this.addOn.setOnShowVoiceprintStatementCB(this._onShowVoiceprintStatementCallback);
    };
    /**
    * [en] User data path change notification [cn] 用户数据路径变化通知
    */
    IConfig.prototype.setOnUserSavePathChangedCB = function (onUserSavePathChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnUserSavePathChangedCB', {});
            electron.ipcRenderer.on('onUserSavePathChanged', function (event, arg) {
                if (onUserSavePathChanged) {
                    onUserSavePathChanged(arg["userSavePathInfo"]);
                }
            });
            return;
        }
        this._onUserSavePathChangedCallback = function (userSavePathInfo) {
            if (onUserSavePathChanged) {
                onUserSavePathChanged(userSavePathInfo);
            }
        };
        this.addOn.setOnUserSavePathChangedCB(this._onUserSavePathChangedCallback);
    };
    /**
    * [en] This interface is used to enable capability [cn] 功能配置开关
    */
    IConfig.prototype.enableCapability = function (capabilityInfo, onEnableCapabilityResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("enableCapability")) {
            if (onEnableCapabilityResult) {
                onEnableCapabilityResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("enableCapability");
        this._enableCapabilityCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("enableCapability");
            if (onEnableCapabilityResult) {
                onEnableCapabilityResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('enableCapability', { "capabilityInfo": capabilityInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('enableCapability');
                if (onEnableCapabilityResult) {
                    onEnableCapabilityResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.enableCapability(capabilityInfo, this._enableCapabilityCallback);
    };
    /**
    * [en] This interface is used to set language. [cn] 设置语言
    */
    IConfig.prototype.setLanguage = function (languageInfo, onSetLanguageResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setLanguage")) {
            if (onSetLanguageResult) {
                onSetLanguageResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setLanguage");
        this._setLanguageCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setLanguage");
            if (onSetLanguageResult) {
                onSetLanguageResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setLanguage', { "languageInfo": languageInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setLanguage');
                if (onSetLanguageResult) {
                    onSetLanguageResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setLanguage(languageInfo, this._setLanguageCallback);
    };
    /**
    * [en] This interface is used to set file save path. [cn] 设置用户保存路径
    */
    IConfig.prototype.setUserSavePath = function (userSavePathInfo, onSetUserSavePathResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setUserSavePath")) {
            if (onSetUserSavePathResult) {
                onSetUserSavePathResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setUserSavePath");
        this._setUserSavePathCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setUserSavePath");
            if (onSetUserSavePathResult) {
                onSetUserSavePathResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setUserSavePath', { "userSavePathInfo": userSavePathInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setUserSavePath');
                if (onSetUserSavePathResult) {
                    onSetUserSavePathResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setUserSavePath(userSavePathInfo, this._setUserSavePathCallback);
    };
    /**
    * [en] This interface is used to get file save path. [cn] 获取用户保存路径
    */
    IConfig.prototype.getUserSavePath = function (pathType, onGetUserSavePathResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getUserSavePath")) {
            if (onGetUserSavePathResult) {
                var nullResult = {};
                onGetUserSavePathResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getUserSavePath");
        this._getUserSavePathCallback = function (ret, reason, pathInfo) {
            _this._inProcessCallbackSet.delete("getUserSavePath");
            if (onGetUserSavePathResult) {
                onGetUserSavePathResult(ret, reason, pathInfo);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getUserSavePath', { "pathType": pathType }).then(function (ret) {
                _this._inProcessCallbackSet.delete('getUserSavePath');
                if (onGetUserSavePathResult) {
                    onGetUserSavePathResult(ret["ret"], ret["reason"], ret["pathInfo"]);
                }
            });
        }
        this.addOn.getUserSavePath(pathType, this._getUserSavePathCallback);
    };
    /**
    * [en] This interface is used to set share strategy. [cn] 设置共享策略
    */
    IConfig.prototype.setShareStrategy = function (shareStrategyInfo, onSetShareStrategyResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setShareStrategy")) {
            if (onSetShareStrategyResult) {
                onSetShareStrategyResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setShareStrategy");
        this._setShareStrategyCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setShareStrategy");
            if (onSetShareStrategyResult) {
                onSetShareStrategyResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setShareStrategy', { "shareStrategyInfo": shareStrategyInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setShareStrategy');
                if (onSetShareStrategyResult) {
                    onSetShareStrategyResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setShareStrategy(shareStrategyInfo, this._setShareStrategyCallback);
    };
    /**
    * [en] This interface is used to set audio raw data output config. [cn] 设置开启或关闭音频码流
    */
    IConfig.prototype.setAudioRawDataOutputConfig = function (audioRawDataConfigInfo, onSetAudioRawDataOutputConfigResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setAudioRawDataOutputConfig")) {
            if (onSetAudioRawDataOutputConfigResult) {
                onSetAudioRawDataOutputConfigResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setAudioRawDataOutputConfig");
        this._setAudioRawDataOutputConfigCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setAudioRawDataOutputConfig");
            if (onSetAudioRawDataOutputConfigResult) {
                onSetAudioRawDataOutputConfigResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setAudioRawDataOutputConfig', { "audioRawDataConfigInfo": audioRawDataConfigInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setAudioRawDataOutputConfig');
                if (onSetAudioRawDataOutputConfigResult) {
                    onSetAudioRawDataOutputConfigResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setAudioRawDataOutputConfig(audioRawDataConfigInfo, this._setAudioRawDataOutputConfigCallback);
    };
    /**
    * [en] This interface is used to set call incoming answer type. [cn] 设置来电应答方式
    */
    IConfig.prototype.setAnswerType = function (inComingAnswerTypeInfo, onSetAnswerTypeResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setAnswerType")) {
            if (onSetAnswerTypeResult) {
                onSetAnswerTypeResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setAnswerType");
        this._setAnswerTypeCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setAnswerType");
            if (onSetAnswerTypeResult) {
                onSetAnswerTypeResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setAnswerType', { "inComingAnswerTypeInfo": inComingAnswerTypeInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setAnswerType');
                if (onSetAnswerTypeResult) {
                    onSetAnswerTypeResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setAnswerType(inComingAnswerTypeInfo, this._setAnswerTypeCallback);
    };
    /**
    * [en] This interface is used to set device config for conf incoming. [cn] 会议来电时设备开关配置
    */
    IConfig.prototype.setDeviceConfigForConfIncoming = function (deviceConfig, onSetDeviceConfigForConfIncomingResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setDeviceConfigForConfIncoming")) {
            if (onSetDeviceConfigForConfIncomingResult) {
                onSetDeviceConfigForConfIncomingResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setDeviceConfigForConfIncoming");
        this._setDeviceConfigForConfIncomingCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setDeviceConfigForConfIncoming");
            if (onSetDeviceConfigForConfIncomingResult) {
                onSetDeviceConfigForConfIncomingResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setDeviceConfigForConfIncoming', { "deviceConfig": deviceConfig }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setDeviceConfigForConfIncoming');
                if (onSetDeviceConfigForConfIncomingResult) {
                    onSetDeviceConfigForConfIncomingResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setDeviceConfigForConfIncoming(deviceConfig, this._setDeviceConfigForConfIncomingCallback);
    };
    /**
    * [en] This interface is used to get conf pstn access number. [cn] 获取会议pstn接入号码
    */
    IConfig.prototype.getConfPstnAccessNumber = function (onGetConfPstnAccessNumberResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getConfPstnAccessNumber")) {
            if (onGetConfPstnAccessNumberResult) {
                var nullResult = {};
                onGetConfPstnAccessNumberResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getConfPstnAccessNumber");
        this._getConfPstnAccessNumberCallback = function (ret, reason, pstnAccessNumberInfo) {
            _this._inProcessCallbackSet.delete("getConfPstnAccessNumber");
            if (onGetConfPstnAccessNumberResult) {
                onGetConfPstnAccessNumberResult(ret, reason, pstnAccessNumberInfo);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getConfPstnAccessNumber', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getConfPstnAccessNumber');
                if (onGetConfPstnAccessNumberResult) {
                    onGetConfPstnAccessNumberResult(ret["ret"], ret["reason"], ret["pstnAccessNumberInfo"]);
                }
            });
        }
        this.addOn.getConfPstnAccessNumber(this._getConfPstnAccessNumberCallback);
    };
    /**
    * [en] This interface is used to AVDeviceCtrl. [cn] 音视频设备控制功能
    */
    IConfig.prototype.aVDeviceCtrl = function (deviceStateInfo, onAVDeviceCtrlResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("aVDeviceCtrl")) {
            if (onAVDeviceCtrlResult) {
                var nullResult = {};
                onAVDeviceCtrlResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("aVDeviceCtrl");
        this._aVDeviceCtrlCallback = function (ret, reason, deviceCtrlInfo) {
            _this._inProcessCallbackSet.delete("aVDeviceCtrl");
            if (onAVDeviceCtrlResult) {
                onAVDeviceCtrlResult(ret, reason, deviceCtrlInfo);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('aVDeviceCtrl', { "deviceStateInfo": deviceStateInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('aVDeviceCtrl');
                if (onAVDeviceCtrlResult) {
                    onAVDeviceCtrlResult(ret["ret"], ret["reason"], ret["deviceCtrlInfo"]);
                }
            });
        }
        this.addOn.aVDeviceCtrl(deviceStateInfo, this._aVDeviceCtrlCallback);
    };
    /**
    * [en] This interface is used to disable voice prompts. [cn] 禁用提示音
    */
    IConfig.prototype.disableVoicePrompts = function (voicePromptsInfo, onDisableVoicePromptsResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("disableVoicePrompts")) {
            if (onDisableVoicePromptsResult) {
                onDisableVoicePromptsResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("disableVoicePrompts");
        this._disableVoicePromptsCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("disableVoicePrompts");
            if (onDisableVoicePromptsResult) {
                onDisableVoicePromptsResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('disableVoicePrompts', { "voicePromptsInfo": voicePromptsInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('disableVoicePrompts');
                if (onDisableVoicePromptsResult) {
                    onDisableVoicePromptsResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.disableVoicePrompts(voicePromptsInfo, this._disableVoicePromptsCallback);
    };
    /**
    * [en] This interface is used to set share permission. [cn] 设置共享权限
    */
    IConfig.prototype.setShareScreenPermission = function (permission, onSetShareScreenPermissionResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setShareScreenPermission")) {
            if (onSetShareScreenPermissionResult) {
                onSetShareScreenPermissionResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setShareScreenPermission");
        this._setShareScreenPermissionCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setShareScreenPermission");
            if (onSetShareScreenPermissionResult) {
                onSetShareScreenPermissionResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setShareScreenPermission', { "permission": permission }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setShareScreenPermission');
                if (onSetShareScreenPermissionResult) {
                    onSetShareScreenPermissionResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setShareScreenPermission(permission, this._setShareScreenPermissionCallback);
    };
    /**
    * [en] This interface is used to set voiceprint statement agreement. [cn] 签署声纹功能声明
    */
    IConfig.prototype.agreeVoiceprintStatement = function (isAgreed, onAgreeVoiceprintStatementResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("agreeVoiceprintStatement")) {
            if (onAgreeVoiceprintStatementResult) {
                onAgreeVoiceprintStatementResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("agreeVoiceprintStatement");
        this._agreeVoiceprintStatementCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("agreeVoiceprintStatement");
            if (onAgreeVoiceprintStatementResult) {
                onAgreeVoiceprintStatementResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('agreeVoiceprintStatement', { "isAgreed": isAgreed }).then(function (ret) {
                _this._inProcessCallbackSet.delete('agreeVoiceprintStatement');
                if (onAgreeVoiceprintStatementResult) {
                    onAgreeVoiceprintStatementResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.agreeVoiceprintStatement(isAgreed, this._agreeVoiceprintStatementCallback);
    };
    /**
    * [en] This interface is used to show voiceprint record window. [cn] 显示声纹录入窗口接口
    */
    IConfig.prototype.showVoiceprintRecordWindow = function (isShow, onShowVoiceprintRecordWindowResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("showVoiceprintRecordWindow")) {
            if (onShowVoiceprintRecordWindowResult) {
                onShowVoiceprintRecordWindowResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("showVoiceprintRecordWindow");
        this._showVoiceprintRecordWindowCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("showVoiceprintRecordWindow");
            if (onShowVoiceprintRecordWindowResult) {
                onShowVoiceprintRecordWindowResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('showVoiceprintRecordWindow', { "isShow": isShow }).then(function (ret) {
                _this._inProcessCallbackSet.delete('showVoiceprintRecordWindow');
                if (onShowVoiceprintRecordWindowResult) {
                    onShowVoiceprintRecordWindowResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.showVoiceprintRecordWindow(isShow, this._showVoiceprintRecordWindowCallback);
    };
    /**
    * [en] This interface is used to set log save path. [cn] 设置日志保存路径
    */
    IConfig.prototype.setLogPath = function (logPathInfo, onSetLogPathResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setLogPath")) {
            if (onSetLogPathResult) {
                onSetLogPathResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setLogPath");
        this._setLogPathCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setLogPath");
            if (onSetLogPathResult) {
                onSetLogPathResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setLogPath', { "logPathInfo": logPathInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setLogPath');
                if (onSetLogPathResult) {
                    onSetLogPathResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setLogPath(logPathInfo, this._setLogPathCallback);
    };
    /**
    * [en] This interface is used to get error message. [cn] 获取错误提示
    */
    IConfig.prototype.getErrorMessage = function (errorCode) {
        if (this.callWithIPC) {
            var ret = electron.ipcRenderer.sendSync('getErrorMessage', { "errorCode": errorCode });
            return ret;
        }
        return this.addOn.getErrorMessage(errorCode);
    };
    /**
    * [en] This interface is used to set need transparent windows in share [cn] 设置屏幕共享中需透明的窗口
    */
    IConfig.prototype.setTransparentWnd = function (wndInfo, onSetTransparentWndResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setTransparentWnd")) {
            if (onSetTransparentWndResult) {
                onSetTransparentWndResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setTransparentWnd");
        this._setTransparentWndCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setTransparentWnd");
            if (onSetTransparentWndResult) {
                onSetTransparentWndResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setTransparentWnd', { "wndInfo": wndInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setTransparentWnd');
                if (onSetTransparentWndResult) {
                    onSetTransparentWndResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setTransparentWnd(wndInfo, this._setTransparentWndCallback);
    };
    /**
    * [en] This interface is used to customize the text of the specified scene [cn] 自定义指定场景文案
    */
    IConfig.prototype.setCustomUIText = function (customSceneTextInfoList, onSetCustomUITextResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setCustomUIText")) {
            if (onSetCustomUITextResult) {
                onSetCustomUITextResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setCustomUIText");
        this._setCustomUITextCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setCustomUIText");
            if (onSetCustomUITextResult) {
                onSetCustomUITextResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setCustomUIText', { "customSceneTextInfoList": customSceneTextInfoList }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setCustomUIText');
                if (onSetCustomUITextResult) {
                    onSetCustomUITextResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setCustomUIText(customSceneTextInfoList, this._setCustomUITextCallback);
    };
    /**
    * [en] This interface is used to customize the image of the specified scene [cn] 自定义指定场景图标
    */
    IConfig.prototype.setCustomUIImage = function (customSceneImageInfoList, onSetCustomUIImageResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setCustomUIImage")) {
            if (onSetCustomUIImageResult) {
                onSetCustomUIImageResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setCustomUIImage");
        this._setCustomUIImageCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setCustomUIImage");
            if (onSetCustomUIImageResult) {
                onSetCustomUIImageResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setCustomUIImage', { "customSceneImageInfoList": customSceneImageInfoList }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setCustomUIImage');
                if (onSetCustomUIImageResult) {
                    onSetCustomUIImageResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setCustomUIImage(customSceneImageInfoList, this._setCustomUIImageCallback);
    };
    /**
    * [en]set virtual background default images [cn]设置虚拟背景默认图片
    */
    IConfig.prototype.setVirtualBackgroundDefaultImages = function (defaultImagesInfo, onSetVirtualBackgroundDefaultImagesResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setVirtualBackgroundDefaultImages")) {
            if (onSetVirtualBackgroundDefaultImagesResult) {
                onSetVirtualBackgroundDefaultImagesResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setVirtualBackgroundDefaultImages");
        this._setVirtualBackgroundDefaultImagesCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setVirtualBackgroundDefaultImages");
            if (onSetVirtualBackgroundDefaultImagesResult) {
                onSetVirtualBackgroundDefaultImagesResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setVirtualBackgroundDefaultImages', { "defaultImagesInfo": defaultImagesInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setVirtualBackgroundDefaultImages');
                if (onSetVirtualBackgroundDefaultImagesResult) {
                    onSetVirtualBackgroundDefaultImagesResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setVirtualBackgroundDefaultImages(defaultImagesInfo, this._setVirtualBackgroundDefaultImagesCallback);
    };
    return IConfig;
}());
exports.IConfig = IConfig;
