"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IUIConfig = void 0;
var enum_1 = require("./enum");
var util_1 = require("./util");
var electron = window.require('electron');
var IUIConfig = /** @class */ (function () {
    function IUIConfig(addOn) {
        this.callWithIPC = false;
        this.addOn = addOn;
        this._inProcessCallbackSet = new Set();
        this.callWithIPC = util_1.needCallWithIPC();
    }
    IUIConfig.prototype.init = function () {
        this._inProcessCallbackSet.clear();
    };
    /**
    * [en] Notify of inject btn. [cn] 注入点击通知
    */
    IUIConfig.prototype.setOnClickInjectBtnNotifyCB = function (onClickInjectBtnNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnClickInjectBtnNotifyCB', {});
            electron.ipcRenderer.on('onClickInjectBtnNotify', function (event, arg) {
                if (onClickInjectBtnNotify) {
                    onClickInjectBtnNotify(arg["injectBtnInfo"]);
                }
            });
            return;
        }
        this._onClickInjectBtnNotifyCallback = function (injectBtnInfo) {
            if (onClickInjectBtnNotify) {
                onClickInjectBtnNotify(injectBtnInfo);
            }
        };
        this.addOn.setOnClickInjectBtnNotifyCB(this._onClickInjectBtnNotifyCallback);
    };
    /**
    * [en] Notify of inject participant item btn. [cn] 与会者列表子项注入点击通知
    */
    IUIConfig.prototype.setOnClickInjectParticipantItemBtnNotifyCB = function (onClickInjectParticipantItemBtnNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnClickInjectParticipantItemBtnNotifyCB', {});
            electron.ipcRenderer.on('onClickInjectParticipantItemBtnNotify', function (event, arg) {
                if (onClickInjectParticipantItemBtnNotify) {
                    onClickInjectParticipantItemBtnNotify(arg["injectBtnInfo"]);
                }
            });
            return;
        }
        this._onClickInjectParticipantItemBtnNotifyCallback = function (injectBtnInfo) {
            if (onClickInjectParticipantItemBtnNotify) {
                onClickInjectParticipantItemBtnNotify(injectBtnInfo);
            }
        };
        this.addOn.setOnClickInjectParticipantItemBtnNotifyCB(this._onClickInjectParticipantItemBtnNotifyCallback);
    };
    /**
    * [en] Notify of inject Call all btn. [cn] 全部呼叫注入点击通知
    */
    IUIConfig.prototype.setOnClickInjectCallAllBtnNotifyCB = function (onClickInjectCallAllBtnNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnClickInjectCallAllBtnNotifyCB', {});
            electron.ipcRenderer.on('onClickInjectCallAllBtnNotify', function (event, arg) {
                if (onClickInjectCallAllBtnNotify) {
                    onClickInjectCallAllBtnNotify(arg["injectBtnInfo"]);
                }
            });
            return;
        }
        this._onClickInjectCallAllBtnNotifyCallback = function (injectBtnInfo) {
            if (onClickInjectCallAllBtnNotify) {
                onClickInjectCallAllBtnNotify(injectBtnInfo);
            }
        };
        this.addOn.setOnClickInjectCallAllBtnNotifyCB(this._onClickInjectCallAllBtnNotifyCallback);
    };
    /**
    * [en] window handle list notify. when window handle changed, will receive this notify [cn] 窗口句柄通知
    */
    IUIConfig.prototype.setOnRenderWindowInfoListChangedCB = function (onRenderWindowInfoListChanged) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnRenderWindowInfoListChangedCB', {});
            electron.ipcRenderer.on('onRenderWindowInfoListChanged', function (event, arg) {
                if (onRenderWindowInfoListChanged) {
                    onRenderWindowInfoListChanged(arg["hwndInfo"]);
                }
            });
            return;
        }
        this._onRenderWindowInfoListChangedCallback = function (hwndInfo) {
            if (onRenderWindowInfoListChanged) {
                onRenderWindowInfoListChanged(hwndInfo);
            }
        };
        this.addOn.setOnRenderWindowInfoListChangedCB(this._onRenderWindowInfoListChangedCallback);
    };
    /**
    * [en] Notify of query external contact avatar [cn] 查询外部通讯录头像通知
    */
    IUIConfig.prototype.setOnQueryContactAvatarNotifyCB = function (onQueryContactAvatarNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnQueryContactAvatarNotifyCB', {});
            electron.ipcRenderer.on('onQueryContactAvatarNotify', function (event, arg) {
                if (onQueryContactAvatarNotify) {
                    onQueryContactAvatarNotify(arg["contactInfo"]);
                }
            });
            return;
        }
        this._onQueryContactAvatarNotifyCallback = function (contactInfo) {
            if (onQueryContactAvatarNotify) {
                onQueryContactAvatarNotify(contactInfo);
            }
        };
        this.addOn.setOnQueryContactAvatarNotifyCB(this._onQueryContactAvatarNotifyCallback);
    };
    /**
    * [en] Notify of double click participant list item [cn] 双击与会者项通知
    */
    IUIConfig.prototype.setOnDoubleClickParticipantListItemNotifyCB = function (onDoubleClickParticipantListItemNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnDoubleClickParticipantListItemNotifyCB', {});
            electron.ipcRenderer.on('onDoubleClickParticipantListItemNotify', function (event, arg) {
                if (onDoubleClickParticipantListItemNotify) {
                    onDoubleClickParticipantListItemNotify(arg["participantInfo"]);
                }
            });
            return;
        }
        this._onDoubleClickParticipantListItemNotifyCallback = function (participantInfo) {
            if (onDoubleClickParticipantListItemNotify) {
                onDoubleClickParticipantListItemNotify(participantInfo);
            }
        };
        this.addOn.setOnDoubleClickParticipantListItemNotifyCB(this._onDoubleClickParticipantListItemNotifyCallback);
    };
    /**
    * [en] This interface is used to config sdk. [cn] 界面配置
    */
    IUIConfig.prototype.config = function (uiConfig, onConfigResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("config")) {
            if (onConfigResult) {
                onConfigResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("config");
        this._configCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("config");
            if (onConfigResult) {
                onConfigResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('config', { "uiConfig": uiConfig }).then(function (ret) {
                _this._inProcessCallbackSet.delete('config');
                if (onConfigResult) {
                    onConfigResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.config(uiConfig, this._configCallback);
    };
    /**
    * [en] This interface is used to set watermark inject information. [cn] 自定义会中水印
    */
    IUIConfig.prototype.setWaterMark = function (waterMarkInfo, onSetWaterMarkResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setWaterMark")) {
            if (onSetWaterMarkResult) {
                onSetWaterMarkResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setWaterMark");
        this._setWaterMarkCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setWaterMark");
            if (onSetWaterMarkResult) {
                onSetWaterMarkResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setWaterMark', { "waterMarkInfo": waterMarkInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setWaterMark');
                if (onSetWaterMarkResult) {
                    onSetWaterMarkResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setWaterMark(waterMarkInfo, this._setWaterMarkCallback);
    };
    /**
    * [en] This method is used to get window handle list. [cn] 获取窗口句柄列表
    */
    IUIConfig.prototype.getRenderWindowInfoList = function (onGetRenderWindowInfoListResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getRenderWindowInfoList")) {
            if (onGetRenderWindowInfoListResult) {
                var nullResult = {};
                onGetRenderWindowInfoListResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getRenderWindowInfoList");
        this._getRenderWindowInfoListCallback = function (ret, reason, hwndInfo) {
            _this._inProcessCallbackSet.delete("getRenderWindowInfoList");
            if (onGetRenderWindowInfoListResult) {
                onGetRenderWindowInfoListResult(ret, reason, hwndInfo);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getRenderWindowInfoList', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getRenderWindowInfoList');
                if (onGetRenderWindowInfoListResult) {
                    onGetRenderWindowInfoListResult(ret["ret"], ret["reason"], ret["hwndInfo"]);
                }
            });
        }
        this.addOn.getRenderWindowInfoList(this._getRenderWindowInfoListCallback);
    };
    /**
    * [en] This interface is used to ShowMeetingWindow. [cn] 显示会议窗口
    */
    IUIConfig.prototype.showMeetingWindow = function (onShowMeetingWindowResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("showMeetingWindow")) {
            if (onShowMeetingWindowResult) {
                onShowMeetingWindowResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("showMeetingWindow");
        this._showMeetingWindowCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("showMeetingWindow");
            if (onShowMeetingWindowResult) {
                onShowMeetingWindowResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('showMeetingWindow', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('showMeetingWindow');
                if (onShowMeetingWindowResult) {
                    onShowMeetingWindowResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.showMeetingWindow(this._showMeetingWindowCallback);
    };
    /**
    * [en] This interface is used to set avatar. [cn] 设置头像
    */
    IUIConfig.prototype.setAvatar = function (avatarInfo, onSetAvatarResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setAvatar")) {
            if (onSetAvatarResult) {
                onSetAvatarResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setAvatar");
        this._setAvatarCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setAvatar");
            if (onSetAvatarResult) {
                onSetAvatarResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setAvatar', { "avatarInfo": avatarInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setAvatar');
                if (onSetAvatarResult) {
                    onSetAvatarResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setAvatar(avatarInfo, this._setAvatarCallback);
    };
    /**
    * [en] This interface is used to set meeting window icon info. [cn] 自定义会议窗口任务栏图标
    */
    IUIConfig.prototype.setMeetingWindowIcon = function (windowIconInfo, onSetMeetingWindowIconResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setMeetingWindowIcon")) {
            if (onSetMeetingWindowIconResult) {
                onSetMeetingWindowIconResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setMeetingWindowIcon");
        this._setMeetingWindowIconCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setMeetingWindowIcon");
            if (onSetMeetingWindowIconResult) {
                onSetMeetingWindowIconResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setMeetingWindowIcon', { "windowIconInfo": windowIconInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setMeetingWindowIcon');
                if (onSetMeetingWindowIconResult) {
                    onSetMeetingWindowIconResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setMeetingWindowIcon(windowIconInfo, this._setMeetingWindowIconCallback);
    };
    /**
    * [en] This interface is used to show setting window. [cn] 显示设置窗口接口
    */
    IUIConfig.prototype.showSettingWindow = function (showInfo, onShowSettingWindowResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("showSettingWindow")) {
            if (onShowSettingWindowResult) {
                onShowSettingWindowResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("showSettingWindow");
        this._showSettingWindowCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("showSettingWindow");
            if (onShowSettingWindowResult) {
                onShowSettingWindowResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('showSettingWindow', { "showInfo": showInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('showSettingWindow');
                if (onShowSettingWindowResult) {
                    onShowSettingWindowResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.showSettingWindow(showInfo, this._showSettingWindowCallback);
    };
    /**
    * [en] This interface is used to show toast info. [cn] 显示提示信息
    */
    IUIConfig.prototype.showToast = function (toastInfo, onShowToastResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("showToast")) {
            if (onShowToastResult) {
                onShowToastResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("showToast");
        this._showToastCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("showToast");
            if (onShowToastResult) {
                onShowToastResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('showToast', { "toastInfo": toastInfo }).then(function (ret) {
                _this._inProcessCallbackSet.delete('showToast');
                if (onShowToastResult) {
                    onShowToastResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.showToast(toastInfo, this._showToastCallback);
    };
    /**
    * [en] This interface is used to get main window info. [cn] 获取主窗口信息
    */
    IUIConfig.prototype.getMainWindowInfo = function (onGetMainWindowInfoResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("getMainWindowInfo")) {
            if (onGetMainWindowInfoResult) {
                var nullResult = {};
                onGetMainWindowInfoResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("getMainWindowInfo");
        this._getMainWindowInfoCallback = function (ret, reason, mainWindowInfo) {
            _this._inProcessCallbackSet.delete("getMainWindowInfo");
            if (onGetMainWindowInfoResult) {
                onGetMainWindowInfoResult(ret, reason, mainWindowInfo);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('getMainWindowInfo', {}).then(function (ret) {
                _this._inProcessCallbackSet.delete('getMainWindowInfo');
                if (onGetMainWindowInfoResult) {
                    onGetMainWindowInfoResult(ret["ret"], ret["reason"], ret["mainWindowInfo"]);
                }
            });
        }
        this.addOn.getMainWindowInfo(this._getMainWindowInfoCallback);
    };
    /**
    * [en] This interface is used to set avatar style. [cn] 设置头像风格
    */
    IUIConfig.prototype.setAvatarStyle = function (avatarStyle, onSetAvatarStyleResult) {
        var _this = this;
        if (this._inProcessCallbackSet.has("setAvatarStyle")) {
            if (onSetAvatarStyleResult) {
                onSetAvatarStyleResult(enum_1.SDKERR.UISDK_IN_PROCESS, "uisdk in process");
            }
            ;
            return;
        }
        this._inProcessCallbackSet.add("setAvatarStyle");
        this._setAvatarStyleCallback = function (ret, reason) {
            _this._inProcessCallbackSet.delete("setAvatarStyle");
            if (onSetAvatarStyleResult) {
                onSetAvatarStyleResult(ret, reason);
            }
        };
        if (this.callWithIPC) {
            electron.ipcRenderer.invoke('setAvatarStyle', { "avatarStyle": avatarStyle }).then(function (ret) {
                _this._inProcessCallbackSet.delete('setAvatarStyle');
                if (onSetAvatarStyleResult) {
                    onSetAvatarStyleResult(ret["ret"], ret["reason"]);
                }
            });
        }
        this.addOn.setAvatarStyle(avatarStyle, this._setAvatarStyleCallback);
    };
    return IUIConfig;
}());
exports.IUIConfig = IUIConfig;
