"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ILogin_1 = require("./ILogin");
var IConfCtrl_1 = require("./IConfCtrl");
var IConfMgr_1 = require("./IConfMgr");
var IConfig_1 = require("./IConfig");
var IUIConfig_1 = require("./IUIConfig");
var ICall_1 = require("./ICall");
var util_1 = require("./util");
var instance = null;
var electron = window.require('electron');
var UISDK = /** @class */ (function () {
    function UISDK(nodePath) {
        this.callWithIPC = false;
        if (!instance) {
            instance = this;
            var uisdkNode = window ? window.require(nodePath) : require(nodePath);
            this.addOn = uisdkNode;
            this.loginImpl = new ILogin_1.ILogin(uisdkNode);
            this.confCtrlImpl = new IConfCtrl_1.IConfCtrl(uisdkNode);
            this.confMgrImpl = new IConfMgr_1.IConfMgr(uisdkNode);
            this.configImpl = new IConfig_1.IConfig(uisdkNode);
            this.uIConfigImpl = new IUIConfig_1.IUIConfig(uisdkNode);
            this.callImpl = new ICall_1.ICall(uisdkNode);
            this.callWithIPC = util_1.needCallWithIPC();
        }
        return instance;
    }
    /**
    * [en] Notify of sdk disconnected. [cn] 连接断开通知
    */
    UISDK.prototype.setOnSdkDisconnectedNotifyCB = function (onSdkDisconnectedNotify) {
        if (this.callWithIPC) {
            electron.ipcRenderer.sendSync('setOnSdkDisconnectedNotifyCB', {});
            electron.ipcRenderer.on('onSdkDisconnectedNotify', function (event, arg) {
                if (onSdkDisconnectedNotify) {
                    onSdkDisconnectedNotify();
                }
            });
            return;
        }
        this._onSdkDisconnectedNotifyCallback = function () {
            if (onSdkDisconnectedNotify) {
                onSdkDisconnectedNotify();
            }
        };
        this.addOn.setOnSdkDisconnectedNotifyCB(this._onSdkDisconnectedNotifyCallback);
    };
    /**
    * [en] This interface is used to init sdk. [cn] 初始化
    */
    UISDK.prototype.init = function (initInfo) {
        this.loginImpl.init();
        this.confCtrlImpl.init();
        this.confMgrImpl.init();
        this.configImpl.init();
        this.uIConfigImpl.init();
        this.callImpl.init();
        if (this.callWithIPC) {
            var ret = electron.ipcRenderer.sendSync('init', { "initInfo": initInfo });
            return ret;
        }
        return this.addOn.init(initInfo);
    };
    /**
    * [en] This interface is used to exit sdk. [cn] 退出
    */
    UISDK.prototype.exit = function () {
        if (this.callWithIPC) {
            var ret = electron.ipcRenderer.sendSync('exit', {});
            return ret;
        }
        return this.addOn.exit();
    };
    /**
    * [en] This interface is used to get the login service object. [cn] 获取登录服务对象
    */
    UISDK.prototype.getLoginApi = function () {
        return this.loginImpl;
    };
    /**
    * [en] This interface is used to get the conf control service object. [cn] 获取会议控制服务对象
    */
    UISDK.prototype.getConfCtrlApi = function () {
        return this.confCtrlImpl;
    };
    /**
    * [en] This interface is used to get the conf management service object. [cn] 获取会议管理服务对象
    */
    UISDK.prototype.getConfMgrApi = function () {
        return this.confMgrImpl;
    };
    /**
    * [en] This interface is used to get the config service object. [cn] 获取配置服务对象
    */
    UISDK.prototype.getConfigApi = function () {
        return this.configImpl;
    };
    /**
    * [en] This interface is used to get the UI config service object. [cn] 获取界面配置服务对象
    */
    UISDK.prototype.getUIConfigApi = function () {
        return this.uIConfigImpl;
    };
    /**
    * [en] This interface is used to get the call service object. [cn] 获取呼叫服务对象
    */
    UISDK.prototype.getCallApi = function () {
        return this.callImpl;
    };
    return UISDK;
}());
exports.default = UISDK;
