import { VmrIdType, ClickInjectParticipantItemBtn, State, DeviceType, ClickInjectBtn, LocalRecordStatus, NetworkAccessType, CycleType, ShareState, ConfRecordMode, SummaryState, InComingAnswerType, ConfAllowJoinUserType, CorpType, ConfResType, MonitorMode, ConfState, SavePathType, ConfIMType, UICustomImageScene, VoiceprintStatementEntry, DeployType, CallEndReason, RecordAuthType, StopShareReason, ConfComingState, LowNetWorkStatus, AudioFrameType, HandleType, AutoMuteType, VerifyMode, LogLevel, ProxyConfigPolicy, Timezone, AutoInviteType, ConfCreateMode, HwndType, TargetLanguageType, AvatarShape, CallState, ShareType, AttendeeType, WndType, SettingVrbkDefaultImageMode, ConferenceType, WaterMarkColorType, ConfRole, NetConnectType, SiteType, SDKERR, ConfEndReason, CapabilityType, SettingPage, LoginState, VmrConfIdType, AuthServerType, ConfAttendeeState, StreamType, ViewType, MediaType, UICustomTextScene, Monitor, ShareStrategyType, Language, NameShowType, InterruptType } from './enum';

/**
* [en]Account auth info. [cn]账号登录鉴权信息
*/
export interface AccountAuthInfo{
	/**<[en]The account [cn]登录账号 [cs_allowNull:N] */
    account: string;
	/**<[en]The password [cn]登录密码 [cs_allowNull:N] */
    password: string;
}

/**
* [en]appId auth info. [cn]appId登录鉴权信息
*/
export interface AppIdAuthInfo{
	/**<[en]Corporation Id [cn]企业Id，仅在SP模式下需要填写，单企业模式不要填写，否则会鉴权失败 [cs_allowNull:Y] */
    corpId?: string;
	/**<[en]The user id [cn]第三方账号唯一标识 [cs_allowNull:N] */
    thirdUserId: string;
	/**<[en]The user name [cn]用户名称（如不填，默认与thirdUserId一致） [cs_allowNull:Y] */
    userName?: string;
	/**<[en]The signature [cn]从第三方服务端获取的鉴权签名 [cs_allowNull:N] */
    signature: string;
	/**<[en]The nonce [cn]从第三方服务端获取的Nonce值，用于华为云服务端验证鉴权签名有效性 [cs_allowNull:N] */
    nonce: string;
	/**<[en]The expire time(s) [cn]从第三方服务端获取的鉴权签名有效期的时间戳（s），0表示永不超时 [cs_allowNull:N] */
    expireTime: number;
	/**<[en]The nonce [cn]用户邮箱信息 [cs_allowNull:Y] */
    userEmail?: string;
	/**<[en]The nonce [cn]用户手机号码 [cs_allowNull:Y] */
    userPhone?: string;
	/**<[en]Indicates the deptCode. [cn]部门id [cs_allowNull:Y] */
    deptCode?: string;
}

/**
* [en]sso auth info. [cn]sso登录鉴权信息
*/
export interface SSOAuthInfo{
	/**<[en]Indicates the account username. [cn]授权码 [cs_sensitive:hide][cs_allowNull:N] */
    code: string;
	/**<[en]sso domain. [cn]企业域名 [cs_sensitive:domain][cs_allowNull:N] */
    domain: string;
	/**<[en]authServerType. [cn]鉴权服务类型 [cs_allowNull:N] */
    authServerType: AuthServerType;
}

/**
* [en]login info. [cn]登录回调返回信息
*/
export interface LoginResult{
	/**<[en]Indicates UUID. [cn]UUID(由系统分配的真实的唯一用户标识) */
    userUuid: string;
	/**<[en]account. [cn]账号 */
    account: string;
	/**<[en]third account. [cn]第三方账号 */
    thirdAccount: string;
	/**<[en]Indicates has call ability. [cn]是否有点对点呼叫能力 */
    basicCallAbility: boolean;
}

/**
* [en]Corporation configuration information. [cn]企业配置信息
*/
export interface CorpConfigInfo{
	/**<[en]Is enable Pstn [cn]是否支持手机呼叫 */
    pstnEnable: boolean;
	/**<[en]Is enable sms [cn]是否支持短信通知 */
    smsEnable: boolean;
	/**<[en]Is enable conference record [cn]是否支持会议录制 */
    recordEnable: boolean;
	/**<[en]Pstn Number [cn]pstn呼叫号码 */
    pstnNumber: string;
	/**<[en]Indicates whether is allow guest start conf. [cn]是否允许来宾提前启动会议默认值 */
    allowGuestStartConf: boolean;
	/**<[en]Indicates join before host time. [cn]允许来宾提前入会时间范围默认值(单位：分钟) 0-随时，n-提前n分钟启动会议 */
    allowGuestStartConfTime: number;
	/**<[en]Is enable Show AddressBook(only for win). [cn]是否支持通讯录显示（仅对win平台生效） */
    enableShowAddressBookStructure: boolean;
	/**<[en]Is enable Rooms local record [cn]大屏是否支持本地录制 [js:disable] */
    enableRoomsLocalRecord: boolean;
	/**<[en]Is support controller [cn]是否支持控制器 [js:disable] */
    supportController: boolean;
	/**<[en]Is enable projection [cn]是否支持共享投屏 [js:disable] */
    enableProjection: boolean;
	/**<[en]Indicates corp enable summary [cn]企业是否支持会议纪要 */
    corpEnableSummary: boolean;
	/**<[en]Is support multi share [cn]企业是否支持多人共享 [js:disable] */
    supportMultiShare: boolean;
	/**<[en]Is support collaborate [cn]企业是否支持新辅流 [js:disable] */
    supportCollaborateCapability: boolean;
	/**<[en]Is support cascading meeting [cn]企业是否支持加入级联会议 [doc:disable] */
    enableSelfCascadingMeeting: boolean;
	/**<[en]Is support across-enterprises cascading meeting [cn]企业是否支持跨企业加入级联会议 [doc:disable] */
    enableCrossCorpCascading: boolean;
	/**<[en]Is enable data guard audio [cn]企业是否支持音频暗水印 [doc:disable] */
    enableDataGuardAudio: boolean;
	/**<[en]Is enable data guard video [cn]企业是否支持视频暗水印 [doc:disable] */
    enableDataGuardVideo: boolean;
}

/**
* [en]This structure is used to describe share vmr info notify [cn]共享vmr信息
*/
export interface ShareVmrInfo{
	/**<[en]Is enable share vmr [cn]共享vmr是否可用 */
    isEnableShareVmr: boolean;
}

/**
* [en]logout info. [cn]登出回调返回信息
*/
export interface LogoutResult{
	/**<[en]Indicates UUID. [cn]UUID(由系统分配的真实的唯一用户标识) */
    userUuid: string;
	/**<[en]account. [cn]账号 */
    account: string;
	/**<[en]third account. [cn]第三方账号 */
    thirdAccount: string;
}

/**
* [en]network mode info [cn]网络模式信息
*/
export interface NetWorkModeInfo{
	/**<[en]Indicates network access type [cn]网络接入类型 [cs_allowNull:N] */
    accessType: NetworkAccessType;
	/**<[en]Indicates network connect type(only for win). [cn]网络连接类型(仅对win平台生效) [cs_allowNull:Y] */
    netConnectType?: NetConnectType;
}

/**
* [en]Self avatar info [cn]个人头像信息
*/
export interface SelfAvatarInfo{
	/**<[en] path [cn] 图片全路径 [cs_allowNull:N] */
    path: string;
}

/**
* [en]This structure is used to describe login parameters. [cn]登录信息参数
*/
export interface ServerInfo{
	/**<[en]Indicates the server address. [cn]服务器地址，默认meeting.huaweicloud.com。 */
    serverAddr: string;
	/**<[en]The server port [cn]服务器端口，默认443。 */
    serverPort: number;
}

/**
* [en]Proxy info. [cn]代理信息
*/
export interface ProxyInfo{
	/**<[en]The proxy config policy [cn]代理配置策略 [mac:disable] */
    proxyConfigPolicy: ProxyConfigPolicy;
	/**<[en]The server address [cn]代理地址 [cs_allowNull:Y] */
    server?: string;
	/**<[en]The server port [cn]代理端口 [cs_allowNull:Y] */
    port?: number;
	/**<[en]The account [cn]代理账号 [cs_allowNull:Y] */
    account?: string;
	/**<[en]The password [cn]代理密码 [cs_allowNull:Y] */
    password?: string;
}

/**
* [en]Proxy info. [cn]代理信息
*/
export interface CAVerifyInfo{
	/**<[en]Indicates the verify mode [cn]认证模式 */
    verifyMode: VerifyMode;
	/**<[en]Indicates the CA certificate path [cn]用户自定义证书存储路径。传空，则使用内置证书校验 [cs_allowNull:Y] */
    certPath?: string;
}

/**
* [en]. [cn]域名保底ip信息
*/
export interface GuaranteedIpAddress{
	/**<[en]Domain [cn]域名 */
    domain: string;
	/**<[en]Guaranteed IP address list. Multiple IP addresses are separated by semicolons (;). A maximum of four IP addresses are supported. [cn]保底ip列表，多个地址中间用分号隔开，最多支持4个地址 */
    guaranteedIps: string;
}

/**
* [en]. [cn]域名保底ip信息
*/
export interface GuaranteedIpAddressesParam{
	/**<[en]Guaranteed IP address list [cn]保底ip信息列表 [cs_allowNull:N] */
    addressList: Array<GuaranteedIpAddress>;
}

/**
* [en]. [cn]部署信息
*/
export interface DeployInfo{
	/**<[en]Indicates the server info. [cn]服务器地址和端口信息 */
    serverInfo: ServerInfo;
	/**<[en]Indicates the deploy mode. [cn]部署模式 */
    deployType: DeployType;
}

/**
* [en]This enumeration is used to describe login state info. [cn]登录状态信息
*/
export interface LoginStateInfo{
	/**<[en]Indicates the login state [cn]登录模式 */
    loginState: LoginState;
}

/**
* [en]This enumeration is used to describe login token info. [cn]登录token信息
*/
export interface LoginTokenInfo{
	/**<[en]Indicates the login token [cn]登录token */
    loginToken: string;
}

/**
* [en]This struct is used to describe attendee base info. [cn]与会者基础信息
*/
export interface AttendeeBaseInfo{
	/**<[en]Indicates nickName [cn]与会者名称。 [cs_allowNull:N] */
    nickName: string;
	/**<[en]Indicates chinese alias. [cn]中文别名（获取会中与会者信息使用） [cs_allowNull:Y][doc:disable] */
    aliasCN?: string;
	/**<[en]Indicates english alias. [cn]英文别名（获取会中与会者信息使用） [cs_allowNull:Y][doc:disable] */
    aliasEN?: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [doc:disable] */
    extendedField: string;
	/**<[en]Indicates number [cn]号码。如果填分配给账号的sip号码（如+99111244216210249）则呼叫该账号的App； 如果填PSTN号码（如18700000000），则通过VoIP网关呼叫该号码，前提是该企业已开通PSTN呼叫权限。 与thirdUserId二选一，账号密码鉴权时使用。 [cs_allowNull:N] */
    number: string;
	/**<[en]The attendee's third account [cn]第三方用户ID。与number二选一，App ID鉴权时使用。 [cs_allowNull:N] */
    thirdUserId: string;
	/**<[en]Indicates account id [cn]华为云会议账号 [cs_allowNull:Y] */
    accountId?: string;
	/**<[en]Indicates email [cn]电子邮箱地址，用于发送邮件通知。 [cs_allowNull:Y] */
    email?: string;
	/**<[en]Indicates sms [cn]短信通知手机号码，用于发送短信通知。 [cs_allowNull:Y] */
    sms?: string;
	/**<[en]Indicates whether is auto invite [cn]是否自动外邀。 [cs_allowNull:Y] */
    isAutoInvite?: boolean;
	/**<[en]Indicates whether is mute [cn]是否闭音。 [cs_allowNull:Y] */
    isMute?: boolean;
	/**<[en]Indicates role [cn]会议角色。 [cs_allowNull:Y] */
    role?: ConfRole;
	/**<[en]This enum is used to describe attendee type [cn]成员类型 [cs_allowNull:Y] */
    type?: AttendeeType;
	/**<[en]Indicates the uuid. [cn]与会者uuid [cs_allowNull:Y] */
    userUuid?: string;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
	/**<[en]Indicates the auto-invite type. [cn]自动邀请类型（仅创建会议生效） [cs_allowNull:Y] */
    autoInviteType?: AutoInviteType;
}

/**
* [en]Creat conf info. [cn]会议信息。
*/
export interface CreateConfInfo{
	/**<[en]The conf suject [cn]会议主题。 [cs_allowNull:N] */
    subject: string;
	/**<[en]The media type [cn]会议类型。 [cs_allowNull:N] */
    mediaType: MediaType;
	/**<[en]Is need password [cn]是否需要来宾密码（仅对随机会议ID生效）。 [cs_allowNull:N] */
    needPassword: boolean;
	/**<[en]Is autorecord [cn]是否开启自动录制会议。开启自动录制会议开关，内部会默认支持录制会议，录制会议开关的打开与关闭并不影响。 说明：仅对云录制生效，客户端本地录制不生效。 [cs_allowNull:Y] */
    isAutoRecord?: boolean;
	/**<[en]Is allow record(only for win) [cn]是否支持录制会议。(仅对win平台生效) 说明：仅对云录制生效，客户端本地录制不生效。 [cs_allowNull:Y] */
    allowRecord?: boolean;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 [cs_allowNull:Y] */
    confAllowJoinUser?: ConfAllowJoinUserType;
	/**<[en]The vmr Id [cn]云会议室唯一ID。预约随机会议时，设置为空字符串。 [cs_allowNull:Y] */
    vmrId?: string;
	/**<[en]VMR conf Id type. [cn]云会议室的会议ID类型 [cs_allowNull:Y] */
    vmrConfIdType?: VmrConfIdType;
	/**<[en]Indicates the password for common participants.If the password is null, the server will generate a password randomly. [cn]来宾密码，如果空则服务器随机生成（仅对随机会议ID生效）。 [cs_allowNull:Y] */
    guestPwd?: string;
	/**<[en]Indicates whether is open waiting room [cn]等候室开启开关。 说明：需要等候室功能开通后才能生效 [cs_allowNull:Y] */
    isOpenWaitingRoom?: boolean;
	/**<[en]Indicates the duration of the conference. (minute) [cn]会议时长，单位分钟，最小值15分钟，最大值1440分钟。 注：不填时由服务端取默认会议时长 [cs_allowNull:Y][mac:disable] */
    duration?: number;
	/**<[en]Is mic on [cn]是否开启麦克风，true开启麦克风；false关闭麦克风。 [cs_allowNull:Y] */
    isMicOn?: boolean;
	/**<[en]Is camera on [cn]是否开启摄像头，true开启摄像头；false关闭摄像头。 [cs_allowNull:Y] */
    isCameraOn?: boolean;
	/**<[en]concurrent participants. [cn]会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数 [cs_allowNull:Y] */
    concurrentParticipants?: number;
	/**<[en]Attendees info [cn]与会者信息。若不需要带与会者，参数值可以为空。 [cs_allowNull:N] */
    attendees: Array<AttendeeBaseInfo>;
	/**<[en]User-defined information [cn]用户自定义信息。 [cs_allowNull:Y] */
    customInfo?: string;
	/**<[en]Indicates conf resource type [cn]会议资源类型 [cs_allowNull:Y] */
    confResType?: ConfResType;
	/**<[en]Indicates record include summary by default [cn]会议云录制是否包含纪要，初始值 [cs_allowNull:Y] */
    defaultSummaryState?: SummaryState;
	/**<[en]Indicates soft terminal auto mute [cn]来宾入会，软终端是否自动静音 [cs_allowNull:Y] */
    autoMuteMode?: AutoMuteType;
	/**<[en]Indicates hard terminal auto mute [cn]来宾入会，硬终端是否自动静音 [cs_allowNull:Y] */
    hardTerminalAutoMuteMode?: AutoMuteType;
	/**<[en]Indicates support multi-share. [cn]是否支持多人共享 [cs_allowNull:Y] [doc:disable] */
    supportMultiShare?: boolean;
	/**<[en]Indicates is whether support watermark [cn]是否支持水印 [cs_allowNull:Y] */
    supportWatermark?: boolean;
	/**<[en]Indicates is whether disable screenshots [cn]是否禁止截屏 [cs_allowNull:Y] */
    forbiddenScreenShots?: boolean;
	/**<[en]Indicates Whether auto publish summary. [cn]是否自动发布纪要（免人工审核） [cs_allowNull:Y] */
    autoPublishSummary?: boolean;
	/**<[en]Indicates whether is support data guard audio. [cn]是否支持音频暗水印 [cs_allowNull:Y][doc:disable] */
    supportDataGuardAudio?: boolean;
	/**<[en]Indicates whether is support data guard video. [cn]是否支持视频暗水印 [cs_allowNull:Y][doc:disable] */
    supportDataGuardVideo?: boolean;
}

/**
* [en]Join conf info. [cn]会议id入会信息
*/
export interface JoinConfByIdInfo{
	/**<[en]Conf id [cn]会议ID。 [cs_allowNull:N] */
    confId: string;
	/**<[en]Conf password [cn]会议密码。若希望以主持人身份入会，必须传入主持人密码。 若希望以来宾身份入会，会议要求来宾密码时，必须传入来宾密码， 会议不要求来宾密码时，可以为空字符串。 [cs_allowNull:Y] */
    password?: string;
	/**<[en]Indicates show nickName in conf. [cn]会议昵称。在已登录状态下可为空，已登录时为空将使用登录的用户名作为会场名。 匿名入会必须传该名字 [cs_allowNull:Y][cs_length:0-256][cs_sensitive:name] */
    nickName?: string;
	/**<[en]Indicates chinese alias. [cn]中文别名 [cs_allowNull:Y][doc:disable] */
    aliasCN?: string;
	/**<[en]Indicates english alias. [cn]英文别名 [cs_allowNull:Y][doc:disable] */
    aliasEN?: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [doc:disable] */
    extendedField: string;
	/**<[en]Indicates corp trust app id. [cn]企业互信应用ID */
    corpTrustAppId: string;
	/**<[en]is speaker off [cn]是否关闭扬声器，true关闭扬声器；false不关闭扬声器。 [cs_allowNull:Y] */
    isSpeakerOff?: boolean;
	/**<[en]Is mic on [cn]是否开启麦克风，true开启麦克风；false关闭麦克风。 [cs_allowNull:Y] */
    isMicOn?: boolean;
	/**<[en]Is camera on [cn]是否开启摄像头，true开启摄像头；false关闭摄像头。 [cs_allowNull:Y] */
    isCameraOn?: boolean;
	/**<[en]Indicates whether stop confilct conf. [cn]强制结束和当前VMR会议资源冲突的会议（必须是vmr资源的拥有者才有权限，否则无效） [cs_allowNull:Y] */
    isStopConflictConf?: boolean;
	/**<[en]Indicates On-premises Meeting. (Anonymous is not supported; Only for Windows). [cn]是否硬件会议（硬件会议不支持匿名入会，仅对Windows平台生效） [doc:disable] */
    isCascadingMeeting: boolean;
	/**<[en]Indicates On-premises prefix id (Only for Windows). [cn]硬件会议企业前缀（仅对Windows平台生效） [doc:disable] */
    confPrefix: string;
	/**<[en]Is hide password alert. (Only for Mac). [cn]是否隐藏密码弹窗，true隐藏；false不隐藏，展示sdk内部的默认弹窗（仅对Mac平台生效） [cs_allowNull:Y] [win:disable] */
    isHidePasswordAlert?: boolean;
}

/**
* [en]Join conf by random info. [cn]会议random入会信息
*/
export interface JoinConfByRandomInfo{
	/**<[en]Conf id [cn]会议ID。 [cs_allowNull:N] */
    confId: string;
	/**<[en]random [cn]48位会议密码映射值。来源于分享会议信息中的会议链接尾部。 会议不要求来宾密码时，可以为空字符串。 [cs_allowNull:Y] */
    random?: string;
	/**<[en]Indicates show name in conf. [cn]会议昵称。在已登录状态下可为空，已登录时为空将使用登录的用户名作为会场名。 匿名入会必须传该名字 [cs_allowNull:Y][cs_length:0-256][cs_sensitive:name] */
    nickName?: string;
	/**<[en]domain. [cn]域名 [cs_sensitive:domain][cs_allowNull:Y] */
    domain?: string;
	/**<[en]is speaker off [cn]是否关闭扬声器，true关闭扬声器；false不关闭扬声器。 [cs_allowNull:Y] */
    isSpeakerOff?: boolean;
	/**<[en]Is mic on [cn]是否开启麦克风，true开启麦克风；false关闭麦克风。 [cs_allowNull:Y] */
    isMicOn?: boolean;
	/**<[en]Is camera on [cn]是否开启摄像头，true开启摄像头；false关闭摄像头。 [cs_allowNull:Y] */
    isCameraOn?: boolean;
}

/**
* [en]Add attendee info [cn]添加与会者信息
*/
export interface AddAttendeeInfo{
	/**<[en]attendees info. [cn]添加与会者的列表 [cs_allowNull:N] */
    attendees: Array<AttendeeBaseInfo>;
}

/**
* [en]Monitor Share info. [cn]屏幕共享信息
*/
export interface MonitorShareInfo{
	/**<[en]Type of monitor [cn]屏幕类型，1-主屏幕，2-副屏幕，mode为主副屏模式下生效 [cs_allowNull:N] */
    monitor: Monitor;
	/**<[en]Mode of monitor [cn]屏幕模式，0-主副屏模式，1-多屏模式 [cs_allowNull:N] */
    monitorMode: MonitorMode;
	/**<[en]Index of monitor [cn]屏幕索引，mode为多屏模式下生效 [cs_allowNull:N] */
    monitorIndex: number;
}

/**
* [en]App share info. [cn]程序共享信息
*/
export interface AppShareInfo{
	/**<[en]App window handle [cn]程序句柄。 [cs_allowNull:N] */
    appHandle: number;
}

/**
* [en]Start share info. [cn]开启共享信息
*/
export interface StartShareInfo{
	/**<[en]Share type [cn]共享类型 [cs_allowNull:N] */
    shareType: ShareType;
	/**<[en]Monitor share info [cn]屏幕共享信息。当共享类型不是屏幕共享时，该变量不需要赋值。 [cs_allowNull:Y] */
    monitorShareInfo?: MonitorShareInfo;
	/**<[en]App Share info [cn]程序共享信息。当共享类型不是程序共享时，该变量不需要赋值。 [cs_allowNull:Y] */
    appShareInfo?: AppShareInfo;
	/**<[en]UI Control Monitor share info [cn]共享时，工具栏所在的显示器信息。若monitor值为0，则不指定显示器。 [cs_allowNull:N] */
    operatableUiMonitor: MonitorShareInfo;
}

/**
* [en]This struct is used to describe attendee info. [cn]会中与会者信息
*/
export interface AttendeeInfo{
	/**<[en]attendee base info. [cn]与会者基本信息 */
    baseInfo: AttendeeBaseInfo;
	/**<[en]is self. [cn]是否是自己 */
    isSelf: boolean;
	/**<[en]Indicates participant state. [cn]与会者状态 */
    state: ConfAttendeeState;
	/**<[en]Indicates whether is anonymous. [cn]是否是匿名入会 */
    isAnonymous: boolean;
	/**<[en]Indicates corp id. [cn]企业id，用于识别是否是本企业账号 */
    corpId: string;
	/**<[en]Indicates userId [cn]与会者唯一标识 [doc:disable] */
    userId: number;
	/**<[en]Indicates has modify custom info in conf capbility. [cn]是否支持会中修改参数能力 [doc:disable] */
    hasModifyCustomInfoInConfCapability: boolean;
}

/**
* [en]This struct is used to describe create conference result. [cn]创建会议结果
*/
export interface CreateConfResult{
	/**<[en]Indicates conference id. [cn]会议id */
    confId: string;
	/**<[en]Indicates VMR conference id(only for mac) [cn]VMR会议id(仅对mac平台生效) [win:todo] */
    vmrConfId: string;
	/**<[en]Indicates host pwd. [cn]主持人密码 [cs_sensitive:hide] */
    hostPwd: string;
	/**<[en]Indicates guest pwd. [cn]来宾密码 [cs_sensitive:hide] */
    guestPwd: string;
	/**<[en]Media type(only for mac) [cn]会议媒体类型(仅对mac平台生效) [win:todo] */
    mediaType: MediaType;
	/**<[en]Indicates guest join url. [cn]来宾链接 */
    guestJoinUri: string;
	/**<[en]Indicates self role. [cn]本人在会议中的角色 */
    selfConfRole: ConfRole;
	/**<[en]Indicates conf subject. [cn]会议主题 [cs_sensitive:subject] */
    subject: string;
	/**<[en]Indicates conference start time. [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间，精度秒(0时区) */
    startTime: number;
	/**<[en]Indicates conference end time. [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间 */
    endTime: number;
	/**<[en]Indicates conference start time [cn]会议开始时间(时间戳，单位秒) */
    startTimeStamp: number;
	/**<[en]Indicates conference end time [cn]会议结束时间(时间戳，单位秒) */
    endTimeStamp: number;
	/**<[en]Indicates conf scheduler name. [cn]预约者名字 [cs_sensitive:name] */
    schedulerName: string;
	/**<[en]Indicates User-defined extended information [cn]自定义扩展信息 */
    customInfo: string;
}

/**
* [en]attendee list info. [cn]与会者列表信息
*/
export interface AttendeeListInfo{
	/**<[en]Attendees info [cn]与会者基础信息 */
    attendees: Array<AttendeeInfo>;
}

/**
* [en]Conf state info. [cn]会议状态信息
*/
export interface ConfStateInfo{
	/**<[en]The state [cn]会议状态。 */
    state: State;
}

/**
* [en]This struct is used to describe conference end info [cn]会议结束信息
*/
export interface ConfEndInfo{
	/**<[en]ConfEndReason [cn]离会原因。 */
    reason: ConfEndReason;
	/**<[en]original ConfEndReason [cn]原始离会原因。 [doc:disable] */
    originalReason: SDKERR;
	/**<[en]is p2p conf [cn]是否立即会议。 */
    isP2PConf: boolean;
	/**<[en]Conf id [cn]会议id */
    confId: string;
}

/**
* [en]Conf info. [cn]会议信息
*/
export interface ConfInfo{
	/**<[en]Indicates the uri for host to join conference(only for mac) [cn]主持人入会链接(仅对mac平台生效) [cs_sensitive:ip][win:todo] */
    hostJoinUri: string;
	/**<[en]the uri used by guest to join conference. [cn]来宾加入会议uri链接，可以分享通过浏览器打开进行入会。 */
    guestJoinUri: string;
	/**<[en]Conf id [cn]会议id */
    confId: string;
	/**<[en]Indicates self role. [cn]本人在会议中的角色。主持人、来宾等。 */
    selfConfRole: ConfRole;
	/**<[en]Indicates host password. [cn]会议主持人密码。 [cs_sensitive:hide] */
    hostPwd: string;
	/**<[en]Indicates guest password. [cn]会议来宾密码。 [cs_sensitive:hide] */
    guestPwd: string;
	/**<[en]conf subject [cn]会议主题。 */
    subject: string;
	/**<[en]start conf time [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间。 */
    startTime: number;
	/**<[en]edn conf time [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间。 */
    endTime: number;
	/**<[en]Indicates conference start time [cn]会议开始时间(时间戳，单位秒) */
    startTimeStamp: number;
	/**<[en]Indicates conference end time [cn]会议结束时间(时间戳，单位秒) */
    endTimeStamp: number;
	/**<[en]Indicates scheduler name [cn]会议预定者名称。 */
    schedulerName: string;
	/**<[en]Media type(only for mac) [cn]会议类型。(仅对mac平台生效) [win:todo] */
    mediaType: MediaType;
	/**<[en]The vmr conf Id(only for mac) [cn]用于云会议显示的ID。(仅对mac平台生效) [win:todo] */
    vmrConfId: string;
	/**<[en]Indicates corp id(only for mac) [cn]企业id。(仅对mac平台生效) [win:todo] */
    corpId: string;
	/**<[en]Indicates User-defined extended information [cn]自定义扩展信息 */
    customInfo: string;
	/**<[en]is other corp conf(only for win) [cn]是否是外部企业的会议：如果是加入外部企业的会议或者匿名入会是true，否则是false */
    isOtherCorpConf: boolean;
	/**<[en]Indicates whether the user is the creator of the conference(only for win) [cn]是否是会议预订者(仅对win平台生效) [mac:todo] */
    isCreator: boolean;
	/**<[en]Indicates whether the user is in breakout sub conf [cn]是否在讨论组中 */
    isInBreakoutSubConf: boolean;
}

/**
* [en]Share state info. [cn]发送端共享状态信息
*/
export interface ShareStateInfo{
	/**<[en]The share state [cn]共享状态。 */
    state: State;
	/**<[en]The nickName [cn]共享者名称。当state为HWM_STATE_ON时才有数据。 */
    nickName: string;
	/**<[en]The number [cn]共享者号码。当state为HWM_STATE_ON时才有数据。 */
    number: string;
	/**<[en]Index of monitor [cn]共享显示器类型（主屏、副屏）。 */
    monitor: Monitor;
	/**<[en]Share type [cn]共享类型。 */
    shareType: ShareType;
	/**<[en]App window handle [cn]程序句柄。 */
    appHandle: number;
	/**<[en]Stop share reason [cn]停止共享原因 */
    stopShareReason: StopShareReason;
}

/**
* [en]Share state info. [cn]接收端共享状态信息
*/
export interface RecvShareStateInfo{
	/**<[en]The share state [cn]共享状态 */
    state: State;
	/**<[en]The nickName [cn]共享者名称。当state为HWM_STATE_ON时才有数据。 */
    nickName: string;
	/**<[en]The number [cn]共享者号码。当state为HWM_STATE_ON时才有数据。 */
    number: string;
}

/**
* [en]Remote control state info. [cn]共享中远程控制状态信息
*/
export interface RemoteControlStateInfo{
	/**<[en]The share state [cn]状态 */
    state: State;
	/**<[en]The nickName [cn]权限所有者名称。 */
    nickName: string;
	/**<[en]The number [cn]权限所有者号码。 */
    number: string;
}

/**
* [en]This struct is used to describe conf common param. [cn]会议信息共有参数
*/
export interface ConfCommonParam{
	/**<[en]Indicates the conference subject. [cn]会议主题。 [cs_sensitive:name][cs_allowNull:N][cs_length:1-385] */
    subject: string;
	/**<[en]The media type [cn]会议类型。默认音频会议。 [cs_allowNull:Y] */
    mediaType?: MediaType;
	/**<[en]Is need password [cn]是否需要来宾密码。默认不需要来宾密码（仅对随机会议ID生效）。 [cs_allowNull:Y] */
    needPassword?: boolean;
	/**<[en]Is autorecord [cn]会议自动录制开关。默认不开启。 开启会议自动录制开关，内部会默认支持录制会议，录制会议开关的打开与关闭并不影响。 说明：仅对云录制生效，客户端本地录制不生效。 [cs_allowNull:Y] */
    isAutoRecord?: boolean;
	/**<[en]Is allow record(only for win) [cn]是否支持录制会议。(仅对win平台生效) 说明：仅对云录制生效，客户端本地录制不生效。 [cs_allowNull:Y] */
    allowRecord?: boolean;
	/**<[en]Reserved.This field is used to transparently transmit conference details when editing a conference. [cn]保留。编辑会议时透传会议详情此字段 [cs_allowNull:Y] */
    allowLive?: boolean;
	/**<[en]Indicates the time zone used in conference notification. [cn]时区码。用于发送会议通知。 [cs_allowNull:N] */
    timezone: Timezone;
	/**<[en]Indicates VMR conference id . [cn]云会议室唯一ID。预约并发会议时，设置为空字符串。编辑会议时不可修改，填入会议详情返回值。 [cs_allowNull:Y] */
    vmrId?: string;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 [cs_allowNull:Y] */
    confAllowJoinUser?: ConfAllowJoinUserType;
	/**<[en]Indicates whether it sends the short message. [cn]发送短信通知开关。企业配置里面需要开启，否则不生效。 [cs_allowNull:Y] */
    isSendSms?: boolean;
	/**<[en]Indicates whether is send email notify. [cn]发送邮件通知开关。 [cs_allowNull:Y] */
    isSendEmail?: boolean;
	/**<[en]VMR conf Id type. [cn]云会议室的会议ID类型。编辑会议时不可修改会议详情中vmrConfId非空，填入HWM_VMR_CONF_ID_TYPE_FIXED； 会议详情中vmrConfId为空，填入HWM_VMR_CONF_ID_TYPE_RANDOM [cs_allowNull:Y] */
    vmrConfIdType?: VmrConfIdType;
	/**<[en]Indicates the password for common participants.If the password is null, the server will generate a password randomly [cn]来宾密码，如果空则服务器随机生成（仅对随机会议ID生效）。 [cs_allowNull:Y][cs_length:0-32][cs_sensitive:hide][win:todo] */
    guestPwd?: string;
	/**<[en]Indicates whether is open waiting room [cn]等候室开启开关。 说明：需要等候室功能开通后才能生效 [cs_allowNull:Y] */
    isOpenWaitingRoom?: boolean;
	/**<[en]Attendees info. If no attendees are included, leave the parameter empty. [cn]与会者列表。若不需要带与会者，参数值可以为空。 [cs_allowNull:Y] */
    attendees?: Array<AttendeeBaseInfo>;
	/**<[en]Indicates allow guest start conf. [cn]允许来宾启动会议 [cs_allowNull:Y] */
    allowGuestStartConf?: boolean;
	/**<[en]Indicates join before host time. [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议 [cs_allowNull:Y] */
    allowGuestStartConfTime?: number;
	/**<[en]Indicates is whether disable screenshots [cn]是否禁止截屏 [cs_allowNull:Y] */
    forbiddenScreenShots?: boolean;
	/**<[en]concurrent participants. [cn]会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数 */
    concurrentParticipants: number;
	/**<[en]User-defined information [cn]用户自定义信息。 [cs_allowNull:Y] */
    customInfo?: string;
	/**<[en]Indicates conf resource type [cn]会议资源类型 [cs_allowNull:Y] */
    confResType?: ConfResType;
	/**<[en]Indicates record include summary by default [cn]会议云录制是否包含纪要，初始值（周期会议暂不支持） [cs_allowNull:Y] */
    defaultSummaryState?: SummaryState;
	/**<[en]Indicates soft terminal auto mute [cn]来宾入会，软终端是否自动静音 [cs_allowNull:Y] */
    autoMuteMode?: AutoMuteType;
	/**<[en]Indicates hard terminal auto mute [cn]来宾入会，硬终端是否自动静音 [cs_allowNull:Y] */
    hardTerminalAutoMuteMode?: AutoMuteType;
	/**<[en]Indicates support multi-share. [cn]是否支持多人共享 [cs_allowNull:Y] [doc:disable] */
    supportMultiShare?: boolean;
	/**<[en]Indicates is whether support watermark [cn]是否支持水印 [cs_allowNull:Y] */
    supportWatermark?: boolean;
	/**<[en]Indicates Whether auto publish summary. [cn]是否自动发布纪要（免人工审核） [cs_allowNull:Y] */
    autoPublishSummary?: boolean;
	/**<[en]Indicates does the attendee list exclude self. [cn]与会者列表是否排除自己，默认不排除自己 [cs_allowNull:Y] */
    attendeesExcludeSelf?: boolean;
	/**<[en]Indicates whether is support data guard audio. [cn]是否支持音频暗水印 [cs_allowNull:Y][doc:disable] */
    supportDataGuardAudio?: boolean;
	/**<[en]Indicates whether is support data guard video. [cn]是否支持视频暗水印 [cs_allowNull:Y][doc:disable] */
    supportDataGuardVideo?: boolean;
}

/**
* [en]Book conf parameter. [cn]预约会议参数
*/
export interface BookConfParam{
	/**<[en]Indicates conference start time. [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间时间戳(utc时间)，单位是秒。说明：UTC时间与UTC偏移量（转换为秒）的差值，如东八区为 UTC时间戳 - (8 x 60 x 60)。 [cs_allowNull:Y] */
    startTime?: number;
	/**<[en]Indicates conference start time [cn]会议开始时间，startTimeStamp、startTime二选一，优先使用startTimeStamp(时间戳，单位秒) [cs_allowNull:Y] */
    startTimeStamp?: number;
	/**<[en]Indicates conference length of time, unit is minute ,this param is optional. [cn]会议时长，单位分钟，最小值15分钟，最大值1440分钟。 [cs_allowNull:N] */
    duration: number;
	/**<[en]Indicates conf common param. [cn]会议公用参数 [cs_allowNull:N] */
    confCommonParam: ConfCommonParam;
	/**<[en]Indicates whether is send calendar notify. [cn]发送邮件日历开关。 [cs_allowNull:Y] */
    isSendCalendar?: boolean;
}

/**
* [en]Cancel conf parameter. [cn]取消会议参数
*/
export interface CancelConfParam{
	/**<[en]Conf id [cn]会议ID。 [cs_allowNull:N] */
    confId: string;
	/**<[en]force cancel(only for win) [cn]是否强制取消，会议开始后可以强制取消(仅对win平台生效) [cs_allowNull:Y][mac:todo] */
    isForceCancel?: boolean;
}

/**
* [en]Edit(modify) conf parameter. [cn]编辑（修改）已经预约的会议
*/
export interface EditConfParam{
	/**<[en]Indicates the conference id. [cn]会议ID。 [cs_allowNull:N] */
    confId: string;
	/**<[en]Indicates conference start time. [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间，如果没有指定开始时间，则表示会议马上开始，精度秒(0时区)。说明：UTC时间与UTC偏移量（转换为秒）的差值，如东八区为 UTC时间戳 - (8 x 60 x 60)。 [cs_allowNull:Y] */
    startTime?: number;
	/**<[en]Indicates conference start time [cn]会议开始时间，startTimeStamp、startTime二选一，优先使用startTimeStamp(时间戳，单位秒) [cs_allowNull:Y] */
    startTimeStamp?: number;
	/**<[en]Indicates conference length of time, unit is minute [cn]会议持续时长，单位分钟 [cs_allowNull:N] */
    duration: number;
	/**<[en]Indicates conf common param. [cn]会议公用参数 [cs_allowNull:N] */
    confCommonParam: ConfCommonParam;
	/**<[en]Indicates whether is send calendar notify. [cn]是否发送日历通知 [cs_allowNull:Y] */
    isSendCalendar?: boolean;
}

/**
* [en]Get conf detail param. [cn]获取会议详情参数体
*/
export interface GetConfDetailParam{
	/**<[en]Conf id [cn]会议ID。 [cs_allowNull:N] */
    confId: string;
}

/**
* [en]Change vmr info param. [cn]修改云会议室参数体
*/
export interface ChangeVmrInfoParam{
	/**<[en]Indicates the id of the vmr. [cn]云会议室唯一ID。 [cs_allowNull:N] */
    vmrId: string;
	/**<[en]Indicates the name of the vmr. [cn]云会议室名称。 [cs_allowNull:N] */
    vmrName: string;
	/**<[en]Indicates the guest password of the vmr. [cn]云会议室来宾密码。 [cs_allowNull:N] */
    guestPwd: string;
	/**<[en]Indicates the host password of the vmr. [cn]云会议室主持人密码。 [cs_allowNull:N] */
    hostPwd: string;
	/**<[en]Indicates whether is allow guest start conf. [cn]是否允许来宾提前启动会议 [cs_allowNull:Y] */
    allowGuestStartConf?: boolean;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 [cs_allowNull:Y] */
    confAllowJoinUser?: ConfAllowJoinUserType;
	/**<[en]Indicates whether is open waiting room [cn]等候室开启开关。 说明：需要等候室功能开通后才能生效 [cs_allowNull:Y] */
    isOpenWaitingRoom?: boolean;
}

/**
* [en]Indicates cycle conference param. [cn]周期子会议的参数
*/
export interface SubCycleConfParam{
	/**<[en]Indicates conference uuid. [cn]子会议唯一标识UUID */
    subConfID: string;
	/**<[en]Indicates media type [cn]媒体类型 */
    mediaType: MediaType;
	/**<[en]Indicates conference start time. [cn]（已废弃，推荐使用字段startTimeStamp）会议起始时间 */
    startTime: number;
	/**<[en]Indicates conference end time. [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间 */
    endTime: number;
	/**<[en]Indicates conference start time [cn]会议开始时间(时间戳，单位秒) */
    startTimeStamp: number;
	/**<[en]Indicates conference end time [cn]会议结束时间(时间戳，单位秒) */
    endTimeStamp: number;
	/**<[en]Indicates whether record automatically when conference begin. [cn]会议开始后是否自动开启录制 */
    isAutoRecord: boolean;
	/**<[en]Indicates record auth type. [cn]录播鉴权方式 */
    recordAuthType: RecordAuthType;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 */
    confAllowJoinUser: ConfAllowJoinUserType;
	/**<[en]Indicates is allow guest start conf. [cn]允许来宾启动会议 */
    allowGuestStartConf: boolean;
	/**<[en]Indicates join before host time. [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议 */
    allowGuestStartConfTime: number;
}

/**
* [en]Indicates cycle conference param. [cn]周期会议的参数
*/
export interface CycleConfParam{
	/**<[en]Indicates conference start date, . [cn]（已废弃，推荐使用字段startTimeStamp）开始日期-时间戳，精度秒(0时区) [cs_allowNull:Y] */
    startDate?: number;
	/**<[en]Indicates conference end date. [cn]（已废弃，推荐使用字段endTimeStamp）结束日期-时间戳，精度秒(0时区) [cs_allowNull:Y] */
    endDate?: number;
	/**<[en]Indicates conference start time [cn]开始时间，startTimeStamp、startDate二选一，优先使用startTimeStamp(时间戳，单位秒) [cs_allowNull:Y] */
    startTimeStamp?: number;
	/**<[en]Indicates conference end time [cn]结束时间，endTimeStamp、endDate二选一，优先使用endTimeStamp(时间戳，单位秒) [cs_allowNull:Y] */
    endTimeStamp?: number;
	/**<[en]Indicates cycle type. [cn]周期类型 */
    cycleType: CycleType;
	/**<[en]Indicates cycle interval. [cn]周期区间 1、周期类型选择了按天，表示每几天召开一次，取值范围[1,15]；2、周期类型选择了Week，表示每几周召开一次，取值范围[1,5]；3、周期类型选择了Month，interval表示隔几月，取值范围[1,3] */
    interval: number;
	/**<[en]Indicates conference points. [cn]周期内的会议召开点。仅当按周和月时有效。数据格式(中间用逗号隔开):1,3,5,7 */
    listPoints: string;
	/**<[en]Indicates prior notificate days. [cn]周期子会议提前通知天数。 */
    preRemindDays: number;
}

/**
* [en]Conf list information. [cn]会议列表信息
*/
export interface ConfListItem{
	/**<[en]Indicates conference id [cn]会议ID。 */
    confId: string;
	/**<[en]Indicates conference subject [cn]会议主题。 */
    subject: string;
	/**<[en]Indicates host pwd. [cn]主持人密码。 [cs_sensitive:hide] */
    hostPwd: string;
	/**<[en]Indicates guest pwd. [cn]来宾密码。 [cs_sensitive:hide] */
    guestPwd: string;
	/**<[en]Indicates the password of audience(only for win) [cn]观众密码。(仅对win平台生效) [cs_sensitive:hide][mac:todo] */
    audiencePwd: string;
	/**<[en]Indicates conference start time [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间(utc时间)，单位秒。 */
    startTime: number;
	/**<[en]Indicates conference end time [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间(utc时间)，单位秒。 */
    endTime: number;
	/**<[en]Indicates conference start time [cn]会议开始时间(时间戳，单位秒) */
    startTimeStamp: number;
	/**<[en]Indicates conference end time [cn]会议结束时间(时间戳，单位秒) */
    endTimeStamp: number;
	/**<[en]Indicates the time zone used in conference notification(only for win) [cn]时区码(仅对win平台生效) [mac:todo] */
    timezone: Timezone;
	/**<[en]Indicates media type [cn]媒体类型 */
    mediaType: MediaType;
	/**<[en]Indicates scheduler name [cn]会议预定者名称。 */
    schedulerName: string;
	/**<[en]Indicates VMR conference id [cn]用于云会议显示的ID。 */
    vmrConfId: string;
	/**<[en]Indicates the uri for host to join conference. [cn]主持人加入会议uri链接 [cs_sensitive:ip] */
    hostJoinUri: string;
	/**<[en]the uri used by guest to join conference. [cn]来宾加入会议uri链接 [cs_sensitive:ip] */
    guestJoinUri: string;
	/**<[en]Indicates the uri for audience to join conference(only for win) [cn]观众加入会议的链接(仅对win平台生效) [cs_sensitive:ip][mac:todo] */
    audienceJoinUri: string;
	/**<[en]Indicates conference state(only for win) [cn]会议状态(仅对win平台生效) [mac:todo] */
    confStateType: ConfState;
	/**<[en]Indicates whether the conference is web conferencre(only for win) [cn]是否是网络研讨会(仅对win平台生效) [mac:todo] */
    isWebinar: boolean;
	/**<[en]Indicates self role. [cn]本人在会议中的角色 */
    selfConfRole: ConfRole;
	/**<[en]Indicates conference type. [cn]会议类型 */
    conferenceType: ConferenceType;
	/**<[en]Indicates cycle conference param. [cn]周期会议的参数 */
    cycleParam: CycleConfParam;
	/**<[en]Indicates cycle sub conference param. [cn]周期子会议参数 */
    subConfParam: Array<SubCycleConfParam>;
	/**<[en]User-defined information [cn]用户自定义信息。 */
    customInfo: string;
}

/**
* [en]Conference information in detail. [cn]会议详细信息
*/
export interface ConfDetail{
	/**<[en]Indicates conference basic info [cn]会议基本信息 */
    confListInfo: ConfListItem;
	/**<[en]Indicates VMR conference id [cn]云会议室唯一ID。 */
    vmrId: string;
	/**<[en]Indicates whether is VMR conference [cn]是否是vmr会议。 */
    vmrFlag: boolean;
	/**<[en]whether auto record the conference [cn]是否开启自动录制会议。 */
    isAutoRecord: boolean;
	/**<[en]Is allow record [cn]是否支持录制会议 */
    allowRecord: boolean;
	/**<[en]Reserved.This field is used to transparently transmit conference details when editing a conference. [cn]保留。编辑会议时透传会议详情此字段 */
    allowLive: boolean;
	/**<[en]Is need password [cn]是否需要密码。 */
    needPassword: boolean;
	/**<[en]Indicates whether it sends the short message. [cn]是否发送短信通知。 */
    isSendSms: boolean;
	/**<[en]Indicates whether is send email notify. [cn]是否发送邮件通知。 */
    isSendEmail: boolean;
	/**<[en]Indicates whether is send calendar notify [cn]是否发送日历通知。 */
    isSendCalendar: boolean;
	/**<[en]Indicates the user type allowed to join the conference. [cn]会议准入设置。 */
    confAllowJoinUser: ConfAllowJoinUserType;
	/**<[en]Attendees info [cn]与会者列表。 */
    attendees: Array<AttendeeBaseInfo>;
	/**<[en]Indicates waiting room state [cn]是否开启等候室 */
    isOpenWaitingRoom: boolean;
	/**<[en]Indicates allow guest start conf. [cn]允许来宾启动会议 */
    allowGuestStartConf: boolean;
	/**<[en]Indicates is whether disable screenshots [cn]是否禁止截屏 */
    forbiddenScreenShots: boolean;
	/**<[en]Indicates join before host time. [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议 */
    allowGuestStartConfTime: number;
	/**<[en]VMR conf Id type. [cn]云会议室的会议ID类型 */
    vmrConfIdType: VmrConfIdType;
	/**<[en]concurrent participants. [cn]会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数 */
    concurrentParticipants: number;
	/**<[en]Indicates record include summary by default [cn]会议云录制是否包含纪要，初始值（周期会议暂不支持） */
    defaultSummaryState: SummaryState;
	/**<[en]Indicates is auto mute of soft terminal [cn]软终端是否自动静音 */
    autoMuteMode: AutoMuteType;
	/**<[en]Indicates is auto mute of hard terminal [cn]硬终端是否自动静音 */
    hardTerminalAutoMuteMode: AutoMuteType;
	/**<[en]Indicates support multi-share. [cn]是否支持多人共享 [cs_allowNull:Y] [doc:disable] */
    supportMultiShare?: boolean;
	/**<[en]Indicates is whether support watermark [cn]是否支持水印 */
    supportWatermark: boolean;
	/**<[en]Indicates Whether auto publish summary. [cn]是否自动发布纪要（免人工审核） */
    autoPublishSummary: boolean;
	/**<[en]Indicates whether is support data guard audio. [cn]是否支持音频暗水印 [doc:disable] */
    supportDataGuardAudio: boolean;
	/**<[en]Indicates whether is support data guard video. [cn]是否支持视频暗水印 [doc:disable] */
    supportDataGuardVideo: boolean;
}

/**
* [en]Vmr information. [cn]云会议室信息
*/
export interface VmrInfo{
	/**<[en]Indicates vmr conference id [cn]云会议室上的固定会议ID。 */
    vmrConfId: string;
	/**<[en]Indicates vmr id [cn]云会议室唯一ID。 */
    vmrId: string;
	/**<[en]Indicates host pwd. [cn]云会议室主持人密码。 [cs_sensitive:hide] */
    hostPwd: string;
	/**<[en]Indicates guest pwd. [cn]云会议室来宾密码。 [cs_sensitive:hide] */
    guestPwd: string;
	/**<[en]Indicates the type of the vmr [cn]云会议室类型。 */
    vmrType: VmrIdType;
	/**<[en]Indicates the max party size of the vmr [cn]云会议室最大方数。 */
    maxParties: number;
	/**<[en]Indicates whether the vmr is enable [cn]云会议室是否可用 */
    isEnable: boolean;
	/**<[en]Indicates the name of the vmr [cn]会议室名称。 */
    name: string;
	/**<[en]Indicates allow guest start conf. [cn]允许来宾启动会议 */
    allowGuestStartConf: boolean;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 */
    confAllowJoinUser: ConfAllowJoinUserType;
	/**<[en]Indicates whether is open waiting room [cn]等候室开启开关。 说明：需要等候室功能开通后才能生效 */
    isOpenWaitingRoom: boolean;
}

/**
* [en]Vmr list info. [cn]云会议室列表信息
*/
export interface VmrListInfo{
	/**<[en]Indicates the specific vmr conference information. [cn]云会议室信息 */
    vmrs: Array<VmrInfo>;
	/**<[en]Indicates whether is share vmr. [cn]是否开启共享vmr */
    isEnableShareVmr: boolean;
	/**<[en]Indicates corp type.(only for windows) [cn]企业类型(仅对win平台生效) [doc:disable] [mac:disable] */
    corpType: CorpType;
}

/**
* [en]This struct is used to describe conference list info. [cn]会议列表信息
*/
export interface ConfListInfo{
	/**<[en]Indicates conf list. [cn]会议列表参数信息。 */
    confListItem: Array<ConfListItem>;
}

/**
* [en]Conf coming information. [cn]会议来电信息
*/
export interface ConfIncomingInfo{
	/**<[en]Conf coming state [cn]来电状态。 */
    state: ConfComingState;
	/**<[en]Media type [cn]会议媒体类型。 */
    mediaType: MediaType;
	/**<[en]is p2p conf [cn]是否立即会议。 */
    isP2PConf: boolean;
	/**<[en]Conf id [cn]会议id。 */
    confId: string;
	/**<[en]Vmr Conf id [cn]Vmr会议id。 */
    vmrConfId: string;
	/**<[en]The attendee's third account [cn]第三方用户ID，App ID鉴权时使用。 */
    thirdUserId: string;
	/**<[en]Invitor name. [cn]邀请者的姓名。会议自动外邀时是预订人，会中邀请时是操作人(仅在win平台下有效) */
    invitorName: string;
	/**<[en]Invitor alias Chinese name. [cn]邀请者的中文别名 [doc:disable] */
    invitorAliasCN: string;
	/**<[en]Invitor alias English name. [cn]邀请者的英文别名 [doc:disable] */
    invitorAliasEN: string;
	/**<[en]Invitor Indicates schedule. [cn]邀请者的扩展字段 [doc:disable] */
    invitorExtendedField: string;
	/**<[en]Indicates Invitor corp id. [cn]邀请者的企业id */
    invitorCorpId: string;
	/**<[en]Schedule user name. [cn]预订者姓名 */
    schedulerName: string;
	/**<[en]Indicates schedule alias Chinese name. [cn]预订者中文别名 [doc:disable] */
    schedulerAliasCN: string;
	/**<[en]Indicates schedule alias English name. [cn]预订者英文别名 [doc:disable] */
    schedulerAliasEN: string;
	/**<[en]Indicates schedule extended field. [cn]预订者的扩展字段 [doc:disable] */
    schedulerExtendedField: string;
}

/**
* [en]Rename self info. [cn]设置会场名信息
*/
export interface RenameSelfInfo{
	/**<[en]Indicates nickName [cn]会场名。 [cs_allowNull:N] */
    nickName: string;
}

/**
* [en] [cn]预约周期会议参数
*/
export interface BookCycleConfParam{
	/**<[en] [cn]预约会议参数 [cs_allowNull:Y] */
    bookConfParam?: BookConfParam;
	/**<[en]Indicates sub conference param. [cn]子会议参数 [cs_allowNull:N] */
    cycleParam: CycleConfParam;
}

/**
* [en]Modify cycle conf param [cn]编辑周期会议参数
*/
export interface ModifyCycleConfParam{
	/**<[en] [cn]编辑会议参数 [cs_allowNull:Y] */
    editConfParam?: EditConfParam;
	/**<[en]Indicates sub conference param. [cn]子会议参数 [cs_allowNull:N] */
    cycleParam: CycleConfParam;
}

/**
* [en]Modify sub cycle conf param [cn]编辑周期子会议参数
*/
export interface ModifySubCycleConfParam{
	/**<[en]Indicates conference id. [cn]会议id [cs_allowNull:N] */
    confId: string;
	/**<[en]Indicates conference uuid. [cn]子会议唯一标识UUID [cs_allowNull:N] */
    subConfID: string;
	/**<[en]The media type [cn]会议类型。 [cs_allowNull:N] */
    mediaType: MediaType;
	/**<[en]Indicates conference start time, . [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间（UTC时间），单位为秒。说明：UTC时间与UTC偏移量（转换为秒）的差值，如东八区为 UTC时间戳 - (8 x 60 x 60)。 [cs_allowNull:Y] */
    startTime?: number;
	/**<[en]Indicates conference start time [cn]会议开始时间，startTimeStamp、startTime二选一，优先使用startTimeStamp(时间戳，单位秒) [cs_allowNull:Y] */
    startTimeStamp?: number;
	/**<[en]Indicates conference length of time, unit is minute [cn]会议持续时长，单位分钟 [cs_allowNull:N] */
    duration: number;
	/**<[en]Is autorecord [cn]是否开启自动录制会议。开启自动录制会议开关，内部会默认支持录制会议，录制会议开关的打开与关闭并不影响。 说明：仅对云录制生效，客户端本地录制不生效。 [cs_allowNull:Y] */
    isAutoRecord?: boolean;
	/**<[en]Indicates record auth type. [cn]录播鉴权方式 [cs_allowNull:Y] */
    recordAuthType?: RecordAuthType;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 [cs_allowNull:Y] */
    confAllowJoinUser?: ConfAllowJoinUserType;
	/**<[en]Indicates allow guest start conf. [cn]允许来宾启动会议 [cs_allowNull:Y] */
    allowGuestStartConf?: boolean;
	/**<[en]Indicates join before host time. [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议 [cs_allowNull:Y] */
    allowGuestStartConfTime?: number;
}

export interface CancelCycleConfParam{
	/**<[en]Indicates conference id. [cn]会议id [cs_allowNull:N] */
    confId: string;
	/**<[en]Indicates is end online conf. [cn]是否需要结束在线会议 [cs_allowNull:N] */
    endOnlineConf: boolean;
}

export interface CancelSubCycleConfParam{
	/**<[en]Indicates conference id. [cn]会议id [cs_allowNull:N] */
    confId: string;
	/**<[en]Indicates conference uuid. [cn]子会议唯一标识UUID [cs_allowNull:N] */
    subConfID: string;
	/**<[en]Indicates is end online conf. [cn]是否需要结束在线会议 [cs_allowNull:N] */
    endOnlineConf: boolean;
}

/**
* [en]This struct is used to describe the status of low net work [cn]弱网状态信息
*/
export interface LowNetWorkStatusInfo{
	/**<[en]Indicates loss rate. [cn]丢包率 */
    packetLoss: number;
	/**<[en]Indicates delay. [cn]时延 */
    delay: number;
	/**<[en]Indicates jitter. [cn]抖动 */
    jitter: number;
	/**<[en]This struct is used to describe the status of low net work [cn]网络状态 */
    status: LowNetWorkStatus;
}

/**
* [en]This struct is used to describe the QoS weak network prompt information [cn]qos弱网提示信息
*/
export interface PoorNetWorkQualityInfo{
	/**<[en]Indicates nickName [cn]与会者名称。 */
    nickName: string;
	/**<[en]Indicates number [cn]号码。如果填分配给账号的sip号码（如+99111244216210249）则呼叫该账号的App； 如果填PSTN号码（如18700000000），则通过VoIP网关呼叫该号码，前提是该企业已开通PSTN呼叫权限。 与thirdUserId二选一，账号密码鉴权时使用。 */
    number: string;
	/**<[en]The attendee's third account [cn]第三方用户ID。与number二选一，App ID鉴权时使用。 */
    thirdUserId: string;
	/**<[en]Indicates account id [cn]华为云会议账号 */
    accountId: string;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
	/**<[en]Indicates is local. [cn]是否本端 */
    isLocal: boolean;
	/**<[en]Indicates is network status. [cn]音频网络状态 */
    audioStatus: LowNetWorkStatusInfo;
	/**<[en]Indicates is network status. [cn]视频网络状态 */
    videoStatus: LowNetWorkStatusInfo;
	/**<[en]Indicates is network status. [cn]共享网络状态 */
    shareStatus: LowNetWorkStatusInfo;
}

/**
* [en] rect info [cn]界面信息
*/
export interface RectInfo{
	/**<[en]left [cn]左边距 */
    left: number;
	/**<[en]top [cn]顶部边距 */
    top: number;
	/**<[en]right [cn]右边距 */
    right: number;
	/**<[en]bottom [cn]底部边距 */
    bottom: number;
}

/**
* [en]watch item param [cn]选看入参
*/
export interface WatchItem{
	/**<[en]Indicates userId [cn]与会者唯一标识 */
    userId: number;
	/**<[en]The render window handle [cn]视频窗口附着的父窗口句柄 */
    renderHandle: number;
	/**<[en]Indicates type of window [cn]窗口类型 */
    wndType: WndType;
	/**<[en]Video rect info [cn]视频显示区域边距 */
    padding: RectInfo;
}

/**
* [en]Watch list info. [cn]选看列表信息
*/
export interface WatchListInfo{
	/**<[en]watch info [cn]选看信息 [cs_allowNull:N] */
    watchList: Array<WatchItem>;
}

/**
* [en]Annotation wnd info [cn]标注窗口信息
*/
export interface AnnotationWndInfo{
	/**<[en]The render window handle [cn]标注窗口附着的父窗口句柄 */
    renderHandle: number;
}

/**
* [en]Annotation save confg info [cn]标注保存配置信息
*/
export interface AnnotationSaveConfigInfo{
	/**<[en]save path [cn]保存路径，注：绝对路径，需要UTF8编码 [cs_allowNull:N] */
    path: string;
}

/**
* [en]Speaker info. [cn]发言人信息
*/
export interface ConfSpeaker{
	/**<[en]Indicates userId [cn]与会者唯一标识 */
    userId: number;
	/**<[en]Display name. [cn]与会者显示名称 */
    name: string;
}

/**
* [en]Speakers info. [cn]发言人列表信息
*/
export interface SpeakerList{
	/**<[en]Speakers. [cn]发言人列表 */
    speakers: Array<ConfSpeaker>;
}

/**
* [en]Stream type info [cn]视频流类型信息
*/
export interface VideoStreamTypeInfo{
	/**<[en]Indicates userId [cn]与会者唯一标识 */
    userId: number;
	/**<[en]Stream type. [cn]流类型 */
    streamType: StreamType;
}

/**
* [en]Annotation state info [cn]标注状态信息
*/
export interface AnnotationStateInfo{
	/**<[en]Annotation state [cn]标注状态 */
    annotationState: State;
}

/**
* [en]This struct is used to describe basic call member info [cn]呼叫基本成员信息
*/
export interface CallMemberInfo{
	/**<[en]Indicates number. [cn]号码 */
    number: string;
	/**<[en]Indicates name. [cn]成员名称 */
    nickName: string;
	/**<[en]Indicates the uuid. [cn]与会者uuid */
    userUuid: string;
	/**<[en]Indicates the third part account. [cn]第三方账号 */
    thirdUserId: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [doc:disable] */
    extendedField: string;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
}

/**
* [en]This struct is used to describe P2P conference record info [cn]立即会议记录
*/
export interface P2PConfRecordInfo{
	/**<[en]Indicates caller infomation. [cn]主叫方信息 */
    callerInfo: CallMemberInfo;
	/**<[en]Indicates callee infomation. [cn]被叫方信息 */
    calleeInfo: CallMemberInfo;
	/**<[en]Indicates calling start time. [cn]（已废弃，推荐使用字段startTimeStamp）呼叫开始时间，精度秒(0时区) */
    startTime: number;
	/**<[en]Indicates calling end time. [cn]（已废弃，推荐使用字段endTimeStamp）呼叫结束时间，精度秒(0时区) */
    endTime: number;
	/**<[en]Indicates conference start time [cn]会议开始时间(时间戳，单位秒) */
    startTimeStamp: number;
	/**<[en]Indicates conference end time [cn]会议结束时间(时间戳，单位秒) */
    endTimeStamp: number;
	/**<[en]Is initiative call out. [cn]是否为主动呼出 */
    isCallOut: boolean;
	/**<[en]Indicates call type. [cn]媒体类型 */
    mediaType: MediaType;
	/**<[en]Error code. [cn]错误码 */
    resultCode: SDKERR;
	/**<[en]Error describe. [cn]错误描述 */
    resultMsg: string;
	/**<[en]Indicates whether the call is established. [cn]呼叫是否建立 */
    isCallEstablished: boolean;
}

/**
* [en]This structure is used to describe start projection param. [cn]发起投屏参数体
*/
export interface StartProjectionParam{
	/**<[en]Indicates pair code. [cn]配对码 [cs_allowNull:N] */
    pairCode: string;
	/**<[en]Indicates random number. [cn]随机数，跨企业投屏场景需要携带。 [cs_allowNull:Y] */
    randomNumber?: string;
	/**<[en]SMS verification code. [cn]验证码，跨企业投屏场景需要携带。 [cs_allowNull:Y] */
    verifyCode?: string;
}

/**
* [en]This structure is used to describe auto hide tool bar param. [cn]自动隐藏会控栏参数体
*/
export interface AutoHideToolBarParam{
	/**<[en]Is auto hide [cn]是否自动隐藏 [cs_allowNull:N] */
    isAutoHide: boolean;
}

/**
* [en]This structure is used to describe start projection result. [cn]发起投屏结果
*/
export interface StartProjectionResult{
	/**<[en]Indicates random number. [cn]随机数 */
    randomNumber: string;
}

/**
* [en]This struct is used to describe conf extend config. [cn]会议扩展配置
*/
export interface ConfExtendConfig{
	/**<[en]Indicates max bitrate. [cn]探高上限值 */
    maxBitrateValue: number;
	/**<[en]Indicates is enable detect max bitrate. [cn]是否开启探高 */
    enableDetectMaxBWE: boolean;
}

/**
* [en]This struct is used to describe conference base info. [cn]会议基础信息
*/
export interface ConfBaseInfo{
	/**<[en]Indicates conference id. [cn]会议id,加入会议时用到。如果是VMR会议，则此ID是真实会议ID，不用来显示；如果不是VMR会议，则用来显示。 */
    confId: string;
	/**<[en]Indicates virtual conference id. [cn]VMR 会议id，VMR会议下有效 */
    vmrConfId: string;
	/**<[cs_sensitive:hide][en]Indicates conference subject. [cn]会议主题 */
    confSubject: string;
	/**<[en]Indicates the conference start time. [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间-时间戳，精度秒(0时区) */
    startTime: number;
	/**<[en]Indicates the conference end time. [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间-时间戳，精度秒(0时区) */
    endTime: number;
	/**<[en]Indicates conference start time [cn]会议开始时间(时间戳，单位秒) */
    startTimeStamp: number;
	/**<[en]Indicates conference end time [cn]会议结束时间(时间戳，单位秒) */
    endTimeStamp: number;
	/**<[en]Indicates the conference end time. [cn]当前服务器时间 [doc:disable] */
    serverCurrentTime: number;
	/**<[en]Indicates time zone, optional, standard time zone for example "Asia/Shanghai" in PBX internal conference; Beijing is "56" in Mediax conference,refer to CONFCTRL_E_TIMEZONE. [cn]时区 */
    timeZone: string;
	/**<[en]Indicates chairman password. [cn]会议主持人密码 */
    hostPwd: string;
	/**<[en]Indicates guest password. [cn]会议来宾密码 */
    guestPwd: string;
	/**<[en]Indicates the conferencn media type. [cn]会议媒体类型 [doc:disable] */
    mediaType: MediaType;
	/**<[en]Indicates schedule uuid. [cn]预订者uuid */
    scheduserUuid: string;
	/**<[en]Indicates schedule user name. [cn]预订者姓名 */
    scheduserName: string;
	/**<[en]Indicates the uri for chairman to join conference . [cn]主持人入会链接 */
    hostJoinUri: string;
	/**<[en]the uri for guest to join conference. [cn]来宾加入会议的链接 */
    guestJoinUri: string;
	/**<[en]Indicates conference access number. [cn]会议接入码 [doc:disable] */
    accessNumber: string;
	/**<[en]Indicates the role of participant. [cn]本人在会议中的角色。主持人、普通与会者等。 */
    selfConfRole: ConfRole;
	/**<[en]Indicates whether the conference is web conferencre. [cn]是否是网络研讨会 */
    isWebinar: boolean;
	/**<[en]Indicates whether the user is the creator of the conference [cn]是否是会议预订者 */
    isCreator: boolean;
	/**<[en]Indicates the uri for audience to join conference. [cn]观众加入会议的链接 */
    audienceJoinUri: string;
	/**<[en]Indicates the password of audience. [cn]观众密码 */
    audiencePwd: string;
	/**<[en]Indicates conference state. [cn]会议状态 [doc:disable] */
    confStateType: ConfState;
	/**<[en]Indicates conference type. [cn]会议类型 */
    conferenceType: ConferenceType;
	/**<[en]Indicates cycle conference param. [cn]周期会议的参数 [doc:disable] */
    cycleParam: CycleConfParam;
	/**<[en]Indicates cycle sub conference param. [cn]周期子会议参数 [doc:disable] */
    subConfParam: Array<SubCycleConfParam>;
	/**<[en]Indicates conference uuid. [cn]会议uuid */
    confUuid: string;
	/**<[en]Indicates is experience conf. [cn]是否为周期体验会议 [doc:disable] */
    isExperienceConf: boolean;
	/**<[en]Indicates . [cn]应用属性，UI根据不同应用拼接 [doc:disable] */
    appAttribute: string;
	/**<[en]Indicates User-defined data on the device side attribute. [cn]自定义扩展信息 */
    openCustomPara: string;
	/**<[en]Indicates live room address [cn]直播地址 */
    liveRoomAddress: string;
	/**<[en]Indicates breakoutID. [cn]讨论分组ID，启动分组后，动态分组成员信息才有 [doc:disable] */
    breakoutID: string;
	/**<[en]Indicates breakoutConfLimit. [cn]分组会议子会场数目上限 [doc:disable] */
    breakoutConfLimit: number;
	/**<[en]Indicates record live type. [cn]录制类型（mmr/rtc/rse） [doc:disable] */
    recordLiveType: string;
	/**<[en]high resolution [cn]是否为超高清(1080p)会议 */
    isHighResolution: boolean;
	/**<[en]Indicates p2p conf. [cn]是否立即会议 */
    isP2PConf: boolean;
	/**<[en]Indicates is use confctlr temporary token. [cn]是否使用会控临时token [doc:disable] */
    isUseConfctrlTempToken: boolean;
	/**<[en]concurrent participants. [cn]会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数 [doc:disable] */
    concurrentParticipants: number;
	/**<[en]Indicates is support E2E encrypt. [cn]是否支持端到端加密 [doc:disable] */
    isSupportE2E: boolean;
	/**<[en]Indicates is chip encrypt call. [cn]是否保密通话 [doc:disable] */
    isChipEncryptCall: boolean;
	/**<[en]conf extend config. [cn]会议扩展配置 [doc:disable] */
    confExtendConfig: ConfExtendConfig;
	/**<[en]Indicates immediatelyConfStartMode. [cn]即时创会类型 [doc:disable] */
    immediatelyConfStartMode: ConfCreateMode;
	/**<[en]Indicates shareState. [cn]共享状态 [doc:disable] */
    shareState: ShareState;
	/**<[en]Indicates enableCollaborate. [cn]是否使用辅流 [doc:disable] */
    enableCollaborate: boolean;
	/**<[en]Indicates supportSummary. [cn]是否支持会议纪要 */
    supportSummary: boolean;
	/**<[en]Indicates defaultSummaryState. [cn]会议纪要开启状态 */
    defaultSummaryState: SummaryState;
	/**<[en]Indicates support multi-share. [cn]是否支持多人共享 [cs_allowNull:Y] [doc:disable] */
    supportMultiShare?: boolean;
	/**<[en]Indicates is corp support water mark. [cn]企业是否支持会议水印 */
    corpEnableWatermark: boolean;
	/**<[en]Indicates is corp support forbidden screen shot. [cn]企业是否支持防截屏 */
    corpEnableForbidScreenShots: boolean;
	/**<[en]Indicates Whether auto publish summary. [cn]是否自动发布纪要（免人工审核） */
    autoPublishSummary: boolean;
}

/**
* [en]This structure is used to describe conf info. [cn]会中信息
*/
export interface MeetingInfo{
	/**<[en]Indicates base information of conference. [cn]会议基本信息 */
    baseInfo: ConfBaseInfo;
	/**<[en]Indicates im group id. [cn]im群组id [doc:disable] */
    imGroupId: string;
	/**<[en]Indicates org id. [cn]企业id */
    orgId: string;
	/**<[en]Indicates conference recording mode. [cn]会议媒体录制模式 */
    recordMode: ConfRecordMode;
	/**<[en]Indicates is support 90P. [cn]是否支持90P [doc:disable] */
    isSupport90P: boolean;
	/**<[en]Indicates is support breakout conf. [cn]是否支持分组会议 */
    supportBreakoutConf: boolean;
	/**<[en]Indicates is breakout sub conf. [cn]是否是分组会议 */
    isBreakoutSubConf: boolean;
	/**<[en]Indicates ctd. [cn]是否是ctd [doc:disable] */
    isCtd: boolean;
	/**<[en]Indicates im type. [cn]会中聊天类型，默认RTM [doc:disable] */
    imType: ConfIMType;
	/**<[en]Indicates conf im group id. [cn]CIM群组id [doc:disable] */
    cimGroupId: string;
	/**<[en]Indicates support cloud virtual background. [cn]是否支持云虚拟背景 [doc:disable] */
    isSupportCloudVirtualBackground: boolean;
	/**<[en]Indicates support guest invite attendee. [cn]是否支持来宾外邀 */
    supportGuestInviteAttendee: boolean;
}

/**
* [en]This structure is used to describe add attendee result. [cn]邀请与会者结果信息
*/
export interface AddAttendeeResult{
	/**<[en]Indicates number. [cn]号码 */
    number: string;
	/**<[en]Indicates the third part account. [cn]第三方账号 */
    thirdUserId: string;
	/**<[en]Error code. [cn]错误码 */
    resultCode: SDKERR;
	/**<[en]Indicates extended field. [cn]扩展字段 [doc:disable] */
    extendedField: string;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
}

/**
* [en]This structure is used to describe add attendee result list. [cn]邀请与会者结果列表
*/
export interface AddAttendeeResultList{
	/**<[en]add attendee result list. [cn]添加与会者结果列表 */
    addAttendeeResults: Array<AddAttendeeResult>;
}

/**
* [en]accept conf param [cn]接受会议邀请参数
*/
export interface AcceptConfParam{
	/**<[en]is audio accept [cn]是否语音接听（仅立即视频会议时有效） [cs_allowNull:Y] */
    isAudioAccept?: boolean;
}

/**
* [en]This struct is used to describe local record state info. [cn]本地录制状态信息
*/
export interface LocalRecordStateInfo{
	/**<[en]Local record status [cn]本地录制状态 */
    status: LocalRecordStatus;
	/**<[en]Local record file path [cn]本地录制文件路径 */
    localRecordPath: string;
	/**<[en]Start time [cn]录制开始时间(时间戳，单位秒) */
    startTime: number;
}

/**
* [en]Self share state info [cn]自己的开启共享状态信息
*/
export interface SelfShareStateInfo{
	/**<[en]The share state [cn]开启共享状态。 */
    state: State;
}

/**
* [en]Local record status info [cn]本地录制状态信息
*/
export interface LocalRecordStatusInfo{
	/**<[en]The local record status [cn]本地录制状态。 */
    state: LocalRecordStatus;
}

/**
* [en]Local record permission info [cn]本地录制权限信息
*/
export interface LocalRecordPermissionInfo{
	/**<[en]The local record permission [cn]是否有本地录制权限。 */
    hasPermission: boolean;
}

/**
* [en]This struct is used to describe the subtitle translation language type info. [cn]字幕翻译语言类型信息
*/
export interface TargetLanguageTypeInfo{
	/**<[en]target language type. [cn]字幕翻译语言类型 */
    targetLanguageType: TargetLanguageType;
}

/**
* [en]This struct is used to describe the subtitle translation language type list. [cn]字幕翻译语言类型列表
*/
export interface TargetLanguageTypeList{
	/**<[en]target language types. [cn]字幕翻译语言类型列表 [cs_allowNull:N] */
    targetLanguageTypes: Array<TargetLanguageTypeInfo>;
}

/**
* [en]This struct is used to describe the real time subtitle info. [cn]实时字幕信息
*/
export interface RealTimeSubtitleInfo{
	/**<[en]Indicates user id. [cn]内部用户id */
    userId: number;
	/**<[en]Indicates Subtitle. [cn]字幕原文内容 */
    originalMsg: string;
	/**<[en]Indicates Subtitle. [cn]字幕翻译内容 */
    translatedMsg: string;
	/**<[en]Indicates is final. [cn]是否完整语句 */
    isFinal: boolean;
	/**<[en]Indicates user name. [cn]用户名称 */
    name: string;
	/**<[en]Indicates user aliasCN. [cn]用户中文别名 */
    aliasCN: string;
	/**<[en]Indicates user aliasEN. [cn]用户英文别名 */
    aliasEN: string;
	/**<[en]Indicates is exist voice print. [cn]是否携带声纹识别信息 */
    isExistVoicePrint: boolean;
	/**<[en]Indicates isRecognize. [cn]是否匹配到声纹 */
    isRecognize: boolean;
	/**<[en]Indicates speakerCN. [cn]发言人中文别名 */
    speakerCN: string;
	/**<[en]Indicates speakerCN. [cn]发言人英文别名 */
    speakerEN: string;
	/**<[en]Indicates userCN. [cn]声纹所属中文名 */
    userCN: string;
	/**<[en]Indicates userEN. [cn]声纹所属英文名 */
    userEN: string;
	/**<[en]Indicates tag. [cn]用户标识 */
    tag: string;
	/**<[en]Indicates translate language. [cn]字幕翻译语言类型 */
    translateLanguage: TargetLanguageType;
}

/**
* [en]This struct is used to describe subtitle record info. [cn]字幕记录信息
*/
export interface SubtitleRecordInfo{
	/**<[en]Indicates real time subtitle. [cn]实时字幕信息 */
    realTimeSubtitleInfo: RealTimeSubtitleInfo;
	/**<[en]Indicates subtitle message id. [cn]消息id,可以用来匹配字幕和翻译 */
    msgId: string;
	/**<[en]Indicates subtitle time stamp. [cn]字幕时间戳,UI可以用来显示字幕时间 */
    timeStamp: number;
}

/**
* [en]This struct is used to describe interrupt info. [cn]中断信息
*/
export interface InterruptInfo{
	/**<[en]Indicates interrupt type. [cn]中断类型 */
    type: InterruptType;
}

/**
* [en]Call state info. [cn]通话状态信息
*/
export interface CallStateInfo{
	/**<[en]Call state [cn]通话状态 */
    state: CallState;
}

/**
* [en]Caller info [cn]主叫信息
*/
export interface CallerInfo{
	/**<[en]Caller nickName [cn]主叫姓名 [cs_allowNull:Y] */
    nickName?: string;
	/**<[en]Indicates chinese alias. [cn]中文别名（获取会中与会者信息使用） [cs_allowNull:Y][doc:disable] */
    aliasCN?: string;
	/**<[en]Indicates english alias. [cn]英文别名（获取会中与会者信息使用） [cs_allowNull:Y][doc:disable] */
    aliasEN?: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [cs_allowNull:Y][doc:disable] */
    extendedField?: string;
}

/**
* [en]Callee info [cn]被叫信息
*/
export interface CalleeInfo{
	/**<[en]Callee nickName [cn]被叫姓名 [cs_allowNull:Y] */
    nickName?: string;
	/**<[en]Indicates chinese alias. [cn]中文别名（获取会中与会者信息使用） [cs_allowNull:Y][doc:disable] */
    aliasCN?: string;
	/**<[en]Indicates english alias. [cn]英文别名（获取会中与会者信息使用） [cs_allowNull:Y][doc:disable] */
    aliasEN?: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [cs_allowNull:Y][doc:disable] */
    extendedField?: string;
	/**<[en]Callee number [cn]被叫号码，如果填分配给账号的sip号码（如+99111244216210249）则呼叫该账号的App； 如果填PSTN号码（如18700000000），则通过VoIP网关呼叫该号码，前提是该企业已开通PSTN呼叫权限。 与thirdUserId二选一（优先级 : number>thirdUserId），账号密码鉴权时使用。 [cs_allowNull:N] */
    number: string;
	/**<[en]Callee third account [cn]被叫三方账号，与number二选一（优先级 : number>thirdUserId），appId鉴权时使用 [cs_allowNull:N] */
    thirdUserId: string;
	/**<[en]Indicates the uuid. [cn]与会者uuid [cs_allowNull:Y] */
    userUuid?: string;
	/**<[en]Indicates the attendee type(只有Normal和Mobile有效) [cn]成员类型 [cs_allowNull:Y] */
    type?: AttendeeType;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
}

/**
* [en]Start call info [cn]发起呼叫信息
*/
export interface StartCallInfo{
	/**<[en]caller info [cn]主叫信息 [cs_allowNull:N] */
    callerInfo: CallerInfo;
	/**<[en]callee info [cn]被叫信息 [cs_allowNull:N] */
    calleeInfo: CalleeInfo;
	/**<[en]Media type [cn]媒体类型 [cs_allowNull:N] */
    mediaType: MediaType;
	/**<[en]Indicates whether the guest joins the conference without password [cn]是否来宾免密 [cs_allowNull:Y] */
    isGuestJoinConfWithoutPwd?: boolean;
	/**<[en]Indicates the user type allowed to join the conference. [cn]允许入会范围限制。默认所有用户。 [cs_allowNull:Y] */
    confAllowJoinUser?: ConfAllowJoinUserType;
	/**<[en]Indicates User-defined data on the device side attribute. [cn]可选，端侧自定义数据，服务器不感知业务 [cs_allowNull:Y] */
    customInfo?: string;
}

/**
* [en]Call information [cn]通话信息
*/
export interface CallInfo{
	/**<[en]Media type [cn]媒体类型 */
    mediaType: MediaType;
	/**<[en]Other party number [cn]对方号码 */
    number: string;
	/**<[en]Other party nickName [cn]对方名称 */
    nickName: string;
	/**<[en]Start call time [cn]呼叫开始时间 */
    startTime: string;
	/**<[en]End call time(is null before call end) [cn]呼叫结束时间（通话结束前为空） */
    endTime: string;
	/**<[en]Is initiative call out [cn]是否为主动呼出 */
    isCallOut: boolean;
}

/**
* [en]Call coming information. [cn]呼叫来电信息
*/
export interface CallIncomingInfo{
	/**<[en]Media type [cn]媒体类型 */
    mediaType: MediaType;
	/**<[en]caller number [cn]来电者号码 */
    number: string;
	/**<[en]caller name [cn]来电者姓名 */
    nickName: string;
}

/**
* [en]Call record information(after call end) [cn]通话记录信息(通话结束后上报)
*/
export interface CallRecordInfo{
	/**<[en]Call information [cn]呼叫信息 */
    callInfo: CallInfo;
	/**<[en]Call end reason [cn]呼叫结束原因 */
    reason: CallEndReason;
}

/**
* [en]Language info [cn]语言信息
*/
export interface LanguageInfo{
	/**<[en]Language type [cn]语言类型 [cs_allowNull:N] */
    type: Language;
	/**<[en]Customized language location-name. [cn]自定义语言区域名 [cs_allowNull:Y] */
    languageCode?: string;
}

/**
* [en]Capability info. [cn]功能配置信息
*/
export interface CapabilityInfo{
	/**<[en]Capability type [cn]功能类型 [cs_allowNull:N] */
    type: CapabilityType;
	/**<[en]Enable state [cn]开启状态 [cs_allowNull:N] */
    isEnable: boolean;
}

/**
* [en]User save path info. [cn]设置用户保存路径信息
*/
export interface UserSavePathInfo{
	/**<[en]save path type [cn]保存路径类型 [cs_allowNull:N] */
    pathType: SavePathType;
	/**<[en]save path [cn]保存路径，注：绝对路径，需要UTF8编码 [cs_allowNull:N] */
    path: string;
}

/**
* [en]Share strategy info. [cn]屏幕共享策略信息
*/
export interface ShareStrategyInfo{
	/**<[en]share strategy type [cn]屏幕共享策略类型 [cs_allowNull:N] */
    shareStrategyType: ShareStrategyType;
}

/**
* [en]AudioRawData config info. [cn]音频码流配置信息
*/
export interface AudioRawDataConfigInfo{
	/**<[en]is open [cn]是否开启 [cs_allowNull:N] */
    isOpen: boolean;
}

/**
* [en]Incoming answer type info [cn]来电应答类型信息
*/
export interface InComingAnswerTypeInfo{
	/**<[en]incoming answer type [cn]来电应答类型 [cs_allowNull:N] */
    type: InComingAnswerType;
}

/**
* [en]Device config info [cn]设备配置信息
*/
export interface DeviceConfig{
	/**<[en]Is mic on [cn]是否开启麦克风 [cs_allowNull:Y] */
    isMicOn?: boolean;
	/**<[en]Is camera on [cn]是否开启摄像头 [cs_allowNull:Y] */
    isCameraOn?: boolean;
}

/**
* [en]Pstn access number info. [cn]会议pstn接入号码信息
*/
export interface PstnAccessNumberInfo{
	/**<[en]Pstn access number [cn]会议pstn接入号码 */
    pstnAccessNumber: string;
}

/**
* [en]Device state info. [cn]设备状态类型
*/
export interface DeviceStateInfo{
	/**<[en]Device type [cn]设备类型 [cs_allowNull:N] */
    deviceType: DeviceType;
	/**<[en]is open [cn]是否开启 [cs_allowNull:N] */
    isOpen: boolean;
}

/**
* [en]Report audio stream frame data. [cn]上报音频码流帧数据
*/
export interface AudioFrameData{
	/**<[en]Indicates frameType. [cn]音频帧类型 */
    eFrameType: AudioFrameType;
	/**<[en]Indicates samples. [cn]每个声道的采样点数,iSamples=iSamplesPerSec × 10ms / 1000 */
    iSamples: number;
	/**<[en]Indicates samplesPerSec. [cn]采样率 */
    iSamplesPerSec: number;
	/**<[en]Indicates bytesPerSample. [cn]每个采样点的字节数,pcm数据一般16bit */
    iBytesPerSample: number;
	/**<[en]Indicates channels. [cn]声道数 */
    iChannels: number;
	/**<[en]Indicates buffer. [cn]数据缓冲区,长度=iSamples × iBytesPerSample × iChannels [trans:Uint8Array] */
    pBuffer: Uint8Array;
	/**<[en]Indicates data length. [cn]编码后或解码前使用该字段表示数据长度，加解密处理后需更新此字段值 */
    uiDataLen: number;
}

/**
* [en]WaterMark info [cn]水印信息
*/
export interface WaterMarkInfo{
	/**<[en]WaterMark content [cn]用户自定义水印注入内容 [cs_allowNull:Y] */
    content?: string;
	/**<[en]WaterMark font color [cn]水印字体颜色，0-浅色，1-标准色，2-深色 [cs_allowNull:Y] */
    color?: WaterMarkColorType;
}

/**
* [en]Contact info [cn]联系人信息
*/
export interface ContactInfo{
	/**<[en]Indicates account id. [cn]账号，账号密码登录场景下优先使用此字段 */
    accountId: string;
	/**<[en]The attendee's third account [cn]与会者三方账号，appid登录场景下优先使用此字段 */
    thirdUserId: string;
	/**<[en]number [cn]号码，跨企业场景下优先使用此字段 */
    number: string;
	/**<[en]Indicates UUID(only for win). [cn]UUID(由系统分配的真实的唯一用户标识)(仅在win平台下有效) */
    userUuid: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [doc:disable] */
    extendedField: string;
	/**<[en]Indicates real name account. [cn]真实账号或名字 [doc:disable] */
    realNameAccount: string;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
}

/**
* [en]Avatar info [cn]头像信息
*/
export interface AvatarInfo{
	/**<[en]number（number和thirdUserId二选一） [cn]号码参数 [cs_allowNull:Y] */
    number?: string;
	/**<[en]The third user id [cn]三方账号（number和thirdUserId二选一） [cs_allowNull:Y] */
    thirdUserId?: string;
	/**<[en]avatar path [cn]头像路径 [cs_allowNull:N] */
    avatarPath: string;
}

/**
* [en]Window icon info [cn]窗口图标信息
*/
export interface WindowIconInfo{
	/**<[en]icon path [cn]图标路径 [cs_allowNull:N] */
    iconPath: string;
}

/**
* [en]Window handle info [cn]窗口句柄信息
*/
export interface HwndInfo{
	/**<[en]The render window handle.when hwndType is SCREEN_ID，the renderHandle Indicate screen id. [cn]渲染视图的窗口句柄.当hwndType为SCREEN_ID，renderHandle代表屏幕的ID 其中值大于1 */
    renderHandle: number;
	/**<[en]The window handle type(only for win). [cn]窗口句柄的类型(仅在win平台下有效) [mac:disable] */
    hwndType: HwndType;
	/**<[en]Large video window for the speaker [cn]是否演讲者大视频窗口 [mac:disable] */
    isBigView: boolean;
	/**<[en]The view type(only for mac). [cn]视图的类型(仅在mac平台下有效) [win:disbale] */
    viewType: ViewType;
	/**<[en]The handle type(only for mac). [cn]句柄的类型(仅在mac平台下有效) [win:disbale] */
    handleType: HandleType;
}

/**
* [en]Window handle list info [cn]窗口句柄列表信息
*/
export interface HwndListInfo{
	/**<[en]Indicates video window handle list [cn]视频窗口句柄列表 */
    hwndInfoList: Array<HwndInfo>;
}

/**
* [en]participant item info. [cn]与会者列表子项信息
*/
export interface ParticipantItemInfo{
	/**<[en]Number [cn]号码 */
    number: string;
	/**<[en]Nickname [cn]与会者昵称 */
    nickName: string;
	/**<[en]The attendee's third account [cn]与会者三方账号，appId登录时使用 */
    thirdUserId: string;
	/**<[en]Indicates account id [cn]华为云会议账号 */
    accountId: string;
	/**<[en]Indicates extended field. [cn]扩展字段 [doc:disable] */
    extendedField: string;
	/**<[en]Indicates corp id. [cn]企业id */
    corpId: string;
}

/**
* [en]Btn pos info. [cn]按钮位置信息
*/
export interface BtnPosInfo{
	/**<[en]The left coordinates [cn]左侧坐标 */
    left: number;
	/**<[en]The top coordinates [cn]上侧坐标 */
    top: number;
	/**<[en]The width [cn]宽度 */
    width: number;
	/**<[en]The height [cn]高度 */
    height: number;
}

/**
* [en]Inject btn info. [cn]注入按钮点击通知信息
*/
export interface InjectBtnInfo{
	/**<[en]Button type [cn]按钮类型 */
    injectBtn: ClickInjectBtn;
	/**<[en]Buttton id [cn]按钮id */
    btnId: string;
	/**<[en]Buttton pos info [cn]按钮位置信息，仅点击自定义按钮时有效(仅对win平台生效) */
    posInfo: BtnPosInfo;
}

/**
* [en]Participant item inject btn info. [cn]与会者子项注入按钮点击通知信息
*/
export interface InjectParticipantItemBtnInfo{
	/**<[en]Button type [cn]按钮类型 */
    injectBtn: ClickInjectParticipantItemBtn;
	/**<[en]Participant info [cn]与会者子项信息 */
    participantInfo: ParticipantItemInfo;
	/**<[en]Buttton id [cn]按钮id */
    btnId: string;
	/**<[en]Buttton pos info [cn]按钮位置信息(仅对win平台生效) */
    posInfo: BtnPosInfo;
}

/**
* [en]Call all item inject btn info. [cn]全部呼叫注入按钮点击通知信息
*/
export interface CallAllBtnInfo{
	/**<[en]Button type [cn]按钮类型 */
    injectBtn: ClickInjectBtn;
	/**<[en]Participants to call [cn]被呼叫的与会者信息 */
    participants: Array<ParticipantItemInfo>;
}

/**
* [en]Device ctrl info. [cn]设备操作信息
*/
export interface DeviceCtrlInfo{
	/**<[en]Device type [cn]设备类型 */
    deviceType: DeviceType;
}

/**
* [en] Show setting window info [cn] 显示设置窗口信息
*/
export interface ShowSettingWindowInfo{
	/**<[en]Is show. [cn]是否显示 */
    isShow: boolean;
	/**<[en]Default page [cn]默认显示标签页 */
    defaultPage: SettingPage;
}

/**
* [en] Voice prompts info [cn] 提示音信息
*/
export interface VoicePromptsInfo{
	/**<[en]Is disable mute prompts. [cn]是否禁用静音提示 */
    isDisableMutePrompt: boolean;
}

/**
* [en] Share permission info [cn] 共享权限信息
*/
export interface SharePermission{
	/**<[en]Is disable share permission. [cn]是否禁用共享权限 */
    isAllowed: boolean;
}

/**
* [en]Show voiceprint statement info [cn]打开声纹降噪功能声明信息
*/
export interface ShowVoiceprintStatementInfo{
	/**<[en]entry of show statement [cn]打开功能声明入口 */
    entry: VoiceprintStatementEntry;
}

/**
* [en] Voiceprint record reading text [cn] 声纹录入朗读文本
*/
export interface VoiceprintRecordReadingText{
	/**<[en]Reading text content [cn]朗读文本内容 */
    content: string;
	/**<[en]Reading text title [cn]朗读文本标题 */
    title: string;
	/**<[en]Reading text language [cn]朗读文本语言 */
    language: Language;
}

/**
* [en] Voiceprint record window config [cn] 声纹录入窗口配置
*/
export interface VoiceprintRecordWindowConfig{
	/**<[en]Indicates reading text list [cn]朗读文本列表 */
    readingTextList: Array<VoiceprintRecordReadingText>;
}

/**
* [en]Set log path info. [cn]设置日志路径信息
*/
export interface LogPathInfo{
	/**<[en]save path [cn]保存路径，注：绝对路径，需要UTF8编码 [cs_allowNull:N] */
    path: string;
}

/**
* [en]Error message info. [cn]错误提示
*/
export interface ErrorMessageInfo{
	/**<[en]error message [cn]错误提示，注：UTF8编码 */
    errorMessage: string;
}

/**
* [en]Toast info. [cn]提示信息
*/
export interface ToastInfo{
	/**<[en]Toast content. [cn]提示内容 */
    content: string;
	/**<[en]Toast duration. [cn]提示持续时间（单位：秒） */
    duration: number;
}

/**
* [en]Main Window info. [cn]主窗口信息
*/
export interface MainWindowInfo{
	/**<[en]Indicates window's left offset from screen [cn]窗口相对于屏幕左侧的偏移量。 */
    x: number;
	/**<[en]Indicates window's top offset from screen [cn]窗口相对于屏幕顶端的偏移量。 */
    y: number;
	/**<[en]Indicates window's width [cn]窗口的宽度。 */
    width: number;
	/**<[en]Indicates Window's height [cn]窗口的高度。 */
    height: number;
	/**<[en]Window handle [cn]窗口句柄 */
    handle: number;
}

/**
* [en]Transparent window info. [cn]透明窗口信息
*/
export interface TransparentWndInfo{
	/**<[en]Window handle [cn]窗口句柄 */
    handle: Array<number>;
}

/**
* [en]CA path info [cn]证书路径信息
*/
export interface CAPathInfo{
	/**<[en]CA path [cn]证书路径，注：绝对路径，需要UTF8编码 [cs_allowNull:N] */
    path: string;
}

/**
* [en]This structure is used to describe custom text info. [cn]自定义文案信息
*/
export interface UICustomTextInfo{
	/**<[en]Language type [cn]语言类型 */
    languageType: Language;
	/**<[en]Customized language location-name. [cn]自定义语言区域名 [cs_allowNull:Y] */
    languageCode?: string;
	/**<[en]User custom text [cn]用户自定义文案 */
    customText: string;
}

/**
* [en]This structure is used to describe custom scene and text info. [cn]自定义场景文案信息
*/
export interface CustomSceneTextInfo{
	/**<[en]Custom text scene [cn]自定义文案场景 */
    scene: UICustomTextScene;
	/**<[en]Custom text list [cn]自定义文案列表 */
    sceneTextList: Array<UICustomTextInfo>;
}

/**
* [en]This structure is used to describe custom scene and text info list. [cn]自定义场景文案信息列表
*/
export interface CustomSceneTextInfoList{
	/**<[en]Scene and custom ui text list [cn]自定义场景文案信息列表 */
    customSceneTextInfoList: Array<CustomSceneTextInfo>;
}

/**
* [en]This structure is used to describe custom scene and image info. [cn]自定义场景图标信息
*/
export interface CustomSceneImageInfo{
	/**<[en]Custom image scene [cn]自定义图标场景 */
    scene: UICustomImageScene;
	/**<[en]Custom image path [cn]自定义图标路径 */
    imagePath: string;
	/**<[en]Custom image path [cn]自定义图标宽度 */
    width: number;
	/**<[en]Custom image path [cn]自定义图标高度 */
    height: number;
}

/**
* [en]This structure is used to describe custom scene and image info list. [cn]自定义场景图标信息列表
*/
export interface CustomSceneImageInfoList{
	/**<[en]Scene and custom ui image list [cn]自定义场景图标信息列表 */
    customSceneImageInfoList: Array<CustomSceneImageInfo>;
}

/**
* [en]Avatar style [cn]头像风格
*/
export interface AvatarStyle{
	/**<[en]background color [cn]背景色 [cs_allowNull:N] */
    backgroundColor: string;
	/**<[en]text color [cn]文字颜色 [cs_allowNull:N] */
    textColor: string;
	/**<[en]phone icon path [cn]手机图标 [cs_allowNull:N] */
    phoneIconPath: string;
	/**<[en]board icon path [cn]大屏图标 [cs_allowNull:N] */
    boardIconPath: string;
	/**<[en]Name show type [cn]姓名显示风格 [cs_allowNull:Y] */
    nameShowType?: NameShowType;
	/**<[en]Avatar shape [cn]头像形状 [cs_allowNull:Y] */
    avatarShape?: AvatarShape;
}

/**
* [en]Virtual background image info [cn]虚拟背景图信息
*/
export interface VirtualBackgroundImageInfo{
	/**<[en]Image path [cn]虚拟背景图片路径 */
    imagePath: string;
}

/**
* [en]This struct is used to describe Virtual background info. [cn]虚拟背景信息
*/
export interface VirtualBackgroundInfo{
	/**<[en]Default image mode [cn]设置自定义虚拟背景默认图模式 */
    mode: SettingVrbkDefaultImageMode;
	/**<[en]Image list [cn]虚拟背景图列表 */
    imageList: Array<VirtualBackgroundImageInfo>;
}

/**
* [en]Init info. [cn]初始化信息
*/
export interface InitInfo{
	/**<[en]The path of the exe file(only for win64) [cn]SDK启动路径，SDK压缩包中HwmSdk文件夹下的exe文件所在的绝对路径。 使用前请将SDK压缩包中HwmSdk文件夹下HwmSdk.exe文件名修改为期望的名称。 如果HwmSdk文件夹的路径为：D:\MyApp\SDK\HwmSdk\，exe文件的名称为MySdk.exe， 则exePath=D:\MyApp\SDK\HwmSdk\MySdk.exe。 注：需要UTF8编码。(仅对win64平台生效) [cs_allowNull:N][mac:disable] */
    exePath: string;
	/**<[en]The path of the log file [cn]SDK日志路径，如果不设置，则使用默认路径。 注：需要UTF8编码。 [cs_allowNull:N] */
    logPath: string;
	/**<[en]The path of the user data file(only for win) [cn]SDK用户数据路径，如果不设置，则使用默认路径。 注：需要UTF8编码。(仅对win平台生效) [cs_allowNull:N][mac:disable] */
    userDataPath: string;
	/**<[en]The app identity [cn]App ID。App ID的申请，请参考“App ID鉴权介绍”章节。 [cs_allowNull:N] */
    appId: string;
	/**<[en]The site type [cn]站点类型。默认使用国内站点（值置0）。 [cs_allowNull:Y] */
    siteType?: SiteType;
	/**<[en]Indicates the log keeping days. [cn]配置项-日志保存天数，输入有效范围为3-30，默认值0。0为不按天数删除日志。 注意：输入1和2会转换为3，大于30的值会被转换为30。 [cs_allowNull:Y] */
    logKeepDays?: number;
	/**<[en]preferred camera(only for win) [cn]优选摄像头列表，填写后，初次打开摄像头按列表中的顺序选择第一个可用的摄像头。 可以不填，不填按照默认顺序打开可用的摄像头。(仅对win平台生效) [cs_allowNull:Y][mac:disable] */
    preferredCamera?: string;
	/**<[en]The app url(only for mac) [cn]官网下载渠道链接(仅对mac平台生效) [cs_allowNull:Y][win:disable] */
    appUrl?: string;
	/**<[en]is support multi client login. [cn]是否支持同终端多应用登录 */
    isSupportMultiAppLogin: boolean;
	/**<[en]WorkSpace Plugin Download Url. [cn]云桌面插件的下载地址配置。(仅对win平台生效) [cs_allowNull:Y][doc:disable][mac:disable] */
    workSpacePluginDownloadUrl?: string;
	/**<[en]Indicates log level。 [cn]日志级别 [cs_allowNull:Y][doc:disable] */
    logLevel?: LogLevel;
	/**<[en]Indicates app version。 [cn]应用版本号 [cs_allowNull:Y][doc:disable] */
    appVersion?: string;
}

