import { SDKERR } from './enum';
import { StartCallInfo, CallRecordInfo, CallStateInfo } from './model';
export declare class ICall {
    addOn: ICall;
    _onCallStateChangedCallback: (callStateInfo: CallStateInfo) => void;
    _onCallEndedNotifyCallback: (callRecordInfo: CallRecordInfo) => void;
    _startCallCallback: (ret: SDKERR, reason: string) => void;
    _inProcessCallbackSet: Set<string>;
    callWithIPC: boolean;
    constructor(addOn: ICall);
    init(): void;
    /**
    * [en] Notify of call state. [cn] 通话状态通知
    */
    setOnCallStateChangedCB(onCallStateChanged: (callStateInfo: CallStateInfo) => void): void;
    /**
    * [en] Notify of the call record when the call ended [cn] 通话结束通知
    */
    setOnCallEndedNotifyCB(onCallEndedNotify: (callRecordInfo: CallRecordInfo) => void): void;
    /**
    * [en] This interface is used to start call. [cn] 发起呼叫
    */
    startCall(startCallInfo: StartCallInfo, onStartCallResult?: (ret: SDKERR, reason: string) => void): void;
}
