import { SDKERR } from './enum';
import { BookConfParam, CancelConfParam, ConfListInfo, EditConfParam, ChangeVmrInfoParam, GetConfDetailParam, CancelCycleConfParam, ModifySubCycleConfParam, CancelSubCycleConfParam, BookCycleConfParam, ConfIncomingInfo, ConfDetail, VmrListInfo, CreateConfResult, ModifyCycleConfParam } from './model';
export declare class IConfMgr {
    addOn: IConfMgr;
    _onConfIncomingNotifyCallback: (confIncomingInfo: ConfIncomingInfo) => void;
    _onConfListChangedCallback: (confListInfo: ConfListInfo) => void;
    _onCreateConfFinishedNotifyCallback: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void;
    _bookConfCallback: (ret: SDKERR, reason: string, confDetail: ConfDetail) => void;
    _cancelConfCallback: (ret: SDKERR, reason: string) => void;
    _editConfCallback: (ret: SDKERR, reason: string) => void;
    _getVmrListCallback: (ret: SDKERR, reason: string, vmrListInfo: VmrListInfo) => void;
    _getConfDetailCallback: (ret: SDKERR, reason: string, confDetail: ConfDetail) => void;
    _changeVmrInfoCallback: (ret: SDKERR, reason: string) => void;
    _getConfListCallback: (ret: SDKERR, reason: string, confListInfo: ConfListInfo) => void;
    _bookCycleConfCallback: (ret: SDKERR, reason: string, confDetail: ConfDetail) => void;
    _modifyCycleConfCallback: (ret: SDKERR, reason: string) => void;
    _modifySubCycleConfCallback: (ret: SDKERR, reason: string) => void;
    _cancelCycleConfCallback: (ret: SDKERR, reason: string) => void;
    _cancelSubCycleConfCallback: (ret: SDKERR, reason: string) => void;
    _inProcessCallbackSet: Set<string>;
    callWithIPC: boolean;
    constructor(addOn: IConfMgr);
    init(): void;
    /**
    * [en] Notify of the conf incoming [cn] 会议来电通知
    */
    setOnConfIncomingNotifyCB(onConfIncomingNotify: (confIncomingInfo: ConfIncomingInfo) => void): void;
    /**
    * [en] Conf list notify. when login/bookconf/cancelconf, will receive this notify [cn] 会议列表通知
    */
    setOnConfListChangedCB(onConfListChanged: (confListInfo: ConfListInfo) => void): void;
    /**
    * [en] Create Conf Finished Notify. when create conf, will receive this notify [cn] 完成创建会议通知
    */
    setOnCreateConfFinishedNotifyCB(onCreateConfFinishedNotify: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void): void;
    /**
    * [en] This interface is book a conference. [cn] 预定会议
    */
    bookConf(bookConfParam: BookConfParam, onBookConfResult?: (ret: SDKERR, reason: string, confDetail: ConfDetail) => void): void;
    /**
    * [en] This interface is used to cancel a conference booked before. [cn] 取消会议
    */
    cancelConf(cancelConfParam: CancelConfParam, onCancelConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to modify a conf booked before. [cn] 编辑会议
    */
    editConf(editConfParam: EditConfParam, onEditConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get vmr list. [cn] 获取VMR列表
    */
    getVmrList(onGetVmrListResult?: (ret: SDKERR, reason: string, vmrListInfo: VmrListInfo) => void): void;
    /**
    * [en] This interface is used to get conf detail. [cn] 获取会议详情
    */
    getConfDetail(getConfDetailParam: GetConfDetailParam, onGetConfDetailResult?: (ret: SDKERR, reason: string, confDetail: ConfDetail) => void): void;
    /**
    * [en] This interface is used to change virtual meeting room information. [cn] 修改云会议室信息
    */
    changeVmrInfo(vmrInfoParam: ChangeVmrInfoParam, onChangeVmrInfoResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en]This interface is used to get conf list [cn]获取会议列表
    */
    getConfList(onGetConfListResult?: (ret: SDKERR, reason: string, confListInfo: ConfListInfo) => void): void;
    /**
    * [en] [cn]预约周期会议
    */
    bookCycleConf(bookCycleConfParam: BookCycleConfParam, onBookCycleConfResult?: (ret: SDKERR, reason: string, confDetail: ConfDetail) => void): void;
    /**
    * [en] [cn]编辑周期会议
    */
    modifyCycleConf(modifyParam: ModifyCycleConfParam, onModifyCycleConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] [cn]编辑周期子会议
    */
    modifySubCycleConf(modifySubCycleConfParam: ModifySubCycleConfParam, onModifySubCycleConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] [cn]取消周期会议
    */
    cancelCycleConf(cancelCycleConfParam: CancelCycleConfParam, onCancelCycleConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] [cn]取消周期子会议
    */
    cancelSubCycleConf(cancelSubCycleConfParam: CancelSubCycleConfParam, onCancelSubCycleConfResult?: (ret: SDKERR, reason: string) => void): void;
}
