import { SDKERR } from './enum';
import { ParticipantItemInfo, ToastInfo, ShowSettingWindowInfo, HwndListInfo, WindowIconInfo, CallAllBtnInfo, InjectBtnInfo, InjectParticipantItemBtnInfo, MainWindowInfo, WaterMarkInfo, AvatarInfo, AvatarStyle, ContactInfo } from './model';
export declare class IUIConfig {
    addOn: IUIConfig;
    _onClickInjectBtnNotifyCallback: (injectBtnInfo: InjectBtnInfo) => void;
    _onClickInjectParticipantItemBtnNotifyCallback: (injectBtnInfo: InjectParticipantItemBtnInfo) => void;
    _onClickInjectCallAllBtnNotifyCallback: (injectBtnInfo: CallAllBtnInfo) => void;
    _onRenderWindowInfoListChangedCallback: (hwndInfo: HwndListInfo) => void;
    _onQueryContactAvatarNotifyCallback: (contactInfo: ContactInfo) => void;
    _onDoubleClickParticipantListItemNotifyCallback: (participantInfo: ParticipantItemInfo) => void;
    _configCallback: (ret: SDKERR, reason: string) => void;
    _setWaterMarkCallback: (ret: SDKERR, reason: string) => void;
    _getRenderWindowInfoListCallback: (ret: SDKERR, reason: string, hwndInfo: HwndListInfo) => void;
    _showMeetingWindowCallback: (ret: SDKERR, reason: string) => void;
    _setAvatarCallback: (ret: SDKERR, reason: string) => void;
    _setMeetingWindowIconCallback: (ret: SDKERR, reason: string) => void;
    _showSettingWindowCallback: (ret: SDKERR, reason: string) => void;
    _showToastCallback: (ret: SDKERR, reason: string) => void;
    _getMainWindowInfoCallback: (ret: SDKERR, reason: string, mainWindowInfo: MainWindowInfo) => void;
    _setAvatarStyleCallback: (ret: SDKERR, reason: string) => void;
    _inProcessCallbackSet: Set<string>;
    callWithIPC: boolean;
    constructor(addOn: IUIConfig);
    init(): void;
    /**
    * [en] Notify of inject btn. [cn] 注入点击通知
    */
    setOnClickInjectBtnNotifyCB(onClickInjectBtnNotify: (injectBtnInfo: InjectBtnInfo) => void): void;
    /**
    * [en] Notify of inject participant item btn. [cn] 与会者列表子项注入点击通知
    */
    setOnClickInjectParticipantItemBtnNotifyCB(onClickInjectParticipantItemBtnNotify: (injectBtnInfo: InjectParticipantItemBtnInfo) => void): void;
    /**
    * [en] Notify of inject Call all btn. [cn] 全部呼叫注入点击通知
    */
    setOnClickInjectCallAllBtnNotifyCB(onClickInjectCallAllBtnNotify: (injectBtnInfo: CallAllBtnInfo) => void): void;
    /**
    * [en] window handle list notify. when window handle changed, will receive this notify [cn] 窗口句柄通知
    */
    setOnRenderWindowInfoListChangedCB(onRenderWindowInfoListChanged: (hwndInfo: HwndListInfo) => void): void;
    /**
    * [en] Notify of query external contact avatar [cn] 查询外部通讯录头像通知
    */
    setOnQueryContactAvatarNotifyCB(onQueryContactAvatarNotify: (contactInfo: ContactInfo) => void): void;
    /**
    * [en] Notify of double click participant list item [cn] 双击与会者项通知
    */
    setOnDoubleClickParticipantListItemNotifyCB(onDoubleClickParticipantListItemNotify: (participantInfo: ParticipantItemInfo) => void): void;
    /**
    * [en] This interface is used to config sdk. [cn] 界面配置
    */
    config(uiConfig: string, onConfigResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set watermark inject information. [cn] 自定义会中水印
    */
    setWaterMark(waterMarkInfo: WaterMarkInfo, onSetWaterMarkResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This method is used to get window handle list. [cn] 获取窗口句柄列表
    */
    getRenderWindowInfoList(onGetRenderWindowInfoListResult?: (ret: SDKERR, reason: string, hwndInfo: HwndListInfo) => void): void;
    /**
    * [en] This interface is used to ShowMeetingWindow. [cn] 显示会议窗口
    */
    showMeetingWindow(onShowMeetingWindowResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set avatar. [cn] 设置头像
    */
    setAvatar(avatarInfo: AvatarInfo, onSetAvatarResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set meeting window icon info. [cn] 自定义会议窗口任务栏图标
    */
    setMeetingWindowIcon(windowIconInfo: WindowIconInfo, onSetMeetingWindowIconResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to show setting window. [cn] 显示设置窗口接口
    */
    showSettingWindow(showInfo: ShowSettingWindowInfo, onShowSettingWindowResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to show toast info. [cn] 显示提示信息
    */
    showToast(toastInfo: ToastInfo, onShowToastResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get main window info. [cn] 获取主窗口信息
    */
    getMainWindowInfo(onGetMainWindowInfoResult?: (ret: SDKERR, reason: string, mainWindowInfo: MainWindowInfo) => void): void;
    /**
    * [en] This interface is used to set avatar style. [cn] 设置头像风格
    */
    setAvatarStyle(avatarStyle: AvatarStyle, onSetAvatarStyleResult?: (ret: SDKERR, reason: string) => void): void;
}
