//
//  HWMContactApiHandler.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/11/6.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMEnterpriseContact.h"
#import "HWMConfQueryContactModel.h"

NS_ASSUME_NONNULL_BEGIN

/// 注意⚠️：三个协议方法，如果都实现，只会生效一个，通过contactModel查询>number查询>account查询
@protocol HWMContactApiHandler <NSObject>
@optional

/// 通过contactModel查询联系人
/// @param contactModels contactModel 集合
/// @param completionBlock 结果回调  若NSArray中有值 error不要返回错误
/// 需要将查询到的结果（userInfos）回传给sdk
- (void)queryUserDetailByContactModels:(NSArray<HWMConfQueryContactModel *> *)contactModels
                       completionBlock:(void (^)(NSError *_Nullable error, NSArray<HWMEnterpriseContact *> *_Nullable userInfos))completionBlock;

/// 通过number（sip号）查询联系人
/// @param numbers number 集合
/// @param completionBlock 结果回调  若NSArray中有值 error不要返回错误
/// 需要将查询到的结果（userInfos）回传给sdk
- (void)queryUserDetailByNumbers:(NSArray<NSString *> *)numbers
                      completionBlock:(void (^)(NSError *_Nullable error, NSArray<HWMEnterpriseContact *> *_Nullable userInfos))completionBlock;

/// 通过三方账号查询联系人(批量查询)
/// @param accounts 账号集合
/// @param completionBlock 结果回调  若NSArray中有值 error不要返回错误
/// 需要将查询到的结果（userInfos）回传给sdk
- (void)queryUserDetailByAccounts:(NSArray<NSString *> *)accounts
                      completionBlock:(void (^)(NSError *_Nullable error, NSArray<HWMEnterpriseContact *> *_Nullable userInfos))completionBlock;

@end

NS_ASSUME_NONNULL_END
