//
//  HWMP2PConfRecordInfoModel.h
//  HWMUISDK
//
//  Created by linweiqiang on 2023/9/22.
//

#import "HWMUISDKCommonDefine.h"
#import "HWMUISDKCallMemberInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMP2PConfRecordInfoModel : NSObject

/// 主叫方信息
@property (nonatomic, strong) HWMUISDKCallMemberInfoModel *callerInfo;
/// 被叫方信息
@property (nonatomic, strong) HWMUISDKCallMemberInfoModel *calleeInfo;
/// 呼叫开始时间
@property (nonatomic, assign) NSInteger startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");
/// 呼叫结束时间
@property (nonatomic, assign) NSInteger endTime DEPRECATED_MSG_ATTRIBUTE("Use 'endTimeStamp' instead");
/// 呼叫开始时间戳，精度秒
@property (nonatomic, assign) NSInteger startTimeStamp;
/// 呼叫结束时间戳，精度秒
@property (nonatomic, assign) NSInteger endTimeStamp;
/// 媒体类型
@property (nonatomic, assign) HWMUISDKMediaType mediaType;
/// 是否为主动呼出
@property (nonatomic, assign) BOOL isCallOut;
/// 呼叫是否建立
@property (nonatomic, assign) BOOL isCallEstablished;
/// 呼叫结束原因
@property (nonatomic, assign) HWMUISDKSDKERR resultCode;
/// 呼叫结束描述
@property (nonatomic, assign) NSString *resultMsg;

@end

NS_ASSUME_NONNULL_END
