//
//  HWMSDKE2eeAdapater.h
//  HWMNativeSDK
//
//  Created by guomeng on 2022/3/10.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol HWME2EENotifyHandler <NSObject>

@optional
/// [en] [cn]端到端加解密之音频加密回调
- (NSData *)onE2EEAudioEncryptNotify:(NSData *)buffer;
/// [en] [cn]端到端加解密之音频解密回调
- (NSData *)onE2EEAudioDecryptNotify:(NSData *)buffer;
/// [en] [cn]端到端加解密之视频加密回调
- (NSData *)onE2EEVideoEncryptNotify:(NSData *)buffer;
/// [en] [cn]端到端加解密之视频解密回调
- (NSData *)onE2EEVideoDecryptNotify:(NSData *)buffer;

@end


@interface HWMSDKE2eeAdapater : NSObject

+ (instancetype)shareInstance;

- (void)addE2EENotifyCallback:(id<HWME2EENotifyHandler>)callback;
- (void)removeE2EENotifyCallback:(id<HWME2EENotifyHandler>)callback;

@end

NS_ASSUME_NONNULL_END

