//
//  HWMSDKPrivateUtilsService.h
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMSDKCommonDefine.h"
#import "HWMSDKAllModelIndex.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^HWMSDKNetDetectSuccessBlock) (void);
typedef void(^HWMSDKNetDetectFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKGetProxySuccessBlock) (HWMSDKProxyInfoModel * proxyInfo);
typedef void(^HWMSDKGetProxyFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKNetworkChangeSuccessBlock) (HWMSDKProxyInfoModel * proxyInfo);
typedef void(^HWMSDKNetworkChangeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKUploadAuditFileSuccessBlock) (HWMSDKUploadAuditFileResultModel * fileResult);
typedef void(^HWMSDKUploadAuditFileFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKReportAuditTaskSuccessBlock) (HWMSDKReportAuditTaskInfoModel * taskInfo);
typedef void(^HWMSDKReportAuditTaskFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryAuditTaskSuccessBlock) (HWMSDKAuditTaskResultListModel * taskResultList);
typedef void(^HWMSDKQueryAuditTaskFailedBlock) (NSError * _Nullable error);


@protocol HWMSDKPrivateUtilsNotify <NSObject>

@optional
- (void)onNetDetectInfoNotify:(HWMSDKUtilsNetDetectResultModel *)utilsNetDetectResult;

@end

@interface HWMSDKPrivateUtilsService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addPrivateUtilsNotifyCallback:(id<HWMSDKPrivateUtilsNotify>)callback;
- (void)removePrivateUtilsNotifyCallback:(id<HWMSDKPrivateUtilsNotify>)callback;
- (void)configCustomParam:(HWMSDKUtilsCustomParamModel *)param;

/// :disable
- (void)configPublicParam:(HWMSDKUtilsPublicParamModel *)param;

/// :disable
- (HWMSDKERR)addUserTrackWithParam:(HWMSDKUtilSpecialParamModel *)param;

/// :disable
- (HWMSDKERR)addMediaTrackWithParam:(HWMSDKUtilSpecialParamModel *)param;

/// [en]This class is about media track. [cn]会议组件打点接口
- (HWMSDKERR)addConfMediaTrackWithEventId:(NSUInteger)eventId trackInfo:(NSString *)trackInfo;

/// :disable
- (HWMSDKERR)startEventWithEventName:(NSString *)eventName;

/// :disable
- (HWMSDKERR)finishEventWithEventName:(NSString *)eventName param:(HWMSDKUtilSpecialParamModel *)param;

- (HWMSDKERR)uploadData;

/// :disable
- (void)setCpuAndMemoryParam:(HWMSDKUtilsCpuAndMemoryParamModel *)param;

/// :disable
- (HWMSDKERR)setUserInfoWithProxyInfo:(HWMSDKProxyInfoModel *)proxyInfo strServerUrl:(NSString *)strServerUrl;

- (void)getProxyWithSuccessCallback:(HWMSDKGetProxySuccessBlock)successCallback failedCallback:(HWMSDKGetProxyFailedBlock)failedCallback;

- (void)networkChangeWithLocalIp:(NSString *)localIp successCallback:(HWMSDKNetworkChangeSuccessBlock)successCallback failedCallback:(HWMSDKNetworkChangeFailedBlock)failedCallback;

/// [en]This class is about getting device guid. [cn]获取设备guid
- (HWMSDKUtilsDeviceGuidModel *)getDeviceGuid;

/// [en]This interface is used to get device active infomation. [cn]获取设备激活信息----废弃掉 :disable
- (HWMSDKUtilsBoardActiveInfosModel *)getDeviceActiveInfoWithPhoneNum:(NSString *)phoneNum code:(NSString *)code;

/// [en]This interface is used to get register infomation. [cn]获取注册信息----废弃掉 :disable
- (HWMSDKUtilsRegInfosModel *)getRegInfo;

- (HWMSDKERR)httpSetProxyWithProxyInfo:(HWMSDKProxyInfoModel *)proxyInfo;

- (HWMSDKERR)httpProxyConnectWithFd:(NSUInteger)fd addr:(NSString *)addr port:(NSUInteger)port;

- (HWMSDKERR)setNetDetectSrvsWithUtilsNetDetectSrvs:(HWMSDKUtilsNetDetectSrvsModel *)utilsNetDetectSrvs;

/// :disable
- (HWMSDKERR)setLocalIp:(NSString *)localIp localGwIp:(NSString *)localGwIp;

/// [en] [cn]网络探测
- (void)netDetectWithSnNum:(NSUInteger)snNum successCallback:(HWMSDKNetDetectSuccessBlock)successCallback failedCallback:(HWMSDKNetDetectFailedBlock)failedCallback;

/// [en]This interface is used to query config cache data by key. [cn]根据键值查询配置数据
- (NSArray <HWMSDKUtilsConfigCacheModel *> *)queryConfigCacheWithKey:(NSString *)key retLen:(NSInteger)retLen;

/// [en]This interface is used to single add config cache data. [cn]单个存配置数据 :disable
- (HWMSDKERR)singleAddConfigCacheWithData:(HWMSDKUtilsConfigCacheModel *)data;

/// [en]This interface is used to upload audit file [cn]上传风控文件
- (void)uploadAuditFileWithFileInfo:(HWMSDKUploadAuditFileInfoModel *)fileInfo successCallback:(HWMSDKUploadAuditFileSuccessBlock)successCallback failedCallback:(HWMSDKUploadAuditFileFailedBlock)failedCallback;

/// [en]This interface is used to report audit task [cn]上报风控审核任务
- (void)reportAuditTaskWithTaskInfo:(HWMSDKReportAuditTaskInfoModel *)taskInfo successCallback:(HWMSDKReportAuditTaskSuccessBlock)successCallback failedCallback:(HWMSDKReportAuditTaskFailedBlock)failedCallback;

/// [en]This interface is used to query audit result [cn]查询风控任务结果
- (void)queryAuditTaskWithTaskInfoList:(NSArray <HWMSDKReportAuditTaskInfoModel *> *)taskInfoList successCallback:(HWMSDKQueryAuditTaskSuccessBlock)successCallback failedCallback:(HWMSDKQueryAuditTaskFailedBlock)failedCallback;

- (void)cleanGetProxyCallbacks;
- (void)cleanNetDetectCallbacks;
- (void)cleanUploadAuditFileCallbacks;
- (void)cleanReportAuditTaskCallbacks;
- (void)cleanQueryAuditTaskCallbacks;
@end



NS_ASSUME_NONNULL_END

