//
//  HWMHeadPortraitApiHandler.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/11/6.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMUISDKContactInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMHeadPortraitApiHandler <NSObject>

@optional
/// 根据用户唯一标识去获取头像图片
/// @param thirdAccount appid登录场景下优先使用此字段
/// @param account 账号 密码登录场景下 优先使用此字段
/// @param number 号码  跨企业场景优先使用此字段
/// @param completionBlock 结果回调
- (void)downloadHeadPortraitWithThirdAccount:(NSString *)thirdAccount
                                     account:(NSString *)account
                                      number:(nonnull NSString *)number
                             completionBlock:(void(^)(NSError * _Nullable error, NSString * _Nullable headImagePath))completionBlock;

/// 根据联系人信息获取头像
/// @param contactInfo 联系人信息
/// @param completionBlock 结果回调
- (void)queryContactAvatarWithContactInfo:(HWMUISDKContactInfoModel *)contactInfo
                          completionBlock:(void (^)(NSError *_Nullable error, NSString *_Nullable headImagePath))completionBlock;

@end

NS_ASSUME_NONNULL_END
