﻿/**
 * @file HwmUISdkConfigServiceDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_UISDK_CONFIG_SERVICE_DEF_H_
#define _HWM_UISDK_CONFIG_SERVICE_DEF_H_

#include "HwmUISdkCommonDef.h"
#include "HwmBaseMacroDef.h"

BEGIN_HWM_UISDK_NAMESPACE

/**
* [en]Language info
* [cn]语言信息
*/
typedef struct tagHwmLanguageInfo
{
    HwmLanguage type;                               /**< [en]Language type
                                                         [cn]语言类型
                                                         [cs_allowNull:N] */
    HWM_CHAR languageCode[HWM_MAX_LOCATION_LEN];    /**< [en]Customized language location-name.
                                                         [cn]自定义语言区域名
                                                         [cs_allowNull:Y] */

} HwmLanguageInfo;

/**
* [en]Capability type.
* [cn]功能类型
*/
typedef enum tagHwmCapabilityType
{
    HWM_CAPABILITY_TYPE_SHOW_HANGUP_ATTENDEE,     /**< [en]Show hangup attendee switch(only for windows)
                                                       [cn]显示离会与会者开关(仅对win平台生效) */
    HWM_CAPABILITY_TYPE_HIDE_EXTERNAL_LABEL,      /**< [en]Hide external label
                                                       [cn]隐藏外部标签 */
    HWM_CAPABILITY_TYPE_RESOLUTION_1080P,         /**< [en]1080P resolution switch(only for windows)
                                                       [cn]1080P开关(仅对win平台生效)
                                                       [mac:disable] */
    HWM_CAPABILITY_TYPE_RESOLUTION_720P,          /**< [en]720p resolution switch(only for mac)
                                                       [cn]720p开关(仅对mac平台生效)
                                                       [win:disable] */
    HWM_CAPABILITY_TYPE_MULTI_MONITOR,            /**< [en]Multi-monitor switch(only for windows)
                                                       [cn]多显示器模式开关(仅对win平台生效)
                                                       [mac:disable] */
    HWM_CAPABILITY_TYPE_HOWLING_DETECTION,        /**< [en]Howling detection switch(only for windows)
                                                       [cn]啸叫检测开关(仅对win平台生效)
                                                       [mac:disable] */
    HWM_CAPABILITY_AUTO_MIC_VOLUME,               /**< [en]Automatic microphone volume adjustment switch(only for windows)
                                                       [cn]自动调节麦克风音量开关(仅对win平台生效)
                                                       [mac:disable] */
    HWM_CAPABILITY_SHARE_AUDIO,                   /**< [en]Share audio switch
                                                       [cn]共享音频开关 */
    HWM_CAPABILITY_HIDE_NO_CAMERA_VIEW,           /**< [en]hide no Camera view(only for mac)
                                                       [cn]隐藏非视频与会者开关(仅对mac平台生效)
                                                       [win:disable] */
    HWM_CAPABILITY_BREAKOUT_CONF,                 /**< [en]Breakout conf switch
                                                       [cn]分组讨论开关 */
    HWM_CAPABILITY_CONFIRM_RECORD,                /**< [en]recording confirm
                                                       [cn]录制确认 */
    HWM_CAPABILITY_VOICEPRINT_NOISE_REDUCE,       /**< [en]Voiceprint noise reduce
                                                       [cn]声纹降噪(仅对win平台生效)
                                                       [mac:disable]
                                                       [doc:disable] */
    HWM_CAPABILITY_SUPPORT_DISCONNECT_AUDIO,      /**< [en]Support Disconnect audio
                                                       [cn]支持断开音频功能(仅对win平台生效)
                                                       [mac:disable] */
    HWM_CAPABILITY_DISCONNECT_AUDIO_TO_JOIN_CONF, /**< [en]Disconnect audio to join conf
                                                       [cn]是否断开音频入会(仅对win平台生效)
                                                       [mac:disable] */
    HWM_CAPABILITY_CPU_REDUCTION_DETECT,          /**< [en]CPU frequency reduction detection
                                                       [cn]是否启用CPU降频检测
                                                       [mac:disable] */
    HWM_CAPABILITY_WITHOUT_MAIN_FRAME,            /**< [en]Config without main frame
                                                       [cn]配置无主界面
                                                       [doc:disable] */
    HWM_CAPABILITY_SUPPORT_GUEST_INVITE,          /**< [en]Is support guest invite.
                                                       [cn]是否支持与会者邀请 */
    HWM_CAPABILITY_HIDE_INVITE_RESULT_TOAST,      /**< [en]Hide invite result toast.
                                                       [cn]是否隐藏与会者邀请结果提示 */
    HWM_CAPABILITY_SUPPORT_AUTO_ACCEPT_REMOTE_CONTROL,          /**< [en]Is support auto accept remote control.
                                                                     [cn]是否支持自动接受远程控制(仅对win平台生效) */
    HWM_CAPABILITY_SUPPORT_HIDE_OFFLINE_PARTICIPANT_LIST,       /**< [en]Is support hide the unjoined conference tab in the participant list.
                                                                     [cn]是否支持隐藏与会者列表未入会标签 */
    HWM_CAPABILITY_HIDE_VB_RISK_TIP,              /**< [en]Hide virtual background risk tip.
                                                       [cn]是否隐藏虚拟背景隐私风险提示 */
    HWM_CAPABILITY_CONF_END_SHOW_TIPS,            /**< [en]Is conf end show tips
                                                       [cn]是否会议结束显示提示 */
    HWM_CAPABILITY_TYPE_BUTT
} HwmCapabilityType;

/**
* [en]Capability info.
* [cn]功能配置信息
*/
typedef struct tagHwmCapabilityInfo
{
    HwmCapabilityType type;                   /**< [en]Capability type
                                                   [cn]功能类型
                                                   [cs_allowNull:N] */
    HWM_BOOL isEnable;                        /**< [en]Enable state
                                                   [cn]开启状态
                                                   [cs_allowNull:N] */
} HwmCapabilityInfo;

/**
* [en]Save path type
* [cn]用户文件保存路径枚举
*/
typedef enum tagHwmSavePathType
{
    HWM_SAVE_PATH_LOCAL_RECORD,                 /**< [en]record save path
                                                     [cn]本地录制文件保存路径 */

    HWM_SAVE_PATH_TYPE_BUTT

} HwmSavePathType;

/**
* [en]User save path info.
* [cn]设置用户保存路径信息
*/
typedef struct tagHwmUserSavePathInfo
{
    HwmSavePathType pathType;                   /**< [en]save path type
                                                     [cn]保存路径类型
                                                     [cs_allowNull:N] */
    HWM_CHAR path[HWM_MAX_FILE_PATH_LEN];       /**< [en]save path
                                                     [cn]保存路径，注：绝对路径，需要UTF8编码
                                                     [cs_allowNull:N] */
}HwmUserSavePathInfo;

/**
* [en]share strategy type
* [cn]屏幕共享策略类型
*/
typedef enum tagHwmShareStrategyType
{
    HWM_SHARE_STRATEGY_DEFINITION_FIRST,                 /**< [en]definition first
                                                              [cn]清晰度优先 */
    HWM_SHARE_STRATEGY_FLUENCY_FIRST,                    /**< [en]fluency first
                                                              [cn]流畅度优先 */
    HWM_SHARE_STRATEGY_DEFINITION_AND_FLUENCY,           /**< [en]definition and fluency
                                                              [cn]清晰且流畅模式，注：有带宽压力，三方自行保证
                                                              [doc:disable] */
    HWM_SHARE_STRATEGY_TYPE_BUTT
} HwmShareStrategyType;

/**
* [en]Share strategy info.
* [cn]屏幕共享策略信息
*/
typedef struct tagHwmShareStrategyInfo
{
    HwmShareStrategyType shareStrategyType;         /**< [en]share strategy type
                                                         [cn]屏幕共享策略类型
                                                         [cs_allowNull:N] */
}HwmShareStrategyInfo;

/**
* [en]AudioRawData config info.
* [cn]音频码流配置信息
*/
typedef struct tagHwmAudioRawDataConfigInfo
{
    HWM_BOOL isOpen;                    /**< [en]is open
                                             [cn]是否开启
                                             [cs_allowNull:N] */
}HwmAudioRawDataConfigInfo;

/**
* [en]Incoming answer type
* [cn]来电应答类型
*/
typedef enum tagHwmIncomingAnswerType
{
    HWM_INCOMING_ANSWER_NORMAL,                           /**< [en]incoming answer normal
                                                               [cn]默认，来电时弹出来电接听界面 */
    HWM_INCOMING_ANSWER_DECLINE,                          /**< [en]incoming answer decline
                                                               [cn]来电时拒接 */
    HWM_INCOMING_ANSWER_ANSWER,                           /**< [en]incoming answer answer
                                                               [cn]来电时接听 */
    HWM_INCOMING_ANSWER_CUSTOM,                           /**< [en]incoming answer custom
                                                               [cn]来电时自定义弹框 */

    HWM_INCOMING_ANSWER_TYPE_BUTT

} HwmInComingAnswerType;

/**
* [en]Incoming answer type info
* [cn]来电应答类型信息
*/
typedef struct tagHwmInComingAnswerTypeInfo
{
    HwmInComingAnswerType type;                           /**< [en]incoming answer type
                                                               [cn]来电应答类型
                                                               [cs_allowNull:N] */
} HwmInComingAnswerTypeInfo;

/**
* [en]Device config info
* [cn]设备配置信息
*/
typedef struct tagHwmDeviceConfig
{
    HWM_BOOL isMicOn;                                       /**< [en]Is mic on
                                                                 [cn]是否开启麦克风
                                                                 [cs_allowNull:Y] */
    HWM_BOOL isCameraOn;                                    /**< [en]Is camera on
                                                                 [cn]是否开启摄像头
                                                                 [cs_allowNull:Y] */
}HwmDeviceConfig;

/**
* [en]Pstn access number info.
* [cn]会议pstn接入号码信息
*/
typedef struct tagHwmPstnAccessNumberInfo
{
    HWM_CHAR pstnAccessNumber[HWM_MAX_NUMBER_LEN];              /**< [en]Pstn access number
                                                                     [cn]会议pstn接入号码 */
}HwmPstnAccessNumberInfo;

/**
* [en]Device state info.
* [cn]设备状态类型
*/
typedef struct tagHwmDeviceStateInfo
{
    HwmDeviceType deviceType;                   /**< [en]Device type
                                                     [cn]设备类型
                                                     [cs_allowNull:N] */
    HWM_BOOL isOpen;                            /**< [en]is open
                                                     [cn]是否开启
                                                     [cs_allowNull:N] */
}HwmDeviceStateInfo;

/**
* [en]16-bit precision PCM.
* [cn]16位精度PCM
*/
typedef enum tagHwmAudioFrameType {
    HWM_AUDIO_FRAME_TYPE_PCM16              /**< [en]PCM16 frame type.
                                                 [cn]PCM16音频帧类型 */
} HwmAudioFrameType;

/**
* [en]Report audio stream frame data.
* [cn]上报音频码流帧数据
*/
typedef struct tagHwmAudioFrameData
{
    HwmAudioFrameType eFrameType;      /**< [en]Indicates frameType.
                                            [cn]音频帧类型 */
    HWM_INT32 iSamples;                /**< [en]Indicates samples.
                                            [cn]每个声道的采样点数,iSamples=iSamplesPerSec × 10ms / 1000 */
    HWM_INT32 iSamplesPerSec;          /**< [en]Indicates samplesPerSec.
                                            [cn]采样率 */
    HWM_INT32 iBytesPerSample;         /**< [en]Indicates bytesPerSample.
                                            [cn]每个采样点的字节数,pcm数据一般16bit */
    HWM_INT32 iChannels;               /**< [en]Indicates channels.
                                            [cn]声道数 */
    HWM_INT32 uiBufferLen;             /**< [en]Indicates pBuffer length.
                                            [cn]缓冲区长度，编码后数据进行第三方加密，数据长度会变大，防止溢出
                                            [length for pBuffer] */
    HWM_CHAR  *pBuffer;                /**< [en]Indicates buffer.
                                            [cn]数据缓冲区,长度=iSamples × iBytesPerSample × iChannels
                                            [trans:Uint8Array] */
    HWM_INT32 uiDataLen;               /**< [en]Indicates data length.
                                            [cn]编码后或解码前使用该字段表示数据长度，加解密处理后需更新此字段值 */

} HwmAudioFrameData;

/**
* [en]WaterMark font color.
* [cn]水印字体颜色
*/
typedef enum tagHwmWaterMarkColorType
{
    HWM_WATERMARK_COLOR_TYPE_LIGHT = 0,         /**< [en]light color
                                                     [cn]浅色 #CCCCCC*/
    HWM_WATERMARK_COLOR_TYPE_STANDARD,          /**< [en]standard color
                                                     [cn]标准色 #999999*/
    HWM_WATERMARK_COLOR_TYPE_DARKER,            /**< [en]dark color
                                                     [cn]深色 #666666*/
}HwmWaterMarkColorType;

/**
* [en]WaterMark info
* [cn]水印信息
*/
typedef struct tagHwmWaterMarkInfo
{
    HWM_CHAR content[HWM_MAX_WATERMARK_CONTENT_LEN]; /**< [en]WaterMark content
                                                          [cn]用户自定义水印注入内容
                                                          [cs_allowNull:Y] */
    HwmWaterMarkColorType color;                     /**< [en]WaterMark font color
                                                          [cn]水印字体颜色，0-浅色，1-标准色，2-深色
                                                          [cs_allowNull:Y] */
} HwmWaterMarkInfo;

/**
* [en]Contact info
* [cn]联系人信息
*/
typedef struct tagHwmContactInfo
{
    HWM_CHAR accountId[MAX_ACCOUNT_ID_LEN];                 /**< [en]Indicates account id.
                                                                 [cn]账号，账号密码登录场景下优先使用此字段 */
    HWM_CHAR thirdUserId[HWM_MAX_USER_ID_LEN];              /**< [en]The attendee's third account
                                                                 [cn]与会者三方账号，appid登录场景下优先使用此字段 */
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                    /**< [en]number
                                                                 [cn]号码，跨企业场景下优先使用此字段 */
    HWM_CHAR userUuid[HWM_MAX_DEVICE_UUID_LEN];             /**< [en]Indicates UUID(only for win).
                                                                 [cn]UUID(由系统分配的真实的唯一用户标识)(仅在win平台下有效) */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];     /**< [en]Indicates extended field.
                                                                 [cn]扩展字段
                                                                 [doc:disable] */
    HWM_CHAR realNameAccount[HWM_MAX_NAME_LEN];             /**< [en]Indicates real name account.
                                                                 [cn]真实账号或名字
                                                                 [doc:disable] */
    HWM_CHAR corpId[HWM_MAX_ORG_ID_LENGTH];                 /**< [en]Indicates corp id.
                                                                 [cn]企业id */
}HwmContactInfo;

/**
* [en]Avatar info
* [cn]头像信息
*/
typedef struct tagHwmAvatarInfo
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];                    /**< [en]number（number和thirdUserId二选一）
                                                                 [cn]号码参数
                                                                 [cs_allowNull:Y] */
    HWM_CHAR thirdUserId[HWM_MAX_USER_ID_LEN];              /**< [en]The third user id
                                                                 [cn]三方账号（number和thirdUserId二选一）
                                                                 [cs_allowNull:Y] */
    HWM_CHAR avatarPath[HWM_MAX_FILE_PATH_LEN];             /**< [en]avatar path
                                                                 [cn]头像路径
                                                                 [cs_allowNull:N] */
}HwmAvatarInfo;

/**
* [en]Window icon info
* [cn]窗口图标信息
*/
typedef struct tagHwmWindowIconInfo
{
    HWM_CHAR iconPath[HWM_MAX_FILE_PATH_LEN];             /**< [en]icon path
                                                               [cn]图标路径
                                                               [cs_allowNull:N] */
}HwmWindowIconInfo;

/**
* [en]Window handle type
* [cn]窗口句柄的类型
*/
typedef enum tagHwmHwndType
{
    VIDEO_WND_TYPE,			      /**< [en]The handle type of window is video.
                                       [cn]窗口句柄的类型为视频 */
    SCREEN_ID,                    /**< [en]The handle type of window is screen's ID.
                                       [cn]窗口句柄的类型为屏幕ID */
    SHARE_RENDER,			      /**< [en]The handle type of window is share render.
                                       [cn]窗口句柄的类型为共享渲染类型 */
    HWND_BUTT_TYPE
} HwmHwndType;

/**
* [en]Window handle type
* [cn]窗口句柄的类型
*/
typedef enum tagHwmHandleType
{
    HWM_HANDLE_VIEW,			      /**< [en]The handle type is view.
                                           [cn]窗口句柄的类型为view */
    HWM_HANDLE_WINDOW,                /**< [en]The handle type is windowID.
                                           [cn]窗口句柄的类型为屏幕ID */
} HwmHandleType;

/**
* [en]Window view type
* [cn]窗口视图的类型
*/
typedef enum tagHwmViewType
{
    HWM_VIEW_Video,             		/**< [en]The view type is video, the handle type is view.
                                             [cn]视图的类型为视频 句柄类型为view */
    HWM_VIEW_SHARE_WHITE_BOARD,         /**< [en]The view type is shared whiteboard, the handle type is view.
                                             [cn]视图的类型为共享白板 句柄类型为view */
    HWM_VIEW_SHARE_SCREEN_RECV,         /**< [en]The view type is screen share recv, the handle type is view.
                                             [cn]视图的类型为共享屏幕接收 句柄类型为view */
    HWM_VIEW_SHARE_SCREEN_SEND,         /**< [en]The view type is screen share send, the handle type is windowID.
                                             [cn]视图的类型为共享屏幕发送 句柄类型为windowID */
} HwmViewType;

/**
* [en]Window handle info
* [cn]窗口句柄信息
*/
typedef struct tagHwndInfo
{
    HWM_HWND renderHandle;	            /**< [en]The render window handle.when hwndType is SCREEN_ID，the renderHandle Indicate screen id.
                                             [cn]渲染视图的窗口句柄.当hwndType为SCREEN_ID，renderHandle代表屏幕的ID 其中值大于1*/
    HwmHwndType hwndType;		        /**< [en]The window handle type(only for win).
                                             [cn]窗口句柄的类型(仅在win平台下有效)
                                             [mac:disable] */
    HWM_BOOL isBigView;                 /**< [en]Large video window for the speaker
                                             [cn]是否演讲者大视频窗口
                                             [mac:disable] */
    HwmViewType viewType;               /**< [en]The view type(only for mac).
                                             [cn]视图的类型(仅在mac平台下有效)
                                             [win:disbale] */ 
    HwmHandleType handleType;           /**< [en]The handle type(only for mac).
                                             [cn]句柄的类型(仅在mac平台下有效)
                                             [win:disbale] */
} HwndInfo;

/**
* [en]Window handle list info
* [cn]窗口句柄列表信息
*/
typedef struct tagHwmHwndListInfo
{
    HwndInfo hwndInfoList[HWM_MAX_HWND_INFO_LIST_LEN];        /**< [en]Indicates video window handle list
                                                                   [cn]视频窗口句柄列表   */
    HWM_INT32 hwndListLength;         	                      /**< [en]Indicates video window handle list's length
                                                                   [cn]窗口句柄列表的实际长度
                                                                   [length for hwndInfoList] */
} HwmHwndListInfo;

/**
* [en]Click inject button type.
* [cn]点击注入按钮类型
*/
typedef enum tagHwmClickInjectBtn
{
    HWM_CLICK_INJECT_BTN_INVITE,                          /**< [en]Invite button
                                                               [cn]邀请按钮 */
    HWM_CLICK_INJECT_BTN_ATTENDEE,                        /**< [en]Show attendees button
                                                               [cn]与会者按钮 */
    HWM_CLICK_INJECT_BTN_CHAT,                            /**< [en]Show chat button
                                                               [cn]聊天按钮 */
    HWM_CLICK_INJECT_BTN_SHARE,                           /**< [en]Share button
                                                               [cn]共享按钮 */
    HWM_CLICK_INJECT_BTN_LEAVE,                           /**< [en]Leave conf button
                                                               [cn]离开会议按钮 */
    HWM_CLICK_INJECT_BTN_CUSTOM,                          /**< [en]User Custome button
                                                               [cn]用户自定义按钮 */
    HWM_CLICK_INJECT_BTN_GUEST_INVITE,                    /**< [en]Guest Invite button
                                                               [cn]来宾邀请按钮 */
    HWM_CLICK_INJECT_BTN_FEEDBACK,                        /**< [en]Feedback button
                                                               [cn]反馈按钮 */
    HWM_CLICK_INJECT_BTN_COPY_CONF_INFO,                  /**< [en]Copy conf info button
                                                               [cn]复制会议信息按钮 */
    HWM_CLICK_INJECT_BTN_COPY_AUDIENCE_CONF_INFO,         /**< [en]Copy Audience conf info button
                                                               [cn]复制观众会议信息按钮 */
    HWM_CLICK_INJECT_BTN_CALL_ALL,                        /**< [en]"Call All" Button at participant list
                                                               [cn]与会者列表“全部呼叫”按钮 */

    HWM_CLICK_INJECT_BTN_BUTT
} HwmClickInjectBtn;

/**
* [en]Click inject participant item button type.
* [cn]点击注入与会者列表子项按钮类型
*/
typedef enum tagHwmClickInjectParticipantItemBtn
{
    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_CALL_OTHER_NUM,                  /**< [en]Call other number button
                                                                                [cn]呼叫其他号码按钮 */
    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_PARTICIPANT_DETAIL,              /**< [en]Participant detail button
                                                                                [cn]查看与会者详情 */
    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_RECALL,                          /**< [en]Recall button
                                                                                [cn]重新呼叫按钮 */

    HWM_CLICK_INJECT_PARTICIPANT_ITEM_BTN_BUTT
} HwmClickInjectParticipantItemBtn;

/**
* [en]participant item info.
* [cn]与会者列表子项信息
*/
typedef struct tagHwmParticipantItemInfo
{
    HWM_CHAR number[HWM_MAX_NUMBER_LEN];            /**< [en]Number
                                                         [cn]号码 */
    HWM_CHAR nickName[HWM_MAX_DISPLAY_NAME_LEN];    /**< [en]Nickname
                                                         [cn]与会者昵称 */
    HWM_CHAR thirdUserId[HWM_MAX_USER_ID_LEN];      /**< [en]The attendee's third account
                                                         [cn]与会者三方账号，appId登录时使用 */
    HWM_CHAR accountId[MAX_ACCOUNT_ID_LEN];         /**< [en]Indicates account id
                                                         [cn]华为云会议账号 */
    HWM_CHAR extendedField[HWM_MAX_EXTENDED_FIELD_LEN];  /**< [en]Indicates extended field.
                                                              [cn]扩展字段
                                                              [doc:disable] */
    HWM_CHAR corpId[HWM_MAX_ORG_ID_LENGTH];         /**< [en]Indicates corp id.
                                                         [cn]企业id */
} HwmParticipantItemInfo;

/**
* [en]Btn pos info.
* [cn]按钮位置信息
*/
typedef struct tagHwmBtnPosInfo
{
    HWM_INT32 left;                                 /**< [en]The left coordinates
                                                    [cn]左侧坐标 */
    HWM_INT32 top;                                  /**< [en]The top coordinates
                                                    [cn]上侧坐标 */
    HWM_UINT32 width;                               /**< [en]The width
                                                    [cn]宽度 */
    HWM_UINT32 height;                              /**< [en]The height
                                                    [cn]高度 */
}HwmBtnPosInfo;

/**
* [en]Inject btn info.
* [cn]注入按钮点击通知信息
*/
typedef struct tagHwmInjectBtnInfo
{
    HwmClickInjectBtn injectBtn;                    /**< [en]Button type
                                                         [cn]按钮类型 */
    HWM_CHAR btnId[HWM_MAX_BTN_ID_LEN];             /**< [en]Buttton id
                                                         [cn]按钮id */
    HwmBtnPosInfo posInfo;                          /**< [en]Buttton pos info
                                                         [cn]按钮位置信息，仅点击自定义按钮时有效(仅对win平台生效) */
} HwmInjectBtnInfo;

/**
* [en]Participant item inject btn info.
* [cn]与会者子项注入按钮点击通知信息
*/
typedef struct tagHwmInjectParticipantItemBtnInfo
{
    HwmClickInjectParticipantItemBtn injectBtn;      /**< [en]Button type
                                                          [cn]按钮类型 */
    HwmParticipantItemInfo participantInfo;          /**< [en]Participant info
                                                          [cn]与会者子项信息 */
    HWM_CHAR btnId[HWM_MAX_BTN_ID_LEN];              /**< [en]Buttton id
                                                          [cn]按钮id */
    HwmBtnPosInfo posInfo;                           /**< [en]Buttton pos info
                                                          [cn]按钮位置信息(仅对win平台生效) */
} HwmInjectParticipantItemBtnInfo;

/**
* [en]Call all item inject btn info.
* [cn]全部呼叫注入按钮点击通知信息
*/
typedef struct tagHwmCallAllBtnInfo
{
    HwmClickInjectBtn injectBtn;                    /**< [en]Button type
                                                         [cn]按钮类型 */
    HwmParticipantItemInfo *participants;           /**< [en]Participants to call
                                                         [cn]被呼叫的与会者信息 */
    HWM_UINT32 count;                               /**< [en]size of 'participants'
                                                         [length for participants]
                                                         [cn]participants 字段中与会者数量*/
} HwmCallAllBtnInfo;

/**
* [en]Device ctrl info.
* [cn]设备操作信息
*/
typedef struct tagHwmDeviceCtrlInfo
{
    HwmDeviceType deviceType;                     /**<  [en]Device type
                                                        [cn]设备类型 */
} HwmDeviceCtrlInfo;


/**
* [en] Setting page
* [cn] 设置界面页签
*/
typedef enum tagHwmSettingPage
{
    SETTING_PAGE_NORMAL,                        /**< [en]Normal setting page.
                                                [cn]基本设置页 */
    SETTING_PAGE_VIDEO,                         /**< [en]Video setting page.
                                                [cn]视频设置页 */
    SETTING_PAGE_AUDIO,                         /**< [en]Audio setting page.
                                                [cn]音频设置页 */
    SETTING_PAGE_RECORD,                        /**< [en]Record setting page.
                                                [cn]录制设置页 */
    SETTING_PAGE_HOTKEY,                        /**< [en]Hotkey setting page.
                                                [cn]快捷键设置页 */
    SETTING_PAGE_SCREEN,                        /**< [en]Screen setting page.
                                                [cn]屏幕设置页 */
    SETTING_PAGE_COUNT,                        /**< [en]Count of setting pages.
                                                [cn]设置页数量 */
}HwmSettingPage;

/**
* [en] Show setting window info
* [cn] 显示设置窗口信息
*/
typedef struct tagHwmShowSettingWindowInfo
{
    HWM_BOOL isShow;                         /**< [en]Is show.
                                             [cn]是否显示 */
    HwmSettingPage defaultPage;          /**< [en]Default page
                                         [cn]默认显示标签页 */
}HwmShowSettingWindowInfo;

/**
* [en] Voice prompts info
* [cn] 提示音信息
*/
typedef struct tagHwmVoicePromptsInfo
{
    HWM_BOOL isDisableMutePrompt;       /**< [en]Is disable mute prompts.
                                             [cn]是否禁用静音提示 */
}HwmVoicePromptsInfo;

/**
* [en] Share permission info
* [cn] 共享权限信息
*/
typedef struct tagHwmSharePermission
{
    HWM_BOOL isAllowed;                 /**< [en]Is disable share permission.
                                             [cn]是否禁用共享权限 */
}HwmSharePermission;

/**
* [en]Entry of show voiceprint statement.
* [cn]打开声纹降噪功能声明的入口
*/
typedef enum tagHwmVoiceprintStatementEntry
{
    VOICEPRINT_STATEMENT_ENTRY_CHECK_STATEMENT = 0,     /**< [en]Indicates check statement
                                                             [cn]点击"功能声明"打开*/
    VOICEPRINT_STATEMENT_ENTRY_OPEN_NOISE_REDUCE,       /**< [en]Indicates open voiceprint noise reduce
                                                             [cn]点击"声纹降噪"打开 */
}HwmVoiceprintStatementEntry;


/**
* [en]Show voiceprint statement info
* [cn]打开声纹降噪功能声明信息
*/
typedef struct tagHwmShowVoiceprintStatementInfo
{
    HwmVoiceprintStatementEntry entry;                  /**<  [en]entry of show statement
                                                              [cn]打开功能声明入口 */
} HwmShowVoiceprintStatementInfo;

/**
* [en] Voiceprint record reading text
* [cn] 声纹录入朗读文本
*/
typedef struct tagHwmVoiceprintRecordReadingText
{
    HWM_CHAR content[HWM_MAX_READING_TEXT_CONTENT_LEN];     /**< [en]Reading text content
                                                                 [cn]朗读文本内容 */
    HWM_CHAR title[HWM_MAX_READING_TEXT_TITLE_LEN];         /**< [en]Reading text title
                                                                 [cn]朗读文本标题 */
    HwmLanguage language;                                   /**< [en]Reading text language
                                                                 [cn]朗读文本语言 */
}HwmVoiceprintRecordReadingText;

/**
* [en] Voiceprint record window config
* [cn] 声纹录入窗口配置
*/
typedef struct tagHwmVoiceprintRecordWindowConfig
{
    HwmVoiceprintRecordReadingText* readingTextList;                            /**< [en]Indicates reading text list
                                                                                     [cn]朗读文本列表   */
    HWM_UINT32 readingTextListLength;         	                                /**< [en]Indicates reading text list's length
                                                                                     [cn]朗读文本列表的实际长度
                                                                                     [length for readingTextList] */
}HwmVoiceprintRecordWindowConfig;

/**
* [en]Set log path info.
* [cn]设置日志路径信息
*/
typedef struct tagHwmLogPathInfo
{
    HWM_CHAR path[HWM_MAX_FILE_PATH_LEN];       /**< [en]save path
                                                     [cn]保存路径，注：绝对路径，需要UTF8编码
                                                     [cs_allowNull:N] */
}HwmLogPathInfo;

/**
* [en]Error message info.
* [cn]错误提示
*/
typedef struct tagHwmErrorMessageInfo
{
    HWM_CHAR errorMessage[HWM_MAX_ERROR_MESSAGE_LEN];       /**< [en]error message
                                                                 [cn]错误提示，注：UTF8编码 */
}HwmErrorMessageInfo;

/**
* [en]Toast info.
* [cn]提示信息
*/
typedef struct tagHwmToastInfo
{
    HWM_CHAR content[HWM_MAX_TOAST_CONTENT_LEN]; /**< [en]Toast content.
                                                      [cn]提示内容 */
    HWM_INT32 duration;                          /**< [en]Toast duration.
                                                      [cn]提示持续时间（单位：秒） */
}HwmToastInfo;

/**
* [en]Main Window info.
* [cn]主窗口信息
*/
typedef struct tagHwmMainWindowInfo
{
    HWM_INT32 x;                                 /**< [en]Indicates window's left offset from screen
                                                      [cn]窗口相对于屏幕左侧的偏移量。 */
    HWM_INT32 y;                                 /**< [en]Indicates window's top offset from screen
                                                      [cn]窗口相对于屏幕顶端的偏移量。 */
    HWM_INT32 width;                             /**< [en]Indicates window's width
                                                      [cn]窗口的宽度。 */
    HWM_INT32 height;                            /**< [en]Indicates Window's height
                                                      [cn]窗口的高度。 */
    HWM_HWND handle;                             /**< [en]Window handle
                                                      [cn]窗口句柄 */
} HwmMainWindowInfo;

/**
* [en]Transparent window info.
* [cn]透明窗口信息
*/
typedef struct tagHwmTransparentWndInfo
{
    HWM_HWND* handle;                                /**< [en]Window handle
                                                     [cn]窗口句柄 */
    HWM_UINT32 count;                                /**< [en]length for window handle
                                                     [cn]窗口句柄个数
                                                     [length for handle]*/
}HwmTransparentWndInfo;

/**
* [en]CA path info
* [cn]证书路径信息
*/
typedef struct tagHwmCAPathInfo
{
    HWM_CHAR path[HWM_MAX_FILE_PATH_LEN];       /**< [en]CA path
                                                     [cn]证书路径，注：绝对路径，需要UTF8编码
                                                     [cs_allowNull:N] */
} HwmCAPathInfo;

/**
* [en]This structure is used to describe custom text scene.
* [cn]自定义文案场景
*/
typedef enum tagHwmUICustomTextScene
{
    CLOUD_RECORD_FINISHED_ALERT_SCENE,          /**< [en]Cloud Record Finished Alert
                                                     [cn]会中主动结束云录制场景 */
    CLOUD_RECORD_FINISHED_ALERT_IM_SCENE,       /**< [en]Cloud Record Finished Alert In Meeting(only for mac)
                                                     [cn]以离会方式结束云录制场景(仅对mac平台生效)
                                                     [win:disable]*/
    CLOUD_RECORD_MENU_TITLE_TEXT_SCENE,         /**< [en]Cloud recording title in the recording pop-up menu
                                                     [cn]录制弹框菜单中的云录制标题(仅对win平台生效)
                                                     [mac:disable]*/
    CLOUD_RECORD_MENU_DES_TEXT_SCENE,           /**< [en]Cloud recording description in the recording pop-up menu
                                                     [cn]录制弹框菜单中的云录制描述(仅对win平台生效)
                                                     [mac:disable]*/
    MAIN_WINDOW_CLOUD_RECORD_DES_TEXT_SCENE,    /**< [en]Cloud recording description in the main window
                                                     [cn]主窗口中的云录制描述(仅对win平台生效)
                                                     [mac:disable]*/
} HwmUICustomTextScene;

/**
* [en]This structure is used to describe custom text info.
* [cn]自定义文案信息
*/
typedef struct tagHwmUICustomTextInfo
{
    HwmLanguage languageType;                               /**< [en]Language type
                                                                 [cn]语言类型 */
    HWM_CHAR languageCode[HWM_MAX_LOCATION_LEN];            /**< [en]Customized language location-name.
                                                                 [cn]自定义语言区域名
                                                                 [cs_allowNull:Y] */
    HWM_CHAR customText[HWM_MAX_CUSTOM_CONTENT_LEN];        /**< [en]User custom text
                                                                 [cn]用户自定义文案 */
} HwmUICustomTextInfo;

/**
* [en]This structure is used to describe custom scene and text info.
* [cn]自定义场景文案信息
*/
typedef struct tagHwmCustomSceneTextInfo
{
    HwmUICustomTextScene scene;                             /**< [en]Custom text scene
                                                                 [cn]自定义文案场景 */
    HWM_UINT32 sceneTextListSize;                           /**< [en]Custom text size
                                                                 [cn]自定义文案列表长度 
                                                                 [length for sceneTextList] */
    HwmUICustomTextInfo* sceneTextList;                     /**< [en]Custom text list
                                                                 [cn]自定义文案列表 */
} HwmCustomSceneTextInfo;

/**
 * [en]This structure is used to describe custom scene and text info list.
 * [cn]自定义场景文案信息列表
*/
typedef struct tagHwmCustomSceneTextInfoList
{
    HWM_UINT32 customSceneTextInfoListSize;                 /**< [en]Scene and custom ui text length
                                                                 [cn]自定义场景文案信息列表长度 
                                                                 [length for customSceneTextInfoList] */
    HwmCustomSceneTextInfo* customSceneTextInfoList;        /**< [en]Scene and custom ui text list
                                                                 [cn]自定义场景文案信息列表 */
} HwmCustomSceneTextInfoList;

/**
* [en]Custom image scene.
* [cn]自定义图标场景
*/
typedef enum tagHwmUICustomImageScene
{
    CLOUD_RECORD_ICON_IMAGE_SCENE,              /**< [en]Cloud record image
                                                     [cn]会中云录制主图标（云录制菜单弹框、与会者列表、共享工具条） */
    MAIN_WINDOW_CLOUD_RECORD_ICON_SCENE,        /**< [en]Main window cloud record icon
                                                     [cn]主窗口云录制ICON小图标 */
    MAIN_WINDOW_CLOUD_RECORD_LOGO_SCENE,        /**< [en]Main window cloud record logo
                                                     [cn]主窗口云录制LOGO大图标 */
} HwmUICustomImageScene;

/**
* [en]This structure is used to describe custom scene and image info.
* [cn]自定义场景图标信息
*/
typedef struct tagHwmCustomSceneImageInfo
{
    HwmUICustomImageScene scene;                            /**< [en]Custom image scene
                                                                 [cn]自定义图标场景 */
    HWM_CHAR imagePath[HWM_MAX_FILE_PATH_LEN];              /**< [en]Custom image path
                                                                 [cn]自定义图标路径 */
    HWM_UINT32 width;                                       /**< [en]Custom image path
                                                                 [cn]自定义图标宽度 */
    HWM_UINT32 height;                                      /**< [en]Custom image path
                                                                 [cn]自定义图标高度 */
} HwmCustomSceneImageInfo;

/**
 * [en]This structure is used to describe custom scene and image info list.
 * [cn]自定义场景图标信息列表
*/
typedef struct tagHwmCustomSceneImageInfoList
{
    HWM_UINT32 customSceneImageInfoListSize;                /**< [en]Scene and custom ui image length
                                                                 [cn]自定义场景图标信息列表长度
                                                                 [length for customSceneImageInfoList] */
    HwmCustomSceneImageInfo* customSceneImageInfoList;      /**< [en]Scene and custom ui image list
                                                                 [cn]自定义场景图标信息列表 */
} HwmCustomSceneImageInfoList;

/**
* [en]Name show type.
* [cn]姓名显示风格
*/
typedef enum tagHwmNameShowType
{
    FIRST_LETTER,                               /**< [en]First letter
                                                     [cn]显示拼音首字母 */
    FAMILY_NAME,                                /**< [en]Family name
                                                     [cn]显示姓氏 */
} HwmNameShowType;

/**
* [en]Avatar shape.
* [cn]头像形状
*/
typedef enum tagHwmAvatarShape
{
    CIRCLE,                                     /**< [en]Circle
                                                     [cn]圆形头像 */
} HwmAvatarShape;

/**
* [en]Avatar style
* [cn]头像风格
*/
typedef struct tagHwmAvatarStyle
{
    HWM_CHAR backgroundColor[HWM_MAX_COLOR_LEN];              /**< [en]background color
                                                                   [cn]背景色
                                                                   [cs_allowNull:N] */
    HWM_CHAR textColor[HWM_MAX_COLOR_LEN];                    /**< [en]text color
                                                                   [cn]文字颜色
                                                                   [cs_allowNull:N] */
    HWM_CHAR phoneIconPath[HWM_MAX_FILE_PATH_LEN];            /**< [en]phone icon path
                                                                   [cn]手机图标
                                                                   [cs_allowNull:N] */
    HWM_CHAR boardIconPath[HWM_MAX_FILE_PATH_LEN];            /**< [en]board icon path
                                                                   [cn]大屏图标
                                                                   [cs_allowNull:N] */
    HwmNameShowType nameShowType;                             /**< [en]Name show type
                                                                   [cn]姓名显示风格
                                                                   [cs_allowNull:Y] */
    HwmAvatarShape avatarShape;                               /**< [en]Avatar shape
                                                                   [cn]头像形状
                                                                   [cs_allowNull:Y] */
}HwmAvatarStyle;

/**
* [en]Setting vrbk default image mode
* [cn]设置自定义虚拟背景默认图模式
*/
typedef enum tagHwmSettingVrbkDefaultImageMode
{
    HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_REPLACE_ALL,    /**< [en]Replace all
                                                             [cn]全部替换, 覆盖内置的默认图片 */
    HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_APPEND,         /**< [en]Append
                                                             [cn]基于内置的默认图片追加 */
}HwmSettingVrbkDefaultImageMode;

/**
* [en]Virtual background image info
* [cn]虚拟背景图信息
**/
typedef struct tagHwmVirtualBackgroundImageInfo
{
    HWM_CHAR imagePath[HWM_MAX_FILE_PATH_LEN];   /**< [en]Image path
                                                      [cn]虚拟背景图片路径 */
}HwmVirtualBackgroundImageInfo;

/**
* [en]This struct is used to describe Virtual background info.
* [cn]虚拟背景信息
*/
typedef struct tagHwmVirtualBackgroundInfo
{
    HwmSettingVrbkDefaultImageMode mode;        /**< [en]Default image mode
                                                     [cn]设置自定义虚拟背景默认图模式 */
    HwmVirtualBackgroundImageInfo* imageList;   /**< [en]Image list
                                                     [cn]虚拟背景图列表 */
    HWM_UINT32 imageLength;                     /**< [en]Num of images
                                                     [cn]虚拟背景图个数
                                                     [length for imageList] */
}HwmVirtualBackgroundInfo;

END_HWM_UISDK_NAMESPACE

#endif /* _HWM_UISDK_CONFIG_SERVICE_DEF_H_ */
