﻿/**
 * @file HwmUISdkLoginServiceDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_UISDK_LOGIN_SERVICE_DEF_H_
#define _HWM_UISDK_LOGIN_SERVICE_DEF_H_

#include "HwmUISdkCommonDef.h"
#include "HwmBaseMacroDef.h"

BEGIN_HWM_UISDK_NAMESPACE
/**
* [en]Auth type.
* [cn]鉴权类型
*/
typedef enum tagHwmAuthType
{
    HWM_AUTH_TYPE_ACCOUNT_AND_PASSWORD = 0,        /**< [en]Auth by account and password
                                                        [cn]账号密码鉴权 */
    HWM_AUTH_TYPE_APPID,                           /**< [en]Auth by appId
                                                        [cn]appId鉴权 */
    HWM_AUTH_TYPE_BUTT

}HwmAuthType;

/**
* [en]Account auth info.
* [cn]账号登录鉴权信息
*/
typedef struct tagHwmAccountAuthInfo
{
    HWM_CHAR account[HWM_MAX_ACCOUNT_LEN];          /**< [en]The account
                                                         [cn]登录账号
                                                         [cs_allowNull:N] */
    HWM_CHAR password[HWM_MAX_PASSWORD_LEN];        /**< [en]The password
                                                         [cn]登录密码
                                                         [cs_allowNull:N] */
}HwmAccountAuthInfo;

/**
* [en]appId auth info.
* [cn]appId登录鉴权信息
*/
typedef struct tagHwmAppIdAuthInfo
{
    HWM_CHAR corpId[HWM_MAX_CORP_ID_LEN];          /**< [en]Corporation Id
                                                        [cn]企业Id，仅在SP模式下需要填写，单企业模式不要填写，否则会鉴权失败
                                                        [cs_allowNull:Y] */
    HWM_CHAR thirdUserId[HWM_MAX_USER_ID_LEN];     /**< [en]The user id
                                                        [cn]第三方账号唯一标识
                                                        [cs_allowNull:N] */
    HWM_CHAR userName[HWM_MAX_USER_NAME_LEN];      /**< [en]The user name
                                                        [cn]用户名称（如不填，默认与thirdUserId一致）
                                                        [cs_allowNull:Y] */
    HWM_CHAR signature[HWM_MAX_SIGNATURE_LEN];     /**< [en]The signature
                                                        [cn]从第三方服务端获取的鉴权签名
                                                        [cs_allowNull:N] */
    HWM_CHAR nonce[HWM_APPID_NONCE_LEN];           /**< [en]The nonce
                                                        [cn]从第三方服务端获取的Nonce值，用于华为云服务端验证鉴权签名有效性
                                                        [cs_allowNull:N] */
    HWM_INT64 expireTime;                          /**< [en]The expire time(s)
                                                        [cn]从第三方服务端获取的鉴权签名有效期的时间戳（s），0表示永不超时
                                                        [cs_allowNull:N] */
    HWM_CHAR userEmail[HWM_MAX_EMAIL_LEN];         /**< [en]The nonce
                                                        [cn]用户邮箱信息
                                                        [cs_allowNull:Y] */
    HWM_CHAR userPhone[HWM_MAX_PHONE_NUM_LEN];     /**< [en]The nonce
                                                        [cn]用户手机号码
                                                        [cs_allowNull:Y] */
    HWM_CHAR deptCode[HWM_MAX_CORPID_LEN];         /**< [en]Indicates the deptCode.
                                                        [cn]部门id 
                                                        [cs_allowNull:Y]*/
}HwmAppIdAuthInfo;

/**
* [en]This structure is used to describe auth server type
* [cn]鉴权服务类型
**/
typedef enum tagHwmAuthServerType
{
    AUTH_SERVER_TYPE_OAUTH2      /**< [en]Indicates user has not binded. 
                                      [cn]单点登录 */
}HwmAuthServerType;

/**
* [en]sso auth info.
* [cn]sso登录鉴权信息
*/
typedef struct tagHwmSSOAuthInfo
{
    HWM_CHAR code[HWM_MAX_SSO_CODE_LEN];                /**< [en]Indicates the account username.
                                                             [cn]授权码
                                                             [cs_sensitive:hide][cs_allowNull:N] */
    HWM_CHAR domain[HWM_MAX_SSO_DOMAIN_LEN];            /**< [en]sso domain.
                                                             [cn]企业域名
                                                             [cs_sensitive:domain][cs_allowNull:N] */
    HwmAuthServerType authServerType;                   /**< [en]authServerType.
                                                             [cn]鉴权服务类型
                                                             [cs_allowNull:N] */
}HwmSSOAuthInfo;

/**
* [en]login info.
* [cn]登录回调返回信息
*/
typedef struct tagHwmLoginResult
{
    HWM_CHAR userUuid[HWM_MAX_DEVICE_UUID_LEN];     /**<[en]Indicates UUID.
                                                        [cn]UUID(由系统分配的真实的唯一用户标识) */
    HWM_CHAR account[HWM_MAX_ACCOUNT_LEN];          /**<[en]account.
                                                        [cn]账号 */
    HWM_CHAR thirdAccount[HWM_MAX_ACCOUNT_LEN];     /**<[en]third account.
                                                        [cn]第三方账号 */
    HWM_BOOL basicCallAbility;                      /**<[en]Indicates has call ability.
                                                        [cn]是否有点对点呼叫能力 */
}HwmLoginResult;

/**
* [en]Corporation configuration information.
* [cn]企业配置信息
*/
typedef struct tagHwmCorpConfigInfo
{
    HWM_BOOL pstnEnable;                                  /**< [en]Is enable Pstn
                                                               [cn]是否支持手机呼叫 */
    HWM_BOOL smsEnable;                                   /**< [en]Is enable sms
                                                               [cn]是否支持短信通知 */
    HWM_BOOL recordEnable;                                /**< [en]Is enable conference record
                                                               [cn]是否支持会议录制 */
    HWM_CHAR pstnNumber[HWM_MAX_NUMBER_LEN];              /**< [en]Pstn Number
                                                               [cn]pstn呼叫号码 */
    HWM_BOOL allowGuestStartConf;                         /**< [en]Indicates whether is allow guest start conf.
                                                               [cn]是否允许来宾提前启动会议默认值 */
    HWM_UINT32 allowGuestStartConfTime;                   /**< [en]Indicates join before host time.
                                                               [cn]允许来宾提前入会时间范围默认值(单位：分钟) 0-随时，n-提前n分钟启动会议 */
    HWM_BOOL enableShowAddressBookStructure;              /**< [en]Is enable Show AddressBook(only for win).
                                                               [cn]是否支持通讯录显示（仅对win平台生效）*/
    HWM_BOOL enableRoomsLocalRecord;                      /**< [en]Is enable Rooms local record
                                                               [cn]大屏是否支持本地录制
                                                               [js:disable] */
    HWM_BOOL supportController;                           /**< [en]Is support controller
                                                               [cn]是否支持控制器
                                                               [js:disable] */
    HWM_BOOL enableProjection;                            /**< [en]Is enable projection
                                                               [cn]是否支持共享投屏
                                                               [js:disable] */
    HWM_BOOL corpEnableSummary;                           /**< [en]Indicates corp enable summary
                                                               [cn]企业是否支持会议纪要 */
    HWM_BOOL supportMultiShare;                           /**< [en]Is support multi share
                                                               [cn]企业是否支持多人共享
                                                               [js:disable] */
    HWM_BOOL supportCollaborateCapability;                /**< [en]Is support collaborate
                                                               [cn]企业是否支持新辅流
                                                               [js:disable] */
    HWM_BOOL enableSelfCascadingMeeting;                  /**< [en]Is support cascading meeting
                                                               [cn]企业是否支持加入级联会议
                                                               [doc:disable] */
    HWM_BOOL enableCrossCorpCascading;                    /**< [en]Is support across-enterprises cascading meeting 
                                                               [cn]企业是否支持跨企业加入级联会议
                                                               [doc:disable] */
    HWM_BOOL enableDataGuardAudio;                        /**< [en]Is enable data guard audio
                                                               [cn]企业是否支持音频暗水印
                                                               [doc:disable] */
    HWM_BOOL enableDataGuardVideo;                        /**< [en]Is enable data guard video
                                                               [cn]企业是否支持视频暗水印
                                                               [doc:disable] */
} HwmCorpConfigInfo;

/**
* [en]This structure is used to describe share vmr info notify
* [cn]共享vmr信息
*/
typedef struct tagHwmShareVmrInfo
{
    HWM_BOOL isEnableShareVmr;                          /**< [en]Is enable share vmr
                                                             [cn]共享vmr是否可用 */
}HwmShareVmrInfo;

/**
* [en]This structure is used to describe user corp info notify type
* [cn]客户企业信息变化通知类型
*/
typedef enum tagHwmUserCorpInfoNotifyType
{
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_DELETE = 0,              /**< [en]Indicates user delete
                                                                      [cn]用户已注销 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_JOIN_NEW_CORP,           /**< [en]Indicates join new corp
                                                                      [cn]用户已加入新的企业（接受邀请、创建企业变成新企业的用户） */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_LEAVE_CURRENT_CORP,      /**< [en]Indicates leave current corp
                                                                      [cn]用户已被移出当前企业（企业管理员删除、解散、用户主动离开企业变成注册用户） */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_RESET,                   /**< [en]Indicates Smartrooms user is reset activation code or user is deleted
                                                                      [cn]用户重置（Smartrooms账号被重置激活码或者账号被删除） */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_VMR_CHANGE,              /**< [en]Indicates vmr change
                                                                      [cn]用户vmr变化 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_NAME_CHANGE,             /**< [en]Indicates user name change
                                                                      [cn]用户姓名变更 */
    HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_STATUS_CHANGE,           /**< [en]Indicates user status change
                                                                      [cn]接入账号状态变化 */
}HwmUserCorpInfoNotifyType;

/**
* [en]logout info.
* [cn]登出回调返回信息
*/
typedef struct tagHwmLogoutResult
{
    HWM_CHAR userUuid[HWM_MAX_DEVICE_UUID_LEN];     /**< [en]Indicates UUID.
                                                         [cn]UUID(由系统分配的真实的唯一用户标识) */
    HWM_CHAR account[HWM_MAX_ACCOUNT_LEN];          /**< [en]account.
                                                         [cn]账号 */
    HWM_CHAR thirdAccount[HWM_MAX_ACCOUNT_LEN];     /**< [en]third account.
                                                         [cn]第三方账号  */
}HwmLogoutResult;

/**
* [en]Indicates network access type
* [cn]网络接入类型
*/
typedef enum tagHwmNetworkAccessType
{
    ACCESS_TYPE_AUTO = 0,                 /**< [en]Indicates auto
                                               [cn]默认值，目前和企业外网接入模式一致。 */
    ACCESS_TYPE_INNER,                    /**< [en]Indicates inner
                                               [cn]公司内网接入, 用于媒体和信令下沉场景，app从内网接入，信令/媒体消息走代理服务器才能访问云会议服务端 */
    ACCESS_TYPE_OUTER,                    /**< [en]Indicates outter
                                               [cn]公司外网接入, 用于非媒体和信令下沉场景，互联网接入，信令/媒体消息可以直接访问云会议服务端 */
} HwmNetworkAccessType;

/*
* [en]Indicates network connect type
* [cn]网络连接类型
*/
typedef enum tagHwmNetConnectType {
    NET_CONNECT_AUTO = 0,                 /**< [en]Indicates auto
                                               [cn]自动模式 */
    NET_CONNECT_FORCE_VPN,                /**< [en]Indicates force vpn
                                               [cn]强制vpn */
    NET_CONNECT_FORCE_DIRECT,             /**< [en]Indicates force direct
                                               [cn]强制直连 */
}HwmNetConnectType;

/**
* [en]network mode info
* [cn]网络模式信息
*/
typedef struct tagHwmNetWorkModeInfo {
    HwmNetworkAccessType accessType;                       /**< [en]Indicates network access type
                                                                [cn]网络接入类型
                                                                [cs_allowNull:N] */
    HwmNetConnectType netConnectType;                      /**< [en]Indicates network connect type(only for win).
                                                                [cn]网络连接类型(仅对win平台生效)
                                                                [cs_allowNull:Y] */
}HwmNetWorkModeInfo;

/**
* [en]Self avatar info
* [cn]个人头像信息
*/
typedef struct tagHwmSelfAvatarInfo
{
    HWM_CHAR path[HWM_MAX_FILE_PATH_LEN];               /**< [en] path
                                                             [cn] 图片全路径
                                                             [cs_allowNull:N] */
}HwmSelfAvatarInfo;

/**
* [en]This structure is used to describe login parameters.
* [cn]登录信息参数
*/
typedef struct tagHwmServerInfo
{
    HWM_CHAR serverAddr[HWM_MAX_URL_LEN];           /**< [en]Indicates the server address.
                                                         [cn]服务器地址，默认meeting.huaweicloud.com。 */
    HWM_UINT16 serverPort;                          /**< [en]The server port
                                                         [cn]服务器端口，默认443。 */
}HwmServerInfo;

/**
* [en]Proxy config policy
* [cn]代理配置策略
*/
typedef enum tagHwmProxyConfigPolicy
{
    HWM_PROXY_CONFIG_POLICY_CUSTOM,                    /**< [en]Use proxy with custom configuration
                                                       [cn]使用具有自定义配置的代理 */
    HWM_PROXY_CONFIG_POLICY_OFF,                       /**< [en]Do not use proxy
                                                       [cn]不使用代理 */
    HWM_PROXY_CONFIG_POLICY_AUTO,                      /**< [en]Use system proxy
                                                       [cn]使用系统代理 */
}HwmProxyConfigPolicy;

/**
* [en]Proxy info.
* [cn]代理信息
*/
typedef struct tagHwmProxyInfo
{
    HwmProxyConfigPolicy proxyConfigPolicy;               /**< [en]The proxy config policy
                                                          [cn]代理配置策略
                                                          [mac:disable] */
    HWM_CHAR server[HWM_MAX_URL_LEN];                     /**< [en]The server address
                                                          [cn]代理地址
                                                          [cs_allowNull:Y] */
    HWM_UINT16 port;                                      /**< [en]The server port
                                                          [cn]代理端口
                                                          [cs_allowNull:Y] */
    HWM_CHAR account[HWM_MAX_USERNAME_LEN];               /**< [en]The account
                                                          [cn]代理账号
                                                          [cs_allowNull:Y] */
    HWM_CHAR password[HWM_MAX_PASSWORD_LEN];              /**< [en]The password
                                                          [cn]代理密码
                                                          [cs_allowNull:Y] */
}HwmProxyInfo;

/**
* [en]This enumeration is used to describe verify mode.
* [cn]认证模式
*/
typedef enum tagHwmVerifyMode
{
    VERIFY_MODE_NONE = 0,                       /**< [en]Indicates no authentication.
                                                     [cn]不认证 */
    VERIFY_MODE_SERVER,                         /**< [en]Indicates authentication server.
                                                     [cn]认证服务端 */
    VERIFY_MODE_BUTT                            
}HwmVerifyMode;

/**
* [en]Proxy info.
* [cn]代理信息
*/
typedef struct tagHwmCAVerifyInfo
{
    HwmVerifyMode verifyMode;                    /**< [en]Indicates the verify mode
                                                      [cn]认证模式 */
    HWM_CHAR certPath[HWM_MAX_FILE_PATH_LEN];    /**< [en]Indicates the CA certificate path
                                                      [cn]用户自定义证书存储路径。传空，则使用内置证书校验
                                                      [cs_allowNull:Y] */
}HwmCAVerifyInfo;

/**
* [en].
* [cn]域名保底ip信息
*/
typedef struct tagHwmGuaranteedIpAddress
{
    HWM_CHAR domain[HWM_MAX_URL_LEN];                            /**< [en]Domain
                                                                      [cn]域名 */
    HWM_CHAR guaranteedIps[HWM_MAX_GURARTEENED_IP_ADDRESS_LEN];  /**< [en]Guaranteed IP address list. Multiple IP addresses are separated by semicolons (;). A maximum of four IP addresses are supported.
                                                                      [cn]保底ip列表，多个地址中间用分号隔开，最多支持4个地址 */
}HwmGuaranteedIpAddress;


/**
* [en].
* [cn]域名保底ip信息
*/
typedef struct tagHwmGuaranteedIpAddressesParam
{
    HWM_UINT32 addressListSize;                        /**< [en]Guaranteed IP address list length
                                                            [cn]保底ip信息list长度
                                                            [cs_allowNull:N][length for addressList] */
    HwmGuaranteedIpAddress* addressList;               /**< [en]Guaranteed IP address list
                                                            [cn]保底ip信息列表
                                                            [cs_allowNull:N] */
}HwmGuaranteedIpAddressesParam;

/**
* [en].
* [cn]部署类型
*/
typedef enum tagHwmDeployType
{
    CLOUD_MODE = 0,     /**< [en]Indicates cloud mode
                             [cn]云上模式 */
    SINK_MODE,          /**< [en]Indicates sink mode
                             [cn]下沉模式 */
}HwmDeployType;

/**
* [en].
* [cn]部署信息
*/
typedef struct tagHwmDeployInfo
{
    HwmServerInfo serverInfo;   /**< [en]Indicates the server info.
                                     [cn]服务器地址和端口信息 */

    HwmDeployType deployType;   /**< [en]Indicates the deploy mode.
                                      [cn]部署模式 */

}HwmDeployInfo;

/**
* [en]This enumeration is used to describe login state.
* [cn]登录状态
*/
typedef enum tagHwmLoginState
{
    LOGIN_STATUS_UN_LOGIN = 0,                      /**< [en]Unlogin.
                                                         [cn]未登录 */
    LOGIN_STATUS_LOGINING,                          /**< [en]Logining.
                                                         [cn]登录中 */
    LOGIN_STATUS_LOGINED,                           /**< [en]Logined.
                                                         [cn]已登录 */
    LOGIN_STATUS_LOGOUTING,                         /**< [en]Logouting.
                                                         [cn]登出中 */
    LOGIN_STATUS_BUTT                               /**< [en]Invalid
                                                         [cn]无效值 */
}HwmLoginState;

/**
* [en]This enumeration is used to describe login state info.
* [cn]登录状态信息
*/
typedef struct tagHwmLoginStateInfo
{
    HwmLoginState loginState;                          /**< [en]Indicates the login state
                                                            [cn]登录模式 */
}HwmLoginStateInfo;

/**
* [en]This enumeration is used to describe login token info.
* [cn]登录token信息
*/
typedef struct tagHwmLoginTokenInfo
{
    HWM_CHAR loginToken[HWM_MAX_TOKEN_LEN];            /**< [en]Indicates the login token
                                                            [cn]登录token */
}HwmLoginTokenInfo;

END_HWM_UISDK_NAMESPACE

#endif /* _HWM_UISDK_LOGIN_SERVICE_DEF_H_ */
