import { MediaType, VmrConfIdType, ConfAllowJoinUserType, AutoMuteType, LocalRecordOperateType, TargetLanguageType, AttendeeType } from './enum'

export const MediaTypeOptions = [
  {
    value: MediaType.HWM_MEDIA_TYPE_AUDIO,
    label: 'Audio',
  },
  {
    value: MediaType.HWM_MEDIA_TYPE_VIDEO,
    label: 'Video',
  },
]

export const VmrConfIdTypeOptions = [
  {
    value: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
    label: 'Fixed',
  },
  {
    value: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_RANDOM,
    label: 'Random',
  },
]

export const ConfAllowJoinUserTypeOptions = [
  {
    value: ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE,
    label: 'All User',
  },
  {
    value: ConfAllowJoinUserType.CONF_ALLOW_JOIN_LOGINED_USER,
    label: 'Non-anonymouse User',
  },
  {
    value: ConfAllowJoinUserType.CONF_ALLOW_JOIN_IN_COMPANY_USER,
    label: 'Company User',
  },
  {
    value: ConfAllowJoinUserType.CONF_ALLOW_JOIN_INVITED_USER,
    label: 'Invited User',
  },
]

export const TerminalAutoMuteTypeOptions = [
  {
    value: AutoMuteType.AUTO_MUTE_TYPE_DEFAULT,
    label: 'Default',
  },
  {
    value: AutoMuteType.AUTO_MUTE_TYPE_MUTE,
    label: 'Mute',
  },
  {
    value: AutoMuteType.AUTO_MUTE_TYPE_UNMUTE,
    label: 'Un Mute',
  },
]

export const LocalRecordOperateTypeOptions = [
  {
    value: LocalRecordOperateType.LOCAL_RECORD_OPERATE_TYPE_START,
    label: 'start',
  },
  {
    value: LocalRecordOperateType.LOCAL_RECORD_OPERATE_TYPE_STOP,
    label: 'stop',
  },
  {
    value: LocalRecordOperateType.LOCAL_RECORD_OPERATE_TYPE_PAUSE,
    label: 'pause',
  },
  {
    value: LocalRecordOperateType.LOCAL_RECORD_OPERATE_TYPE_RESUME,
    label: 'resume',
  },
]

export const TargetLanguageTypeOptions = [
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_DEFAULT,
    label: 'default',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_CN,
    label: 'CN',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_EN,
    label: 'EN',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_GE,
    label: 'GE',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_FR,
    label: 'FR',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_RU,
    label: 'RU',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_JA,
    label: 'JA',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_KO,
    label: 'KO',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_ES,
    label: 'ES',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_PT,
    label: 'PT',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_AR,
    label: 'AR',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_IT,
    label: 'IT',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_TH,
    label: 'TH',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_ID,
    label: 'ID',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_MS,
    label: 'MS',
  },
  {
    value: TargetLanguageType.SUBTITLE_LANGUAGE_TR,
    label: 'TR',
  },
]

export const AttendeeTypeOptions = [
  {
    value: AttendeeType.ATTENDEE_TYPE_NORMAL,
    label: 'Normal',
  },
  {
    value: AttendeeType.ATTENDEE_TYPE_MOBILE,
    label: 'Mobile',
  },
]
