import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class SetAutoHideToolBar extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isAutoHide: false,
    }
  }

  changeIsAutoHide (e) {
    this.setState({
      isAutoHide: e.target.checked,
    })
  }

  async goSetAutoHideToolBar () {
    const { isAutoHide } = this.state
    const param = {
      isAutoHide,
    }
    const apiService = new ApiService()
    const ret = await apiService.setAutoHideToolBar(param)
    if (ret !== 0) {
      showErrorTips(ret, '')
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="area">
                 <div className="input-box">
                    <div className="input-box-title-check">Is Auto Hide:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.isAutoHide} onChange={this.changeIsAutoHide.bind(this)} /></div>
                </div>
                <button onClick={this.goSetAutoHideToolBar.bind(this)}>Submit</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default SetAutoHideToolBar
