import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class SetMeetingWindowIcon extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      iconPath: '',
    }
  }

  changeIconPath (e) {
    this.setState({
      iconPath: e.target.value,
    })
  }

  async goToSetMeetingWindowIcon () {
    const { iconPath } = this.state
    const param = {
      iconPath,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setMeetingWindowIcon(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setMeetingWindowIcon">
        <div className="input-box">
          <div className="input-box-title">IconPath:</div>
          <div className="input-box-text">
            <input value={this.state.iconPath} onChange={this.changeIconPath.bind(this)}/>
          </div>
        </div>
        <button onClick={this.goToSetMeetingWindowIcon.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetMeetingWindowIcon
