import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { SDKERR } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

class LoginByAccount extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      account: '',
      password: '',
    }
  }

  changeAccount (e) {
    this.setState({
      account: e.target.value,
    })
  }

  changePassword (e) {
    this.setState({
      password: e.target.value,
    })
  }

  async goToLoginByAccount () {
    const { account, password } = this.state
    const param = {
      account,
      password,
    }
    const apiService = new ApiService()
    const setResult = await apiService.loginByAccount(param)
    if (setResult.ret === 0) {
      this.props.history.push('/main')
    } else if (setResult.ret === SDKERR.SDK_LOGIN_E_ERR_MNG_FAILED) {
      // 服务器降级，接入方收到该错误码可以继续调用入会接口离线入会
      this.props.history.push('/main')
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="loginByAccount">
        <div className="input-box">
          <div className="input-box-title">Account:</div>
          <div className="input-box-text">
            <input value={this.state.account} onChange={this.changeAccount.bind(this)}/>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Password:</div>
          <div className="input-box-text">
            <input value={this.state.password} onChange={this.changePassword.bind(this)}/>
          </div>
        </div>
        <button onClick={this.goToLoginByAccount.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default LoginByAccount
