import React from 'react'
import { connect } from 'react-redux'
import PropTypes from 'prop-types'
import './index.css'
import { SDKERR } from '../../../Constants/enum'
import { showErrorTips } from '../../../utils'
import { DEMOCONFIG, getConfig } from '../../../demoConfig.js'

const log = require('electron-log')

class JoinConfByNonce extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      conf_id: '',
      enter_code: '',
      name: '',
    }
  }

  changeConfId (e) {
    this.setState({ conf_id: e.target.value })
  }

  changeEnterCode (e) {
    this.setState({ enter_code: e.target.value })
  }

  changeName (e) {
    this.setState({ name: e.target.value })
  }

  async goConfByNonce () {
    if (window.process.platform === 'darwin') {
      // mac平台不支持,弹框提示
      showErrorTips(SDKERR.UISDK_NOT_SUPPORT_END, '')
      return
    }
    const { conf_id, enter_code, name } = this.state
    const nonce = await this.getNonce()
    const { serverAddr } = this.props
    const link = `cloudlink://welinksoftclient/h5page?page=LoginAndJoinConf&server_url=${serverAddr}&port=443&conf_id=${conf_id}&enter_code=${enter_code}&name=${name}&open_mic=true&open_camera=false&nonce=${nonce}`
    log.info('goConfByNonce link = ', link)
    window.location = link
  }

  async getAccessToken () {
    let token = ''
    const config = await getConfig()
    const data = {
      appId: config.DEFAULT_JOIN_CONF_APPID,
      clientType: 50,
      corpId: DEMOCONFIG.DEFAULT_CORPID,
      expireTime: 0,
      nonce: config.DEFAULT_NONCE,
      userEmail: DEMOCONFIG.DEFAULT_USER_EMAIL,
      userId: config.DEFAULT_USERID,
      userName: DEMOCONFIG.DEFAULT_USER_NAME,
      userPhone: DEMOCONFIG.DEFAULT_USER_PHONE,
    }
    // app id鉴权
    const url = `${config.API_URL}/v2/usg/acs/auth/appauth`
    const params = {
      method: 'POST',
      body: JSON.stringify(data),
      credentials: 'include',
      headers: new Headers({
        'Content-Type': 'application/json',
        Authorization: `HMAC-SHA256 signature=${config.DEFAULT_SIGNATURE}`,
      }),
    }
    try {
      const { accessToken } = await window.fetch(url, params).then(res => res.json())
      token = accessToken
    } catch (error) {
      log.error('Error:', error)
    }
    return token
  }

  async getNonce () {
    let nonce = ''
    const accessToken = await this.getAccessToken()
    const config = await getConfig()
    const url = `${config.API_URL}/v1/usg/acs/auth/portal-ref-nonce`
    const params = {
      method: 'POST',
      credentials: 'include',
      headers: new Headers({
        'Content-Type': 'application/json',
        'X-Access-Token': accessToken,
      }),
    }
    try {
      const result = await window.fetch(url, params).then(res => res.json())
      log.info('nonce:', result)
      nonce = result.nonce
    } catch (error) {
      log.error('Error:', error)
    }
    return nonce
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="nonce-area">
        <div className="input-box">
          <div className="input-box-title">conf_id:</div>
          <div className="input-box-text"><input value={this.state.conf_id} onChange={this.changeConfId.bind(this)}/></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">enter_code:</div>
          <div className="input-box-text"><input value={this.state.enter_code} onChange={this.changeEnterCode.bind(this)}/></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">nick_name:</div>
          <div className="input-box-text"><input value={this.state.name} onChange={this.changeName.bind(this)}/></div>
        </div>
        <button onClick={this.goConfByNonce.bind(this)}>enter conf by nonce</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

JoinConfByNonce.propTypes = {
  serverAddr: PropTypes.string,
}

const mapStateToProps = (state) => {
  const { serverAddr } = state.setting.server
  return { serverAddr }
}
export default connect(mapStateToProps)(JoinConfByNonce)
