import { CycleType } from '../../../Constants/enum'

/**
 * 获取周期类型下拉选项
 */
export const getCycleTypeOptions = () => {
  return [
    {
      value: CycleType.CYCLE_TYPE_DAY, // 按天
      label: 'Daily',
    },
    {
      value: CycleType.CYCLE_TYPE_WEEK, // 按周
      label: 'Weekly',
    },
    {
      value: CycleType.CYCLE_TYPE_MONTH, // 按月
      label: 'Monthly',
    },
  ]
}
/**
   * 根据周期类型获取频率间隔选项
   */
export const getIntervalOptions = (cycleType) => {
  const MAX_RANGE_DAY = 15
  const MAX_RANGE_WEEK = 5
  const MAX_RANGE_MONTH = 3
  let maxRange = MAX_RANGE_DAY
  if (cycleType === 1) {
    maxRange = MAX_RANGE_WEEK
  } else if (cycleType === 2) {
    maxRange = MAX_RANGE_MONTH
  }
  return Array.from(new Array(maxRange).keys()).map(val => {
    return {
      value: val + 1,
      label: 'Every' + (val + 1),
    }
  })
}
