import React from 'react'
import moment from 'moment-timezone'

import './index.css'
import ApiService from '../../../AppService/ApiService'
import { MediaType, VmrConfIdType, ConfAllowJoinUserType, VmrIdType, Timezone, CycleType, AutoMuteType, DeployType } from '../../../Constants/enum'
import PropTypes from 'prop-types'
import { MediaTypeOptions, VmrConfIdTypeOptions, ConfAllowJoinUserTypeOptions, TerminalAutoMuteTypeOptions } from '../../../Constants/typeOption'
import { getCycleTypeOptions, getIntervalOptions } from './helper'
import { showErrorTips } from '../../../utils'
import { connect } from 'react-redux'

const FORMAT_DATE_MINUTE = 'YYYY-MM-DD HH:mm'
const FORMAT_DATE = 'YYYY-MM-DD'
class BookConf extends React.Component {
  constructor (props) {
    super(props)
    const startTimeStampStr = moment().add(30, 'minutes').format(FORMAT_DATE_MINUTE)
    const endTimeStampStr = moment().add(30, 'minutes').format(FORMAT_DATE)
    this.state = {
      subject: '预约会议主题',
      startTimeStampStr,
      duration: 60,
      mediaType: MediaType.HWM_MEDIA_TYPE_VIDEO,
      needPassword: false,
      guestPwd: 'random guest pass',
      guestPwdDisable: false,
      isAutoRecord: false,
      allowRecord: false,
      timezone: Timezone.HWM_TIMEZONE_BEIJING,
      vmrFlag: false,
      vmrInfo: [],
      vmrIndex: 0,
      vmrId: '',
      vmrName: '',
      hostPwd: '',
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
      vmrConfIdTypeDisable: true,
      confAllowJoinUser: ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE,
      isSendSms: false,
      isSendEmail: false,
      isSendCalendar: false,
      isOpenWaitingRoom: false,
      showCycleConf: false,
      cycleParam: { // 周期会议参数
        startTimeStampStr,
        endTimeStampStr,
        cycleType: CycleType.CYCLE_TYPE_WEEK, // 周期类型， 默认按周
        interval: 1, // 周期频率， 默认每1周
        listPoints: [], // 会议召开点，默认开始时间的星期X
        preRemindDays: 1, // 提前通知天数， 默认提前1天
      },
      listPointsExample: '0, 1, 2',
      allowGuestStartConf: true,
      allowGuestStartConfTime: 0,
      allowGuestStartConfTimeDisable: false,
      attendees: '',
      customInfo: '',
      attendeesExample: '[{"nickName":"店小二","aliasCN":"汤姆","aliasEN":"tom","number":"15211111111","email":"xxxxx@xx.com","sms":"15211111111","isMute":false,"isAutoInvite":false,"role":0,"thirdUserId":"","extendedField":"","corpId":""}]',
      concurrentParticipants: 0, // 会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数
      isEnableShareVmr: false,
      isUseShareVmr: false, // 使用共享vmr
      defaultSummaryState: false,
      autoPublishSummary: true,
      autoMuteMode: AutoMuteType.AUTO_MUTE_TYPE_MUTE,
      hardTerminalAutoMuteMode: AutoMuteType.AUTO_MUTE_TYPE_UNMUTE,
      supportWatermark: false,
      forbiddenScreenShots: false,
      attendeesExcludeSelf: false,
    }
  }

  async componentDidMount () {
    const { attendeesExample } = this.state

    this.setState({
      attendees: attendeesExample,
    })

    this.refreshVmrList()
  }

  changeSubject (e) {
    this.setState({
      subject: e.target.value,
    })
  }

  changeStartTime (e) {
    const { cycleParam } = this.state
    this.setState({
      startTimeStampStr: e.target.value,
      cycleParam: { ...cycleParam, startTimeStampStr: e.target.value },
    })
  }

  changeDuration (e) {
    this.setState({
      duration: Number(e.target.value),
    })
  }

  changeMediaType (e) {
    this.setState({
      mediaType: Number(e.target.value),
    })
  }

  changeNeedPassword (e) {
    this.setState({
      needPassword: e.target.checked,
    })
  }

  changeGuestPwd (e) {
    this.setState({
      guestPwd: e.target.value,
    })
  }

  changeAllowGuestStartConf (e) {
    this.setState({
      allowGuestStartConf: e.target.checked,
    })
  }

  changeAllowGuestStartConfTime (e) {
    this.setState({
      allowGuestStartConfTime: Number(e.target.value),
    })
  }

  changeTimezone (e) {
    this.setState({
      timezone: Number(e.target.value),
    })
  }

  changeConcurrentParticipants (e) {
    this.setState({
      concurrentParticipants: Number(e.target.value),
    })
  }

  async refreshVmrList () {
    const { deployType } = this.props
    if (deployType === DeployType.SINK_MODE) {
      return
    }
    const apiService = await new ApiService()
    const setResult = await apiService.getVmrList()
    if (setResult.ret === 0) {
      const { vmrs, isEnableShareVmr } = setResult.vmrListInfo
      this.setState({
        vmrInfo: vmrs,
        isEnableShareVmr,
      })
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async changeVmrFlag (e) {
    this.setState({
      vmrFlag: e.target.checked,
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
    })
    if (e.target.checked) {
      await this.refreshVmrList()
      const { vmrInfo } = this.state
      if (vmrInfo?.length > 0) {
        this.changeVmrIndex(0)
      }
    } else {
      this.setState({
        guestPwd: 'random guest pass',
        guestPwdDisable: false,
        vmrConfIdTypeDisable: true,
        allowGuestStartConfTimeDisable: false,
      })
    }
  }

  changeUseShareVmr (e) {
    if (e.target.checked) {
      this.setState({
        isUseShareVmr: true,
        vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_RANDOM, // 随机会议号
      })
    } else {
      this.setState({
        isUseShareVmr: false,
      })
    }
  }

  changeVmrIndex (e) {
    const vmrIndexInput = typeof e === 'number' ? e : Number(e.target.value)
    const { vmrInfo } = this.state
    this.setState({
      vmrIndex: vmrIndexInput,
      vmrId: vmrInfo[vmrIndexInput].vmrId,
      vmrName: vmrInfo[vmrIndexInput].name,
      hostPwd: vmrInfo[vmrIndexInput].hostPwd,
      guestPwd: vmrInfo[vmrIndexInput].guestPwd,
      guestPwdDisable: true,
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
      allowGuestStartConfTimeDisable: true,
    })
    // 云会议室才能修改vmrConfIdType
    if (vmrInfo[vmrIndexInput].vmrType === VmrIdType.CLOUD_MEETING_ROOM_ID) {
      this.setState({
        vmrConfIdTypeDisable: false,
      })
    } else {
      this.setState({
        vmrConfIdTypeDisable: true,
      })
    }
    this.setState({
      isOpenWaitingRoom: vmrInfo[vmrIndexInput].isOpenWaitingRoom,
      confAllowJoinUser: vmrInfo[vmrIndexInput].confAllowJoinUser,
    })
  }

  changeVmrConfIdType (e) {
    const vmrConfIdTypeInput = Number(e.target.value)
    this.setState({
      vmrConfIdType: vmrConfIdTypeInput,
    })
    if (vmrConfIdTypeInput === VmrConfIdType.HWM_VMR_CONF_ID_TYPE_RANDOM) {
      // 随机VMR id
      this.setState({
        guestPwd: 'random guest pass',
        guestPwdDisable: false,
        allowGuestStartConfTimeDisable: false,
      })
    } else {
      // 固定VMR id
      const { vmrInfo, vmrIndex } = this.state
      this.setState({
        guestPwd: vmrInfo[vmrIndex].guestPwd,
        guestPwdDisable: true,
        allowGuestStartConfTimeDisable: true,
        isOpenWaitingRoom: vmrInfo[vmrIndex]?.isOpenWaitingRoom,
        confAllowJoinUser: vmrInfo[vmrIndex]?.confAllowJoinUser,
      })
    }
  }

  changeConfAllowJoinUser (e) {
    const val = Number(e.target.value)
    this.setState({
      confAllowJoinUser: val,
    })
  }

  changeIsSendSms (e) {
    this.setState({
      isSendSms: e.target.checked,
    })
  }

  changeIsSendEmail (e) {
    this.setState({
      isSendEmail: e.target.checked,
    })
  }

  changeIsSendCalendar (e) {
    this.setState({
      isSendCalendar: e.target.checked,
    })
  }

  changeIsOpenWaitingRoom (e) {
    const val = e.target.checked
    this.setState({
      isOpenWaitingRoom: val,
    })
  }

  changeShowCycleConf (e) {
    this.setState({
      showCycleConf: e.target.checked,
    })
  }

  changeEndDateStr (e) {
    const { cycleParam } = this.state
    this.setState({
      cycleParam: { ...cycleParam, endTimeStampStr: e.target.value },
    })
  }

  changeAttendees (e) {
    this.setState({
      attendees: e.target.value,
    })
  }

  changeCustomInfo (e) {
    this.setState({
      customInfo: e.target.value,
    })
  }

  changeIsAutoRecord (e) {
    this.setState({
      isAutoRecord: e.target.checked,
    })
  }

  changeDefaultSummaryState (e) {
    this.setState({
      defaultSummaryState: e.target.checked,
    })
  }

  changeAutoPublishSummary (e) {
    this.setState({
      autoPublishSummary: e.target.checked,
    })
  }

  changeAllowRecord (e) {
    this.setState({
      allowRecord: e.target.checked,
    })
  }

  changeSoftTerminalAutoMute = (e) => {
    this.setState({ autoMuteMode: Number(e.target.value) })
  }

  changeHardTerminalAutoMuteMode = (e) => {
    this.setState({ hardTerminalAutoMuteMode: Number(e.target.value) })
  }

  changeSupportWatermark = (e) => {
    const val = e.target.checked
    this.setState({
      supportWatermark: val,
    })
  }

  changeForbiddenScreenShots = (e) => {
    const val = e.target.checked
    this.setState({
      forbiddenScreenShots: val,
    })
  }

  changeAttendeesExcludeSelf = (e) => {
    const val = e.target.checked
    this.setState({
      attendeesExcludeSelf: val,
    })
  }

  async dealAllowGuestStartConf () {
    const { vmrFlag, vmrConfIdType, vmrId, guestPwd, allowGuestStartConf, vmrName, hostPwd } = this.state
    if (vmrFlag && vmrConfIdType === VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED) {
      const param = {
        vmrId,
        guestPwd: (guestPwd === 'random guest pass') ? '' : guestPwd,
        allowGuestStartConf,
        vmrName,
        hostPwd,
      }
      const apiService = new ApiService()
      await apiService.changeVmrInfo(param)
    }
  }

  async goToBookConf () {
    // 先处理来宾提前入会字段
    await this.dealAllowGuestStartConf()

    const {
      subject, startTimeStampStr, duration, mediaType, needPassword, timezone, vmrFlag, vmrId, confAllowJoinUser, isSendSms, isSendEmail, isSendCalendar,
      attendees, isAutoRecord, allowRecord, guestPwd, isOpenWaitingRoom, vmrConfIdType, showCycleConf, cycleParam, allowGuestStartConf, allowGuestStartConfTime,
      customInfo, concurrentParticipants, isUseShareVmr, isEnableShareVmr, defaultSummaryState, autoPublishSummary, autoMuteMode, hardTerminalAutoMuteMode, supportWatermark, forbiddenScreenShots,
      attendeesExcludeSelf,
    } = this.state
    const _attendees = attendees ? JSON.parse(attendees) : ''
    const isShareVmr = isEnableShareVmr && isUseShareVmr
    const param = {
      startTimeStamp: moment(startTimeStampStr).unix(),
      duration: Number(duration),
      isSendCalendar,
      confCommonParam: {
        confResType: isShareVmr ? 3 : 0, // 3-共享vmr，0-使用默认方式
        subject,
        mediaType, // 0:音频 1 视频
        needPassword,
        guestPwd: (guestPwd === 'random guest pass') ? '' : guestPwd,
        timezone,
        vmrId: (isShareVmr || !vmrFlag) ? '' : vmrId,
        vmrConfIdType,
        confAllowJoinUser,
        isSendSms,
        isSendEmail,
        isOpenWaitingRoom,
        attendees: _attendees,
        isAutoRecord,
        allowRecord,
        allowGuestStartConf,
        allowGuestStartConfTime,
        customInfo,
        concurrentParticipants,
        defaultSummaryState: defaultSummaryState ? 1 : 0,
        autoPublishSummary,
        autoMuteMode,
        hardTerminalAutoMuteMode,
        supportWatermark,
        forbiddenScreenShots,
        attendeesExcludeSelf,
      },
    }
    const apiService = new ApiService()
    let setResult = null
    if (showCycleConf) {
      console.log('cycleParam', cycleParam)
      const {
        startTimeStampStr,
        endTimeStampStr,
        cycleType,
        interval,
        listPoints,
        preRemindDays,
      } = cycleParam
      setResult = await apiService.bookCycleConf({
        bookConfParam: param,
        cycleParam: {
          startTimeStamp: moment(startTimeStampStr).unix(),
          endTimeStamp: moment(endTimeStampStr).unix(),
          cycleType,
          interval,
          listPoints,
          preRemindDays,
        },
      })
    } else {
      setResult = await apiService.bookConf(param)
    }
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    const {
      startTimeStampStr,
      vmrInfo,
      showCycleConf,
      cycleParam,
      cycleParam: {
        endTimeStampStr,
        cycleType,
        interval,
        listPoints,
        preRemindDays,
      },
      listPointsExample,
      isEnableShareVmr,
      isUseShareVmr,
      vmrConfIdTypeDisable,
      autoMuteMode,
      hardTerminalAutoMuteMode,
    } = this.state
    const intervalOptions = getIntervalOptions(cycleType) || []
    if (!intervalOptions.find(item => item.value === interval)) {
      this.setState({ cycleParam: { ...cycleParam, interval: 1 } })
    }
    return (
      <div className="bookConf">
        <div className="input-box">
          <div className="input-box-title">Conf Subject:</div>
          <div className="input-box-text"><input value={this.state.subject} onChange={this.changeSubject.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Start Time:</div>
          <div className="input-box-text"><input value={startTimeStampStr} onChange={this.changeStartTime.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Duration:</div>
          <div className="input-box-text"><input value={this.state.duration} onChange={this.changeDuration.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Media Type:</div>
          <div className="input-box-text">
            <select value={this.state.mediaType} onChange={this.changeMediaType.bind(this)}>
              {MediaTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">Need Password:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.needPassword} onChange={this.changeNeedPassword.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">Allow Guest Start Conf:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.allowGuestStartConf} onChange={this.changeAllowGuestStartConf.bind(this)} /></div>
        </div>
        <div className="input-box" style={{ display: 'flex', margin: '10px 0px' }}>
          <div className="input-box-title">Advance Conf Time:</div>
          <div className="input-box-text">
            <select value={this.state.allowGuestStartConfTime} disabled={this.state.allowGuestStartConfTimeDisable || !this.state.allowGuestStartConf} onChange={this.changeAllowGuestStartConfTime.bind(this)}>
              <option value="5">5 min</option>
              <option value="10">10 min</option>
              <option value="15">15 min</option>
              <option value="30">30 min</option>
              <option value="0">anytime</option>
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">isAutoRecord:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isAutoRecord} onChange={this.changeIsAutoRecord.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">allowRecord:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.allowRecord} onChange={this.changeAllowRecord.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">DefaultSummaryState:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.defaultSummaryState} onChange={this.changeDefaultSummaryState.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">AutoPublishSummary:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.autoPublishSummary} onChange={this.changeAutoPublishSummary.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Time Zone:</div>
          <div className="input-box-text"><input value={this.state.timezone} onChange={this.changeTimezone.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">Vmr Flag:</div>
          <div className="input-box-text-check"><input disabled={isUseShareVmr} type="checkbox" checked={this.state.vmrFlag} onChange={this.changeVmrFlag.bind(this)} /></div>
        </div>
        {isEnableShareVmr
          ? <div className="input-box">
          <div className="input-box-title-check">Use Share Vmr:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={isUseShareVmr} onChange={this.changeUseShareVmr.bind(this)} /></div>
        </div>
          : null}
        <div className="input-box">
          <div className="input-box-title">Vmr Id:</div>
          <div className="input-box-text">
            <select disabled={isUseShareVmr} value={this.state.vmrIndex} onChange={this.changeVmrIndex.bind(this)}>
              {
                vmrInfo.map((obj, index) => {
                  return (
                    <option value={index} key={index}>{obj.vmrConfId}</option>
                  )
                })
              }
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>VmrConfIdType:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select disabled={isUseShareVmr || vmrConfIdTypeDisable} value={this.state.vmrConfIdType} onChange={this.changeVmrConfIdType.bind(this)}>
              {VmrConfIdTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Guest pass:</div>
          <div className="input-box-text"><input value={this.state.guestPwd} disabled={this.state.guestPwdDisable} onChange={this.changeGuestPwd.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>ConfAllowJoinUser:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select value={this.state.confAllowJoinUser} onChange={this.changeConfAllowJoinUser.bind(this)}>
              {ConfAllowJoinUserTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsSendSms:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isSendSms} onChange={this.changeIsSendSms.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsSendEmail:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isSendEmail} onChange={this.changeIsSendEmail.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsSendCalendar:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isSendCalendar} onChange={this.changeIsSendCalendar.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">IsOpenWaitingRoom:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.isOpenWaitingRoom} onChange={this.changeIsOpenWaitingRoom.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">ForbiddenScreenShots:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.forbiddenScreenShots} onChange={this.changeForbiddenScreenShots.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">SupportWatermark:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.supportWatermark} onChange={this.changeSupportWatermark.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">AttendeesExcludeSelf:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.attendeesExcludeSelf} onChange={this.changeAttendeesExcludeSelf.bind(this)} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">SoftTerminalAutoMute:</div>
          <div className="input-box-text-check">
            <select value={autoMuteMode} onChange={this.changeSoftTerminalAutoMute}>
              {TerminalAutoMuteTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">HardTerminalAutoMute:</div>
          <div className="input-box-text-check">
            <select value={hardTerminalAutoMuteMode} onChange={this.changeHardTerminalAutoMuteMode}>
              {TerminalAutoMuteTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">concurrentParticipants:</div>
          <div className="input-box-text"><input value={this.state.concurrentParticipants} onChange={this.changeConcurrentParticipants.bind(this)} /></div>
        </div>
        <hr />
        <div className="input-box">
          <div className="input-box-title-check">Repeat:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={this.state.showCycleConf} onChange={this.changeShowCycleConf.bind(this)} /></div>
        </div>
        {showCycleConf && <React.Fragment>
          <div className="input-box">
            <div className="input-box-title">cycleType:</div>
            <div className="input-box-text">
              <select value={cycleType} onChange={e => this.setState({ cycleParam: { ...cycleParam, cycleType: Number(e.target.value) } })}>
                {getCycleTypeOptions().map((item) => {
                  const { label, value } = item
                  return <option key={value} value={value} title={label}>{label}</option>
                })}
              </select>
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">interval:</div>
            <div className="input-box-text">
              <select value={interval} onChange={e => this.setState({ cycleParam: { ...cycleParam, interval: Number(e.target.value) } })}>
                {intervalOptions.map((item) => {
                  const { label, value } = item
                  return <option key={value} value={value} title={label}>{label}</option>
                })}
              </select>
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">listPoints:</div>
            <div className="input-box-text">
              <input value={listPoints}
                onChange={e => this.setState({ cycleParam: { ...cycleParam, listPoints: e.target.value } })}
                placeholder={listPointsExample}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">preRemindDays:</div>
            <div className="input-box-text">
              <input value={preRemindDays}
                onChange={e => this.setState({ cycleParam: { ...cycleParam, preRemindDays: Number(e.target.value) } })}
              />
            </div>
          </div>
          <div className="input-box">
            <div className="input-box-title">endDate:</div>
            <div className="input-box-text">
              <input value={endTimeStampStr} onChange={e => this.changeEndDateStr(e)} />
            </div>
          </div>
        </React.Fragment>}
        <div className="input-box-long">
          <div className="input-box-title-long">Attendees:</div>
          <div className="input-box-edit"><textarea value={this.state.attendees} onChange={this.changeAttendees.bind(this)} placeholder={this.state.attendeesExample} /></div>
        </div>
        <div className="input-box-long">
          <div className="input-box-title-long">User Data:</div>
          <div className="input-box-edit"><textarea value={this.state.customInfo} onChange={this.changeCustomInfo.bind(this)} /></div>
        </div>
        <button onClick={this.goToBookConf.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

BookConf.propTypes = {
  deployType: PropTypes.oneOf([DeployType.SINK_MODE, DeployType.CLOUD_MODE]),
}

const mapStateToProps = (state) => {
  const { deployType } = state.setting.deploy
  return { deployType }
}

export default connect(mapStateToProps)(BookConf)
