import React from 'react'
import moment from 'moment-timezone'

import './index.css'
import ApiService from '../../../AppService/ApiService'
import { MediaTypeOptions, ConfAllowJoinUserTypeOptions } from '../../../Constants/typeOption'
import { showErrorTips } from '../../../utils'

const FORMAT_DATE_MINUTE = 'YYYY-MM-DD HH:mm'
class EditCycleSubConf extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      confId: '',
      subConfID: '',
      startTimeStampStr: '',
      duration: 0,
      isAutoRecord: false,
      confAllowJoinUser: 0,
      mediaType: 0,
      allowGuestStartConf: true,
      allowGuestStartConfTime: 0,
    }
  }

  componentDidMount () {
    const { confId, allowGuestStartConfTimeDisable, vmrId, guestPwd, vmrName, hostPwd } = this.props
    const {
      subConfID,
      startTimeStamp,
      endTimeStamp,
      isAutoRecord,
      confAllowJoinUser,
      mediaType,
      recordAuthType,
      allowGuestStartConf,
      allowGuestStartConfTime,
    } = this.props.subConf
    const duration = (endTimeStamp - startTimeStamp) / 60
    this.setState({
      confId,
      subConfID,
      startTimeStampStr: moment.unix(startTimeStamp).format(FORMAT_DATE_MINUTE),
      duration,
      isAutoRecord,
      confAllowJoinUser,
      mediaType,
      recordAuthType,
      allowGuestStartConf,
      allowGuestStartConfTime,
      allowGuestStartConfTimeDisable,
      vmrId,
      guestPwd,
      vmrName,
      hostPwd,
    })
  }

  async editSubConf () {
    // 先处理来宾提前入会字段
    await this.dealAllowGuestStartConf()

    const { confId, onSuccess } = this.props
    const {
      subConfID,
      startTimeStampStr,
      duration,
      isAutoRecord,
      confAllowJoinUser,
      mediaType,
      recordAuthType,
      allowGuestStartConf,
      allowGuestStartConfTime,
    } = this.state
    const apiService = new ApiService()
    const param = {
      confId,
      subConfID,
      startTimeStamp: moment(startTimeStampStr).unix(),
      duration,
      isAutoRecord,
      confAllowJoinUser,
      mediaType,
      recordAuthType,
      allowGuestStartConf,
      allowGuestStartConfTime,
    }
    const setResult = await apiService.editCycleSubConf(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
    onSuccess()
  }

  changeStartTimeStr (e) {
    this.setState({
      startTimeStampStr: e.target.value,
    })
  }

  changeIsAutoRecord (e) {
    this.setState({
      isAutoRecord: e.target.checked,
    })
  }

  changeConfAllowJoinUser (e) {
    this.setState({
      confAllowJoinUser: Number(e.target.value),
    })
  }

  changeMediaType (e) {
    this.setState({
      mediaType: Number(e.target.value),
    })
  }

  changeAllowGuestStartConf (e) {
    this.setState({
      allowGuestStartConf: e.target.checked,
    })
  }

  changeAllowGuestStartConfTime (e) {
    this.setState({
      allowGuestStartConfTime: Number(e.target.value),
    })
  }

  async dealAllowGuestStartConf () {
    const { allowGuestStartConfTimeDisable, allowGuestStartConf, vmrId, guestPwd, vmrName, hostPwd } = this.state
    if (allowGuestStartConfTimeDisable) {
      const param = {
        vmrId,
        guestPwd,
        allowGuestStartConf,
        vmrName,
        hostPwd,
      }
      const apiService = new ApiService()
      const setResult = await apiService.changeVmrInfo(param)
      if (setResult.ret !== 0) {
        showErrorTips(setResult.ret, setResult.reason)
      }
    }
  }

  render () {
    const { onClose } = this.props
    const {
      startTimeStampStr,
      duration,
      isAutoRecord,
      confAllowJoinUser,
      mediaType,
      allowGuestStartConfTimeDisable,
    } = this.state
    return (
      <div className="modal edit-sub-conf">
        <div className="input-box">
          <div className="edit-sub-conf-close" onClick={onClose}>close</div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Start Time:</div>
          <div className="input-box-text"><input value={startTimeStampStr} onChange={e => this.changeStartTimeStr(e)}/></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">duration:</div>
          <div className="input-box-text"><input value={duration} onChange={e => this.setState({ duration: Number(e.target.value) })}/></div>
        </div>
        <div className="input-box">
            <div className="input-box-title" style={{ width: '140px' }}>ConfAllowJoinUser:</div>
            <div className="input-box-text" style={{ width: '85px' }}>
                <select value={confAllowJoinUser} onChange={this.changeConfAllowJoinUser.bind(this)}>
                    {ConfAllowJoinUserTypeOptions.map(item => {
                      return <option value={item.value} key={item.value}>{item.label}</option>
                    })}
                </select>
            </div>
        </div>
        <div className="input-box">
            <div className="input-box-title">Media Type:</div>
            <div className="input-box-text">
                <select value={mediaType} onChange={this.changeMediaType.bind(this)}>
                    {MediaTypeOptions.map(item => {
                      return <option value={item.value} key={item.value}>{item.label}</option>
                    })}
                </select>
            </div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check">isAutoRecord:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={isAutoRecord} onChange={this.changeIsAutoRecord.bind(this)}/></div>
        </div>
        <div className="input-box">
            <div className="input-box-title-check">Allow Guest Start Conf:</div>
            <div className="input-box-text-check"><input type="checkbox" checked={this.state.allowGuestStartConf} onChange={this.changeAllowGuestStartConf.bind(this)}/></div>
        </div>
        <div className="input-box" style={{ display: 'flex', margin: '10px 0px' }}>
            <div className="input-box-title">Advance Conf Time:</div>
            <div className="input-box-text">
                <select value={this.state.allowGuestStartConfTime} disabled={allowGuestStartConfTimeDisable || !this.state.allowGuestStartConf} onChange={this.changeAllowGuestStartConfTime.bind(this)}>
                    <option value ="5">5 min</option>
                    <option value ="10">10 min</option>
                    <option value ="15">15 min</option>
                    <option value ="30">30 min</option>
                    <option value ="0">anytime</option>
                </select>
            </div>
        </div>
        <div className="input-box">
          <button onClick={onClose}>Cancel</button>
        </div>
        <div className="input-box">
          <button onClick={this.editSubConf.bind(this)}>OK</button>
        </div>
      </div>
    )
  }
}

export default EditCycleSubConf
