import { ConfRole, ForbiddenScreenShotsEnableType, LocalRecordOperateType, TargetLanguageType, UserState, SDKERR} from './enum';
import { AcceptConfParam, AddAttendeeInfo, AddAttendeeResultList, AnnotationSaveConfigInfo, AnnotationStateInfo, AnnotationWndInfo, AttendeeListInfo, AutoHideToolBarParam, ConfEndInfo, ConfInfo, ConfStateInfo, CreateConfInfo, CreateConfResult, InterruptInfo, JoinConfByIdInfo, JoinConfByRandomInfo, LocalRecordPermissionInfo, LocalRecordStateInfo, LocalRecordStatusInfo, MeetingInfo, P2PConfRecordInfo, PoorNetWorkQualityInfo, RealTimeSubtitleInfo, RecvShareStateInfo, RemoteControlStateInfo, RenameSelfInfo, SelfShareStateInfo, ShareStateInfo, SpeakerList, StartCallInfo, StartProjectionParam, StartProjectionResult, StartShareInfo, SubtitleRecordInfo, TargetLanguageTypeList, VideoStreamTypeInfo, WatchListInfo} from './model';
import { needCallWithIPC } from './util';
const electron = (typeof window !== 'undefined') ? (window as any).require('electron') : require('electron');

export class IConfCtrl {
	addOn!: IConfCtrl;
	_onConfStateChangedCallback!: (confStateInfo: ConfStateInfo) => void;
	_onConfEndedNotifyCallback!: (confEndInfo: ConfEndInfo) => void;
	_onP2PConfRecordNotifyCallback!: (recordInfo: P2PConfRecordInfo) => void;
	_onConfInfoNotifyCallback!: (confInfo: ConfInfo) => void;
	_onShareStateChangedCallback!: (shareStateInfo: ShareStateInfo) => void;
	_onRecvShareStateChangedCallback!: (shareStateInfo: RecvShareStateInfo) => void;
	_onSelfRoleChangedCallback!: (role: ConfRole) => void;
	_onPoorNetworkQualityInfoNotifyCallback!: (poorNetWorkInfo: PoorNetWorkQualityInfo) => void;
	_onMeetingInfoChangedCallback!: (meetingInfo: MeetingInfo) => void;
	_onWaitingListChangedCallback!: (waitingList: AttendeeListInfo) => void;
	_onAddAttendeeNotifyCallback!: (addAttendeeResultList: AddAttendeeResultList) => void;
	_onSelfLocalRecordStateNotifyCallback!: (localRecordStateInfo: LocalRecordStateInfo) => void;
	_onAttendeeListChangedCallback!: (attendeeList: AttendeeListInfo) => void;
	_onRealTimeSubtitleInfoNotifyCallback!: (realTimeSubtitleInfo: RealTimeSubtitleInfo) => void;
	_onSubtitleRecordNotifyCallback!: (subtitleRecordInfo: SubtitleRecordInfo) => void;
	_onSubtitleStateChangedCallback!: (isOpen: boolean) => void;
	_onWaitingRoomStateChangedCallback!: (isOpen: boolean) => void;
	_onStartLocalRecordOperationInterruptNotifyCallback!: (info: InterruptInfo) => void;
	_onConfForbiddenScreenShotsEnableChangedCallback!: (enableType: ForbiddenScreenShotsEnableType) => void;
	_createConfCallback!: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void;
	_startP2pConfCallback!: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void;
	_joinConfByIdCallback!: (ret: SDKERR, reason: string) => void;
	_joinConfByRandomCallback!: (ret: SDKERR, reason: string) => void;
	_addAttendeeCallback!: (ret: SDKERR, reason: string) => void;
	_leaveConfCallback!: (ret: SDKERR, reason: string) => void;
	_endConfCallback!: (ret: SDKERR, reason: string) => void;
	_startShareCallback!: (ret: SDKERR, reason: string) => void;
	_stopShareCallback!: (ret: SDKERR, reason: string) => void;
	_getAttendeeListCallback!: (ret: SDKERR, reason: string, attendeeList: AttendeeListInfo) => void;
	_getAudienceListCallback!: (ret: SDKERR, reason: string, audidenceList: AttendeeListInfo) => void;
	_getUserStateCallback!: (ret: SDKERR, reason: string, userState: UserState) => void;
	_getSelfRoleCallback!: (ret: SDKERR, reason: string, selfRole: ConfRole) => void;
	_renameSelfCallback!: (ret: SDKERR, reason: string) => void;
	_startProjectionCallback!: (ret: SDKERR, reason: string, startProjectionResult: StartProjectionResult) => void;
	_acceptConfCallback!: (ret: SDKERR, reason: string) => void;
	_rejectConfCallback!: (ret: SDKERR, reason: string) => void;
	_getSelfShareStateCallback!: (ret: SDKERR, reason: string, selfShareStateInfo: SelfShareStateInfo) => void;
	_openSubtitleCallback!: (ret: SDKERR, reason: string, isOpen: boolean) => void;
	_openWaitingRoomCallback!: (ret: SDKERR, reason: string, isOpen: boolean) => void;
	_operateLocalRecordCallback!: (ret: SDKERR, reason: string, type: LocalRecordOperateType) => void;
	_openVirtualBackgroundSettingPageCallback!: (ret: SDKERR, reason: string) => void;
	_getConfLocalRecordStatusCallback!: (ret: SDKERR, reason: string, state: LocalRecordStatusInfo) => void;
	_getSelfHasLocalRecordPermissionCallback!: (ret: SDKERR, reason: string, permission: LocalRecordPermissionInfo) => void;
	_requestLocalRecordPermissionCallback!: (ret: SDKERR, reason: string) => void;
	_applyHostRoleCallback!: (ret: SDKERR, reason: string) => void;
	_getSubtitlePageOpenedCallback!: (ret: SDKERR, reason: string, isOpen: boolean) => void;
	_getWaitingRoomOpenedCallback!: (ret: SDKERR, reason: string, isOpen: boolean) => void;
	_getVirtualBackgroundSettingPageOpenedCallback!: (ret: SDKERR, reason: string, isOpen: boolean) => void;
	_subscribeSubtitleLanguageCallback!: (ret: SDKERR, reason: string, targetLanguageType: TargetLanguageType) => void;
	_subscribeSubtitleCallback!: (ret: SDKERR, reason: string, isSubscirbe: boolean) => void;
	_getSubtitleSupportLanguageCallback!: (ret: SDKERR, reason: string, targetLanguageTypeList: TargetLanguageTypeList) => void;
	_inProcessCallbackSet!: Set<string>;
	callWithIPC: boolean = false;
	constructor(addOn: IConfCtrl) {
		this.addOn = addOn;
		this._inProcessCallbackSet = new Set<string>();
		this.callWithIPC = needCallWithIPC();
	}

	init(): void {
		this._inProcessCallbackSet.clear();
	}

	/**
	* [en] Notify of conf state. [cn] 会议状态通知
	*/
	setOnConfStateChangedCB(onConfStateChanged: (confStateInfo: ConfStateInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnConfStateChangedCB', {});
			electron.ipcRenderer.on('onConfStateChanged', (event: any, arg: any) => {
				if (onConfStateChanged) {
					onConfStateChanged(arg["confStateInfo"])
				}
			});
			return;
		}

		this._onConfStateChangedCallback = (confStateInfo: ConfStateInfo) => {
			if (onConfStateChanged) {
				onConfStateChanged(confStateInfo);
			}
		}
		this.addOn.setOnConfStateChangedCB(this._onConfStateChangedCallback);
	}

	/**
	* [en] This class is about the notification of an ended conference. [cn] 会议结束通知
	*/
	setOnConfEndedNotifyCB(onConfEndedNotify: (confEndInfo: ConfEndInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnConfEndedNotifyCB', {});
			electron.ipcRenderer.on('onConfEndedNotify', (event: any, arg: any) => {
				if (onConfEndedNotify) {
					onConfEndedNotify(arg["confEndInfo"])
				}
			});
			return;
		}

		this._onConfEndedNotifyCallback = (confEndInfo: ConfEndInfo) => {
			if (onConfEndedNotify) {
				onConfEndedNotify(confEndInfo);
			}
		}
		this.addOn.setOnConfEndedNotifyCB(this._onConfEndedNotifyCallback);
	}

	/**
	* [en] This class is about the callback of transfering point to point call to conference. [cn] 立即会议记录回调
	*/
	setOnP2PConfRecordNotifyCB(onP2PConfRecordNotify: (recordInfo: P2PConfRecordInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnP2PConfRecordNotifyCB', {});
			electron.ipcRenderer.on('onP2PConfRecordNotify', (event: any, arg: any) => {
				if (onP2PConfRecordNotify) {
					onP2PConfRecordNotify(arg["recordInfo"])
				}
			});
			return;
		}

		this._onP2PConfRecordNotifyCallback = (recordInfo: P2PConfRecordInfo) => {
			if (onP2PConfRecordNotify) {
				onP2PConfRecordNotify(recordInfo);
			}
		}
		this.addOn.setOnP2PConfRecordNotifyCB(this._onP2PConfRecordNotifyCallback);
	}

	/**
	* [en] Notify of conf info. [cn] 会议信息通知
	*/
	setOnConfInfoNotifyCB(onConfInfoNotify: (confInfo: ConfInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnConfInfoNotifyCB', {});
			electron.ipcRenderer.on('onConfInfoNotify', (event: any, arg: any) => {
				if (onConfInfoNotify) {
					onConfInfoNotify(arg["confInfo"])
				}
			});
			return;
		}

		this._onConfInfoNotifyCallback = (confInfo: ConfInfo) => {
			if (onConfInfoNotify) {
				onConfInfoNotify(confInfo);
			}
		}
		this.addOn.setOnConfInfoNotifyCB(this._onConfInfoNotifyCallback);
	}

	/**
	* [en] Notify of share state. [cn] 共享状态通知
	*/
	setOnShareStateChangedCB(onShareStateChanged: (shareStateInfo: ShareStateInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnShareStateChangedCB', {});
			electron.ipcRenderer.on('onShareStateChanged', (event: any, arg: any) => {
				if (onShareStateChanged) {
					onShareStateChanged(arg["shareStateInfo"])
				}
			});
			return;
		}

		this._onShareStateChangedCallback = (shareStateInfo: ShareStateInfo) => {
			if (onShareStateChanged) {
				onShareStateChanged(shareStateInfo);
			}
		}
		this.addOn.setOnShareStateChangedCB(this._onShareStateChangedCallback);
	}

	/**
	* [en] Notify of receive share state. [cn] 收到共享状态通知
	*/
	setOnRecvShareStateChangedCB(onRecvShareStateChanged: (shareStateInfo: RecvShareStateInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnRecvShareStateChangedCB', {});
			electron.ipcRenderer.on('onRecvShareStateChanged', (event: any, arg: any) => {
				if (onRecvShareStateChanged) {
					onRecvShareStateChanged(arg["shareStateInfo"])
				}
			});
			return;
		}

		this._onRecvShareStateChangedCallback = (shareStateInfo: RecvShareStateInfo) => {
			if (onRecvShareStateChanged) {
				onRecvShareStateChanged(shareStateInfo);
			}
		}
		this.addOn.setOnRecvShareStateChangedCB(this._onRecvShareStateChangedCallback);
	}

	/**
	* [en] Self role changed. [cn] 个人角色变化通知
	*/
	setOnSelfRoleChangedCB(onSelfRoleChanged: (role: ConfRole) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnSelfRoleChangedCB', {});
			electron.ipcRenderer.on('onSelfRoleChanged', (event: any, arg: any) => {
				if (onSelfRoleChanged) {
					onSelfRoleChanged(arg["role"])
				}
			});
			return;
		}

		this._onSelfRoleChangedCallback = (role: ConfRole) => {
			if (onSelfRoleChanged) {
				onSelfRoleChanged(role);
			}
		}
		this.addOn.setOnSelfRoleChangedCB(this._onSelfRoleChangedCallback);
	}

	/**
	* [en] This class is about the notification of low quality network. [cn] 弱网提示通知
	*/
	setOnPoorNetworkQualityInfoNotifyCB(onPoorNetworkQualityInfoNotify: (poorNetWorkInfo: PoorNetWorkQualityInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnPoorNetworkQualityInfoNotifyCB', {});
			electron.ipcRenderer.on('onPoorNetworkQualityInfoNotify', (event: any, arg: any) => {
				if (onPoorNetworkQualityInfoNotify) {
					onPoorNetworkQualityInfoNotify(arg["poorNetWorkInfo"])
				}
			});
			return;
		}

		this._onPoorNetworkQualityInfoNotifyCallback = (poorNetWorkInfo: PoorNetWorkQualityInfo) => {
			if (onPoorNetworkQualityInfoNotify) {
				onPoorNetworkQualityInfoNotify(poorNetWorkInfo);
			}
		}
		this.addOn.setOnPoorNetworkQualityInfoNotifyCB(this._onPoorNetworkQualityInfoNotifyCallback);
	}

	/**
	* [en]Notify of conf info [cn]会中信息更新通知
	*/
	setOnMeetingInfoChangedCB(onMeetingInfoChanged: (meetingInfo: MeetingInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnMeetingInfoChangedCB', {});
			electron.ipcRenderer.on('onMeetingInfoChanged', (event: any, arg: any) => {
				if (onMeetingInfoChanged) {
					onMeetingInfoChanged(arg["meetingInfo"])
				}
			});
			return;
		}

		this._onMeetingInfoChangedCallback = (meetingInfo: MeetingInfo) => {
			if (onMeetingInfoChanged) {
				onMeetingInfoChanged(meetingInfo);
			}
		}
		this.addOn.setOnMeetingInfoChangedCB(this._onMeetingInfoChangedCallback);
	}

	/**
	* [en] Notify of the waiting list [cn] 等候室成员列表变更的通知
	*/
	setOnWaitingListChangedCB(onWaitingListChanged: (waitingList: AttendeeListInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnWaitingListChangedCB', {});
			electron.ipcRenderer.on('onWaitingListChanged', (event: any, arg: any) => {
				if (onWaitingListChanged) {
					onWaitingListChanged(arg["waitingList"])
				}
			});
			return;
		}

		this._onWaitingListChangedCallback = (waitingList: AttendeeListInfo) => {
			if (onWaitingListChanged) {
				onWaitingListChanged(waitingList);
			}
		}
		this.addOn.setOnWaitingListChangedCB(this._onWaitingListChangedCallback);
	}

	/**
	* [en] Notify of the add attendee [cn] 添加与会者结果通知
	*/
	setOnAddAttendeeNotifyCB(onAddAttendeeNotify: (addAttendeeResultList: AddAttendeeResultList) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnAddAttendeeNotifyCB', {});
			electron.ipcRenderer.on('onAddAttendeeNotify', (event: any, arg: any) => {
				if (onAddAttendeeNotify) {
					onAddAttendeeNotify(arg["addAttendeeResultList"])
				}
			});
			return;
		}

		this._onAddAttendeeNotifyCallback = (addAttendeeResultList: AddAttendeeResultList) => {
			if (onAddAttendeeNotify) {
				onAddAttendeeNotify(addAttendeeResultList);
			}
		}
		this.addOn.setOnAddAttendeeNotifyCB(this._onAddAttendeeNotifyCallback);
	}

	/**
	* [en] Notify of local record state [cn] 本地录制状态通知
	*/
	setOnSelfLocalRecordStateNotifyCB(onSelfLocalRecordStateNotify: (localRecordStateInfo: LocalRecordStateInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnSelfLocalRecordStateNotifyCB', {});
			electron.ipcRenderer.on('onSelfLocalRecordStateNotify', (event: any, arg: any) => {
				if (onSelfLocalRecordStateNotify) {
					onSelfLocalRecordStateNotify(arg["localRecordStateInfo"])
				}
			});
			return;
		}

		this._onSelfLocalRecordStateNotifyCallback = (localRecordStateInfo: LocalRecordStateInfo) => {
			if (onSelfLocalRecordStateNotify) {
				onSelfLocalRecordStateNotify(localRecordStateInfo);
			}
		}
		this.addOn.setOnSelfLocalRecordStateNotifyCB(this._onSelfLocalRecordStateNotifyCallback);
	}

	/**
	* [en] Notify of the attendee list [cn] 与会者列表变更的通知
	*/
	setOnAttendeeListChangedCB(onAttendeeListChanged: (attendeeList: AttendeeListInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnAttendeeListChangedCB', {});
			electron.ipcRenderer.on('onAttendeeListChanged', (event: any, arg: any) => {
				if (onAttendeeListChanged) {
					onAttendeeListChanged(arg["attendeeList"])
				}
			});
			return;
		}

		this._onAttendeeListChangedCallback = (attendeeList: AttendeeListInfo) => {
			if (onAttendeeListChanged) {
				onAttendeeListChanged(attendeeList);
			}
		}
		this.addOn.setOnAttendeeListChangedCB(this._onAttendeeListChangedCallback);
	}

	/**
	* [en] Notify of the real time subtitle info [cn] 实时字幕信息的通知
	*/
	setOnRealTimeSubtitleInfoNotifyCB(onRealTimeSubtitleInfoNotify: (realTimeSubtitleInfo: RealTimeSubtitleInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnRealTimeSubtitleInfoNotifyCB', {});
			electron.ipcRenderer.on('onRealTimeSubtitleInfoNotify', (event: any, arg: any) => {
				if (onRealTimeSubtitleInfoNotify) {
					onRealTimeSubtitleInfoNotify(arg["realTimeSubtitleInfo"])
				}
			});
			return;
		}

		this._onRealTimeSubtitleInfoNotifyCallback = (realTimeSubtitleInfo: RealTimeSubtitleInfo) => {
			if (onRealTimeSubtitleInfoNotify) {
				onRealTimeSubtitleInfoNotify(realTimeSubtitleInfo);
			}
		}
		this.addOn.setOnRealTimeSubtitleInfoNotifyCB(this._onRealTimeSubtitleInfoNotifyCallback);
	}

	/**
	* [en] Notify of the subtitle record info [cn] 字幕记录消息的通知
	*/
	setOnSubtitleRecordNotifyCB(onSubtitleRecordNotify: (subtitleRecordInfo: SubtitleRecordInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnSubtitleRecordNotifyCB', {});
			electron.ipcRenderer.on('onSubtitleRecordNotify', (event: any, arg: any) => {
				if (onSubtitleRecordNotify) {
					onSubtitleRecordNotify(arg["subtitleRecordInfo"])
				}
			});
			return;
		}

		this._onSubtitleRecordNotifyCallback = (subtitleRecordInfo: SubtitleRecordInfo) => {
			if (onSubtitleRecordNotify) {
				onSubtitleRecordNotify(subtitleRecordInfo);
			}
		}
		this.addOn.setOnSubtitleRecordNotifyCB(this._onSubtitleRecordNotifyCallback);
	}

	/**
	* [en] Notify of subtitle state change [cn] 字幕状态变更通知
	*/
	setOnSubtitleStateChangedCB(onSubtitleStateChanged: (isOpen: boolean) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnSubtitleStateChangedCB', {});
			electron.ipcRenderer.on('onSubtitleStateChanged', (event: any, arg: any) => {
				if (onSubtitleStateChanged) {
					onSubtitleStateChanged(arg["isOpen"])
				}
			});
			return;
		}

		this._onSubtitleStateChangedCallback = (isOpen: boolean) => {
			if (onSubtitleStateChanged) {
				onSubtitleStateChanged(isOpen);
			}
		}
		this.addOn.setOnSubtitleStateChangedCB(this._onSubtitleStateChangedCallback);
	}

	/**
	* [en] Notify of waiting room state change [cn] 等候室状态变更通知
	*/
	setOnWaitingRoomStateChangedCB(onWaitingRoomStateChanged: (isOpen: boolean) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnWaitingRoomStateChangedCB', {});
			electron.ipcRenderer.on('onWaitingRoomStateChanged', (event: any, arg: any) => {
				if (onWaitingRoomStateChanged) {
					onWaitingRoomStateChanged(arg["isOpen"])
				}
			});
			return;
		}

		this._onWaitingRoomStateChangedCallback = (isOpen: boolean) => {
			if (onWaitingRoomStateChanged) {
				onWaitingRoomStateChanged(isOpen);
			}
		}
		this.addOn.setOnWaitingRoomStateChangedCB(this._onWaitingRoomStateChangedCallback);
	}

	/**
	* [en] Notify of local record operation interrupt notify [cn] 本地录制操作中断通知
	*/
	setOnStartLocalRecordOperationInterruptNotifyCB(onStartLocalRecordOperationInterruptNotify: (info: InterruptInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnStartLocalRecordOperationInterruptNotifyCB', {});
			electron.ipcRenderer.on('onStartLocalRecordOperationInterruptNotify', (event: any, arg: any) => {
				if (onStartLocalRecordOperationInterruptNotify) {
					onStartLocalRecordOperationInterruptNotify(arg["info"])
				}
			});
			return;
		}

		this._onStartLocalRecordOperationInterruptNotifyCallback = (info: InterruptInfo) => {
			if (onStartLocalRecordOperationInterruptNotify) {
				onStartLocalRecordOperationInterruptNotify(info);
			}
		}
		this.addOn.setOnStartLocalRecordOperationInterruptNotifyCB(this._onStartLocalRecordOperationInterruptNotifyCallback);
	}

	/**
	* [en]Notify of forbidden screenshots enabletype changed [cn]禁止截屏开关状态变更
	*/
	setOnConfForbiddenScreenShotsEnableChangedCB(onConfForbiddenScreenShotsEnableChanged: (enableType: ForbiddenScreenShotsEnableType) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnConfForbiddenScreenShotsEnableChangedCB', {});
			electron.ipcRenderer.on('onConfForbiddenScreenShotsEnableChanged', (event: any, arg: any) => {
				if (onConfForbiddenScreenShotsEnableChanged) {
					onConfForbiddenScreenShotsEnableChanged(arg["enableType"])
				}
			});
			return;
		}

		this._onConfForbiddenScreenShotsEnableChangedCallback = (enableType: ForbiddenScreenShotsEnableType) => {
			if (onConfForbiddenScreenShotsEnableChanged) {
				onConfForbiddenScreenShotsEnableChanged(enableType);
			}
		}
		this.addOn.setOnConfForbiddenScreenShotsEnableChangedCB(this._onConfForbiddenScreenShotsEnableChangedCallback);
	}

	/**
	* [en] This interface is used to create conf. [cn] 创建会议
	*/
	createConf(createConfInfo: CreateConfInfo, onCreateConfResult?: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void): void {
		if (this._inProcessCallbackSet.has("createConf")) {
			if (onCreateConfResult) {
				let nullResult = <CreateConfResult>{};
				onCreateConfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("createConf");
		this._createConfCallback = (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => {
			this._inProcessCallbackSet.delete("createConf");
			if (onCreateConfResult) {
				onCreateConfResult(ret, reason, createConfResult);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('createConf', {"createConfInfo":createConfInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('createConf');
				if (onCreateConfResult) {
					onCreateConfResult(ret["ret"], ret["reason"], ret["createConfResult"]);
				}
			});
		}

		this.addOn.createConf(createConfInfo, this._createConfCallback);
	}

	/**
	* [en] This interface is used to start p2p conf. [cn] 发起立即会议
	*/
	startP2pConf(startCallInfo: StartCallInfo, onStartP2pConfResult?: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void): void {
		if (this._inProcessCallbackSet.has("startP2pConf")) {
			if (onStartP2pConfResult) {
				let nullResult = <CreateConfResult>{};
				onStartP2pConfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("startP2pConf");
		this._startP2pConfCallback = (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => {
			this._inProcessCallbackSet.delete("startP2pConf");
			if (onStartP2pConfResult) {
				onStartP2pConfResult(ret, reason, createConfResult);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('startP2pConf', {"startCallInfo":startCallInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('startP2pConf');
				if (onStartP2pConfResult) {
					onStartP2pConfResult(ret["ret"], ret["reason"], ret["createConfResult"]);
				}
			});
		}

		this.addOn.startP2pConf(startCallInfo, this._startP2pConfCallback);
	}

	/**
	* [en] This interface is used to join conf by id. [cn] 加入会议
	*/
	joinConfById(joinConfByIdInfo: JoinConfByIdInfo, onJoinConfByIdResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("joinConfById")) {
			if (onJoinConfByIdResult) {
				onJoinConfByIdResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("joinConfById");
		this._joinConfByIdCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("joinConfById");
			if (onJoinConfByIdResult) {
				onJoinConfByIdResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('joinConfById', {"joinConfByIdInfo":joinConfByIdInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('joinConfById');
				if (onJoinConfByIdResult) {
					onJoinConfByIdResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.joinConfById(joinConfByIdInfo, this._joinConfByIdCallback);
	}

	/**
	* [en] This interface is used to join conf by random. [cn] Random入会
	*/
	joinConfByRandom(joinConfByRandomInfo: JoinConfByRandomInfo, onJoinConfByRandomResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("joinConfByRandom")) {
			if (onJoinConfByRandomResult) {
				onJoinConfByRandomResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("joinConfByRandom");
		this._joinConfByRandomCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("joinConfByRandom");
			if (onJoinConfByRandomResult) {
				onJoinConfByRandomResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('joinConfByRandom', {"joinConfByRandomInfo":joinConfByRandomInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('joinConfByRandom');
				if (onJoinConfByRandomResult) {
					onJoinConfByRandomResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.joinConfByRandom(joinConfByRandomInfo, this._joinConfByRandomCallback);
	}

	/**
	* [en] This interface is used to add attendee. [cn] 添加与会者
	*/
	addAttendee(addAttendeeInfo: AddAttendeeInfo, onAddAttendeeResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("addAttendee")) {
			if (onAddAttendeeResult) {
				onAddAttendeeResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("addAttendee");
		this._addAttendeeCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("addAttendee");
			if (onAddAttendeeResult) {
				onAddAttendeeResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('addAttendee', {"addAttendeeInfo":addAttendeeInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('addAttendee');
				if (onAddAttendeeResult) {
					onAddAttendeeResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.addAttendee(addAttendeeInfo, this._addAttendeeCallback);
	}

	/**
	* [en] This interface is used to leave conf. [cn] 离开会议
	*/
	leaveConf(onLeaveConfResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("leaveConf")) {
			if (onLeaveConfResult) {
				onLeaveConfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("leaveConf");
		this._leaveConfCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("leaveConf");
			if (onLeaveConfResult) {
				onLeaveConfResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('leaveConf', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('leaveConf');
				if (onLeaveConfResult) {
					onLeaveConfResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.leaveConf(this._leaveConfCallback);
	}

	/**
	* [en] This interface is used to end conf. [cn] 结束会议
	*/
	endConf(onEndConfResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("endConf")) {
			if (onEndConfResult) {
				onEndConfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("endConf");
		this._endConfCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("endConf");
			if (onEndConfResult) {
				onEndConfResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('endConf', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('endConf');
				if (onEndConfResult) {
					onEndConfResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.endConf(this._endConfCallback);
	}

	/**
	* [en] This interface is used to start share. [cn] 开启共享
	*/
	startShare(startShareInfo: StartShareInfo, onStartShareResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("startShare")) {
			if (onStartShareResult) {
				onStartShareResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("startShare");
		this._startShareCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("startShare");
			if (onStartShareResult) {
				onStartShareResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('startShare', {"startShareInfo":startShareInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('startShare');
				if (onStartShareResult) {
					onStartShareResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.startShare(startShareInfo, this._startShareCallback);
	}

	/**
	* [en] This interface is used to stop share. [cn] 结束共享
	*/
	stopShare(onStopShareResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("stopShare")) {
			if (onStopShareResult) {
				onStopShareResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("stopShare");
		this._stopShareCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("stopShare");
			if (onStopShareResult) {
				onStopShareResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('stopShare', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('stopShare');
				if (onStopShareResult) {
					onStopShareResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.stopShare(this._stopShareCallback);
	}

	/**
	* [en] This interface is used to get attendee List. [cn] 获取与会者列表
	*/
	getAttendeeList(onGetAttendeeListResult?: (ret: SDKERR, reason: string, attendeeList: AttendeeListInfo) => void): void {
		if (this._inProcessCallbackSet.has("getAttendeeList")) {
			if (onGetAttendeeListResult) {
				let nullResult = <AttendeeListInfo>{};
				onGetAttendeeListResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getAttendeeList");
		this._getAttendeeListCallback = (ret: SDKERR, reason: string, attendeeList: AttendeeListInfo) => {
			this._inProcessCallbackSet.delete("getAttendeeList");
			if (onGetAttendeeListResult) {
				onGetAttendeeListResult(ret, reason, attendeeList);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getAttendeeList', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getAttendeeList');
				if (onGetAttendeeListResult) {
					onGetAttendeeListResult(ret["ret"], ret["reason"], ret["attendeeList"]);
				}
			});
		}

		this.addOn.getAttendeeList(this._getAttendeeListCallback);
	}

	/**
	* [en] This interface is used to get audience List. [cn] 获取观众列表
	*/
	getAudienceList(onGetAudienceListResult?: (ret: SDKERR, reason: string, audidenceList: AttendeeListInfo) => void): void {
		if (this._inProcessCallbackSet.has("getAudienceList")) {
			if (onGetAudienceListResult) {
				let nullResult = <AttendeeListInfo>{};
				onGetAudienceListResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getAudienceList");
		this._getAudienceListCallback = (ret: SDKERR, reason: string, audidenceList: AttendeeListInfo) => {
			this._inProcessCallbackSet.delete("getAudienceList");
			if (onGetAudienceListResult) {
				onGetAudienceListResult(ret, reason, audidenceList);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getAudienceList', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getAudienceList');
				if (onGetAudienceListResult) {
					onGetAudienceListResult(ret["ret"], ret["reason"], ret["audidenceList"]);
				}
			});
		}

		this.addOn.getAudienceList(this._getAudienceListCallback);
	}

	/**
	* [en] This interface is used to get user state. [cn] 获取用户状态
	*/
	getUserState(onGetUserStateResult?: (ret: SDKERR, reason: string, userState: UserState) => void): void {
		if (this._inProcessCallbackSet.has("getUserState")) {
			if (onGetUserStateResult) {
				let nullResult = <UserState>{};
				onGetUserStateResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getUserState");
		this._getUserStateCallback = (ret: SDKERR, reason: string, userState: UserState) => {
			this._inProcessCallbackSet.delete("getUserState");
			if (onGetUserStateResult) {
				onGetUserStateResult(ret, reason, userState);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getUserState', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getUserState');
				if (onGetUserStateResult) {
					onGetUserStateResult(ret["ret"], ret["reason"], ret["userState"]);
				}
			});
		}

		this.addOn.getUserState(this._getUserStateCallback);
	}

	/**
	* [en] This interface is used to get self role. [cn] 获取自己会中角色
	*/
	getSelfRole(onGetSelfRoleResult?: (ret: SDKERR, reason: string, selfRole: ConfRole) => void): void {
		if (this._inProcessCallbackSet.has("getSelfRole")) {
			if (onGetSelfRoleResult) {
				let nullResult = <ConfRole>{};
				onGetSelfRoleResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getSelfRole");
		this._getSelfRoleCallback = (ret: SDKERR, reason: string, selfRole: ConfRole) => {
			this._inProcessCallbackSet.delete("getSelfRole");
			if (onGetSelfRoleResult) {
				onGetSelfRoleResult(ret, reason, selfRole);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getSelfRole', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getSelfRole');
				if (onGetSelfRoleResult) {
					onGetSelfRoleResult(ret["ret"], ret["reason"], ret["selfRole"]);
				}
			});
		}

		this.addOn.getSelfRole(this._getSelfRoleCallback);
	}

	/**
	* [en] This interface is used to rename self. [cn] 设置会场名
	*/
	renameSelf(renameSelfInfo: RenameSelfInfo, onRenameSelfResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("renameSelf")) {
			if (onRenameSelfResult) {
				onRenameSelfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("renameSelf");
		this._renameSelfCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("renameSelf");
			if (onRenameSelfResult) {
				onRenameSelfResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('renameSelf', {"renameSelfInfo":renameSelfInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('renameSelf');
				if (onRenameSelfResult) {
					onRenameSelfResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.renameSelf(renameSelfInfo, this._renameSelfCallback);
	}

	/**
	* [en] This interface is used to start projection. [cn] 发起投屏
	*/
	startProjection(startProjectionParam: StartProjectionParam, onStartProjectionResult?: (ret: SDKERR, reason: string, startProjectionResult: StartProjectionResult) => void): void {
		if (this._inProcessCallbackSet.has("startProjection")) {
			if (onStartProjectionResult) {
				let nullResult = <StartProjectionResult>{};
				onStartProjectionResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("startProjection");
		this._startProjectionCallback = (ret: SDKERR, reason: string, startProjectionResult: StartProjectionResult) => {
			this._inProcessCallbackSet.delete("startProjection");
			if (onStartProjectionResult) {
				onStartProjectionResult(ret, reason, startProjectionResult);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('startProjection', {"startProjectionParam":startProjectionParam}).then((ret: any) => {
				this._inProcessCallbackSet.delete('startProjection');
				if (onStartProjectionResult) {
					onStartProjectionResult(ret["ret"], ret["reason"], ret["startProjectionResult"]);
				}
			});
		}

		this.addOn.startProjection(startProjectionParam, this._startProjectionCallback);
	}

	/**
	* [en] This interface is used to set auto hide tool bar. [cn] 设置会控栏自动隐藏
	*/
	setAutoHideToolBar(autoHideToolBarParam: AutoHideToolBarParam): SDKERR {
		if (this.callWithIPC) {
			const ret = electron.ipcRenderer.sendSync('setAutoHideToolBar', {"autoHideToolBarParam":autoHideToolBarParam});
			return ret;
		}

		return this.addOn.setAutoHideToolBar(autoHideToolBarParam);
	}

	/**
	* [en] This interface is used to accept conf. [cn] 接受会议邀请
	*/
	acceptConf(acceptConfParam: AcceptConfParam, onAcceptConfResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("acceptConf")) {
			if (onAcceptConfResult) {
				onAcceptConfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("acceptConf");
		this._acceptConfCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("acceptConf");
			if (onAcceptConfResult) {
				onAcceptConfResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('acceptConf', {"acceptConfParam":acceptConfParam}).then((ret: any) => {
				this._inProcessCallbackSet.delete('acceptConf');
				if (onAcceptConfResult) {
					onAcceptConfResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.acceptConf(acceptConfParam, this._acceptConfCallback);
	}

	/**
	* [en] This interface is used to reject conf. [cn] 拒绝会议邀请
	*/
	rejectConf(onRejectConfResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("rejectConf")) {
			if (onRejectConfResult) {
				onRejectConfResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("rejectConf");
		this._rejectConfCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("rejectConf");
			if (onRejectConfResult) {
				onRejectConfResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('rejectConf', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('rejectConf');
				if (onRejectConfResult) {
					onRejectConfResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.rejectConf(this._rejectConfCallback);
	}

	/**
	* [en] This interface is used to get self share state. [cn] 获取自己的开启共享状态
	*/
	getSelfShareState(onGetSelfShareStateResult?: (ret: SDKERR, reason: string, selfShareStateInfo: SelfShareStateInfo) => void): void {
		if (this._inProcessCallbackSet.has("getSelfShareState")) {
			if (onGetSelfShareStateResult) {
				let nullResult = <SelfShareStateInfo>{};
				onGetSelfShareStateResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getSelfShareState");
		this._getSelfShareStateCallback = (ret: SDKERR, reason: string, selfShareStateInfo: SelfShareStateInfo) => {
			this._inProcessCallbackSet.delete("getSelfShareState");
			if (onGetSelfShareStateResult) {
				onGetSelfShareStateResult(ret, reason, selfShareStateInfo);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getSelfShareState', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getSelfShareState');
				if (onGetSelfShareStateResult) {
					onGetSelfShareStateResult(ret["ret"], ret["reason"], ret["selfShareStateInfo"]);
				}
			});
		}

		this.addOn.getSelfShareState(this._getSelfShareStateCallback);
	}

	/**
	* [en] This interface is used to operate subtitle. [cn] 开启/关闭字幕
	*/
	openSubtitle(isOpen: boolean, onOpenSubtitleResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void {
		if (this._inProcessCallbackSet.has("openSubtitle")) {
			if (onOpenSubtitleResult) {
				let nullResult = <boolean>{};
				onOpenSubtitleResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("openSubtitle");
		this._openSubtitleCallback = (ret: SDKERR, reason: string, isOpen: boolean) => {
			this._inProcessCallbackSet.delete("openSubtitle");
			if (onOpenSubtitleResult) {
				onOpenSubtitleResult(ret, reason, isOpen);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('openSubtitle', {"isOpen":isOpen}).then((ret: any) => {
				this._inProcessCallbackSet.delete('openSubtitle');
				if (onOpenSubtitleResult) {
					onOpenSubtitleResult(ret["ret"], ret["reason"], ret["isOpen"]);
				}
			});
		}

		this.addOn.openSubtitle(isOpen, this._openSubtitleCallback);
	}

	/**
	* [en] This interface is used to operate waiting room. [cn] 开启/关闭等候室
	*/
	openWaitingRoom(isOpen: boolean, onOpenWaitingRoomResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void {
		if (this._inProcessCallbackSet.has("openWaitingRoom")) {
			if (onOpenWaitingRoomResult) {
				let nullResult = <boolean>{};
				onOpenWaitingRoomResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("openWaitingRoom");
		this._openWaitingRoomCallback = (ret: SDKERR, reason: string, isOpen: boolean) => {
			this._inProcessCallbackSet.delete("openWaitingRoom");
			if (onOpenWaitingRoomResult) {
				onOpenWaitingRoomResult(ret, reason, isOpen);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('openWaitingRoom', {"isOpen":isOpen}).then((ret: any) => {
				this._inProcessCallbackSet.delete('openWaitingRoom');
				if (onOpenWaitingRoomResult) {
					onOpenWaitingRoomResult(ret["ret"], ret["reason"], ret["isOpen"]);
				}
			});
		}

		this.addOn.openWaitingRoom(isOpen, this._openWaitingRoomCallback);
	}

	/**
	* [en] This interface is used to operate local record. [cn] 操作本地录制
	*/
	operateLocalRecord(type: LocalRecordOperateType, onOperateLocalRecordResult?: (ret: SDKERR, reason: string, type: LocalRecordOperateType) => void): void {
		if (this._inProcessCallbackSet.has("operateLocalRecord")) {
			if (onOperateLocalRecordResult) {
				let nullResult = <LocalRecordOperateType>{};
				onOperateLocalRecordResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("operateLocalRecord");
		this._operateLocalRecordCallback = (ret: SDKERR, reason: string, type: LocalRecordOperateType) => {
			this._inProcessCallbackSet.delete("operateLocalRecord");
			if (onOperateLocalRecordResult) {
				onOperateLocalRecordResult(ret, reason, type);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('operateLocalRecord', {"type":type}).then((ret: any) => {
				this._inProcessCallbackSet.delete('operateLocalRecord');
				if (onOperateLocalRecordResult) {
					onOperateLocalRecordResult(ret["ret"], ret["reason"], ret["type"]);
				}
			});
		}

		this.addOn.operateLocalRecord(type, this._operateLocalRecordCallback);
	}

	/**
	* [en] This interface is used to open virtual background setting page. [cn] 打开虚拟背景设置
	*/
	openVirtualBackgroundSettingPage(onOpenVirtualBackgroundSettingPageResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("openVirtualBackgroundSettingPage")) {
			if (onOpenVirtualBackgroundSettingPageResult) {
				onOpenVirtualBackgroundSettingPageResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("openVirtualBackgroundSettingPage");
		this._openVirtualBackgroundSettingPageCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("openVirtualBackgroundSettingPage");
			if (onOpenVirtualBackgroundSettingPageResult) {
				onOpenVirtualBackgroundSettingPageResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('openVirtualBackgroundSettingPage', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('openVirtualBackgroundSettingPage');
				if (onOpenVirtualBackgroundSettingPageResult) {
					onOpenVirtualBackgroundSettingPageResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.openVirtualBackgroundSettingPage(this._openVirtualBackgroundSettingPageCallback);
	}

	/**
	* [en] This interface is used to get local record status. [cn] 获取本地录制状态
	*/
	getConfLocalRecordStatus(onGetConfLocalRecordStatusResult?: (ret: SDKERR, reason: string, state: LocalRecordStatusInfo) => void): void {
		if (this._inProcessCallbackSet.has("getConfLocalRecordStatus")) {
			if (onGetConfLocalRecordStatusResult) {
				let nullResult = <LocalRecordStatusInfo>{};
				onGetConfLocalRecordStatusResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getConfLocalRecordStatus");
		this._getConfLocalRecordStatusCallback = (ret: SDKERR, reason: string, state: LocalRecordStatusInfo) => {
			this._inProcessCallbackSet.delete("getConfLocalRecordStatus");
			if (onGetConfLocalRecordStatusResult) {
				onGetConfLocalRecordStatusResult(ret, reason, state);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getConfLocalRecordStatus', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getConfLocalRecordStatus');
				if (onGetConfLocalRecordStatusResult) {
					onGetConfLocalRecordStatusResult(ret["ret"], ret["reason"], ret["state"]);
				}
			});
		}

		this.addOn.getConfLocalRecordStatus(this._getConfLocalRecordStatusCallback);
	}

	/**
	* [en] This interface is used to get local record permission. [cn] 获取本地录制权限
	*/
	getSelfHasLocalRecordPermission(onGetSelfHasLocalRecordPermissionResult?: (ret: SDKERR, reason: string, permission: LocalRecordPermissionInfo) => void): void {
		if (this._inProcessCallbackSet.has("getSelfHasLocalRecordPermission")) {
			if (onGetSelfHasLocalRecordPermissionResult) {
				let nullResult = <LocalRecordPermissionInfo>{};
				onGetSelfHasLocalRecordPermissionResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getSelfHasLocalRecordPermission");
		this._getSelfHasLocalRecordPermissionCallback = (ret: SDKERR, reason: string, permission: LocalRecordPermissionInfo) => {
			this._inProcessCallbackSet.delete("getSelfHasLocalRecordPermission");
			if (onGetSelfHasLocalRecordPermissionResult) {
				onGetSelfHasLocalRecordPermissionResult(ret, reason, permission);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getSelfHasLocalRecordPermission', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getSelfHasLocalRecordPermission');
				if (onGetSelfHasLocalRecordPermissionResult) {
					onGetSelfHasLocalRecordPermissionResult(ret["ret"], ret["reason"], ret["permission"]);
				}
			});
		}

		this.addOn.getSelfHasLocalRecordPermission(this._getSelfHasLocalRecordPermissionCallback);
	}

	/**
	* [en] This interface is used to request local record permission. [cn] 申请本地录制权限
	*/
	requestLocalRecordPermission(onRequestLocalRecordPermissionResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("requestLocalRecordPermission")) {
			if (onRequestLocalRecordPermissionResult) {
				onRequestLocalRecordPermissionResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("requestLocalRecordPermission");
		this._requestLocalRecordPermissionCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("requestLocalRecordPermission");
			if (onRequestLocalRecordPermissionResult) {
				onRequestLocalRecordPermissionResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('requestLocalRecordPermission', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('requestLocalRecordPermission');
				if (onRequestLocalRecordPermissionResult) {
					onRequestLocalRecordPermissionResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.requestLocalRecordPermission(this._requestLocalRecordPermissionCallback);
	}

	/**
	* [en] This interface is used to request host role. [cn] 申请主持人
	*/
	applyHostRole(password: string, onApplyHostRoleResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("applyHostRole")) {
			if (onApplyHostRoleResult) {
				onApplyHostRoleResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("applyHostRole");
		this._applyHostRoleCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("applyHostRole");
			if (onApplyHostRoleResult) {
				onApplyHostRoleResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('applyHostRole', {"password":password}).then((ret: any) => {
				this._inProcessCallbackSet.delete('applyHostRole');
				if (onApplyHostRoleResult) {
					onApplyHostRoleResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.applyHostRole(password, this._applyHostRoleCallback);
	}

	/**
	* [en] This interface is used to get subtitle state. [cn] 获取字幕状态
	*/
	getSubtitlePageOpened(onGetSubtitlePageOpenedResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void {
		if (this._inProcessCallbackSet.has("getSubtitlePageOpened")) {
			if (onGetSubtitlePageOpenedResult) {
				let nullResult = <boolean>{};
				onGetSubtitlePageOpenedResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getSubtitlePageOpened");
		this._getSubtitlePageOpenedCallback = (ret: SDKERR, reason: string, isOpen: boolean) => {
			this._inProcessCallbackSet.delete("getSubtitlePageOpened");
			if (onGetSubtitlePageOpenedResult) {
				onGetSubtitlePageOpenedResult(ret, reason, isOpen);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getSubtitlePageOpened', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getSubtitlePageOpened');
				if (onGetSubtitlePageOpenedResult) {
					onGetSubtitlePageOpenedResult(ret["ret"], ret["reason"], ret["isOpen"]);
				}
			});
		}

		this.addOn.getSubtitlePageOpened(this._getSubtitlePageOpenedCallback);
	}

	/**
	* [en] This interface is used to get waiting room state. [cn] 获取等候室状态
	*/
	getWaitingRoomOpened(onGetWaitingRoomOpenedResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void {
		if (this._inProcessCallbackSet.has("getWaitingRoomOpened")) {
			if (onGetWaitingRoomOpenedResult) {
				let nullResult = <boolean>{};
				onGetWaitingRoomOpenedResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getWaitingRoomOpened");
		this._getWaitingRoomOpenedCallback = (ret: SDKERR, reason: string, isOpen: boolean) => {
			this._inProcessCallbackSet.delete("getWaitingRoomOpened");
			if (onGetWaitingRoomOpenedResult) {
				onGetWaitingRoomOpenedResult(ret, reason, isOpen);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getWaitingRoomOpened', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getWaitingRoomOpened');
				if (onGetWaitingRoomOpenedResult) {
					onGetWaitingRoomOpenedResult(ret["ret"], ret["reason"], ret["isOpen"]);
				}
			});
		}

		this.addOn.getWaitingRoomOpened(this._getWaitingRoomOpenedCallback);
	}

	/**
	* [en] This interface is used to get virtual background setting page state. [cn] 获取是否已经打开虚拟背景设置
	*/
	getVirtualBackgroundSettingPageOpened(onGetVirtualBackgroundSettingPageOpenedResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void {
		if (this._inProcessCallbackSet.has("getVirtualBackgroundSettingPageOpened")) {
			if (onGetVirtualBackgroundSettingPageOpenedResult) {
				let nullResult = <boolean>{};
				onGetVirtualBackgroundSettingPageOpenedResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getVirtualBackgroundSettingPageOpened");
		this._getVirtualBackgroundSettingPageOpenedCallback = (ret: SDKERR, reason: string, isOpen: boolean) => {
			this._inProcessCallbackSet.delete("getVirtualBackgroundSettingPageOpened");
			if (onGetVirtualBackgroundSettingPageOpenedResult) {
				onGetVirtualBackgroundSettingPageOpenedResult(ret, reason, isOpen);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getVirtualBackgroundSettingPageOpened', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getVirtualBackgroundSettingPageOpened');
				if (onGetVirtualBackgroundSettingPageOpenedResult) {
					onGetVirtualBackgroundSettingPageOpenedResult(ret["ret"], ret["reason"], ret["isOpen"]);
				}
			});
		}

		this.addOn.getVirtualBackgroundSettingPageOpened(this._getVirtualBackgroundSettingPageOpenedCallback);
	}

	/**
	* [en] This interface is used to subscribe subtitle language. [cn] 订阅字幕语言
	*/
	subscribeSubtitleLanguage(targetLanguageType: TargetLanguageType, onSubscribeSubtitleLanguageResult?: (ret: SDKERR, reason: string, targetLanguageType: TargetLanguageType) => void): void {
		if (this._inProcessCallbackSet.has("subscribeSubtitleLanguage")) {
			if (onSubscribeSubtitleLanguageResult) {
				let nullResult = <TargetLanguageType>{};
				onSubscribeSubtitleLanguageResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("subscribeSubtitleLanguage");
		this._subscribeSubtitleLanguageCallback = (ret: SDKERR, reason: string, targetLanguageType: TargetLanguageType) => {
			this._inProcessCallbackSet.delete("subscribeSubtitleLanguage");
			if (onSubscribeSubtitleLanguageResult) {
				onSubscribeSubtitleLanguageResult(ret, reason, targetLanguageType);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('subscribeSubtitleLanguage', {"targetLanguageType":targetLanguageType}).then((ret: any) => {
				this._inProcessCallbackSet.delete('subscribeSubtitleLanguage');
				if (onSubscribeSubtitleLanguageResult) {
					onSubscribeSubtitleLanguageResult(ret["ret"], ret["reason"], ret["targetLanguageType"]);
				}
			});
		}

		this.addOn.subscribeSubtitleLanguage(targetLanguageType, this._subscribeSubtitleLanguageCallback);
	}

	/**
	* [en] This interface is used to subscribe subtitle. [cn] 订阅/取消订阅字幕
	*/
	subscribeSubtitle(isSubscribe: boolean, onSubscribeSubtitleResult?: (ret: SDKERR, reason: string, isSubscirbe: boolean) => void): void {
		if (this._inProcessCallbackSet.has("subscribeSubtitle")) {
			if (onSubscribeSubtitleResult) {
				let nullResult = <boolean>{};
				onSubscribeSubtitleResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("subscribeSubtitle");
		this._subscribeSubtitleCallback = (ret: SDKERR, reason: string, isSubscirbe: boolean) => {
			this._inProcessCallbackSet.delete("subscribeSubtitle");
			if (onSubscribeSubtitleResult) {
				onSubscribeSubtitleResult(ret, reason, isSubscirbe);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('subscribeSubtitle', {"isSubscribe":isSubscribe}).then((ret: any) => {
				this._inProcessCallbackSet.delete('subscribeSubtitle');
				if (onSubscribeSubtitleResult) {
					onSubscribeSubtitleResult(ret["ret"], ret["reason"], ret["isSubscirbe"]);
				}
			});
		}

		this.addOn.subscribeSubtitle(isSubscribe, this._subscribeSubtitleCallback);
	}

	/**
	* [en] This interface is used to get subtitle support languagues. [cn] 获取字幕支持的语言
	*/
	getSubtitleSupportLanguage(onGetSubtitleSupportLanguageResult?: (ret: SDKERR, reason: string, targetLanguageTypeList: TargetLanguageTypeList) => void): void {
		if (this._inProcessCallbackSet.has("getSubtitleSupportLanguage")) {
			if (onGetSubtitleSupportLanguageResult) {
				let nullResult = <TargetLanguageTypeList>{};
				onGetSubtitleSupportLanguageResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getSubtitleSupportLanguage");
		this._getSubtitleSupportLanguageCallback = (ret: SDKERR, reason: string, targetLanguageTypeList: TargetLanguageTypeList) => {
			this._inProcessCallbackSet.delete("getSubtitleSupportLanguage");
			if (onGetSubtitleSupportLanguageResult) {
				onGetSubtitleSupportLanguageResult(ret, reason, targetLanguageTypeList);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getSubtitleSupportLanguage', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getSubtitleSupportLanguage');
				if (onGetSubtitleSupportLanguageResult) {
					onGetSubtitleSupportLanguageResult(ret["ret"], ret["reason"], ret["targetLanguageTypeList"]);
				}
			});
		}

		this.addOn.getSubtitleSupportLanguage(this._getSubtitleSupportLanguageCallback);
	}

}

