import { UserCorpInfoNotifyType, SDKERR } from './enum';
import { AccountAuthInfo, AppIdAuthInfo, CAVerifyInfo, CorpConfigInfo, GuaranteedIpAddressesParam, LoginResult, LoginStateInfo, LoginTokenInfo, LogoutResult, NetWorkModeInfo, ProxyInfo, SSOAuthInfo, SelfAvatarInfo, ServerInfo, ShareVmrInfo } from './model';
export declare class ILogin {
    addOn: ILogin;
    _onKickedOutNotifyCallback: () => void;
    _onCorpConfigNotifyCallback: (configInfo: CorpConfigInfo) => void;
    _onUserCorpInfoChangedCallback: (type: UserCorpInfoNotifyType) => void;
    _onLoginErrorNotifyCallback: (ret: SDKERR, reason: string) => void;
    _onShareVmrInfoNotifyCallback: (shareVmrInfo: ShareVmrInfo) => void;
    _onLoginStateChangeNotifyCallback: (loginStateInfo: LoginStateInfo) => void;
    _loginByAccountCallback: (ret: SDKERR, reason: string, loginResult: LoginResult) => void;
    _loginByAppIdCallback: (ret: SDKERR, reason: string, loginResult: LoginResult) => void;
    _loginBySSOCallback: (ret: SDKERR, reason: string, loginResult: LoginResult) => void;
    _logoutCallback: (ret: SDKERR, reason: string, logoutResult: LogoutResult) => void;
    _setNetworkModeCallback: (ret: SDKERR, reason: string) => void;
    _uploadSelfAvatarCallback: (ret: SDKERR, reason: string) => void;
    _deleteSelfAvatarCallback: (ret: SDKERR, reason: string) => void;
    _setGlobalGuaranteedIpAddressesCallback: (ret: SDKERR, reason: string) => void;
    _setServerAddressCallback: (ret: SDKERR, reason: string) => void;
    _setProxyCallback: (ret: SDKERR, reason: string) => void;
    _setCAVerifyInfoCallback: (ret: SDKERR, reason: string) => void;
    _getLoginStateCallback: (ret: SDKERR, reason: string, loginStateInfo: LoginStateInfo) => void;
    _getLoginTokenCallback: (ret: SDKERR, reason: string, loginTokenInfo: LoginTokenInfo) => void;
    _inProcessCallbackSet: Set<string>;
    callWithIPC: boolean;
    constructor(addOn: ILogin);
    init(): void;
    /**
    * [en] Notify of be kicked out. [cn] 登录被踢通知
    */
    setOnKickedOutNotifyCB(onKickedOutNotify: () => void): void;
    /**
    * [en] Notify of the config of corporation. [cn] 企业配置通知
    */
    setOnCorpConfigNotifyCB(onCorpConfigNotify: (configInfo: CorpConfigInfo) => void): void;
    /**
    * [en] Notify of the info of corporation. [cn] 客户企业信息变化通知
    */
    setOnUserCorpInfoChangedCB(onUserCorpInfoChanged: (type: UserCorpInfoNotifyType) => void): void;
    /**
    * [en]This is about login error notify. [cn]登录错误通知
    */
    setOnLoginErrorNotifyCB(onLoginErrorNotify: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en]This is about share vmr info notify. [cn]共享vmr信息通知
    */
    setOnShareVmrInfoNotifyCB(onShareVmrInfoNotify: (shareVmrInfo: ShareVmrInfo) => void): void;
    /**
    * [en]This is about login state change notify. [cn]登录状态变化通知
    */
    setOnLoginStateChangeNotifyCB(onLoginStateChangeNotify: (loginStateInfo: LoginStateInfo) => void): void;
    /**
    * [en] This interface is used to login by account info. [cn] 账号密码登录
    */
    loginByAccount(accountAuthInfo: AccountAuthInfo, onLoginResult?: (ret: SDKERR, reason: string, loginResult: LoginResult) => void): void;
    /**
    * [en] This interface is used to login by appId info. [cn] AppId登录
    */
    loginByAppId(appIdAuthInfo: AppIdAuthInfo, onLoginResult?: (ret: SDKERR, reason: string, loginResult: LoginResult) => void): void;
    /**
    * [en] This method is used to login by SSO. [cn] SSO登录
    */
    loginBySSO(ssoAuthInfo: SSOAuthInfo, onLoginResult?: (ret: SDKERR, reason: string, loginResult: LoginResult) => void): void;
    /**
    * [en] This interface is used to logout sdk. [cn] 退出登录
    */
    logout(onLogoutResult?: (ret: SDKERR, reason: string, logoutResult: LogoutResult) => void): void;
    /**
    * [en] This interface is used to set network mode. [cn] 设置网络模式
    */
    setNetworkMode(networkInfo: NetWorkModeInfo, onSetNetworkModeResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to upload self avatar. [cn] 上传头像
    */
    uploadSelfAvatar(selfAvatarInfo: SelfAvatarInfo, onUploadSelfAvatarResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to delete self avatar. [cn] 删除头像。
    */
    deleteSelfAvatar(onDeleteSelfAvatarResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set guaranteed ip addresses. [cn] 设置(会控)保底ip地址
    */
    setGuaranteedIpAddresses(guaranteedIpAddresses: string): SDKERR;
    /**
    * [en] This interface is used to set guaranteed ip addresses of global domain. [cn] 设置管理面域名对应的保底ip地址
    */
    setGlobalGuaranteedIpAddresses(guaranteedIpAddressesParam: GuaranteedIpAddressesParam, onSetGlobalGuaranteedIpAddressesResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set login server info. [cn] 设置登录服务器信息
    */
    setServerAddress(serverInfo: ServerInfo, onSetServerAddressResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set proxy info. [cn] 设置代理信息
    */
    setProxy(proxyInfo: ProxyInfo, onSetProxyResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to set CA verify info. [cn] 设置证书校验信息
    */
    setCAVerifyInfo(CAVerifyInfo: CAVerifyInfo, onSetCAVerifyInfoResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get login state. [cn] 获取登录状态
    */
    getLoginState(onGetLoginStateResult?: (ret: SDKERR, reason: string, loginStateInfo: LoginStateInfo) => void): void;
    /**
    * [en] This interface is used to get login token. [cn] 获取登录token
    */
    getLoginToken(onGetLoginTokenResult?: (ret: SDKERR, reason: string, loginTokenInfo: LoginTokenInfo) => void): void;
}
