import { SDKERR } from './enum';
import { InitInfo } from './model';
import { ILogin } from './ILogin';
import { IConfCtrl } from './IConfCtrl';
import { IConfMgr } from './IConfMgr';
import { IConfig } from './IConfig';
import { IUIConfig } from './IUIConfig';
import { ICall } from './ICall';
declare class UISDK {
    loginImpl: ILogin;
    confCtrlImpl: IConfCtrl;
    confMgrImpl: IConfMgr;
    configImpl: IConfig;
    uIConfigImpl: IUIConfig;
    callImpl: ICall;
    addOn: UISDK;
    _onSdkDisconnectedNotifyCallback: () => void;
    callWithIPC: boolean;
    constructor(nodePath: string);
    /**
    * [en] Notify of sdk disconnected. [cn] 连接断开通知
    */
    setOnSdkDisconnectedNotifyCB(onSdkDisconnectedNotify: () => void): void;
    /**
    * [en] This interface is used to init sdk. [cn] 初始化
    */
    init(initInfo: InitInfo): SDKERR;
    /**
    * [en] This interface is used to exit sdk. [cn] 退出
    */
    exit(): SDKERR;
    /**
    * [en] This interface is used to get the login service object. [cn] 获取登录服务对象
    */
    getLoginApi(): ILogin;
    /**
    * [en] This interface is used to get the conf control service object. [cn] 获取会议控制服务对象
    */
    getConfCtrlApi(): IConfCtrl;
    /**
    * [en] This interface is used to get the conf management service object. [cn] 获取会议管理服务对象
    */
    getConfMgrApi(): IConfMgr;
    /**
    * [en] This interface is used to get the config service object. [cn] 获取配置服务对象
    */
    getConfigApi(): IConfig;
    /**
    * [en] This interface is used to get the UI config service object. [cn] 获取界面配置服务对象
    */
    getUIConfigApi(): IUIConfig;
    /**
    * [en] This interface is used to get the call service object. [cn] 获取呼叫服务对象
    */
    getCallApi(): ICall;
}
export default UISDK;
