//
//  HWMConfCtrlItemHandler.h
//  HWMUISDK
//
//  Created by tyfinal on 2021/6/25.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMMenuItemModel.h"
#import "HWMToolBarItemModel.h"
#import "HWMUISDKConfigCommonInfo.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMConfCtrlItemHandler <NSObject>
@optional

/**
 * 会议工具条全量数据源
 * @param scene 场景。可以该值配置不同场景的数据源
 * @return 返回左中右三个区域的数据源 如需隐藏该区域按钮 则使用空数组;返回nil时 则该场景按钮将使用默认按钮
 */
- (nullable NSArray <NSArray <HWMToolBarItemModel *> *> *)meetingToolBarItemsForScene:(HWMConfToolBarScene)scene;

/**
 * 数据共享工具条按钮配置
 * @return WKCFToolBarItemModel 集合数组 最多支持八个按钮。 为nil时 将使用默认配置，传空数组( @[ ] )则只展示默认常驻配置项。
 */
- (nullable NSArray <HWMToolBarItemModel *> *)screenShareToolBarItems;

/**
 * 会控工具栏更多按钮弹出菜单项配置
 * @return HWMMenuItemModel 集合数组 。  为nil时 将使用默认配置，传空数组( @[ ] )则不展示菜单项
 */
- (nullable NSArray <HWMMenuItemModel *>*)meetingToolbarMoreMenuItems DEPRECATED_MSG_ATTRIBUTE("可通过HWMToolBarItemModel自定义submenus实现");

/**
 * 共享工具栏更多按钮弹出菜单项配置
 * @return HWMMenuItemModel 集合数组 。  为nil时 将使用默认配置，传空数组( @[ ] )则不展示菜单项
 */
- (nullable NSArray <HWMMenuItemModel *>*)screenShareToolbarMoreMenuItems DEPRECATED_MSG_ATTRIBUTE("可通过HWMToolBarItemModel自定义submenus实现");

/**
 * 会控按钮点击事件，与json配置会控按钮配合使用
 */
- (void)onItemClicked:(HWMClickInjectItemType)ctrlType buttonId:(NSString *)buttonId;

@end

NS_ASSUME_NONNULL_END
