//
//  HWMConfListItemInfo.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/14.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMNativeSDK.h"
#import "HWMCycleConfParam.h"
#import "HWMUISDKCommonDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMConfListItemInfo : NSObject
/// 会议id
@property (nonatomic, copy) NSString *confId;

/// 会议主题
@property (nonatomic, copy) NSString *confSubject;

/// 会议接入码
@property (nonatomic, copy) NSString *accessNumber;

/// 主持人密码
@property (nonatomic, copy) NSString *chairmanPwd;

/// 来宾密码
@property (nonatomic, copy) NSString *generalPwd;

/// 观众密码
@property (nonatomic, copy) NSString *audiencePwd;

/// 会议开始时间，UTC时间戳，精度秒
@property (nonatomic, assign) NSTimeInterval startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");

/// 会议结束时间，UTC时间戳，精度秒
@property (nonatomic, assign) NSTimeInterval endTime DEPRECATED_MSG_ATTRIBUTE("Use 'endTimeStamp' instead");

/// 会议开始时间戳，精度秒
@property (nonatomic, assign) NSInteger startTimeStamp;

/// 会议结束时间戳，精度秒
@property (nonatomic, assign) NSInteger endTimeStamp;

/// 时区
@property (nonatomic, copy) NSString *timeZone;

/// 是否是视频会议
@property (nonatomic, assign) BOOL videoConf;

/// 预订者姓名
@property (nonatomic, copy) NSString *confScheduledName;

/// 主持人加入会议uri链接
@property (nonatomic, copy) NSString *chairJoinUri;

/// 普通与会者加入会议uri链接
@property (nonatomic, copy) NSString *guestJoinUri;

/// 观众加入会议uri链接
@property (nonatomic, copy) NSString *audienceJoinUri;

/// VMR会议显示ID
@property (nonatomic, copy) NSString *vmrConferenceId;

/// 是否会议开启自动录制
@property (nonatomic, assign) BOOL isAutoRecord;

/// 可选，是否是VMR预约记录：0.普通会议记录；1.VMR预约记录
@property (nonatomic, assign) BOOL scheduleVmr;

/// 是否是网络研讨会
@property (nonatomic, assign) BOOL isWebinar;

/// 会议状态
@property (nonatomic, assign) HWMUISDKConfState confStateType;

/// 角色
@property (nonatomic, assign) HWMConfRoleType role;

/// 会议类型
@property (nonatomic, assign) HWMConferenceType conferenceType;

/// 周期会议信息
@property (nonatomic, strong) HWMCycleConfParam *cycleParam;

/// 周期子会议
@property (nonatomic, copy) NSArray <HWMSDKSubCycleConfParamModel *> *subConfParam;

@end

NS_ASSUME_NONNULL_END
