//
//  HWMContactUIHandler.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMAttendeeInfo.h"

typedef NS_ENUM (NSUInteger, HWMSelectedContactScene) {
    HWMSelectedContactInConf = 0,    // 正常会议中  win可以使用模态框弹出样式、非模态框弹出样式
    HWMSelectedContactInShare,      // 会议中的共享场景  win使用非模态框弹出样式，不建议使用模态框模式
};

NS_ASSUME_NONNULL_BEGIN

@protocol HWMContactUIHandler <NSObject>
@optional

/// 定制打开联系人选择窗口
/// @param param 会议中已有的联系人
/// @param scene 选择联系人场景，默认会议中
/// @param handler 结果，接入方需将选中的联系人封装成HWMAttendeeInfo 调用handler返回给sdk
/// 注意：点击window的取消、关闭等按钮时，需要handler回来，result可以传递nil 用于改变工具条邀请按钮的选中状态  点击确认将选中的联系人信息通过resul传递回来
- (void)openContactSelectWindow:(nullable NSArray<HWMAttendeeInfo *> *)param
                          scene:(HWMSelectedContactScene)scene
                 completeHander:(void (^)(NSArray<HWMAttendeeInfo *> *_Nullable result))handler;

/// 关闭联系人选择窗口
- (void)closeContactSelectWindow;
@end

NS_ASSUME_NONNULL_END
