//
//  HWMMenuItemModel.h
//  HWMUISDK
//
//  Created by tyfinal on 2021/6/25.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMMenuItemModel : NSObject

/** item等级
 *  HWMToolBarMenuItemThemeLevelHeading 大标题
 *  HWMToolBarMenuItemThemeLevelTitle普通菜单项 存在高亮选中状态 默认为该选项
 */
@property (nonatomic, assign) HWMToolBarMenuItemThemeLevel themeLevel;
/** 按钮是否允许选中 默认为NO */
@property (nonatomic, assign) BOOL allowSelected;
/** allowSelected 为YES时 标记item的选中状态 默认为NO*/
@property (nonatomic, assign) BOOL selected;
/** 可选  文字前的icon 大小24x24pt */
@property (nonatomic, strong) NSImage *image;
/** 可选  文字前的icon 大小24x24pt 仅当allowSelected为YES且selected为YES时展示  */
@property (nonatomic, strong) NSImage *selectedImage;
/** menu item 的标题 */
@property (nonatomic, copy) NSString *title;
/** menu item 的标题颜色 可选项  仅针对themeLevel =  HWMToolBarMenuItemThemeLevelTitle*/
@property (nonatomic, strong) NSColor *titleColor;
/** 该item是否需要分割线  为YES时在该Item下方出现一条分割线 默认为NO*/
@property (nonatomic, assign) BOOL needSeperator;
/** 可选 菜单项标识 不传默认为HWMMenuItemTypeNone  前0~200为内部保留项  自定义菜单项枚举值从201开始 */
@property (nonatomic, assign) HWMMenuItemType ctrlType;
/** 设置按钮标识符 可选 */
@property (nonatomic, copy, nullable) NSString *accessibilityIdentifier;
/** 子菜单项 仅针对themeLevel =  HWMToolBarMenuItemThemeLevelTitle */
@property (nonatomic, copy, nullable) NSArray <HWMMenuItemModel *> *submenus;
/** 处理每个menu item的点击事件 */
@property (nonatomic, copy) void (^ _Nullable clickHandler)(void);

/// 会控助手
+ (instancetype)defaultManageMeetingsModel;
/// 字幕
+ (instancetype)defaultSubtitleModel;
/// 反馈
+ (instancetype)defaultFeedbackModel;
/// 网络检测
+ (instancetype)defaultNetworkDectectionModel;
/// 隐藏或显示视频小画面
+ (instancetype)defaultSmallPaneModel;
/// 点对点通话 语音/视频 互转
+ (instancetype)defaultSwitchCallTypeModel;
/// 安全
+ (instancetype)defaultSecurityModel;
/// 邀请
+ (instancetype)defaultInvitationModel;
/// 离开会议
+ (instancetype)defaultLeaveMeetingModel;
/// 会议设置
+ (instancetype)defaultSettingModel;
/// 投票
+ (instancetype)defaultVoteModel;
/// 直播
+ (instancetype)defaultLiveModel;
/// 改名
+ (instancetype)defaultRenameModel;
/// 共享
+ (instancetype)defaultShareModel;
@end

NS_ASSUME_NONNULL_END
