//
//  HWMOpenApiCommand.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMOpenApiCommand : NSObject<NSCopying>
@property (nonatomic, copy) NSString *apiKey; // 请求key
@property (nonatomic, strong) id param; // 参数
@property (nonatomic, copy, nullable) HWMSDKCompleteHandler apiCallback; //回调
@property (nonatomic, assign) NSTimeInterval startTime; //开始时间
@property (nonatomic, assign) BOOL isTimeOut; // 是否超时
@property (nonatomic, copy, nullable) void (^ finishBlock)(void); // 完成回调，交给openapi 处理请求队列
/// 超时时间
@property (nonatomic, assign) NSUInteger timeout;

- (instancetype)initWithKey:(NSString *_Nonnull)key param:(id _Nullable)param callback:(HWMSDKCompleteHandler _Nonnull)callback;

- (void)executeWithFinished:(void (^)(void))finishBlock;

- (void)trackApiFinishWithError:(NSError *)error;
@end

NS_ASSUME_NONNULL_END
