//
//  HWMOpenSDKConfigDefine.h
//  WKConference
//
//  Created by linweiqiang on 2021/12/1.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#ifndef HWMOpenSDKConfigDefine_h
#define HWMOpenSDKConfigDefine_h

typedef NS_ENUM (NSUInteger, HWMSettingHotKeyType) {
    HWMSettingHotKeyOpenMain = 0, // 打开主面板
    HWMSettingHotKeyActivateSearch, // 激活搜索
};

typedef NS_ENUM (NSUInteger, HWMSettingMenuType) {
    HWMSettingMenuLogin = 0, // 登录设置
    HWMSettingMenuCall, // 会议呼叫设置
    HWMSettingMenuChatNotify, // 聊天消息提醒设置
    HWMSettingMenuSubtitle, // 字幕设置
    HWMSettingMenuWindowFilter, // 会议窗口过滤
    HWMSettingMenuMicrophone, // 麦克风设置
    HWMSettingMenuSpeaker, // 扬声器设置
    HWMSettingMenuAIAudioTnr, //智能降噪
    HWMSettingMenuAdvanced, // 高级设置
    HWMSettingMenuCamera, // 摄像头设置
    HWMSettingMenuLayout, // 画面设置
    HWMSettingMenuRecord, // 录制设置
    HWMSettingMenuLocalRecordSetting, // 本地录制设置
    HWMSettingMenuVirtual, // 虚拟背景设置
    HWMSettingMenuHotKey, // 快捷键设置
    HWMSettingMenuOther,  // 其他设置
    HWMSettingMenuScreen, // 屏幕设置
};

typedef NS_ENUM (NSUInteger, HWMSettingTabType) {
    HWMSettingTabNormal = 0, // 常规设置
    HWMSettingTabVideo, // 视频
    HWMSettingTabAudio, // 音频
    HWMSettingTabRecord, // 录制
    HWMSettingTabVirtual, // 虚拟背景
    HWMSettingTabHotKey, // 快捷键
    HWMSettingTabScreen, // 屏幕设置
};

typedef NS_ENUM (NSUInteger, HWMSDKCapabilitySuport) {
    HWMSDKCapabilitySuportVideoHD = 0, // 高清视频
    HWMSDKCapabilitySuportShareAudio, // 共享时包含电脑声音
    HWMSDKCapabilitySuportHideNoCameraView, // 隐藏非视频与会者
    HWMSDKCapabilitySuportCustomVirtualBGImage, // 用户自定义虚拟背景图片
    HWMSDKCapabilitySuportBreakoutConf, // 分组会议
    HWMSDKCapabilitySuportConfirmRecord, // 录制安全提示
    HWMSDKCapabilitySuportAlsoReceiveCalls, // 电脑端在线时移动端同时接收会议呼叫
    HWMSDKCapabilityWithoutMainFrame, // 配置无会中主界面
    HWMSDKCapabilitySuportGuestInvite, // 是否支持与会者邀请
    HWMSDKCapabilityHideInviteResultToast, // 隐藏邀请结果提示
    HWMSDKCapabilityHideOfflineParticipantList, // 是否隐藏与会者列表未入会标签
    HWMSDKCapabilityHideVbRiskTip, // 是否隐藏虚拟背景隐私风险提示
    HWMSDKCapabilityConfEndShowTips, //是否展示confEnd提示
};

typedef NS_ENUM (NSUInteger, HWMHandleType) {
    HWMHandleView = 0,  // 句柄的类型为view
    HWMHandleWindow,    // 句柄的类型为windowID
};

typedef NS_ENUM (NSUInteger, HWMHwndType) {
    HWMHwndVideo = 0,       // 视图的类型为视频 句柄类型为view
    HWMHwndShareWhiteBoard, // 视图的类型为共享白板 句柄类型为view
    HWMHwndShareScreenRecv, // 视图的类型为共享屏幕接收 句柄类型为view
    HWMHwndShareScreenSend, // 视图的类型为共享屏幕发送 句柄类型为windowID
};

typedef NS_ENUM(NSInteger,HWMToolBarItemType) {
    HWMToolBarItemTypeNone = 0,
    /// 扬声器
    HWMToolBarItemTypeSpeaker = 1,
    /// 麦克风
    HWMToolBarItemTypeMicrophone,
    /// 摄像头
    HWMToolBarItemTypeCamera,
    /// 观众观看
    HWMToolBarItemTypeWatch,
    /// 安全
    HWMToolBarItemTypeSecurity = 5,
    /// 邀请
    HWMToolBarItemTypeInvitation,
    /// 与会者
    HWMToolBarItemTypeParticipant,
    /// 数据共享
    HWMToolBarItemTypeDataShare,
    /// 同声传译
    HWMToolBarItemTypeInterpret,
    /// 聊天
    HWMToolBarItemTypeChat = 10,
    /// 会控工具栏更多
    HWMToolBarItemTypeMore,
    /// 离开
    HWMToolBarItemTypeLeave,
    /// 挂断
    HWMToolBarItemTypeHangup,
    /// 观众分享
    HWMToolBarItemTypeAudienceShare,
    /// 观众举手
    HWMToolBarItemTypeAudienceHandup = 15,
    /// 再次共享
    HWMToolBarItemTypeReshare,
    /// 远程控制
    HWMToolBarItemTypeRemoteCtrl,
    /// 标注
    HWMToolBarItemTypeAnnotation,
    /// 录制 支持暂停 /继续的录制类型---已废弃，不可用
    HWMToolBarItemTypeRecordPauseMode,
    /// 录制 支持暂停 /继续的录制类型---已废弃，不可用
    HWMToolBarItemTypeRecordStopMode = 20,
    /// 投票
    HWMToolBarItemTypeVote,
    /// 共享工具栏更多
    HWMToolBarItemTypeShareMore,
    /// 分组讨论
    HWMToolBarItemTypeBreakout,
    /// 请求帮助
    HWMToolBarItemTypeAskHelp,
    /// 录制
    HWMToolBarItemTypeRecord = 25,
    /// 枚举最后一项 后续增加枚举需添加在该项之前
    HWMToolBarItemTypeButt,
};

typedef NS_ENUM(NSInteger,HWMStatusBarType) {
    /// 默认值
    HWMStatusBarTypeNone          = 0,
    /// 禁止点击录制中
    HWMStatusBarTypeRecord,
    /// 枚举最后一项 后续增加枚举需添加在该项之前
    HWMStatusBarTypeButt,
};

typedef NS_ENUM (NSInteger, HWMMenuItemType) {
    /// 默认值
    HWMMenuItemTypeNone          = 0,
    /// 会控助手
    HWMMenuItemTypeManageMeeting = 1,
    /// 字幕
    HWMMenuItemTypeSubtitle,
    /// 反馈
    HWMMenuItemTypeFeedback,
    /// 网络检测
    HWMMenuItemTypeNetworkDetection,
    /// 隐藏显示小画面
    HWMMenuItemTypeSmallPane = 5,
    /// 通话模式切换
    HWMMenuItemTypeSwitchCall,
    /// 安全
    HWMMenuItemTypeSecurity,
    /// 邀请
    HWMMenuItemTypeInvitation,
    /// 离开会议
    HWMMenuItemTypeLeave,
    /// 选看
    HWMMenuItemTypeSiteView = 10,
    ///与会者更多
    HWMMenuItemTypeAttendeeMore,
    ///等候室移除
    HWMMenuItemTypeRemoveWaitinger,
    ///独立弹出
    HWMMenuItemTypeIndependent,
    ///关闭
    HWMMenuItemTypeClose,
    /// 会议设置
    HWMMenuItemTypeSetting = 15,
    /// 投票
    HWMMenuItemTypeVote,
    /// 分组讨论
    HWMMenuItemTypeBreakout,
    /// 直播
    HWMMenuItemTypeLive,
    /// 改名
    HWMMenuItemTypeRename,
    /// 共享
    HWMMenuItemTypeShare,
    /// 枚举最后一项 添加的枚举值均应添加在该项之前
    HWMMenuItemTypeButt,
};

/// 工具条弹出的NSMenu菜单项主题等级
typedef NS_ENUM (NSInteger, HWMToolBarMenuItemThemeLevel) {
    /// 区头 文字左对齐 只支持设置文字 且无法触发点击事件
    HWMToolBarMenuItemThemeLevelHeading = 1,
    /// 普通菜单项 支持设置 文字和图片
    HWMToolBarMenuItemThemeLevelTitle   = 2,
};

typedef NS_ENUM (NSInteger, HWMClickParticipantItemBtn) {
    /// 呼叫其他号码按钮
    HWMClickParticipantCallOtherNumber = 0,
    /// 查看与会者详情
    HWMClickParticipantItemBtnDetail = 1,
    /// 重新呼叫按钮
    HWMClickParticipantItemBtnRecall = 2,
};

typedef NS_ENUM(NSInteger, HWMContactPhoneHideType) {
    /// 显示手机号码
    HWMContactShowPhone = 1,
    /// 隐藏手机号码
    HWMContactHidePhone = 2,
    /// 打码手机号码
    HWMContactSafePhone = 3
};

typedef NS_ENUM(NSInteger, HWMNameShowType) {
    /// 显示拼音首字母
    HWMFirstLetter = 0,
    /// 显示姓氏
    HWMFamilyName = 1,
};

typedef NS_ENUM(NSInteger, HWMAvatarShape) {
    /// 圆形头像
    HWMCircle = 0,
};

typedef NS_ENUM(NSInteger, HWMLocalRecordInterruptType) {
    /// 选择录制文件存放地址
    HWMLocalRecordSelectSavePath = 0,
    /// 开启安全录制提示
    HWMLocalRecordRiskTip = 1,
    /// 画廊模式录制效果不佳，需切换到演讲者视图
    HWMLocalRecordInfluenceRecordForGallery = 2,
};

#endif /* HWMOpenSDKConfigDefine_h */
